/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.spider.DialogAddDomainAlwaysInScope;
import org.zaproxy.zap.extension.spider.DialogModifyDomainAlwaysInScope;
import org.zaproxy.zap.extension.spider.DomainsAlwaysInScopeTableModel;
import org.zaproxy.zap.spider.DomainAlwaysInScopeMatcher;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.view.AbstractMultipleOptionsTablePanel;
import org.zaproxy.zap.view.PositiveValuesSlider;

public class OptionsSpiderPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = -5623691753271231473L;
    private JPanel panelSpider = null;
    private JSlider sliderMaxDepth = null;
    private JSlider sliderThreads = null;
    private JCheckBox chkPostForm = null;
    private JCheckBox chkProcessForm = null;
    private JCheckBox parseComments = null;
    private JCheckBox parseRobotsTxt = null;
    private JCheckBox parseSitemapXml = null;
    private JCheckBox parseSVNEntries = null;
    private JCheckBox parseGit = null;
    private JCheckBox handleODataSpecificParameters = null;
    private JCheckBox chkSendRefererHeader;
    private DomainsAlwaysInScopeMultipleOptionsPanel domainsAlwaysInScopePanel;
    private DomainsAlwaysInScopeTableModel domainsAlwaysInScopeTableModel;
    private JComboBox<SpiderParam.HandleParametersOption> handleParameters = null;

    public OptionsSpiderPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("spider.options.title"));
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(314, 245);
        }
        this.add((Component)this.getPanelSpider(), this.getPanelSpider().getName());
    }

    private JPanel getPanelSpider() {
        if (this.panelSpider == null) {
            Insets insets;
            this.panelSpider = new JPanel(new BorderLayout());
            if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
                this.panelSpider.setSize(114, 150);
            }
            this.panelSpider.setName("");
            JLabel jLabel = new JLabel();
            JLabel jLabel2 = new JLabel();
            JLabel jLabel3 = new JLabel();
            JLabel jLabel4 = new JLabel();
            jLabel3.setText(Constant.messages.getString("spider.options.label.depth"));
            jLabel2.setText(Constant.messages.getString("spider.options.label.threads"));
            jLabel.setText(Constant.messages.getString("spider.options.label.domains"));
            jLabel4.setText(Constant.messages.getString("spider.options.label.handleparameters"));
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = insets = new Insets(2, 2, 2, 2);
            jPanel.add((Component)jLabel3, gridBagConstraints);
            jPanel.add((Component)this.getSliderMaxDepth(), gridBagConstraints);
            jPanel.add((Component)jLabel2, gridBagConstraints);
            jPanel.add((Component)this.getSliderThreads(), gridBagConstraints);
            jPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            jPanel.add((Component)this.getDomainsAlwaysInScopePanel(), gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 0.0;
            jPanel.add((Component)this.getChkSendRefererHeader(), gridBagConstraints);
            jPanel.add((Component)jLabel4, gridBagConstraints);
            jPanel.add(this.getComboHandleParameters(), gridBagConstraints);
            jPanel.add((Component)this.getChkProcessForm(), gridBagConstraints);
            insets.left = 15;
            jPanel.add((Component)this.getChkPostForm(), gridBagConstraints);
            insets.left = 2;
            jPanel.add((Component)this.getChkParseComments(), gridBagConstraints);
            jPanel.add((Component)this.getChkParseRobotsTxt(), gridBagConstraints);
            jPanel.add((Component)this.getChkParseSitemapXml(), gridBagConstraints);
            jPanel.add((Component)this.getChkParseSVNEntries(), gridBagConstraints);
            jPanel.add((Component)this.getChkParseGit(), gridBagConstraints);
            jPanel.add((Component)this.getHandleODataSpecificParameters(), gridBagConstraints);
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.panelSpider.add((Component)jScrollPane, "Center");
        }
        return this.panelSpider;
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        SpiderParam spiderParam = optionsParam.getParamSet(SpiderParam.class);
        this.getSliderMaxDepth().setValue(spiderParam.getMaxDepth());
        this.getSliderThreads().setValue(spiderParam.getThreadCount());
        this.getDomainsAlwaysInScopeTableModel().setDomainsAlwaysInScope(spiderParam.getDomainsAlwaysInScope());
        this.getDomainsAlwaysInScopePanel().setRemoveWithoutConfirmation(spiderParam.isConfirmRemoveDomainAlwaysInScope());
        this.getChkProcessForm().setSelected(spiderParam.isProcessForm());
        this.getChkSendRefererHeader().setSelected(spiderParam.isSendRefererHeader());
        this.getChkPostForm().setSelected(spiderParam.isPostForm());
        this.getChkParseComments().setSelected(spiderParam.isParseComments());
        this.getChkParseRobotsTxt().setSelected(spiderParam.isParseRobotsTxt());
        this.getChkParseSitemapXml().setSelected(spiderParam.isParseSitemapXml());
        this.getChkParseSVNEntries().setSelected(spiderParam.isParseSVNEntries());
        this.getChkParseGit().setSelected(spiderParam.isParseGit());
        this.getComboHandleParameters().setSelectedItem((Object)spiderParam.getHandleParameters());
        this.getHandleODataSpecificParameters().setSelected(spiderParam.isHandleODataParametersVisited());
    }

    @Override
    public void validateParam(Object object) {
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        SpiderParam spiderParam = optionsParam.getParamSet(SpiderParam.class);
        spiderParam.setMaxDepth(this.getSliderMaxDepth().getValue());
        spiderParam.setThreadCount(this.getSliderThreads().getValue());
        spiderParam.setDomainsAlwaysInScope(this.getDomainsAlwaysInScopeTableModel().getDomainsAlwaysInScope());
        spiderParam.setConfirmRemoveDomainAlwaysInScope(this.getDomainsAlwaysInScopePanel().isRemoveWithoutConfirmation());
        spiderParam.setSendRefererHeader(this.getChkSendRefererHeader().isSelected());
        spiderParam.setProcessForm(this.getChkProcessForm().isSelected());
        spiderParam.setPostForm(this.getChkPostForm().isSelected());
        spiderParam.setParseComments(this.getChkParseComments().isSelected());
        spiderParam.setParseRobotsTxt(this.getChkParseRobotsTxt().isSelected());
        spiderParam.setParseSitemapXml(this.getChkParseSitemapXml().isSelected());
        spiderParam.setParseSVNEntries(this.getChkParseSVNEntries().isSelected());
        spiderParam.setParseGit(this.getChkParseGit().isSelected());
        spiderParam.setHandleParameters((SpiderParam.HandleParametersOption)((Object)this.getComboHandleParameters().getSelectedItem()));
        spiderParam.setHandleODataParametersVisited(this.getHandleODataSpecificParameters().isSelected());
    }

    private JSlider getSliderMaxDepth() {
        if (this.sliderMaxDepth == null) {
            this.sliderMaxDepth = new JSlider();
            this.sliderMaxDepth.setMaximum(19);
            this.sliderMaxDepth.setMinimum(1);
            this.sliderMaxDepth.setMinorTickSpacing(1);
            this.sliderMaxDepth.setPaintTicks(true);
            this.sliderMaxDepth.setPaintLabels(true);
            this.sliderMaxDepth.setName("");
            this.sliderMaxDepth.setMajorTickSpacing(1);
            this.sliderMaxDepth.setSnapToTicks(true);
            this.sliderMaxDepth.setPaintTrack(true);
        }
        return this.sliderMaxDepth;
    }

    private JSlider getSliderThreads() {
        if (this.sliderThreads == null) {
            this.sliderThreads = new PositiveValuesSlider(50);
        }
        return this.sliderThreads;
    }

    private JCheckBox getChkSendRefererHeader() {
        if (this.chkSendRefererHeader == null) {
            this.chkSendRefererHeader = new JCheckBox(Constant.messages.getString("spider.options.label.sendRefererHeader"));
        }
        return this.chkSendRefererHeader;
    }

    private JCheckBox getChkPostForm() {
        if (this.chkPostForm == null) {
            this.chkPostForm = new JCheckBox();
            this.chkPostForm.setText(Constant.messages.getString("spider.options.label.post"));
            if (!this.getChkProcessForm().isSelected()) {
                this.chkPostForm.setEnabled(false);
            }
        }
        return this.chkPostForm;
    }

    private JCheckBox getChkProcessForm() {
        if (this.chkProcessForm == null) {
            this.chkProcessForm = new JCheckBox();
            this.chkProcessForm.setText(Constant.messages.getString("spider.options.label.processform"));
            this.chkProcessForm.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (OptionsSpiderPanel.this.chkProcessForm.isSelected()) {
                        OptionsSpiderPanel.this.chkPostForm.setEnabled(true);
                    } else {
                        OptionsSpiderPanel.this.chkPostForm.setEnabled(false);
                    }
                }
            });
        }
        return this.chkProcessForm;
    }

    private JCheckBox getChkParseComments() {
        if (this.parseComments == null) {
            this.parseComments = new JCheckBox();
            this.parseComments.setText(Constant.messages.getString("spider.options.label.comments"));
        }
        return this.parseComments;
    }

    private JCheckBox getChkParseRobotsTxt() {
        if (this.parseRobotsTxt == null) {
            this.parseRobotsTxt = new JCheckBox();
            this.parseRobotsTxt.setText(Constant.messages.getString("spider.options.label.robotstxt"));
        }
        return this.parseRobotsTxt;
    }

    private JCheckBox getChkParseSitemapXml() {
        if (this.parseSitemapXml == null) {
            this.parseSitemapXml = new JCheckBox();
            this.parseSitemapXml.setText(Constant.messages.getString("spider.options.label.sitemapxml"));
        }
        return this.parseSitemapXml;
    }

    private JCheckBox getChkParseSVNEntries() {
        if (this.parseSVNEntries == null) {
            this.parseSVNEntries = new JCheckBox();
            this.parseSVNEntries.setText(Constant.messages.getString("spider.options.label.svnentries"));
        }
        return this.parseSVNEntries;
    }

    private JCheckBox getChkParseGit() {
        if (this.parseGit == null) {
            this.parseGit = new JCheckBox();
            this.parseGit.setText(Constant.messages.getString("spider.options.label.git"));
        }
        return this.parseGit;
    }

    private JCheckBox getHandleODataSpecificParameters() {
        if (this.handleODataSpecificParameters == null) {
            this.handleODataSpecificParameters = new JCheckBox();
            this.handleODataSpecificParameters.setText(Constant.messages.getString("spider.options.label.handlehodataparameters"));
        }
        return this.handleODataSpecificParameters;
    }

    private JComboBox<SpiderParam.HandleParametersOption> getComboHandleParameters() {
        if (this.handleParameters == null) {
            this.handleParameters = new JComboBox<SpiderParam.HandleParametersOption>(new SpiderParam.HandleParametersOption[]{SpiderParam.HandleParametersOption.USE_ALL, SpiderParam.HandleParametersOption.IGNORE_VALUE, SpiderParam.HandleParametersOption.IGNORE_COMPLETELY});
            this.handleParameters.setRenderer(new HandleParametersOptionRenderer());
        }
        return this.handleParameters;
    }

    private DomainsAlwaysInScopeMultipleOptionsPanel getDomainsAlwaysInScopePanel() {
        if (this.domainsAlwaysInScopePanel == null) {
            this.domainsAlwaysInScopePanel = new DomainsAlwaysInScopeMultipleOptionsPanel(this.getDomainsAlwaysInScopeTableModel());
        }
        return this.domainsAlwaysInScopePanel;
    }

    private DomainsAlwaysInScopeTableModel getDomainsAlwaysInScopeTableModel() {
        if (this.domainsAlwaysInScopeTableModel == null) {
            this.domainsAlwaysInScopeTableModel = new DomainsAlwaysInScopeTableModel();
        }
        return this.domainsAlwaysInScopeTableModel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.spider";
    }

    private static class DomainsAlwaysInScopeMultipleOptionsPanel
    extends AbstractMultipleOptionsTablePanel<DomainAlwaysInScopeMatcher> {
        private static final long serialVersionUID = 2332044353650231701L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("spider.options.domains.in.scope.dialog.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("spider.options.domains.in.scope.dialog.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("spider.options.domains.in.scope.dialog.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("spider.options.domains.in.scope.dialog.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("spider.options.domains.in.scope.dialog.remove.checkbox.label");
        private DialogAddDomainAlwaysInScope addDialog = null;
        private DialogModifyDomainAlwaysInScope modifyDialog = null;

        public DomainsAlwaysInScopeMultipleOptionsPanel(DomainsAlwaysInScopeTableModel domainsAlwaysInScopeTableModel) {
            super(domainsAlwaysInScopeTableModel);
            this.getTable().setVisibleRowCount(5);
            this.getTable().setSortOrder(2, SortOrder.ASCENDING);
        }

        @Override
        public DomainAlwaysInScopeMatcher showAddDialogue() {
            if (this.addDialog == null) {
                this.addDialog = new DialogAddDomainAlwaysInScope(View.getSingleton().getOptionsDialog(null));
                this.addDialog.pack();
            }
            this.addDialog.setVisible(true);
            DomainAlwaysInScopeMatcher domainAlwaysInScopeMatcher = this.addDialog.getDomainAlwaysInScope();
            this.addDialog.clear();
            return domainAlwaysInScopeMatcher;
        }

        @Override
        public DomainAlwaysInScopeMatcher showModifyDialogue(DomainAlwaysInScopeMatcher domainAlwaysInScopeMatcher) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogModifyDomainAlwaysInScope(View.getSingleton().getOptionsDialog(null));
                this.modifyDialog.pack();
            }
            this.modifyDialog.setDomainAlwaysInScope(domainAlwaysInScopeMatcher);
            this.modifyDialog.setVisible(true);
            DomainAlwaysInScopeMatcher domainAlwaysInScopeMatcher2 = this.modifyDialog.getDomainAlwaysInScope();
            this.modifyDialog.clear();
            if (!domainAlwaysInScopeMatcher2.equals(domainAlwaysInScopeMatcher)) {
                return domainAlwaysInScopeMatcher2;
            }
            return null;
        }

        @Override
        public boolean showRemoveDialogue(DomainAlwaysInScopeMatcher domainAlwaysInScopeMatcher) {
            JCheckBox jCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] objectArray = new Object[]{REMOVE_DIALOG_TEXT, " ", jCheckBox};
            int n = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), objectArray, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (n == 0) {
                this.setRemoveWithoutConfirmation(jCheckBox.isSelected());
                return true;
            }
            return false;
        }
    }

    private static class HandleParametersOptionRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 3654541772447187317L;
        private static final Border BORDER = new EmptyBorder(2, 3, 3, 3);

        private HandleParametersOptionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                this.setBorder(BORDER);
                SpiderParam.HandleParametersOption handleParametersOption = (SpiderParam.HandleParametersOption)((Object)object);
                this.setText(handleParametersOption.getName());
            }
            return this;
        }
    }
}

