/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.scan;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.zaproxy.zap.scan.BaseScannerThread;
import org.zaproxy.zap.scan.ScannerThreadManager;

public abstract class BaseScannerThreadManager<ScannerThread extends BaseScannerThread<?>>
implements ScannerThreadManager<ScannerThread, Integer> {
    private Map<Integer, ScannerThread> threadsMap = new HashMap<Integer, ScannerThread>();

    @Override
    public ScannerThread getScannerThread(Integer n) {
        BaseScannerThread<Object> baseScannerThread = (BaseScannerThread)this.threadsMap.get(n);
        if (baseScannerThread == null) {
            baseScannerThread = this.createNewScannerThread(n);
            this.threadsMap.put(n, baseScannerThread);
        }
        return (ScannerThread)baseScannerThread;
    }

    @Override
    public ScannerThread recreateScannerThreadIfHasRun(Integer n) {
        BaseScannerThread<Object> baseScannerThread = (BaseScannerThread)this.threadsMap.get(n);
        if (baseScannerThread.hasRun()) {
            baseScannerThread = this.createNewScannerThread(n);
            this.threadsMap.put(n, baseScannerThread);
        }
        return (ScannerThread)baseScannerThread;
    }

    @Override
    public Collection<ScannerThread> getAllThreads() {
        return this.threadsMap.values();
    }

    @Override
    public void clearThreads() {
        this.threadsMap.clear();
    }

    @Override
    public void stopAllScannerThreads() {
        for (BaseScannerThread baseScannerThread : this.getAllThreads()) {
            baseScannerThread.stopScan();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.clearThreads();
    }

    public abstract ScannerThread createNewScannerThread(int var1);
}

