/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.GraphicAttribute;
import java.awt.geom.Rectangle2D;

public final class ImageGraphicAttribute
extends GraphicAttribute {
    private Image fImage;
    private float fImageWidth;
    private float fImageHeight;
    private float fOriginX;
    private float fOriginY;

    public ImageGraphicAttribute(Image image, int alignment) {
        this(image, alignment, 0.0f, 0.0f);
    }

    public ImageGraphicAttribute(Image image, int alignment, float originX, float originY) {
        super(alignment);
        this.fImage = image;
        this.fImageWidth = image.getWidth(null);
        this.fImageHeight = image.getHeight(null);
        this.fOriginX = originX;
        this.fOriginY = originY;
    }

    @Override
    public float getAscent() {
        return Math.max(0.0f, this.fOriginY);
    }

    @Override
    public float getDescent() {
        return Math.max(0.0f, this.fImageHeight - this.fOriginY);
    }

    @Override
    public float getAdvance() {
        return Math.max(0.0f, this.fImageWidth - this.fOriginX);
    }

    @Override
    public Rectangle2D getBounds() {
        return new Rectangle2D.Float(-this.fOriginX, -this.fOriginY, this.fImageWidth, this.fImageHeight);
    }

    @Override
    public void draw(Graphics2D graphics, float x, float y) {
        graphics.drawImage(this.fImage, (int)(x - this.fOriginX), (int)(y - this.fOriginY), null);
    }

    public int hashCode() {
        return this.fImage.hashCode();
    }

    public boolean equals(Object rhs) {
        try {
            return this.equals((ImageGraphicAttribute)rhs);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean equals(ImageGraphicAttribute rhs) {
        if (rhs == null) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        if (this.fOriginX != rhs.fOriginX || this.fOriginY != rhs.fOriginY) {
            return false;
        }
        if (this.getAlignment() != rhs.getAlignment()) {
            return false;
        }
        return this.fImage.equals(rhs.fImage);
    }
}

