/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XTextProperty
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 16;
    }

    @Override
    public int getDataSize() {
        return XTextProperty.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XTextProperty(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XTextProperty() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XTextProperty.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public byte get_value(int index) {
        log.finest("");
        return Native.getByte(Native.getLong(this.pData + 0L) + (long)(index * 1));
    }

    public long get_value() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_value(long v) {
        log.finest("");
        Native.putLong(this.pData + 0L, v);
    }

    public long get_encoding() {
        log.finest("");
        return Native.getLong(this.pData + 4L);
    }

    public void set_encoding(long v) {
        log.finest("");
        Native.putLong(this.pData + 4L, v);
    }

    public int get_format() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_format(int v) {
        log.finest("");
        Native.putInt(this.pData + 8L, v);
    }

    public long get_nitems() {
        log.finest("");
        return Native.getLong(this.pData + 12L);
    }

    public void set_nitems(long v) {
        log.finest("");
        Native.putLong(this.pData + 12L, v);
    }

    @Override
    String getName() {
        return "XTextProperty";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(160);
        ret.append("value = ").append(this.get_value()).append(", ");
        ret.append("encoding = ").append(this.get_encoding()).append(", ");
        ret.append("format = ").append(this.get_format()).append(", ");
        ret.append("nitems = ").append(this.get_nitems()).append(", ");
        return ret.toString();
    }
}

