/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.Keymap;
import org.netbeans.modules.openide.windows.GlobalActionContextImpl;
import org.openide.awt.Actions;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.actions.SystemAction;
import org.openide.windows.DefaultTopComponentLookup;
import org.openide.windows.DelegateActionMap;
import org.openide.windows.Mode;
import org.openide.windows.OpenComponentAction;
import org.openide.windows.RetainLocation;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class TopComponent
extends JComponent
implements Externalizable,
Accessible,
HelpCtx.Provider,
Lookup.Provider {
    private static Logger UILOG = Logger.getLogger("org.netbeans.ui.actions");
    static final long serialVersionUID = -3022538025284122942L;
    static final Logger LOG = Logger.getLogger(TopComponent.class.getName());
    @Deprecated
    public static final int CLOSE_EACH = 0;
    @Deprecated
    public static final int CLOSE_LAST = 1;
    public static final int PERSISTENCE_ALWAYS = 0;
    public static final int PERSISTENCE_ONLY_OPENED = 1;
    public static final int PERSISTENCE_NEVER = 2;
    private static Object defaultLookupLock = new Object();
    private static final Set<Class> warnedTCPIClasses = new WeakSet();
    private static final Set<Class> warnedClasses = new WeakSet();
    private Object defaultLookupRef;
    private NodeName nodeName;
    private int closeOperation = 1;
    private transient Image icon;
    private transient Node[] activatedNodes;
    private transient String displayName;
    private String htmlDisplayName;
    short serialVersion = 1;
    private AttentionGetter attentionGetter = null;
    public static final String PROP_KEEP_PREFERRED_SIZE_WHEN_SLIDED_IN = "netbeans.winsys.tc.keep_preferred_size_when_slided_in";
    public static final String PROP_CLOSING_DISABLED = "netbeans.winsys.tc.closing_disabled";
    public static final String PROP_SLIDING_DISABLED = "netbeans.winsys.tc.sliding_disabled";
    public static final String PROP_UNDOCKING_DISABLED = "netbeans.winsys.tc.undocking_disabled";
    public static final String PROP_DRAGGING_DISABLED = "netbeans.winsys.tc.dragging_disabled";
    public static final String PROP_MAXIMIZATION_DISABLED = "netbeans.winsys.tc.maximization_disabled";
    public static final String PROP_DND_COPY_DISABLED = "netbeans.winsys.tc.draganddrop_copy_disabled";
    private transient String modeName;
    private static final String MODE_ID_PREFERENCES_KEY_INFIX = "_modeId_";

    public TopComponent() {
        this(null);
    }

    public TopComponent(Lookup lookup) {
        if (lookup != null) {
            this.setLookup(lookup, true);
        }
        this.enableEvents(8L);
        this.setFocusable(false);
        this.initActionMap(lookup);
    }

    @Override
    public void addNotify() {
        Mode mode;
        super.addNotify();
        if (this.isPersistLocation() && (mode = WindowManager.getDefault().findMode(this)) != null) {
            this.modeName = mode.getName();
            if (this.modeName == null) {
                this.modeName = this.getClass().getAnnotation(RetainLocation.class).value();
            }
            NbPreferences.forModule(this.getClass()).put(this.getModeIdKey(), this.modeName);
        }
    }

    private boolean isPersistLocation() {
        boolean bl;
        boolean bl2 = bl = this.getPersistenceType() == 2 && this.getClass().getAnnotation(RetainLocation.class) != null;
        assert (this.annotationAndPersistenceTypeAreCompatible());
        return bl;
    }

    private boolean annotationAndPersistenceTypeAreCompatible() {
        if (this.getPersistenceType() != 2 && this.getClass().getAnnotation(RetainLocation.class) != null) {
            Logger.getLogger(TopComponent.class.getName()).log(Level.WARNING, "Useless to annotate a TopComponent with @RetainLocation if its persistence type is not PERSISTENCE_NEVER: {0}", new Object[]{this.getClass().getName()});
        }
        return true;
    }

    private String getModeIdKey() {
        return this.getClass().getName() + MODE_ID_PREFERENCES_KEY_INFIX + WindowManager.getDefault().findTopComponentID(this);
    }

    private void initActionMap(Lookup lookup) {
        ActionMap actionMap = null;
        if (lookup != null) {
            actionMap = (ActionMap)lookup.lookup(ActionMap.class);
        }
        if (actionMap == null) {
            actionMap = new ActionMap();
        }
        DelegateActionMap delegateActionMap = new DelegateActionMap(this, actionMap);
        if (this instanceof Cloneable) {
            delegateActionMap.put("cloneWindow", new CloneWindowAction(delegateActionMap));
        }
        delegateActionMap.put("closeWindow", new CloseWindowAction(delegateActionMap));
        this.setActionMap(delegateActionMap);
    }

    public static final Registry getRegistry() {
        return WindowManager.getDefault().getRegistry();
    }

    public final Node[] getActivatedNodes() {
        return this.activatedNodes;
    }

    public final void setActivatedNodes(Node[] nodeArray) {
        assert (this.multiviewActivatedNodes());
        this.setActivatedNodesImpl(nodeArray);
    }

    private boolean multiviewActivatedNodes() {
        if ("org.netbeans.core.multiview.MultiViewTopComponent".equals(this.getClass().getName()) || "org.netbeans.core.multiview.MultiViewCloneableTopComponent".equals(this.getClass().getName())) {
            LOG.info("Warning: You should not call setActivatedNodes() on the multiview topcomponents. Instead please manipulate the lookup of the embedded MultiViewElements. For details, please see http://www.netbeans.org/issues/show_bug.cgi?id=67257");
        }
        return true;
    }

    private void setActivatedNodesImpl(Node[] nodeArray) {
        boolean bl = LOG.isLoggable(Level.FINER);
        if (Arrays.equals(this.activatedNodes, nodeArray)) {
            if (bl) {
                LOG.finer("No change to activatedNodes for " + this);
            }
            return;
        }
        Lookup lookup = this.getLookup(false);
        if (lookup instanceof DefaultTopComponentLookup) {
            if (bl) {
                LOG.finer("Updating lookup " + lookup + " for " + this);
            }
            ((DefaultTopComponentLookup)lookup).updateLookups(nodeArray);
        }
        Node[] nodeArray2 = this.activatedNodes;
        this.activatedNodes = nodeArray;
        if (bl) {
            LOG.finer("activatedNodes changed: " + (nodeArray == null ? "" : Arrays.asList(nodeArray).toString()));
        }
        WindowManager.getDefault().topComponentActivatedNodesChanged(this, this.activatedNodes);
        if (bl) {
            LOG.finer("window manager notified: " + this);
        }
        this.firePropertyChange("activatedNodes", nodeArray2, this.activatedNodes);
        if (bl) {
            LOG.finer("listeners notified: " + this);
        }
    }

    public int getPersistenceType() {
        String string;
        Description description = this.getClass().getAnnotation(Description.class);
        if (description != null) {
            return description.persistenceType();
        }
        if (warnedClasses.add(this.getClass()) && !TopComponent.class.equals(this.getClass())) {
            Logger.getAnonymousLogger().warning("Note - " + this.getClass().getName() + " ought to override getPersistenceType()" + " rather than using the client property or accepting the default.");
        }
        if ((string = (String)this.getClientProperty("PersistenceType")) == null) {
            return 0;
        }
        if ("Never".equals(string)) {
            return 2;
        }
        if ("OnlyOpened".equals(string)) {
            return 1;
        }
        return 0;
    }

    public UndoRedo getUndoRedo() {
        return UndoRedo.NONE;
    }

    public void open() {
        this.open(null);
    }

    @Deprecated
    public void open(Workspace workspace) {
        if (this.isPersistLocation()) {
            Mode mode;
            this.modeName = NbPreferences.forModule(this.getClass()).get(this.getModeIdKey(), null);
            if (this.modeName == null) {
                this.modeName = this.getClass().getAnnotation(RetainLocation.class).value();
            }
            if ((mode = WindowManager.getDefault().findMode(this.modeName)) != null) {
                mode.dockInto(this);
            }
        }
        WindowManager.getDefault().topComponentOpen(this);
    }

    public final void openAtTabPosition(int n) {
        WindowManager.getDefault().topComponentOpenAtTabPosition(this, n);
    }

    public final int getTabPosition() {
        return WindowManager.getDefault().topComponentGetTabPosition(this);
    }

    public final boolean isOpened() {
        return this.isOpened(null);
    }

    @Deprecated
    public final boolean isOpened(Workspace workspace) {
        return WindowManager.getDefault().topComponentIsOpened(this);
    }

    public final boolean close() {
        return this.close(null);
    }

    @Deprecated
    public final boolean close(Workspace workspace) {
        if (!this.isOpened()) {
            return true;
        }
        WindowManager.getDefault().topComponentClose(this);
        return !this.isOpened();
    }

    public boolean canClose() {
        if (!this.isOpened()) {
            return false;
        }
        return this.canClose(null, true);
    }

    @Deprecated
    public boolean canClose(Workspace workspace, boolean bl) {
        return true;
    }

    @Deprecated
    protected void openNotify() {
    }

    @Deprecated
    protected void closeNotify() {
    }

    @Deprecated
    public SystemAction[] getSystemActions() {
        return new SystemAction[0];
    }

    public Action[] getActions() {
        Action[] actionArray = WindowManager.getDefault().topComponentDefaultActions(this);
        SystemAction[] systemActionArray = this.getSystemActions();
        if (systemActionArray.length > 0) {
            ArrayList<Action> arrayList = new ArrayList<Action>(Arrays.asList(actionArray));
            arrayList.addAll(Arrays.asList(systemActionArray));
            return arrayList.toArray(new Action[0]);
        }
        return actionArray;
    }

    public static Action openAction(TopComponent topComponent, String string, String string2, boolean bl) {
        return Actions.alwaysEnabled((ActionListener)new OpenComponentAction(topComponent), (String)string, (String)string2, (boolean)bl);
    }

    static Action openAction(Map map) {
        return Actions.alwaysEnabled((ActionListener)new OpenComponentAction(map), (String)((String)map.get("displayName")), (String)((String)map.get("iconBase")), (boolean)Boolean.TRUE.equals(map.get("noIconInMenu")));
    }

    @Deprecated
    public final void setCloseOperation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(NbBundle.getBundle(TopComponent.class).getString("EXC_UnknownOperation"));
        }
        if (this.closeOperation == n) {
            return;
        }
        this.closeOperation = n;
        this.firePropertyChange("closeOperation", null, null);
    }

    @Deprecated
    public final int getCloseOperation() {
        return this.closeOperation;
    }

    protected String preferredID() {
        String string;
        Class<?> clazz = this.getClass();
        Description description = clazz.getAnnotation(Description.class);
        if (description != null) {
            return description.preferredID();
        }
        if (this.getPersistenceType() != 2 && warnedTCPIClasses.add(clazz)) {
            Logger.getAnonymousLogger().warning(clazz.getName() + " should override preferredID()");
        }
        if ((string = this.getName()) == null) {
            int n = clazz.getName().lastIndexOf(46);
            string = n == -1 ? clazz.getName() : clazz.getName().substring(n + 1);
        }
        return string;
    }

    protected void componentOpened() {
        this.openNotify();
    }

    protected void componentClosed() {
        this.closeNotify();
    }

    protected void componentShowing() {
    }

    protected void componentHidden() {
    }

    protected void componentActivated() {
    }

    protected void componentDeactivated() {
    }

    @Override
    public void requestFocus() {
        if (this.isFocusable()) {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.isFocusable()) {
            return super.requestFocusInWindow();
        }
        return false;
    }

    public void requestActive() {
        WindowManager.getDefault().topComponentRequestActive(this);
    }

    public void toFront() {
        WindowManager.getDefault().topComponentToFront(this);
    }

    public void requestVisible() {
        WindowManager.getDefault().topComponentRequestVisible(this);
        GlobalActionContextImpl.blickActionMap(this.getActionMap());
    }

    public final void requestAttention(final boolean bl) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TopComponent.this.attentionGetter != null && !bl) {
                    TopComponent.this.attentionGetter.kill();
                } else if (!bl) {
                    WindowManager.getDefault().topComponentRequestAttention(TopComponent.this);
                } else if (TopComponent.this.attentionGetter != null) {
                    TopComponent.this.attentionGetter.reset();
                } else {
                    TopComponent.this.attentionGetter = new AttentionGetter();
                }
            }
        });
    }

    public final void makeBusy(final boolean bl) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                WindowManager.getDefault().topComponentMakeBusy(TopComponent.this, bl);
            }
        });
    }

    public final void cancelRequestAttention() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TopComponent.this.attentionGetter != null) {
                    TopComponent.this.attentionGetter.stop();
                } else {
                    WindowManager.getDefault().topComponentCancelRequestAttention(TopComponent.this);
                }
            }
        });
    }

    public final void setAttentionHighlight(final boolean bl) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                WindowManager.getDefault().topComponentAttentionHighlight(TopComponent.this, bl);
            }
        });
    }

    @Override
    public void setName(String string) {
        String string2 = this.getName();
        if (string != null && string.equals(string2)) {
            return;
        }
        super.setName(string);
        this.firePropertyChange("name", string2, string);
        WindowManager.getDefault().topComponentDisplayNameChanged(this, string);
    }

    public void setDisplayName(String string) {
        String string2 = this.displayName;
        if (string == string2 || string != null && string.equals(string2)) {
            return;
        }
        if (BasicHTML.isHTMLString(string)) {
            Logger.getAnonymousLogger().warning("Call of " + this.getClass().getName() + ".setDisplayName(\"" + string + "\")" + " shouldn't contain any HTML tags. Please use " + this.getClass().getName() + ".setHtmlDisplayName(String)" + "for such purpose. For details please see http://www.netbeans.org/issues/show_bug.cgi?id=66777.");
        }
        this.displayName = string;
        this.firePropertyChange("displayName", string2, string);
        WindowManager.getDefault().topComponentDisplayNameChanged(this, string);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShortName() {
        return null;
    }

    public void setHtmlDisplayName(String string) {
        String string2 = this.htmlDisplayName;
        if (string == string2 || string != null && string.equals(string2)) {
            return;
        }
        this.htmlDisplayName = string;
        this.firePropertyChange("htmlDisplayName", string2, string);
        WindowManager.getDefault().topComponentHtmlDisplayNameChanged(this, string);
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    @Override
    public void setToolTipText(String string) {
        if (string != null && string.equals(this.getToolTipText())) {
            return;
        }
        super.setToolTipText(string);
        WindowManager.getDefault().topComponentToolTipChanged(this, string);
    }

    public void setIcon(Image image) {
        if (image == this.icon) {
            return;
        }
        Image image2 = this.icon;
        this.icon = image;
        WindowManager.getDefault().topComponentIconChanged(this, this.icon);
        this.firePropertyChange("icon", image2, image);
    }

    public Image getIcon() {
        Description description;
        if (this.icon == null && (description = this.getClass().getAnnotation(Description.class)) != null) {
            this.icon = ImageUtilities.loadImage((String)description.iconBase(), (boolean)true);
        }
        return this.icon;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(TopComponent.class);
    }

    public List<Mode> availableModes(List<Mode> list) {
        return list;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
        if (1 == n && !bl2 && !keyEvent.isConsumed()) {
            Object object;
            Object object2;
            Keymap keymap = (Keymap)Lookup.getDefault().lookup(Keymap.class);
            Object object3 = object2 = keymap != null ? keymap.getAction(keyStroke) : null;
            if (object2 == null) {
                return false;
            }
            if (object2 instanceof ContextAwareAction) {
                object = ((ContextAwareAction)object2).createContextAwareInstance(this.getLookup());
                assert (object != null) : "ContextAwareAction cannot return null: " + object2;
                if (object.isEnabled() && this.getActivatedNodes() != null) {
                    object2 = object;
                }
            } else if (SwingUtilities.getWindowAncestor(keyEvent.getComponent()) instanceof Dialog && !Boolean.TRUE.equals(object = object2.getValue("OpenIDE-Transmodal-Action"))) {
                return false;
            }
            if (object2.isEnabled()) {
                object = new LogRecord(Level.FINER, "UI_ACTION_KEY_PRESS");
                ((LogRecord)object).setParameters(new Object[]{keyStroke, keyStroke.toString(), object2.toString(), object2.getClass().getName(), object2.getValue("Name")});
                ((LogRecord)object).setResourceBundle(NbBundle.getBundle(TopComponent.class));
                ((LogRecord)object).setLoggerName(UILOG.getName());
                UILOG.log((LogRecord)object);
                ActionEvent actionEvent = new ActionEvent(this, 1001, Utilities.keyToString((KeyStroke)keyStroke));
                object2.actionPerformed(actionEvent);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            return true;
        }
        return bl2;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(new Short(this.serialVersion));
        objectOutput.writeInt(this.closeOperation);
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(this.getToolTipText());
        if (this.getDisplayName() != null) {
            objectOutput.writeObject(this.getDisplayName());
        }
        Node node = this.nodeName == null ? null : this.nodeName.getNode();
        Node.Handle handle = node == null ? null : node.getHandle();
        objectOutput.writeObject(handle);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = objectInput.readObject();
        if (object instanceof Integer) {
            this.serialVersion = 0;
            this.closeOperation = (Integer)object;
            objectInput.readObject();
            super.setName((String)objectInput.readObject());
            this.setToolTipText((String)objectInput.readObject());
        } else {
            Node.Handle handle;
            this.serialVersion = (Short)object;
            this.closeOperation = objectInput.readInt();
            super.setName((String)objectInput.readObject());
            this.setToolTipText((String)objectInput.readObject());
            Object object2 = objectInput.readObject();
            if (object2 instanceof String) {
                this.setDisplayName((String)object2);
                object2 = objectInput.readObject();
            }
            if ((handle = (Node.Handle)object2) != null) {
                Node node = handle.getNode();
                NodeName.connect(this, node);
            }
        }
        if (this.closeOperation != 0 && this.closeOperation != 1) {
            throw new IOException("invalid closeOperation: " + this.closeOperation);
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new Replacer(this);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }

                @Override
                public String getAccessibleName() {
                    if (this.accessibleName != null) {
                        return this.accessibleName;
                    }
                    return TopComponent.this.getName();
                }

                @Override
                public String getToolTipText() {
                    return TopComponent.this.getToolTipText();
                }
            };
        }
        return this.accessibleContext;
    }

    public Lookup getLookup() {
        return this.getLookup(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup getLookup(boolean bl) {
        Object object = defaultLookupLock;
        synchronized (object) {
            Object object2;
            if (this.defaultLookupRef instanceof Lookup) {
                return (Lookup)this.defaultLookupRef;
            }
            if (this.defaultLookupRef instanceof Object[]) {
                return (Lookup)((Object[])this.defaultLookupRef)[0];
            }
            if (this.defaultLookupRef instanceof Reference && (object2 = ((Reference)this.defaultLookupRef).get()) instanceof Lookup) {
                return (Lookup)object2;
            }
            if (!bl) {
                return null;
            }
            object2 = new DefaultTopComponentLookup(this);
            this.defaultLookupRef = new WeakReference(object2);
            return object2;
        }
    }

    protected final void associateLookup(Lookup lookup) {
        this.setLookup(lookup, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setLookup(Lookup lookup, boolean bl) {
        Object object = defaultLookupLock;
        synchronized (object) {
            if (this.defaultLookupRef != null) {
                throw new IllegalStateException("Trying to set lookup " + lookup + " but there already is " + this.defaultLookupRef + " for component: " + this);
            }
            this.defaultLookupRef = lookup;
            if (bl) {
                this.defaultLookupRef = new Object[]{this.defaultLookupRef, new SynchronizeNodes(lookup)};
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("setLookup with " + lookup + " and sync: " + bl + " on " + this);
            }
        }
    }

    private void attachNodeName(NodeName nodeName) {
        this.nodeName = nodeName;
    }

    public SubComponent[] getSubComponents() {
        return new SubComponent[0];
    }

    private static class CloseWindowAction
    extends AbstractAction {
        DelegateActionMap am;

        public CloseWindowAction(DelegateActionMap delegateActionMap) {
            this.am = delegateActionMap;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TopComponent topComponent = (TopComponent)this.am.getComponent();
            if (topComponent != null) {
                topComponent.close();
            }
        }
    }

    private static class CloneWindowAction
    extends AbstractAction {
        DelegateActionMap am;

        public CloneWindowAction(DelegateActionMap delegateActionMap) {
            this.am = delegateActionMap;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Cloneable cloneable = (Cloneable)((Object)this.am.getComponent());
            if (cloneable != null) {
                Mode mode;
                TopComponent topComponent = cloneable.cloneComponent();
                int n = -1;
                if (cloneable instanceof TopComponent && null != (mode = WindowManager.getDefault().findMode((TopComponent)((Object)cloneable)))) {
                    TopComponent[] topComponentArray = mode.getTopComponents();
                    for (int i = 0; i < topComponentArray.length; ++i) {
                        if (topComponentArray[i] != cloneable) continue;
                        n = i + 1;
                        break;
                    }
                    if (n >= topComponentArray.length) {
                        n = -1;
                    }
                }
                if (n >= 0) {
                    topComponent.openAtTabPosition(n);
                } else {
                    topComponent.open();
                }
                topComponent.requestActive();
            }
        }
    }

    private class SynchronizeNodes
    implements LookupListener,
    Runnable {
        private Lookup.Result<Node> res;

        public SynchronizeNodes(Lookup lookup) {
            this.res = lookup.lookup(new Lookup.Template(Node.class));
            this.res.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            boolean bl = LOG.isLoggable(Level.FINE);
            if (bl) {
                LOG.fine("lookup changed for " + TopComponent.this + " is visible: " + TopComponent.this.isVisible());
            }
            if (TopComponent.this.isVisible() && EventQueue.isDispatchThread()) {
                this.run();
            } else {
                EventQueue.invokeLater(this);
            }
            if (bl) {
                LOG.fine("lookup changed exit " + TopComponent.this);
            }
        }

        @Override
        public void run() {
            boolean bl = LOG.isLoggable(Level.FINE);
            Collection collection = this.res.allInstances();
            if (bl) {
                LOG.fine("setting nodes for " + TopComponent.this + " to " + collection);
            }
            TopComponent.this.setActivatedNodesImpl(collection.toArray(new Node[0]));
            if (bl) {
                LOG.fine("setting nodes done for " + TopComponent.this + " to " + collection);
            }
        }
    }

    private static final class Replacer
    implements Serializable {
        static final long serialVersionUID = -8897067133215740572L;
        transient TopComponent tc;

        public Replacer(TopComponent topComponent) {
            this.tc = topComponent;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
            objectOutputStream.writeObject(this.tc.getClass().getName());
            this.tc.writeExternal(objectOutputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            block13: {
                String string = (String)objectInputStream.readObject();
                string = Utilities.translate((String)string);
                try {
                    Class<?>[] classArray;
                    ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    if (classLoader == null) {
                        classLoader = this.getClass().getClassLoader();
                    }
                    Class<?> clazz = Class.forName(string, true, classLoader);
                    Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    try {
                        this.tc = (TopComponent)constructor.newInstance(new Object[0]);
                    }
                    finally {
                        constructor.setAccessible(false);
                    }
                    this.tc.readExternal(objectInputStream);
                    Method method = Replacer.findReadResolveMethod(clazz);
                    if (method == null || (classArray = method.getExceptionTypes()).length != 1 || !ObjectStreamException.class.equals(classArray[0]) || !Object.class.equals(method.getReturnType())) break block13;
                    method.setAccessible(true);
                    try {
                        TopComponent topComponent = this.tc;
                        this.tc = (TopComponent)method.invoke((Object)this.tc, new Object[0]);
                        if (this.tc == null) {
                            throw new InvalidObjectException("TopComponent.readResolve() cannot return null. See http://www.netbeans.org/issues/show_bug.cgi?id=27849 for more info. TopComponent:" + topComponent);
                        }
                    }
                    finally {
                        method.setAccessible(false);
                    }
                }
                catch (Exception exception) {
                    Throwable throwable = exception;
                    if (throwable instanceof InvocationTargetException) {
                        throwable = ((InvocationTargetException)throwable).getTargetException();
                    }
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    throw (IOException)new IOException(throwable.toString()).initCause(throwable);
                }
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return this.tc;
        }

        private static Method findReadResolveMethod(Class clazz) {
            Method method = null;
            Class[] classArray = new Class[]{};
            try {
                method = clazz.getMethod("readResolve", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                for (Class clazz2 = clazz; clazz2 != null && clazz2 != TopComponent.class; clazz2 = clazz2.getSuperclass()) {
                    try {
                        method = clazz2.getDeclaredMethod("readResolve", classArray);
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        continue;
                    }
                }
            }
            return method;
        }
    }

    @Deprecated
    public static class NodeName
    extends NodeAdapter {
        private TopComponent top;
        private Reference node;
        private NodeListener nodeL;

        public static void connect(TopComponent topComponent, Node node) {
            new NodeName(topComponent).attach(node);
        }

        @Deprecated
        public NodeName(TopComponent topComponent) {
            this.top = topComponent;
        }

        @Deprecated
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Node node;
            if (propertyChangeEvent.getPropertyName().equals("displayName") && (node = (Node)this.node.get()) != null) {
                Mutex.EVENT.readAccess(new Runnable(){

                    @Override
                    public void run() {
                        NodeName.this.top.setName(node.getDisplayName());
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void attach(Node node) {
            TopComponent topComponent = this.top;
            synchronized (topComponent) {
                this.node = new WeakReference<Node>(node);
                this.nodeL = (NodeListener)WeakListeners.create(NodeListener.class, (EventListener)((Object)this), (Object)node);
                node.addNodeListener(this.nodeL);
                this.top.attachNodeName(this);
                this.top.setActivatedNodes(new Node[]{node});
                this.top.setName(node.getDisplayName());
            }
        }

        private Node getNode() {
            return (Node)this.node.get();
        }
    }

    private class AttentionGetter
    implements ActionListener {
        Timer timer = null;

        public AttentionGetter() {
            this.reset();
        }

        public void reset() {
            assert (EventQueue.isDispatchThread());
            if (this.timer != null) {
                this.timer.stop();
            }
            this.start();
            this.timer = new Timer(3500, this);
            this.timer.setRepeats(false);
            this.timer.start();
        }

        private void start() {
            WindowManager.getDefault().topComponentRequestAttention(TopComponent.this);
        }

        public void kill() {
            this.timer.stop();
            TopComponent.this.attentionGetter = null;
        }

        private void stop() {
            if (this.timer != null) {
                this.timer.stop();
            }
            TopComponent.this.attentionGetter = null;
            WindowManager.getDefault().topComponentCancelRequestAttention(TopComponent.this);
            TopComponent.this.attentionGetter = null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.stop();
        }
    }

    public static final class SubComponent {
        private final String displayName;
        private final String description;
        private final boolean active;
        private final ActionListener activator;
        private final Lookup lookup;
        private final boolean showing;

        public SubComponent(String string, ActionListener actionListener, boolean bl) {
            this(string, null, actionListener, bl);
        }

        public SubComponent(String string, String string2, ActionListener actionListener, boolean bl) {
            this(string, string2, actionListener, bl, Lookup.EMPTY, false);
        }

        public SubComponent(String string, String string2, ActionListener actionListener, boolean bl, Lookup lookup, boolean bl2) {
            this.displayName = string;
            this.description = string2;
            this.active = bl;
            this.activator = actionListener;
            this.lookup = lookup;
            this.showing = bl2;
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        public boolean isShowing() {
            return this.showing;
        }

        public final boolean isActive() {
            return this.active;
        }

        public final String getDescription() {
            return this.description;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void activate() {
            this.activator.actionPerformed(new ActionEvent(this, 0, "activate"));
        }
    }

    public static interface Registry {
        public static final String PROP_OPENED = "opened";
        public static final String PROP_ACTIVATED = "activated";
        public static final String PROP_CURRENT_NODES = "currentNodes";
        public static final String PROP_ACTIVATED_NODES = "activatedNodes";
        public static final String PROP_TC_OPENED = "tcOpened";
        public static final String PROP_TC_CLOSED = "tcClosed";

        public Set<TopComponent> getOpened();

        public TopComponent getActivated();

        public Node[] getCurrentNodes();

        public Node[] getActivatedNodes();

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface OpenActionRegistration {
        public String displayName();

        public String preferredID() default "";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface Registration {
        public String mode();

        public int position() default 0x7FFFFFFF;

        public boolean openAtStartup();

        public String[] roles() default {};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Description {
        public String preferredID();

        public String iconBase() default "";

        public int persistenceType() default 0;
    }

    public static interface Cloneable {
        public TopComponent cloneComponent();
    }
}

