/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.core.multitabs.Controller;
import org.netbeans.core.multitabs.impl.AbstractTabDisplayer;
import org.netbeans.core.multitabs.impl.CloseButtonHandler;
import org.netbeans.core.multitabs.impl.TabTable;
import org.netbeans.core.multitabs.impl.TabTableModel;
import org.netbeans.core.multitabs.impl.TabTableUI;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.openide.windows.TopComponent;

public class SimpleTabDisplayer
extends AbstractTabDisplayer
implements ListSelectionListener {
    private final TabTable table;

    public SimpleTabDisplayer(TabDataModel tabDataModel, int n) {
        super(tabDataModel, n);
        this.table = new TabTable(tabDataModel, n);
        this.scrollPane.setViewportView(this.table);
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(this);
        this.table.addMouseWheelListener(this);
        this.table.setBorder(TabTableUI.createTabBorder(this.table, n));
    }

    @Override
    public Rectangle getTabBounds(int n) {
        Rectangle rectangle = this.table.getTabBounds(n);
        if (null != rectangle) {
            rectangle = SwingUtilities.convertRectangle(this.table, rectangle, this);
        }
        return rectangle;
    }

    @Override
    public TabData getTabAt(Point point) {
        point = SwingUtilities.convertPoint(this, point, this.table);
        return this.table.getTabAt(point);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = -1;
        int n2 = this.table.getSelectedRow();
        int n3 = this.table.getSelectedColumn();
        if (n2 >= 0 && n3 >= 0) {
            TabData tabData = (TabData)this.table.getValueAt(n2, n3);
            if (tabData != null) {
                n = this.tabModel.indexOf(tabData);
                Rectangle rectangle = this.table.getCellRect(n2, n3, true);
                this.table.scrollRectToVisible(rectangle);
                this.controller.setSelectedIndex(n);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int n = SimpleTabDisplayer.this.controller.getSelectedIndex();
                    if (n < 0) {
                        n = 0;
                    }
                    SimpleTabDisplayer.this.setSelectedIndex(n);
                }
            });
        }
    }

    @Override
    public void setSelectedIndex(int n) {
        TabTableModel tabTableModel = (TabTableModel)this.table.getModel();
        int n2 = tabTableModel.toRowIndex(n);
        int n3 = tabTableModel.toColumnIndex(n);
        if (n3 >= 0 && n2 >= 0) {
            this.table.getSelectionModel().setSelectionInterval(n2, n2);
            this.table.getColumnModel().getSelectionModel().setSelectionInterval(n3, n3);
            Rectangle rectangle = this.table.getCellRect(n2, n3, true);
            this.table.scrollRectToVisible(rectangle);
        }
    }

    @Override
    public void attach(Controller controller) {
        super.attach(controller);
        this.table.addMouseListener(controller);
        CloseButtonHandler closeButtonHandler = new CloseButtonHandler(this, controller);
        this.table.addMouseListener(closeButtonHandler);
        this.table.addMouseMotionListener(closeButtonHandler);
    }

    @Override
    public int dropIndexOfPoint(Point point) {
        int n = -1;
        TabData tabData = this.table.getTabAt(point = SwingUtilities.convertPoint(this, point, this.table));
        if (null != tabData) {
            n = this.getModel().indexOf(tabData);
            Rectangle rectangle = this.getTabBounds(n);
            rectangle = SwingUtilities.convertRectangle(this, rectangle, this.table);
            n = this.orientation == 1 ? (point.y <= rectangle.y + rectangle.height / 2 ? Math.max(0, n) : ++n) : (point.x <= rectangle.x + rectangle.width / 2 ? Math.max(0, n) : ++n);
        }
        return n;
    }

    @Override
    public Rectangle dropIndication(TopComponent topComponent, Point point) {
        int n = this.dropIndexOfPoint(point);
        if (n < 0) {
            return null;
        }
        if (n == this.getModel().size()) {
            --n;
        }
        Rectangle rectangle = this.getTabBounds(n);
        if (this.orientation == 1) {
            rectangle.y = point.y <= rectangle.y + rectangle.height / 2 ? (rectangle.y -= rectangle.height / 2) : (rectangle.y += rectangle.height / 2);
        } else {
            rectangle.x = point.x <= rectangle.x + rectangle.width / 2 ? (rectangle.x -= rectangle.width / 2) : (rectangle.x += rectangle.width / 2);
        }
        return rectangle;
    }
}

