/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTableValidation;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.StatusToXContent;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.RestStatus;

public class ClusterHealthResponse
extends ActionResponse
implements Iterable<ClusterIndexHealth>,
StatusToXContent {
    private String clusterName;
    int numberOfNodes = 0;
    int numberOfDataNodes = 0;
    int activeShards = 0;
    int relocatingShards = 0;
    int activePrimaryShards = 0;
    int initializingShards = 0;
    int unassignedShards = 0;
    int numberOfPendingTasks = 0;
    int numberOfInFlightFetch = 0;
    int delayedUnassignedShards = 0;
    TimeValue taskMaxWaitingTime = TimeValue.timeValueMillis(0L);
    double activeShardsPercent = 100.0;
    boolean timedOut = false;
    ClusterHealthStatus status = ClusterHealthStatus.RED;
    private List<String> validationFailures;
    Map<String, ClusterIndexHealth> indices = Maps.newHashMap();

    ClusterHealthResponse() {
    }

    public ClusterHealthResponse(String clusterName, String[] concreteIndices, ClusterState clusterState) {
        this(clusterName, concreteIndices, clusterState, -1, -1, -1, TimeValue.timeValueHours(0L));
    }

    public ClusterHealthResponse(String clusterName, String[] concreteIndices, ClusterState clusterState, int numberOfPendingTasks, int numberOfInFlightFetch, int delayedUnassignedShards, TimeValue taskMaxWaitingTime) {
        this.clusterName = clusterName;
        this.numberOfPendingTasks = numberOfPendingTasks;
        this.numberOfInFlightFetch = numberOfInFlightFetch;
        this.delayedUnassignedShards = delayedUnassignedShards;
        this.clusterName = clusterName;
        this.numberOfPendingTasks = numberOfPendingTasks;
        this.numberOfInFlightFetch = numberOfInFlightFetch;
        this.taskMaxWaitingTime = taskMaxWaitingTime;
        RoutingTableValidation validation = clusterState.routingTable().validate(clusterState.metaData());
        this.validationFailures = validation.failures();
        this.numberOfNodes = clusterState.nodes().size();
        this.numberOfDataNodes = clusterState.nodes().dataNodes().size();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRoutingTable = clusterState.routingTable().index(index);
            IndexMetaData indexMetaData = clusterState.metaData().index(index);
            if (indexRoutingTable == null) continue;
            ClusterIndexHealth indexHealth = new ClusterIndexHealth(indexMetaData, indexRoutingTable);
            this.indices.put(indexHealth.getIndex(), indexHealth);
        }
        this.status = ClusterHealthStatus.GREEN;
        for (ClusterIndexHealth indexHealth : this.indices.values()) {
            this.activePrimaryShards += indexHealth.getActivePrimaryShards();
            this.activeShards += indexHealth.getActiveShards();
            this.relocatingShards += indexHealth.getRelocatingShards();
            this.initializingShards += indexHealth.getInitializingShards();
            this.unassignedShards += indexHealth.getUnassignedShards();
            if (indexHealth.getStatus() == ClusterHealthStatus.RED) {
                this.status = ClusterHealthStatus.RED;
                continue;
            }
            if (indexHealth.getStatus() != ClusterHealthStatus.YELLOW || this.status == ClusterHealthStatus.RED) continue;
            this.status = ClusterHealthStatus.YELLOW;
        }
        if (!this.validationFailures.isEmpty()) {
            this.status = ClusterHealthStatus.RED;
        } else if (clusterState.blocks().hasGlobalBlock(RestStatus.SERVICE_UNAVAILABLE)) {
            this.status = ClusterHealthStatus.RED;
        }
        if (this.status.equals((Object)ClusterHealthStatus.GREEN)) {
            this.activeShardsPercent = 100.0;
        } else {
            List<ShardRouting> shardRoutings = clusterState.getRoutingTable().allShards();
            int activeShardCount = 0;
            int totalShardCount = 0;
            for (ShardRouting shardRouting : shardRoutings) {
                if (shardRouting.active()) {
                    ++activeShardCount;
                }
                ++totalShardCount;
            }
            this.activeShardsPercent = (double)activeShardCount / (double)totalShardCount * 100.0;
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public List<String> getValidationFailures() {
        return this.validationFailures;
    }

    public List<String> getAllValidationFailures() {
        ArrayList<String> allFailures = new ArrayList<String>(this.getValidationFailures());
        for (ClusterIndexHealth indexHealth : this.indices.values()) {
            allFailures.addAll(indexHealth.getValidationFailures());
        }
        return allFailures;
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActivePrimaryShards() {
        return this.activePrimaryShards;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public int getNumberOfDataNodes() {
        return this.numberOfDataNodes;
    }

    public int getNumberOfPendingTasks() {
        return this.numberOfPendingTasks;
    }

    public int getNumberOfInFlightFetch() {
        return this.numberOfInFlightFetch;
    }

    public int getDelayedUnassignedShards() {
        return this.delayedUnassignedShards;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public Map<String, ClusterIndexHealth> getIndices() {
        return this.indices;
    }

    public TimeValue getTaskMaxWaitingTime() {
        return this.taskMaxWaitingTime;
    }

    public double getActiveShardsPercent() {
        return this.activeShardsPercent;
    }

    @Override
    public Iterator<ClusterIndexHealth> iterator() {
        return this.indices.values().iterator();
    }

    public static ClusterHealthResponse readResponseFrom(StreamInput in) throws IOException {
        ClusterHealthResponse response = new ClusterHealthResponse();
        response.readFrom(in);
        return response;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        super.readFrom(in);
        this.clusterName = in.readString();
        this.activePrimaryShards = in.readVInt();
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.numberOfNodes = in.readVInt();
        this.numberOfDataNodes = in.readVInt();
        this.numberOfPendingTasks = in.readInt();
        this.status = ClusterHealthStatus.fromValue(in.readByte());
        int size = in.readVInt();
        for (i = 0; i < size; ++i) {
            ClusterIndexHealth indexHealth = ClusterIndexHealth.readClusterIndexHealth(in);
            this.indices.put(indexHealth.getIndex(), indexHealth);
        }
        this.timedOut = in.readBoolean();
        size = in.readVInt();
        if (size == 0) {
            this.validationFailures = Collections.emptyList();
        } else {
            for (i = 0; i < size; ++i) {
                this.validationFailures.add(in.readString());
            }
        }
        this.numberOfInFlightFetch = in.readInt();
        if (in.getVersion().onOrAfter(Version.V_1_7_0)) {
            this.delayedUnassignedShards = in.readInt();
        }
        this.activeShardsPercent = in.readDouble();
        this.taskMaxWaitingTime = TimeValue.readTimeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.clusterName);
        out.writeVInt(this.activePrimaryShards);
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeVInt(this.numberOfNodes);
        out.writeVInt(this.numberOfDataNodes);
        out.writeInt(this.numberOfPendingTasks);
        out.writeByte(this.status.value());
        out.writeVInt(this.indices.size());
        for (ClusterIndexHealth indexHealth : this) {
            indexHealth.writeTo(out);
        }
        out.writeBoolean(this.timedOut);
        out.writeVInt(this.validationFailures.size());
        for (String failure : this.validationFailures) {
            out.writeString(failure);
        }
        out.writeInt(this.numberOfInFlightFetch);
        if (out.getVersion().onOrAfter(Version.V_1_7_0)) {
            out.writeInt(this.delayedUnassignedShards);
        }
        out.writeDouble(this.activeShardsPercent);
        this.taskMaxWaitingTime.writeTo(out);
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    @Override
    public RestStatus status() {
        return this.isTimedOut() ? RestStatus.REQUEST_TIMEOUT : RestStatus.OK;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean outputIndices;
        builder.field(Fields.CLUSTER_NAME, this.getClusterName());
        builder.field(Fields.STATUS, this.getStatus().name().toLowerCase(Locale.ROOT));
        builder.field(Fields.TIMED_OUT, this.isTimedOut());
        builder.field(Fields.NUMBER_OF_NODES, this.getNumberOfNodes());
        builder.field(Fields.NUMBER_OF_DATA_NODES, this.getNumberOfDataNodes());
        builder.field(Fields.ACTIVE_PRIMARY_SHARDS, this.getActivePrimaryShards());
        builder.field(Fields.ACTIVE_SHARDS, this.getActiveShards());
        builder.field(Fields.RELOCATING_SHARDS, this.getRelocatingShards());
        builder.field(Fields.INITIALIZING_SHARDS, this.getInitializingShards());
        builder.field(Fields.UNASSIGNED_SHARDS, this.getUnassignedShards());
        builder.field(Fields.DELAYED_UNASSIGNED_SHARDS, this.getDelayedUnassignedShards());
        builder.field(Fields.NUMBER_OF_PENDING_TASKS, this.getNumberOfPendingTasks());
        builder.field(Fields.NUMBER_OF_IN_FLIGHT_FETCH, this.getNumberOfInFlightFetch());
        builder.timeValueField(Fields.TASK_MAX_WAIT_TIME_IN_QUEUE_IN_MILLIS, Fields.TASK_MAX_WAIT_TIME_IN_QUEUE, this.getTaskMaxWaitingTime());
        builder.percentageField(Fields.ACTIVE_SHARDS_PERCENT_AS_NUMBER, Fields.ACTIVE_SHARDS_PERCENT, this.getActiveShardsPercent());
        String level = params.param("level", "cluster");
        boolean bl = outputIndices = "indices".equals(level) || "shards".equals(level);
        if (!this.getValidationFailures().isEmpty()) {
            builder.startArray(Fields.VALIDATION_FAILURES);
            for (String validationFailure : this.getValidationFailures()) {
                builder.value(validationFailure);
            }
            if (!outputIndices) {
                for (ClusterIndexHealth indexHealth : this.indices.values()) {
                    builder.startObject(indexHealth.getIndex());
                    if (!indexHealth.getValidationFailures().isEmpty()) {
                        builder.startArray(Fields.VALIDATION_FAILURES);
                        for (String validationFailure : indexHealth.getValidationFailures()) {
                            builder.value(validationFailure);
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                }
            }
            builder.endArray();
        }
        if (outputIndices) {
            builder.startObject(Fields.INDICES);
            for (ClusterIndexHealth indexHealth : this.indices.values()) {
                builder.startObject(indexHealth.getIndex(), XContentBuilder.FieldCaseConversion.NONE);
                indexHealth.toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString CLUSTER_NAME = new XContentBuilderString("cluster_name");
        static final XContentBuilderString STATUS = new XContentBuilderString("status");
        static final XContentBuilderString TIMED_OUT = new XContentBuilderString("timed_out");
        static final XContentBuilderString NUMBER_OF_NODES = new XContentBuilderString("number_of_nodes");
        static final XContentBuilderString NUMBER_OF_DATA_NODES = new XContentBuilderString("number_of_data_nodes");
        static final XContentBuilderString NUMBER_OF_PENDING_TASKS = new XContentBuilderString("number_of_pending_tasks");
        static final XContentBuilderString NUMBER_OF_IN_FLIGHT_FETCH = new XContentBuilderString("number_of_in_flight_fetch");
        static final XContentBuilderString DELAYED_UNASSIGNED_SHARDS = new XContentBuilderString("delayed_unassigned_shards");
        static final XContentBuilderString TASK_MAX_WAIT_TIME_IN_QUEUE = new XContentBuilderString("task_max_waiting_in_queue");
        static final XContentBuilderString TASK_MAX_WAIT_TIME_IN_QUEUE_IN_MILLIS = new XContentBuilderString("task_max_waiting_in_queue_millis");
        static final XContentBuilderString ACTIVE_SHARDS_PERCENT_AS_NUMBER = new XContentBuilderString("active_shards_percent_as_number");
        static final XContentBuilderString ACTIVE_SHARDS_PERCENT = new XContentBuilderString("active_shards_percent");
        static final XContentBuilderString ACTIVE_PRIMARY_SHARDS = new XContentBuilderString("active_primary_shards");
        static final XContentBuilderString ACTIVE_SHARDS = new XContentBuilderString("active_shards");
        static final XContentBuilderString RELOCATING_SHARDS = new XContentBuilderString("relocating_shards");
        static final XContentBuilderString INITIALIZING_SHARDS = new XContentBuilderString("initializing_shards");
        static final XContentBuilderString UNASSIGNED_SHARDS = new XContentBuilderString("unassigned_shards");
        static final XContentBuilderString VALIDATION_FAILURES = new XContentBuilderString("validation_failures");
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");

        Fields() {
        }
    }
}

