/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors.dfs;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.dfs.AggregatedDfs;

public class DfsOnlyResponse
extends BroadcastResponse {
    private AggregatedDfs dfs;
    private long tookInMillis;

    DfsOnlyResponse(AggregatedDfs dfs, int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures, long tookInMillis) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.dfs = dfs;
        this.tookInMillis = tookInMillis;
    }

    public AggregatedDfs getDfs() {
        return this.dfs;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        AggregatedDfs.readAggregatedDfs(in);
        this.tookInMillis = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.dfs.writeTo(out);
        out.writeVLong(this.tookInMillis);
    }
}

