/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class UnassignedInfo
implements ToXContent,
Writeable<UnassignedInfo> {
    public static final FormatDateTimeFormatter DATE_TIME_FORMATTER = Joda.forPattern("dateOptionalTime");
    public static final String INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING = "index.unassigned.node_left.delayed_timeout";
    private static final TimeValue DEFAULT_DELAYED_NODE_LEFT_TIMEOUT = TimeValue.timeValueMinutes(1L);
    private final Reason reason;
    private final long timestamp;
    private final String message;
    private final Throwable failure;

    public UnassignedInfo(Reason reason, String message) {
        this(reason, System.currentTimeMillis(), message, null);
    }

    public UnassignedInfo(Reason reason, @Nullable String message, @Nullable Throwable failure) {
        this(reason, System.currentTimeMillis(), message, failure);
    }

    private UnassignedInfo(Reason reason, long timestamp, String message, Throwable failure) {
        this.reason = reason;
        this.timestamp = timestamp;
        this.message = message;
        this.failure = failure;
        assert (message != null || failure == null) : "provide a message if a failure exception is provided";
    }

    UnassignedInfo(StreamInput in) throws IOException {
        this.reason = Reason.values()[in.readByte()];
        this.timestamp = in.readLong();
        this.message = in.readOptionalString();
        this.failure = in.readThrowable();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte((byte)this.reason.ordinal());
        out.writeLong(this.timestamp);
        out.writeOptionalString(this.message);
        out.writeThrowable(this.failure);
    }

    @Override
    public UnassignedInfo readFrom(StreamInput in) throws IOException {
        return new UnassignedInfo(in);
    }

    public Reason getReason() {
        return this.reason;
    }

    public long getTimestampInMillis() {
        return this.timestamp;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public Throwable getFailure() {
        return this.failure;
    }

    @Nullable
    public String getDetails() {
        if (this.message == null) {
            return null;
        }
        return this.message + (this.failure == null ? "" : ", failure " + ExceptionsHelper.detailedMessage(this.failure));
    }

    public long getAllocationDelayTimeoutSetting(Settings settings, Settings indexSettings) {
        if (this.reason != Reason.NODE_LEFT) {
            return 0L;
        }
        TimeValue delayTimeout = indexSettings.getAsTime(INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING, settings.getAsTime(INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING, DEFAULT_DELAYED_NODE_LEFT_TIMEOUT));
        return Math.max(0L, delayTimeout.millis());
    }

    public long getDelayAllocationExpirationIn(long unassignedShardsAllocatedTimestamp, Settings settings, Settings indexSettings) {
        long delayTimeout = this.getAllocationDelayTimeoutSetting(settings, indexSettings);
        if (delayTimeout == 0L) {
            return 0L;
        }
        long delta = unassignedShardsAllocatedTimestamp - this.timestamp;
        if (delta < 0L) {
            return 0L;
        }
        return delayTimeout - delta;
    }

    public static int getNumberOfDelayedUnassigned(long unassignedShardsAllocatedTimestamp, Settings settings, ClusterState state) {
        int count = 0;
        for (ShardRouting shard : state.routingTable().shardsWithState(ShardRoutingState.UNASSIGNED)) {
            if (shard.primary()) continue;
            IndexMetaData indexMetaData = state.metaData().index(shard.getIndex());
            long delay = shard.unassignedInfo().getDelayAllocationExpirationIn(unassignedShardsAllocatedTimestamp, settings, indexMetaData.getSettings());
            if (delay <= 0L) continue;
            ++count;
        }
        return count;
    }

    public static long findSmallestDelayedAllocationSetting(Settings settings, ClusterState state) {
        long nextDelaySetting = Long.MAX_VALUE;
        for (ShardRouting shard : state.routingTable().shardsWithState(ShardRoutingState.UNASSIGNED)) {
            if (shard.primary()) continue;
            IndexMetaData indexMetaData = state.metaData().index(shard.getIndex());
            long delayTimeoutSetting = shard.unassignedInfo().getAllocationDelayTimeoutSetting(settings, indexMetaData.getSettings());
            if (delayTimeoutSetting <= 0L || delayTimeoutSetting >= nextDelaySetting) continue;
            nextDelaySetting = delayTimeoutSetting;
        }
        return nextDelaySetting == Long.MAX_VALUE ? 0L : nextDelaySetting;
    }

    public static long findNextDelayedAllocationIn(long unassignedShardsAllocatedTimestamp, Settings settings, ClusterState state) {
        long nextDelay = Long.MAX_VALUE;
        for (ShardRouting shard : state.routingTable().shardsWithState(ShardRoutingState.UNASSIGNED)) {
            if (shard.primary()) continue;
            IndexMetaData indexMetaData = state.metaData().index(shard.getIndex());
            long nextShardDelay = shard.unassignedInfo().getDelayAllocationExpirationIn(unassignedShardsAllocatedTimestamp, settings, indexMetaData.getSettings());
            if (nextShardDelay <= 0L || nextShardDelay >= nextDelay) continue;
            nextDelay = nextShardDelay;
        }
        return nextDelay == Long.MAX_VALUE ? 0L : nextDelay;
    }

    public String shortSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("[reason=").append((Object)this.reason).append("]");
        sb.append(", at[").append(DATE_TIME_FORMATTER.printer().print(this.timestamp)).append("]");
        String details = this.getDetails();
        if (details != null) {
            sb.append(", details[").append(details).append("]");
        }
        return sb.toString();
    }

    public String toString() {
        return "unassigned_info[" + this.shortSummary() + "]";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("unassigned_info");
        builder.field("reason", (Object)this.reason);
        builder.field("at", DATE_TIME_FORMATTER.printer().print(this.timestamp));
        String details = this.getDetails();
        if (details != null) {
            builder.field("details", details);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnassignedInfo that = (UnassignedInfo)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.reason != that.reason) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        return !(this.failure == null ? that.failure != null : !this.failure.equals(that.failure));
    }

    public int hashCode() {
        int result = this.reason != null ? this.reason.hashCode() : 0;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.failure != null ? this.failure.hashCode() : 0);
        return result;
    }

    public static enum Reason {
        INDEX_CREATED,
        CLUSTER_RECOVERED,
        INDEX_REOPENED,
        DANGLING_INDEX_IMPORTED,
        NEW_INDEX_RESTORED,
        EXISTING_INDEX_RESTORED,
        REPLICA_ADDED,
        ALLOCATION_FAILED,
        NODE_LEFT,
        REROUTE_CANCELLED,
        REINITIALIZED,
        REALLOCATED_REPLICA;

    }
}

