/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.support.filtering;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.SerializableString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.json.BaseJsonGenerator;
import org.elasticsearch.common.xcontent.support.filtering.FilterContext;

public class FilteringJsonGenerator
extends BaseJsonGenerator {
    private Queue<FilterContext> contexts = new ArrayDeque<FilterContext>();
    private static final int MAX_CONTEXTS = 10;
    private FilterContext context;

    public FilteringJsonGenerator(JsonGenerator generator, String[] filters) {
        super(generator);
        ArrayList<String[]> builder = new ArrayList<String[]>();
        if (filters != null) {
            for (String filter : filters) {
                String[] matcher = Strings.delimitedListToStringArray(filter, ".");
                if (matcher == null) continue;
                builder.add(matcher);
            }
        }
        this.context = this.get(null, null, Collections.unmodifiableList(builder));
    }

    private FilterContext get(String property, FilterContext parent) {
        FilterContext ctx = this.contexts.poll();
        if (ctx == null) {
            ctx = new FilterContext(property, parent);
        } else {
            ctx.reset(property, parent);
        }
        return ctx;
    }

    private FilterContext get(String property, FilterContext context, List<String[]> matchings) {
        FilterContext ctx = this.get(property, context);
        if (matchings != null) {
            for (String[] matching : matchings) {
                ctx.addMatching(matching);
            }
        }
        return ctx;
    }

    private void put(FilterContext ctx) {
        if (this.contexts.size() <= 10) {
            this.contexts.offer(ctx);
        }
    }

    public void writeStartArray() throws IOException {
        this.context.initArray();
        if (this.context.include()) {
            super.writeStartArray();
        }
    }

    public void writeStartArray(int size) throws IOException {
        this.context.initArray();
        if (this.context.include()) {
            super.writeStartArray(size);
        }
    }

    public void writeEndArray() throws IOException {
        if (this.context.isArrayOfObject()) {
            FilterContext parent = this.context.parent();
            this.put(this.context);
            this.context = parent;
        }
        if (this.context.include()) {
            super.writeEndArray();
        }
    }

    public void writeStartObject() throws IOException {
        if (this.context.isArray()) {
            this.context = this.get(null, this.context, this.context.matchings());
            this.context.initArrayOfObject();
        }
        if (!this.context.isArrayOfObject()) {
            this.context.initObject();
        }
        if (this.context.include()) {
            super.writeStartObject();
        }
        this.context = this.get(null, this.context);
    }

    public void writeEndObject() throws IOException {
        if (!this.context.isRoot()) {
            FilterContext parent = this.context.parent();
            this.put(this.context);
            this.context = parent;
        }
        if (this.context.include()) {
            super.writeEndObject();
        }
    }

    public void writeFieldName(String name) throws IOException {
        this.context.reset(name);
        if (this.context.include()) {
            this.context.writePath(this.delegate);
            super.writeFieldName(name);
        }
    }

    public void writeFieldName(SerializableString name) throws IOException {
        this.context.reset(name.getValue());
        if (this.context.include()) {
            this.context.writePath(this.delegate);
            super.writeFieldName(name);
        }
    }

    public void writeString(String text) throws IOException {
        if (this.context.include()) {
            super.writeString(text);
        }
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        if (this.context.include()) {
            super.writeString(text, offset, len);
        }
    }

    public void writeString(SerializableString text) throws IOException {
        if (this.context.include()) {
            super.writeString(text);
        }
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException {
        if (this.context.include()) {
            super.writeRawUTF8String(text, offset, length);
        }
    }

    public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
        if (this.context.include()) {
            super.writeUTF8String(text, offset, length);
        }
    }

    public void writeRaw(String text) throws IOException {
        if (this.context.include()) {
            super.writeRaw(text);
        }
    }

    public void writeRaw(String text, int offset, int len) throws IOException {
        if (this.context.include()) {
            super.writeRaw(text, offset, len);
        }
    }

    public void writeRaw(SerializableString raw) throws IOException {
        if (this.context.include()) {
            super.writeRaw(raw);
        }
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        if (this.context.include()) {
            super.writeRaw(text, offset, len);
        }
    }

    public void writeRaw(char c) throws IOException {
        if (this.context.include()) {
            super.writeRaw(c);
        }
    }

    public void writeRawValue(String text) throws IOException {
        if (this.context.include()) {
            super.writeRawValue(text);
        }
    }

    public void writeRawValue(String text, int offset, int len) throws IOException {
        if (this.context.include()) {
            super.writeRawValue(text, offset, len);
        }
    }

    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        if (this.context.include()) {
            super.writeRawValue(text, offset, len);
        }
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException {
        if (this.context.include()) {
            super.writeBinary(b64variant, data, offset, len);
        }
    }

    public int writeBinary(Base64Variant b64variant, InputStream data, int dataLength) throws IOException {
        if (this.context.include()) {
            return super.writeBinary(b64variant, data, dataLength);
        }
        return 0;
    }

    public void writeNumber(short v) throws IOException {
        if (this.context.include()) {
            super.writeNumber(v);
        }
    }

    public void writeNumber(int v) throws IOException {
        if (this.context.include()) {
            super.writeNumber(v);
        }
    }

    public void writeNumber(long v) throws IOException {
        if (this.context.include()) {
            super.writeNumber(v);
        }
    }

    public void writeNumber(BigInteger v) throws IOException {
        if (this.context.include()) {
            super.writeNumber(v);
        }
    }

    public void writeNumber(double v) throws IOException {
        if (this.context.include()) {
            super.writeNumber(v);
        }
    }

    public void writeNumber(float v) throws IOException {
        if (this.context.include()) {
            super.writeNumber(v);
        }
    }

    public void writeNumber(BigDecimal v) throws IOException {
        if (this.context.include()) {
            super.writeNumber(v);
        }
    }

    public void writeNumber(String encodedValue) throws IOException, UnsupportedOperationException {
        if (this.context.include()) {
            super.writeNumber(encodedValue);
        }
    }

    public void writeBoolean(boolean state) throws IOException {
        if (this.context.include()) {
            super.writeBoolean(state);
        }
    }

    public void writeNull() throws IOException {
        if (this.context.include()) {
            super.writeNull();
        }
    }

    public void copyCurrentEvent(JsonParser jp) throws IOException {
        if (this.context.include()) {
            super.copyCurrentEvent(jp);
        }
    }

    public void copyCurrentStructure(JsonParser jp) throws IOException {
        if (this.context.include()) {
            super.copyCurrentStructure(jp);
        }
    }

    @Override
    protected void writeRawValue(byte[] content, OutputStream bos) throws IOException {
        if (this.context.include()) {
            super.writeRawValue(content, bos);
        }
    }

    @Override
    protected void writeRawValue(byte[] content, int offset, int length, OutputStream bos) throws IOException {
        if (this.context.include()) {
            super.writeRawValue(content, offset, length, bos);
        }
    }

    @Override
    protected void writeRawValue(InputStream content, OutputStream bos) throws IOException {
        if (this.context.include()) {
            super.writeRawValue(content, bos);
        }
    }

    @Override
    protected void writeRawValue(BytesReference content, OutputStream bos) throws IOException {
        if (this.context.include()) {
            super.writeRawValue(content, bos);
        }
    }

    public void close() throws IOException {
        this.contexts.clear();
        super.close();
    }
}

