/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.StringAndBytesText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentFieldMappers;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperUtils;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MergeResult;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;
import org.elasticsearch.index.mapper.internal.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.internal.IdFieldMapper;
import org.elasticsearch.index.mapper.internal.IndexFieldMapper;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.mapper.internal.RoutingFieldMapper;
import org.elasticsearch.index.mapper.internal.SourceFieldMapper;
import org.elasticsearch.index.mapper.internal.TTLFieldMapper;
import org.elasticsearch.index.mapper.internal.TimestampFieldMapper;
import org.elasticsearch.index.mapper.internal.TypeFieldMapper;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.mapper.internal.VersionFieldMapper;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.mapper.object.RootObjectMapper;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.internal.SearchContext;

public class DocumentMapper
implements ToXContent {
    private final MapperService mapperService;
    private final String type;
    private final StringAndBytesText typeText;
    private volatile CompressedXContent mappingSource;
    private final Mapping mapping;
    private final DocumentParser documentParser;
    private volatile DocumentFieldMappers fieldMappers;
    private volatile ImmutableMap<String, ObjectMapper> objectMappers = ImmutableMap.of();
    private boolean hasNestedObjects = false;
    private final ReleasableLock mappingWriteLock;
    private final ReentrantReadWriteLock mappingLock;

    public DocumentMapper(MapperService mapperService, @Nullable Settings indexSettings, DocumentMapperParser docMapperParser, RootObjectMapper rootObjectMapper, ImmutableMap<String, Object> meta, Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> rootMappers, List<Mapping.SourceTransform> sourceTransforms, ReentrantReadWriteLock mappingLock) {
        this.mapperService = mapperService;
        this.type = rootObjectMapper.name();
        this.typeText = new StringAndBytesText(this.type);
        this.mapping = new Mapping(Version.indexCreated(indexSettings), rootObjectMapper, rootMappers.values().toArray(new MetadataFieldMapper[rootMappers.values().size()]), sourceTransforms.toArray(new Mapping.SourceTransform[sourceTransforms.size()]), meta);
        this.documentParser = new DocumentParser(indexSettings, docMapperParser, this, new ReleasableLock(mappingLock.readLock()));
        this.mappingWriteLock = new ReleasableLock(mappingLock.writeLock());
        this.mappingLock = mappingLock;
        if (this.rootMapper(ParentFieldMapper.class).active()) {
            this.rootMapper(RoutingFieldMapper.class).markAsRequired();
        }
        ArrayList<ObjectMapper> newObjectMappers = new ArrayList<ObjectMapper>();
        ArrayList<FieldMapper> newFieldMappers = new ArrayList<FieldMapper>();
        for (MetadataFieldMapper metadataMapper : this.mapping.metadataMappers) {
            if (!(metadataMapper instanceof FieldMapper)) continue;
            newFieldMappers.add(metadataMapper);
        }
        MapperUtils.collect(this.mapping.root, newObjectMappers, newFieldMappers);
        this.fieldMappers = new DocumentFieldMappers(docMapperParser.analysisService).copyAndAllAll(newFieldMappers);
        this.objectMappers = Maps.uniqueIndex(newObjectMappers, (Function)new Function<ObjectMapper, String>(){

            public String apply(ObjectMapper mapper) {
                return mapper.fullPath();
            }
        });
        for (ObjectMapper objectMapper : newObjectMappers) {
            if (!objectMapper.nested().isNested()) continue;
            this.hasNestedObjects = true;
        }
        this.refreshSource();
    }

    public Mapping mapping() {
        return this.mapping;
    }

    public String type() {
        return this.type;
    }

    public Text typeText() {
        return this.typeText;
    }

    public ImmutableMap<String, Object> meta() {
        return this.mapping.meta;
    }

    public CompressedXContent mappingSource() {
        return this.mappingSource;
    }

    public RootObjectMapper root() {
        return this.mapping.root;
    }

    public UidFieldMapper uidMapper() {
        return this.rootMapper(UidFieldMapper.class);
    }

    public <T extends MetadataFieldMapper> T rootMapper(Class<T> type) {
        return this.mapping.rootMapper(type);
    }

    public IndexFieldMapper indexMapper() {
        return this.rootMapper(IndexFieldMapper.class);
    }

    public TypeFieldMapper typeMapper() {
        return this.rootMapper(TypeFieldMapper.class);
    }

    public SourceFieldMapper sourceMapper() {
        return this.rootMapper(SourceFieldMapper.class);
    }

    public AllFieldMapper allFieldMapper() {
        return this.rootMapper(AllFieldMapper.class);
    }

    public IdFieldMapper idFieldMapper() {
        return this.rootMapper(IdFieldMapper.class);
    }

    public RoutingFieldMapper routingFieldMapper() {
        return this.rootMapper(RoutingFieldMapper.class);
    }

    public ParentFieldMapper parentFieldMapper() {
        return this.rootMapper(ParentFieldMapper.class);
    }

    public TimestampFieldMapper timestampFieldMapper() {
        return this.rootMapper(TimestampFieldMapper.class);
    }

    public TTLFieldMapper TTLFieldMapper() {
        return this.rootMapper(TTLFieldMapper.class);
    }

    public IndexFieldMapper IndexFieldMapper() {
        return this.rootMapper(IndexFieldMapper.class);
    }

    public Query typeFilter() {
        return this.typeMapper().fieldType().termQuery(this.type, null);
    }

    public boolean hasNestedObjects() {
        return this.hasNestedObjects;
    }

    public DocumentFieldMappers mappers() {
        return this.fieldMappers;
    }

    public ImmutableMap<String, ObjectMapper> objectMappers() {
        return this.objectMappers;
    }

    public ParsedDocument parse(String index, String type, String id, BytesReference source) throws MapperParsingException {
        return this.parse(SourceToParse.source(source).index(index).type(type).id(id));
    }

    public ParsedDocument parse(SourceToParse source) throws MapperParsingException {
        return this.documentParser.parseDocument(source);
    }

    public ObjectMapper findNestedObjectMapper(int nestedDocId, SearchContext sc, LeafReaderContext context) throws IOException {
        ObjectMapper nestedObjectMapper = null;
        for (ObjectMapper objectMapper : this.objectMappers().values()) {
            DocIdSetIterator iterator;
            DocIdSet nestedTypeSet;
            Filter filter;
            if (!objectMapper.nested().isNested() || (filter = objectMapper.nestedTypeFilter()) == null || (nestedTypeSet = filter.getDocIdSet(context, null)) == null || (iterator = nestedTypeSet.iterator()) == null || iterator.advance(nestedDocId) != nestedDocId) continue;
            if (nestedObjectMapper == null) {
                nestedObjectMapper = objectMapper;
                continue;
            }
            if (nestedObjectMapper.fullPath().length() >= objectMapper.fullPath().length()) continue;
            nestedObjectMapper = objectMapper;
        }
        return nestedObjectMapper;
    }

    public ObjectMapper findParentObjectMapper(ObjectMapper objectMapper) {
        int indexOfLastDot = objectMapper.fullPath().lastIndexOf(46);
        if (indexOfLastDot != -1) {
            String parentNestObjectPath = objectMapper.fullPath().substring(0, indexOfLastDot);
            return (ObjectMapper)this.objectMappers().get((Object)parentNestObjectPath);
        }
        return null;
    }

    public Map<String, Object> transformSourceAsMap(Map<String, Object> sourceAsMap) {
        return DocumentParser.transformSourceAsMap(this.mapping, sourceAsMap);
    }

    public boolean isParent(String type) {
        return this.mapperService.getParentTypes().contains((Object)type);
    }

    private void addMappers(Collection<ObjectMapper> objectMappers, Collection<FieldMapper> fieldMappers, boolean updateAllTypes) {
        assert (this.mappingLock.isWriteLockedByCurrentThread());
        this.mapperService.checkNewMappersCompatibility(objectMappers, fieldMappers, updateAllTypes);
        MapBuilder<String, ObjectMapper> builder = MapBuilder.newMapBuilder(this.objectMappers);
        for (ObjectMapper objectMapper : objectMappers) {
            builder.put(objectMapper.fullPath(), objectMapper);
            if (!objectMapper.nested().isNested()) continue;
            this.hasNestedObjects = true;
        }
        this.objectMappers = builder.immutableMap();
        this.fieldMappers = this.fieldMappers.copyAndAllAll(fieldMappers);
        this.mapperService.addMappers(objectMappers, fieldMappers);
    }

    public MergeResult merge(Mapping mapping, boolean simulate, boolean updateAllTypes) {
        try (ReleasableLock lock = this.mappingWriteLock.acquire();){
            MergeResult mergeResult = new MergeResult(simulate, updateAllTypes);
            this.mapping.merge(mapping, mergeResult);
            if (!simulate) {
                this.addMappers(mergeResult.getNewObjectMappers(), mergeResult.getNewFieldMappers(), updateAllTypes);
                this.refreshSource();
            }
            MergeResult mergeResult2 = mergeResult;
            return mergeResult2;
        }
    }

    private void refreshSource() throws ElasticsearchGenerationException {
        try {
            this.mappingSource = new CompressedXContent(this, XContentType.JSON, ToXContent.EMPTY_PARAMS);
        }
        catch (Exception e) {
            throw new ElasticsearchGenerationException("failed to serialize source for type [" + this.type + "]", e);
        }
    }

    public void close() {
        this.documentParser.close();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.mapping.toXContent(builder, params);
    }

    private static class ScriptTransform
    implements Mapping.SourceTransform {
        private final ScriptService scriptService;
        private final Script script;

        public ScriptTransform(ScriptService scriptService, Script script) {
            this.scriptService = scriptService;
            this.script = script;
        }

        @Override
        public Map<String, Object> transformSourceAsMap(Map<String, Object> sourceAsMap) {
            try {
                ExecutableScript executable = this.scriptService.executable(this.script, ScriptContext.Standard.MAPPING, null);
                Map ctx = new HashMap<String, Map<String, Object>>(1);
                ctx.put("_source", sourceAsMap);
                executable.setNextVar("ctx", ctx);
                executable.run();
                ctx = (Map)executable.unwrap(ctx);
                return (Map)ctx.get("_source");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("failed to execute script", e);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.script.toXContent(builder, params);
        }
    }

    public static class Builder {
        private Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> rootMappers = new LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>();
        private List<Mapping.SourceTransform> sourceTransforms = new ArrayList<Mapping.SourceTransform>(1);
        private final Settings indexSettings;
        private final RootObjectMapper rootObjectMapper;
        private ImmutableMap<String, Object> meta = ImmutableMap.of();
        private final Mapper.BuilderContext builderContext;

        public Builder(Settings indexSettings, RootObjectMapper.Builder builder, MapperService mapperService) {
            this.indexSettings = indexSettings;
            this.builderContext = new Mapper.BuilderContext(indexSettings, new ContentPath(1));
            this.rootObjectMapper = (RootObjectMapper)builder.build(this.builderContext);
            this.rootMappers.put(UidFieldMapper.class, new UidFieldMapper(indexSettings, mapperService.fullName("_uid")));
            this.rootMappers.put(IdFieldMapper.class, new IdFieldMapper(indexSettings, mapperService.fullName("_id")));
            this.rootMappers.put(RoutingFieldMapper.class, new RoutingFieldMapper(indexSettings, mapperService.fullName("_routing")));
            this.rootMappers.put(IndexFieldMapper.class, new IndexFieldMapper(indexSettings, mapperService.fullName("_index")));
            this.rootMappers.put(SourceFieldMapper.class, new SourceFieldMapper(indexSettings));
            this.rootMappers.put(TypeFieldMapper.class, new TypeFieldMapper(indexSettings, mapperService.fullName("_type")));
            this.rootMappers.put(AllFieldMapper.class, new AllFieldMapper(indexSettings, mapperService.fullName("_all")));
            this.rootMappers.put(TimestampFieldMapper.class, new TimestampFieldMapper(indexSettings, mapperService.fullName("_timestamp")));
            this.rootMappers.put(TTLFieldMapper.class, new TTLFieldMapper(indexSettings));
            this.rootMappers.put(VersionFieldMapper.class, new VersionFieldMapper(indexSettings));
            this.rootMappers.put(ParentFieldMapper.class, new ParentFieldMapper(indexSettings, mapperService.fullName("_parent"), builder.name()));
            this.rootMappers.put(FieldNamesFieldMapper.class, new FieldNamesFieldMapper(indexSettings, mapperService.fullName("_field_names")));
        }

        public Builder meta(ImmutableMap<String, Object> meta) {
            this.meta = meta;
            return this;
        }

        public Builder put(MetadataFieldMapper.Builder<?, ?> mapper) {
            MetadataFieldMapper metadataMapper = (MetadataFieldMapper)mapper.build(this.builderContext);
            this.rootMappers.put(metadataMapper.getClass(), metadataMapper);
            return this;
        }

        public Builder transform(ScriptService scriptService, Script script) {
            this.sourceTransforms.add(new ScriptTransform(scriptService, script));
            return this;
        }

        @Deprecated
        public Builder transform(ScriptService scriptService, String script, ScriptService.ScriptType scriptType, String language, Map<String, Object> parameters) {
            this.sourceTransforms.add(new ScriptTransform(scriptService, new Script(script, scriptType, language, parameters)));
            return this;
        }

        public DocumentMapper build(MapperService mapperService, DocumentMapperParser docMapperParser) {
            Preconditions.checkNotNull((Object)this.rootObjectMapper, (Object)"Mapper builder must have the root object mapper set");
            return new DocumentMapper(mapperService, this.indexSettings, docMapperParser, this.rootObjectMapper, this.meta, this.rootMappers, this.sourceTransforms, mapperService.mappingLock);
        }
    }
}

