/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.DoubleTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.GlobalOrdinalsStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.LongTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.ContextIndexSearcher;

public class TermsAggregatorFactory
extends ValuesSourceAggregatorFactory<ValuesSource> {
    private final Terms.Order order;
    private final IncludeExclude includeExclude;
    private final String executionHint;
    private final Aggregator.SubAggCollectionMode collectMode;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final boolean showTermDocCountError;

    public TermsAggregatorFactory(String name, ValuesSourceConfig config, Terms.Order order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, String executionHint, Aggregator.SubAggCollectionMode executionMode, boolean showTermDocCountError) {
        super(name, StringTerms.TYPE.name(), config);
        this.order = order;
        this.includeExclude = includeExclude;
        this.executionHint = executionHint;
        this.bucketCountThresholds = bucketCountThresholds;
        this.collectMode = executionMode;
        this.showTermDocCountError = showTermDocCountError;
    }

    @Override
    protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        final UnmappedTerms aggregation = new UnmappedTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getShardSize(), this.bucketCountThresholds.getMinDocCount(), pipelineAggregators, metaData);
        return new NonCollectingAggregator(this.name, aggregationContext, parent, this.factories, pipelineAggregators, metaData){
            {
                super(x0, x1, x2, x3, (List<PipelineAggregator>)x4, (Map<String, Object>)x5);
                InternalOrder.validate(TermsAggregatorFactory.this.order, this);
            }

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, AggregationContext aggregationContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (!collectsFromSingleBucket) {
            return TermsAggregatorFactory.asMultiBucketAggregator(this, aggregationContext, parent);
        }
        if (valuesSource instanceof ValuesSource.Bytes) {
            double ratio;
            long maxOrd;
            ExecutionMode execution = null;
            if (this.executionHint != null) {
                execution = ExecutionMode.fromString(this.executionHint, aggregationContext.searchContext().parseFieldMatcher());
            }
            if (!(valuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
                execution = ExecutionMode.MAP;
            }
            if (execution == null || execution.needsGlobalOrdinals()) {
                ValuesSource.Bytes.WithOrdinals valueSourceWithOrdinals = (ValuesSource.Bytes.WithOrdinals)valuesSource;
                ContextIndexSearcher indexSearcher = aggregationContext.searchContext().searcher();
                maxOrd = valueSourceWithOrdinals.globalMaxOrd(indexSearcher);
                ratio = (double)maxOrd / (double)indexSearcher.getIndexReader().numDocs();
            } else {
                maxOrd = -1L;
                ratio = -1.0;
            }
            if (execution == null) {
                execution = Aggregator.descendsFromBucketAggregator(parent) ? ExecutionMode.GLOBAL_ORDINALS_HASH : (this.factories == AggregatorFactories.EMPTY ? (ratio <= 0.5 && maxOrd <= 2048L ? ExecutionMode.GLOBAL_ORDINALS_LOW_CARDINALITY : ExecutionMode.GLOBAL_ORDINALS) : ExecutionMode.GLOBAL_ORDINALS);
            }
            return execution.create(this.name, this.factories, valuesSource, this.order, this.bucketCountThresholds, this.includeExclude, aggregationContext, parent, this.collectMode, this.showTermDocCountError, pipelineAggregators, metaData);
        }
        if (this.includeExclude != null && this.includeExclude.isRegexBased()) {
            throw new AggregationExecutionException("Aggregation [" + this.name + "] cannot support regular expression style include/exclude " + "settings as they can only be applied to string fields. Use an array of numeric values for include/exclude clauses used to filter numeric fields");
        }
        if (valuesSource instanceof ValuesSource.Numeric) {
            IncludeExclude.LongFilter longFilter = null;
            if (((ValuesSource.Numeric)valuesSource).isFloatingPoint()) {
                if (this.includeExclude != null) {
                    longFilter = this.includeExclude.convertToDoubleFilter();
                }
                return new DoubleTermsAggregator(this.name, this.factories, (ValuesSource.Numeric)valuesSource, this.config.format(), this.order, this.bucketCountThresholds, aggregationContext, parent, this.collectMode, this.showTermDocCountError, longFilter, pipelineAggregators, metaData);
            }
            if (this.includeExclude != null) {
                longFilter = this.includeExclude.convertToLongFilter();
            }
            return new LongTermsAggregator(this.name, this.factories, (ValuesSource.Numeric)valuesSource, this.config.format(), this.order, this.bucketCountThresholds, aggregationContext, parent, this.collectMode, this.showTermDocCountError, longFilter, pipelineAggregators, metaData);
        }
        throw new AggregationExecutionException("terms aggregation cannot be applied to field [" + this.config.fieldContext().field() + "]. It can only be applied to numeric or string fields.");
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, Terms.Order order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                IncludeExclude.StringFilter filter = includeExclude == null ? null : includeExclude.convertToStringFilter();
                return new StringTermsAggregator(name, factories, valuesSource, order, bucketCountThresholds, filter, aggregationContext, parent, subAggCollectMode, showTermDocCountError, pipelineAggregators, metaData);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return false;
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, Terms.Order order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                IncludeExclude.OrdinalsFilter filter = includeExclude == null ? null : includeExclude.convertToOrdinalsFilter();
                return new GlobalOrdinalsStringTermsAggregator(name, factories, (ValuesSource.Bytes.WithOrdinals)valuesSource, order, bucketCountThresholds, filter, aggregationContext, parent, subAggCollectMode, showTermDocCountError, pipelineAggregators, metaData);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return true;
            }
        }
        ,
        GLOBAL_ORDINALS_HASH(new ParseField("global_ordinals_hash", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, Terms.Order order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                IncludeExclude.OrdinalsFilter filter = includeExclude == null ? null : includeExclude.convertToOrdinalsFilter();
                return new GlobalOrdinalsStringTermsAggregator.WithHash(name, factories, (ValuesSource.Bytes.WithOrdinals.FieldData)valuesSource, order, bucketCountThresholds, filter, aggregationContext, parent, subAggCollectMode, showTermDocCountError, pipelineAggregators, metaData);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return true;
            }
        }
        ,
        GLOBAL_ORDINALS_LOW_CARDINALITY(new ParseField("global_ordinals_low_cardinality", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, Terms.Order order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                if (includeExclude != null || factories.count() > 0) {
                    return GLOBAL_ORDINALS.create(name, factories, valuesSource, order, bucketCountThresholds, includeExclude, aggregationContext, parent, subAggCollectMode, showTermDocCountError, pipelineAggregators, metaData);
                }
                return new GlobalOrdinalsStringTermsAggregator.LowCardinality(name, factories, (ValuesSource.Bytes.WithOrdinals)valuesSource, order, bucketCountThresholds, aggregationContext, parent, subAggCollectMode, showTermDocCountError, pipelineAggregators, metaData);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return true;
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value, ParseFieldMatcher parseFieldMatcher) {
            for (ExecutionMode mode : ExecutionMode.values()) {
                if (!parseFieldMatcher.match(value, mode.parseField)) continue;
                return mode;
            }
            throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of " + ExecutionMode.values());
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, ValuesSource var3, Terms.Order var4, TermsAggregator.BucketCountThresholds var5, IncludeExclude var6, AggregationContext var7, Aggregator var8, Aggregator.SubAggCollectionMode var9, boolean var10, List<PipelineAggregator> var11, Map<String, Object> var12) throws IOException;

        abstract boolean needsGlobalOrdinals();

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

