/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.MinDocQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.Weight;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.MinimumScoreCollector;
import org.elasticsearch.common.lucene.search.FilteredCollector;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.aggregations.AggregationPhase;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.FilterBinaryParseElement;
import org.elasticsearch.search.query.FromParseElement;
import org.elasticsearch.search.query.IndicesBoostParseElement;
import org.elasticsearch.search.query.MinScoreParseElement;
import org.elasticsearch.search.query.PostFilterParseElement;
import org.elasticsearch.search.query.QueryBinaryParseElement;
import org.elasticsearch.search.query.QueryParseElement;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.SizeParseElement;
import org.elasticsearch.search.query.TerminateAfterParseElement;
import org.elasticsearch.search.query.TimeoutParseElement;
import org.elasticsearch.search.rescore.RescorePhase;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.scan.ScanContext;
import org.elasticsearch.search.sort.SortParseElement;
import org.elasticsearch.search.sort.TrackScoresParseElement;
import org.elasticsearch.search.suggest.SuggestPhase;

public class QueryPhase
implements SearchPhase {
    private final AggregationPhase aggregationPhase;
    private final SuggestPhase suggestPhase;
    private RescorePhase rescorePhase;

    @Inject
    public QueryPhase(AggregationPhase aggregationPhase, SuggestPhase suggestPhase, RescorePhase rescorePhase) {
        this.aggregationPhase = aggregationPhase;
        this.suggestPhase = suggestPhase;
        this.rescorePhase = rescorePhase;
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        ImmutableMap.Builder parseElements = ImmutableMap.builder();
        parseElements.put((Object)"from", (Object)new FromParseElement()).put((Object)"size", (Object)new SizeParseElement()).put((Object)"indices_boost", (Object)new IndicesBoostParseElement()).put((Object)"indicesBoost", (Object)new IndicesBoostParseElement()).put((Object)"query", (Object)new QueryParseElement()).put((Object)"queryBinary", (Object)new QueryBinaryParseElement()).put((Object)"query_binary", (Object)new QueryBinaryParseElement()).put((Object)"filter", (Object)new PostFilterParseElement()).put((Object)"post_filter", (Object)new PostFilterParseElement()).put((Object)"postFilter", (Object)new PostFilterParseElement()).put((Object)"filterBinary", (Object)new FilterBinaryParseElement()).put((Object)"filter_binary", (Object)new FilterBinaryParseElement()).put((Object)"sort", (Object)new SortParseElement()).put((Object)"trackScores", (Object)new TrackScoresParseElement()).put((Object)"track_scores", (Object)new TrackScoresParseElement()).put((Object)"min_score", (Object)new MinScoreParseElement()).put((Object)"minScore", (Object)new MinScoreParseElement()).put((Object)"timeout", (Object)new TimeoutParseElement()).put((Object)"terminate_after", (Object)new TerminateAfterParseElement()).putAll(this.aggregationPhase.parseElements()).putAll(this.suggestPhase.parseElements()).putAll(this.rescorePhase.parseElements());
        return parseElements.build();
    }

    @Override
    public void preProcess(SearchContext context) {
        context.preProcess();
    }

    @Override
    public void execute(SearchContext searchContext) throws QueryPhaseExecutionException {
        this.aggregationPhase.preProcess(searchContext);
        boolean rescore = QueryPhase.execute(searchContext, searchContext.searcher());
        if (rescore) {
            this.rescorePhase.execute(searchContext);
        }
        this.suggestPhase.execute(searchContext);
        this.aggregationPhase.execute(searchContext);
    }

    private static boolean returnsDocsInOrder(Query query, Sort sort) {
        if (sort == null || Sort.RELEVANCE.equals((Object)sort)) {
            return query.getClass() == ConstantScoreQuery.class || query.getClass() == MatchAllDocsQuery.class;
        }
        return Sort.INDEXORDER.equals((Object)sort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean execute(SearchContext searchContext, final IndexSearcher searcher) throws QueryPhaseExecutionException {
        QuerySearchResult queryResult = searchContext.queryResult();
        queryResult.searchTimedOut(false);
        SearchType searchType = searchContext.searchType();
        boolean rescore = false;
        try {
            boolean timeoutSet;
            boolean terminateAfterSet;
            Callable<TopDocs> topDocsCallable;
            Object collector;
            queryResult.from(searchContext.from());
            queryResult.size(searchContext.size());
            Query query = searchContext.query();
            int totalNumDocs = searcher.getIndexReader().numDocs();
            int numDocs = Math.min(searchContext.from() + searchContext.size(), totalNumDocs);
            assert (query == searcher.rewrite(query));
            if (searchContext.size() == 0) {
                TotalHitCountCollector totalHitCountCollector;
                collector = totalHitCountCollector = new TotalHitCountCollector();
                topDocsCallable = new Callable<TopDocs>(){

                    @Override
                    public TopDocs call() throws Exception {
                        return new TopDocs(totalHitCountCollector.getTotalHits(), Lucene.EMPTY_SCORE_DOCS, 0.0f);
                    }
                };
            } else if (searchType == SearchType.SCAN) {
                query = searchContext.scanContext().wrapQuery(query);
                final ScanContext.ScanCollector scanCollector = searchContext.scanContext().collector(searchContext);
                collector = scanCollector;
                topDocsCallable = new Callable<TopDocs>(){

                    @Override
                    public TopDocs call() throws Exception {
                        return scanCollector.topDocs();
                    }
                };
            } else {
                TopFieldCollector topDocsCollector;
                ScoreDoc lastEmittedDoc;
                ScrollContext scrollContext = searchContext.scrollContext();
                assert (scrollContext != null == (searchContext.request().scroll() != null));
                if (searchContext.request().scroll() != null) {
                    numDocs = Math.min(searchContext.size(), totalNumDocs);
                    lastEmittedDoc = scrollContext.lastEmittedDoc;
                    if (QueryPhase.returnsDocsInOrder(query, searchContext.sort())) {
                        if (scrollContext.totalHits == -1) {
                            assert (scrollContext.lastEmittedDoc == null);
                        } else {
                            if (scrollContext.lastEmittedDoc != null) {
                                BooleanQuery bq = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add((Query)new MinDocQuery(lastEmittedDoc.doc + 1), BooleanClause.Occur.FILTER).build();
                                query = bq;
                            }
                            searchContext.terminateAfter(numDocs);
                        }
                    }
                } else {
                    lastEmittedDoc = null;
                }
                if (totalNumDocs == 0) {
                    numDocs = 1;
                }
                assert (numDocs > 0);
                if (searchContext.sort() != null) {
                    topDocsCollector = TopFieldCollector.create((Sort)searchContext.sort(), (int)numDocs, (FieldDoc)((FieldDoc)lastEmittedDoc), (boolean)true, (boolean)searchContext.trackScores(), (boolean)searchContext.trackScores());
                } else {
                    rescore = !searchContext.rescore().isEmpty();
                    for (RescoreSearchContext rescoreContext : searchContext.rescore()) {
                        numDocs = Math.max(rescoreContext.window(), numDocs);
                    }
                    topDocsCollector = TopScoreDocCollector.create((int)numDocs, (ScoreDoc)lastEmittedDoc);
                }
                collector = topDocsCollector;
                topDocsCallable = new Callable<TopDocs>((TopDocsCollector)topDocsCollector, scrollContext, searchType){
                    final /* synthetic */ TopDocsCollector val$topDocsCollector;
                    final /* synthetic */ ScrollContext val$scrollContext;
                    final /* synthetic */ SearchType val$searchType;
                    {
                        this.val$topDocsCollector = topDocsCollector;
                        this.val$scrollContext = scrollContext;
                        this.val$searchType = searchType;
                    }

                    @Override
                    public TopDocs call() throws Exception {
                        TopDocs topDocs = this.val$topDocsCollector.topDocs();
                        if (this.val$scrollContext != null) {
                            if (this.val$scrollContext.totalHits == -1) {
                                this.val$scrollContext.totalHits = topDocs.totalHits;
                                this.val$scrollContext.maxScore = topDocs.getMaxScore();
                            } else {
                                topDocs.totalHits = this.val$scrollContext.totalHits;
                                topDocs.setMaxScore(this.val$scrollContext.maxScore);
                            }
                            switch (this.val$searchType) {
                                case QUERY_AND_FETCH: 
                                case DFS_QUERY_AND_FETCH: {
                                    if (topDocs.scoreDocs.length <= 0) break;
                                    this.val$scrollContext.lastEmittedDoc = topDocs.scoreDocs[topDocs.scoreDocs.length - 1];
                                }
                            }
                        }
                        return topDocs;
                    }
                };
            }
            boolean bl = terminateAfterSet = searchContext.terminateAfter() != 0;
            if (terminateAfterSet) {
                collector = Lucene.wrapCountBasedEarlyTerminatingCollector((Collector)collector, searchContext.terminateAfter());
            }
            if (searchContext.parsedPostFilter() != null) {
                Weight filterWeight = searcher.createNormalizedWeight(searchContext.parsedPostFilter().query(), false);
                collector = new FilteredCollector((Collector)collector, filterWeight);
            }
            ArrayList<Object> allCollectors = new ArrayList<Object>();
            allCollectors.add(collector);
            allCollectors.addAll(searchContext.queryCollectors().values());
            collector = MultiCollector.wrap(allCollectors);
            if (searchContext.minimumScore() != null) {
                collector = new MinimumScoreCollector((Collector)collector, searchContext.minimumScore().floatValue());
            }
            if (collector.getClass() == TotalHitCountCollector.class) {
                while (query instanceof ConstantScoreQuery) {
                    query = ((ConstantScoreQuery)query).getQuery();
                }
                if (query.getClass() == MatchAllDocsQuery.class) {
                    collector = null;
                    topDocsCallable = new Callable<TopDocs>(){

                        @Override
                        public TopDocs call() throws Exception {
                            int count = searcher.getIndexReader().numDocs();
                            return new TopDocs(count, Lucene.EMPTY_SCORE_DOCS, 0.0f);
                        }
                    };
                } else if (query.getClass() == TermQuery.class && !searcher.getIndexReader().hasDeletions()) {
                    final Term term = ((TermQuery)query).getTerm();
                    collector = null;
                    topDocsCallable = new Callable<TopDocs>(){

                        @Override
                        public TopDocs call() throws Exception {
                            int count = 0;
                            for (LeafReaderContext context : searcher.getIndexReader().leaves()) {
                                count += context.reader().docFreq(term);
                            }
                            return new TopDocs(count, Lucene.EMPTY_SCORE_DOCS, 0.0f);
                        }
                    };
                }
            }
            boolean bl2 = timeoutSet = searchContext.timeoutInMillis() != SearchService.NO_TIMEOUT.millis();
            if (timeoutSet && collector != null) {
                collector = Lucene.wrapTimeLimitingCollector((Collector)collector, searchContext.timeEstimateCounter(), searchContext.timeoutInMillis());
            }
            try {
                if (collector != null) {
                    searcher.search(query, (Collector)collector);
                }
            }
            catch (TimeLimitingCollector.TimeExceededException e) {
                assert (timeoutSet) : "TimeExceededException thrown even though timeout wasn't set";
                queryResult.searchTimedOut(true);
            }
            catch (Lucene.EarlyTerminationException e) {
                assert (terminateAfterSet) : "EarlyTerminationException thrown even though terminateAfter wasn't set";
                queryResult.terminatedEarly(true);
            }
            finally {
                searchContext.clearReleasables(SearchContext.Lifetime.COLLECTION);
            }
            if (terminateAfterSet && queryResult.terminatedEarly() == null) {
                queryResult.terminatedEarly(false);
            }
            queryResult.topDocs(topDocsCallable.call());
            return rescore;
        }
        catch (Throwable e) {
            throw new QueryPhaseExecutionException(searchContext, "Failed to execute main query", e);
        }
    }
}

