%% Generated by the Erlang ASN.1 BER_V2-compiler version, utilizing bit-syntax:4.0
%% Purpose: encoder and decoder to the types in mod megaco_ber_media_gateway_control_v2

-module('megaco_ber_media_gateway_control_v2').
-compile(nowarn_unused_vars).
-include("megaco_ber_media_gateway_control_v2.hrl").
-asn1_info([{vsn,'4.0'},
            {module,'megaco_ber_media_gateway_control_v2'},
            {options,[warnings,ber,errors,
 {cwd,"/build/erlang-nox/src/otp/lib/megaco/src/binary"},
 {outdir,"/build/erlang-nox/src/otp/lib/megaco/src/binary"},
 asn1config,legacy_erlang_types,noobj,
 {i,"."},
 {i,"/build/erlang-nox/src/otp/lib/megaco/src/binary"}]}]).

-export([encoding_rule/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
'enc_Value'/2,
'enc_TimeNotation'/2,
'enc_H221NonStandard'/2,
'enc_NonStandardIdentifier'/2,
'enc_NonStandardData'/2,
'enc_StatisticsParameter'/2,
'enc_StatisticsDescriptor'/2,
'enc_PackagesItem'/2,
'enc_PackagesDescriptor'/2,
'enc_ServiceChangeProfile'/2,
'enc_ServiceChangeMethod'/2,
'enc_ServiceChangeResParm'/2,
'enc_ServiceChangeAddress'/2,
'enc_ServiceChangeParm'/2,
'enc_DigitMapValue'/2,
'enc_DigitMapName'/2,
'enc_DigitMapDescriptor'/2,
'enc_ModemType'/2,
'enc_ModemDescriptor'/2,
'enc_RequestID'/2,
'enc_SigParameter'/2,
'enc_NotifyCompletion'/2,
'enc_SignalName'/2,
'enc_SignalType'/2,
'enc_Signal'/2,
'enc_SeqSigList'/2,
'enc_SignalRequest'/2,
'enc_SignalsDescriptor'/2,
'enc_EventSpec'/2,
'enc_EventBufferDescriptor'/2,
'enc_SecondRequestedActions'/2,
'enc_SecondRequestedEvent'/2,
'enc_SecondEventsDescriptor'/2,
'enc_EventDM'/2,
'enc_RequestedActions'/2,
'enc_RequestedEvent'/2,
'enc_EventsDescriptor'/2,
'enc_StreamID'/2,
'enc_MuxType'/2,
'enc_MuxDescriptor'/2,
'enc_ServiceState'/2,
'enc_EventBufferControl'/2,
'enc_TerminationStateDescriptor'/2,
'enc_PropertyGroup'/2,
'enc_LocalRemoteDescriptor'/2,
'enc_Relation'/2,
'enc_PkgdName'/2,
'enc_Name'/2,
'enc_PropertyParm'/2,
'enc_StreamMode'/2,
'enc_LocalControlDescriptor'/2,
'enc_StreamParms'/2,
'enc_StreamDescriptor'/2,
'enc_MediaDescriptor'/2,
'enc_TerminationIDList'/2,
'enc_TerminationID'/2,
'enc_WildcardField'/2,
'enc_ServiceChangeResult'/2,
'enc_ServiceChangeReply'/2,
'enc_ServiceChangeRequest'/2,
'enc_EventParameter'/2,
'enc_EventName'/2,
'enc_ObservedEvent'/2,
'enc_ObservedEventsDescriptor'/2,
'enc_NotifyReply'/2,
'enc_NotifyRequest'/2,
'enc_IndAudPackagesDescriptor'/2,
'enc_IndAudStatisticsDescriptor'/2,
'enc_IndAudDigitMapDescriptor'/2,
'enc_IndAudSignal'/2,
'enc_IndAudSeqSigList'/2,
'enc_IndAudSignalsDescriptor'/2,
'enc_IndAudEventBufferDescriptor'/2,
'enc_IndAudEventsDescriptor'/2,
'enc_IndAudTerminationStateDescriptor'/2,
'enc_IndAudPropertyGroup'/2,
'enc_IndAudLocalRemoteDescriptor'/2,
'enc_IndAudPropertyParm'/2,
'enc_IndAudLocalControlDescriptor'/2,
'enc_IndAudStreamParms'/2,
'enc_IndAudStreamDescriptor'/2,
'enc_IndAudMediaDescriptor'/2,
'enc_IndAuditParameter'/2,
'enc_AuditDescriptor'/2,
'enc_AuditReturnParameter'/2,
'enc_TerminationAudit'/2,
'enc_AuditResult'/2,
'enc_AuditReply'/2,
'enc_AuditRequest'/2,
'enc_SubtractRequest'/2,
'enc_AmmsReply'/2,
'enc_AmmDescriptor'/2,
'enc_AmmRequest'/2,
'enc_TopologyRequest'/2,
'enc_CommandReply'/2,
'enc_Command'/2,
'enc_CommandRequest'/2,
'enc_ContextAttrAuditRequest'/2,
'enc_ContextRequest'/2,
'enc_ActionReply'/2,
'enc_ActionRequest'/2,
'enc_ContextID'/2,
'enc_ErrorText'/2,
'enc_ErrorCode'/2,
'enc_ErrorDescriptor'/2,
'enc_TransactionAck'/2,
'enc_TransactionResponseAck'/2,
'enc_TransactionReply'/2,
'enc_TransactionPending'/2,
'enc_TransactionRequest'/2,
'enc_TransactionId'/2,
'enc_Transaction'/2,
'enc_PathName'/2,
'enc_IP6Address'/2,
'enc_IP4Address'/2,
'enc_DomainName'/2,
'enc_MId'/2,
'enc_Message'/2,
'enc_AuthData'/2,
'enc_SequenceNum'/2,
'enc_SecurityParmIndex'/2,
'enc_AuthenticationHeader'/2,
'enc_MegacoMessage'/2
]).

-export([
'dec_Value'/2,
'dec_TimeNotation'/2,
'dec_H221NonStandard'/2,
'dec_NonStandardIdentifier'/2,
'dec_NonStandardData'/2,
'dec_StatisticsParameter'/2,
'dec_StatisticsDescriptor'/2,
'dec_PackagesItem'/2,
'dec_PackagesDescriptor'/2,
'dec_ServiceChangeProfile'/2,
'dec_ServiceChangeMethod'/2,
'dec_ServiceChangeResParm'/2,
'dec_ServiceChangeAddress'/2,
'dec_ServiceChangeParm'/2,
'dec_DigitMapValue'/2,
'dec_DigitMapName'/2,
'dec_DigitMapDescriptor'/2,
'dec_ModemType'/2,
'dec_ModemDescriptor'/2,
'dec_RequestID'/2,
'dec_SigParameter'/2,
'dec_NotifyCompletion'/2,
'dec_SignalName'/2,
'dec_SignalType'/2,
'dec_Signal'/2,
'dec_SeqSigList'/2,
'dec_SignalRequest'/2,
'dec_SignalsDescriptor'/2,
'dec_EventSpec'/2,
'dec_EventBufferDescriptor'/2,
'dec_SecondRequestedActions'/2,
'dec_SecondRequestedEvent'/2,
'dec_SecondEventsDescriptor'/2,
'dec_EventDM'/2,
'dec_RequestedActions'/2,
'dec_RequestedEvent'/2,
'dec_EventsDescriptor'/2,
'dec_StreamID'/2,
'dec_MuxType'/2,
'dec_MuxDescriptor'/2,
'dec_ServiceState'/2,
'dec_EventBufferControl'/2,
'dec_TerminationStateDescriptor'/2,
'dec_PropertyGroup'/2,
'dec_LocalRemoteDescriptor'/2,
'dec_Relation'/2,
'dec_PkgdName'/2,
'dec_Name'/2,
'dec_PropertyParm'/2,
'dec_StreamMode'/2,
'dec_LocalControlDescriptor'/2,
'dec_StreamParms'/2,
'dec_StreamDescriptor'/2,
'dec_MediaDescriptor'/2,
'dec_TerminationIDList'/2,
'dec_TerminationID'/2,
'dec_WildcardField'/2,
'dec_ServiceChangeResult'/2,
'dec_ServiceChangeReply'/2,
'dec_ServiceChangeRequest'/2,
'dec_EventParameter'/2,
'dec_EventName'/2,
'dec_ObservedEvent'/2,
'dec_ObservedEventsDescriptor'/2,
'dec_NotifyReply'/2,
'dec_NotifyRequest'/2,
'dec_IndAudPackagesDescriptor'/2,
'dec_IndAudStatisticsDescriptor'/2,
'dec_IndAudDigitMapDescriptor'/2,
'dec_IndAudSignal'/2,
'dec_IndAudSeqSigList'/2,
'dec_IndAudSignalsDescriptor'/2,
'dec_IndAudEventBufferDescriptor'/2,
'dec_IndAudEventsDescriptor'/2,
'dec_IndAudTerminationStateDescriptor'/2,
'dec_IndAudPropertyGroup'/2,
'dec_IndAudLocalRemoteDescriptor'/2,
'dec_IndAudPropertyParm'/2,
'dec_IndAudLocalControlDescriptor'/2,
'dec_IndAudStreamParms'/2,
'dec_IndAudStreamDescriptor'/2,
'dec_IndAudMediaDescriptor'/2,
'dec_IndAuditParameter'/2,
'dec_AuditDescriptor'/2,
'dec_AuditReturnParameter'/2,
'dec_TerminationAudit'/2,
'dec_AuditResult'/2,
'dec_AuditReply'/2,
'dec_AuditRequest'/2,
'dec_SubtractRequest'/2,
'dec_AmmsReply'/2,
'dec_AmmDescriptor'/2,
'dec_AmmRequest'/2,
'dec_TopologyRequest'/2,
'dec_CommandReply'/2,
'dec_Command'/2,
'dec_CommandRequest'/2,
'dec_ContextAttrAuditRequest'/2,
'dec_ContextRequest'/2,
'dec_ActionReply'/2,
'dec_ActionRequest'/2,
'dec_ContextID'/2,
'dec_ErrorText'/2,
'dec_ErrorCode'/2,
'dec_ErrorDescriptor'/2,
'dec_TransactionAck'/2,
'dec_TransactionResponseAck'/2,
'dec_TransactionReply'/2,
'dec_TransactionPending'/2,
'dec_TransactionRequest'/2,
'dec_TransactionId'/2,
'dec_Transaction'/2,
'dec_PathName'/2,
'dec_IP6Address'/2,
'dec_IP4Address'/2,
'dec_DomainName'/2,
'dec_MId'/2,
'dec_Message'/2,
'dec_AuthData'/2,
'dec_SequenceNum'/2,
'dec_SecurityParmIndex'/2,
'dec_AuthenticationHeader'/2,
'dec_MegacoMessage'/2
]).

-export([info/0]).


-export([encode/2,decode/2]).

encoding_rule() -> ber.

bit_string_format() -> bitstring.

legacy_erlang_types() -> true.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception when Class =:= error; Class =:= exit ->
      case Exception of
        {error,Reason}=Error ->
          Error;
        Reason ->
         {error,{asn1,Reason}}
      end
end.

decode(Type,Data) ->
try decode_disp(Type, element(1, ber_decode_nif(Data))) of
  Result ->
    {ok,Result}
  catch
    Class:Exception when Class =:= error; Class =:= exit ->
      case Exception of
        {error,Reason}=Error ->
          Error;
        Reason ->
         {error,{asn1,Reason}}
      end
end.

encode_disp('Value',Data) -> 'enc_Value'(Data);
encode_disp('TimeNotation',Data) -> 'enc_TimeNotation'(Data);
encode_disp('H221NonStandard',Data) -> 'enc_H221NonStandard'(Data);
encode_disp('NonStandardIdentifier',Data) -> 'enc_NonStandardIdentifier'(Data);
encode_disp('NonStandardData',Data) -> 'enc_NonStandardData'(Data);
encode_disp('StatisticsParameter',Data) -> 'enc_StatisticsParameter'(Data);
encode_disp('StatisticsDescriptor',Data) -> 'enc_StatisticsDescriptor'(Data);
encode_disp('PackagesItem',Data) -> 'enc_PackagesItem'(Data);
encode_disp('PackagesDescriptor',Data) -> 'enc_PackagesDescriptor'(Data);
encode_disp('ServiceChangeProfile',Data) -> 'enc_ServiceChangeProfile'(Data);
encode_disp('ServiceChangeMethod',Data) -> 'enc_ServiceChangeMethod'(Data);
encode_disp('ServiceChangeResParm',Data) -> 'enc_ServiceChangeResParm'(Data);
encode_disp('ServiceChangeAddress',Data) -> 'enc_ServiceChangeAddress'(Data);
encode_disp('ServiceChangeParm',Data) -> 'enc_ServiceChangeParm'(Data);
encode_disp('DigitMapValue',Data) -> 'enc_DigitMapValue'(Data);
encode_disp('DigitMapName',Data) -> 'enc_DigitMapName'(Data);
encode_disp('DigitMapDescriptor',Data) -> 'enc_DigitMapDescriptor'(Data);
encode_disp('ModemType',Data) -> 'enc_ModemType'(Data);
encode_disp('ModemDescriptor',Data) -> 'enc_ModemDescriptor'(Data);
encode_disp('RequestID',Data) -> 'enc_RequestID'(Data);
encode_disp('SigParameter',Data) -> 'enc_SigParameter'(Data);
encode_disp('NotifyCompletion',Data) -> 'enc_NotifyCompletion'(Data);
encode_disp('SignalName',Data) -> 'enc_SignalName'(Data);
encode_disp('SignalType',Data) -> 'enc_SignalType'(Data);
encode_disp('Signal',Data) -> 'enc_Signal'(Data);
encode_disp('SeqSigList',Data) -> 'enc_SeqSigList'(Data);
encode_disp('SignalRequest',Data) -> 'enc_SignalRequest'(Data);
encode_disp('SignalsDescriptor',Data) -> 'enc_SignalsDescriptor'(Data);
encode_disp('EventSpec',Data) -> 'enc_EventSpec'(Data);
encode_disp('EventBufferDescriptor',Data) -> 'enc_EventBufferDescriptor'(Data);
encode_disp('SecondRequestedActions',Data) -> 'enc_SecondRequestedActions'(Data);
encode_disp('SecondRequestedEvent',Data) -> 'enc_SecondRequestedEvent'(Data);
encode_disp('SecondEventsDescriptor',Data) -> 'enc_SecondEventsDescriptor'(Data);
encode_disp('EventDM',Data) -> 'enc_EventDM'(Data);
encode_disp('RequestedActions',Data) -> 'enc_RequestedActions'(Data);
encode_disp('RequestedEvent',Data) -> 'enc_RequestedEvent'(Data);
encode_disp('EventsDescriptor',Data) -> 'enc_EventsDescriptor'(Data);
encode_disp('StreamID',Data) -> 'enc_StreamID'(Data);
encode_disp('MuxType',Data) -> 'enc_MuxType'(Data);
encode_disp('MuxDescriptor',Data) -> 'enc_MuxDescriptor'(Data);
encode_disp('ServiceState',Data) -> 'enc_ServiceState'(Data);
encode_disp('EventBufferControl',Data) -> 'enc_EventBufferControl'(Data);
encode_disp('TerminationStateDescriptor',Data) -> 'enc_TerminationStateDescriptor'(Data);
encode_disp('PropertyGroup',Data) -> 'enc_PropertyGroup'(Data);
encode_disp('LocalRemoteDescriptor',Data) -> 'enc_LocalRemoteDescriptor'(Data);
encode_disp('Relation',Data) -> 'enc_Relation'(Data);
encode_disp('PkgdName',Data) -> 'enc_PkgdName'(Data);
encode_disp('Name',Data) -> 'enc_Name'(Data);
encode_disp('PropertyParm',Data) -> 'enc_PropertyParm'(Data);
encode_disp('StreamMode',Data) -> 'enc_StreamMode'(Data);
encode_disp('LocalControlDescriptor',Data) -> 'enc_LocalControlDescriptor'(Data);
encode_disp('StreamParms',Data) -> 'enc_StreamParms'(Data);
encode_disp('StreamDescriptor',Data) -> 'enc_StreamDescriptor'(Data);
encode_disp('MediaDescriptor',Data) -> 'enc_MediaDescriptor'(Data);
encode_disp('TerminationIDList',Data) -> 'enc_TerminationIDList'(Data);
encode_disp('TerminationID',Data) -> 'enc_TerminationID'(Data);
encode_disp('WildcardField',Data) -> 'enc_WildcardField'(Data);
encode_disp('ServiceChangeResult',Data) -> 'enc_ServiceChangeResult'(Data);
encode_disp('ServiceChangeReply',Data) -> 'enc_ServiceChangeReply'(Data);
encode_disp('ServiceChangeRequest',Data) -> 'enc_ServiceChangeRequest'(Data);
encode_disp('EventParameter',Data) -> 'enc_EventParameter'(Data);
encode_disp('EventName',Data) -> 'enc_EventName'(Data);
encode_disp('ObservedEvent',Data) -> 'enc_ObservedEvent'(Data);
encode_disp('ObservedEventsDescriptor',Data) -> 'enc_ObservedEventsDescriptor'(Data);
encode_disp('NotifyReply',Data) -> 'enc_NotifyReply'(Data);
encode_disp('NotifyRequest',Data) -> 'enc_NotifyRequest'(Data);
encode_disp('IndAudPackagesDescriptor',Data) -> 'enc_IndAudPackagesDescriptor'(Data);
encode_disp('IndAudStatisticsDescriptor',Data) -> 'enc_IndAudStatisticsDescriptor'(Data);
encode_disp('IndAudDigitMapDescriptor',Data) -> 'enc_IndAudDigitMapDescriptor'(Data);
encode_disp('IndAudSignal',Data) -> 'enc_IndAudSignal'(Data);
encode_disp('IndAudSeqSigList',Data) -> 'enc_IndAudSeqSigList'(Data);
encode_disp('IndAudSignalsDescriptor',Data) -> 'enc_IndAudSignalsDescriptor'(Data);
encode_disp('IndAudEventBufferDescriptor',Data) -> 'enc_IndAudEventBufferDescriptor'(Data);
encode_disp('IndAudEventsDescriptor',Data) -> 'enc_IndAudEventsDescriptor'(Data);
encode_disp('IndAudTerminationStateDescriptor',Data) -> 'enc_IndAudTerminationStateDescriptor'(Data);
encode_disp('IndAudPropertyGroup',Data) -> 'enc_IndAudPropertyGroup'(Data);
encode_disp('IndAudLocalRemoteDescriptor',Data) -> 'enc_IndAudLocalRemoteDescriptor'(Data);
encode_disp('IndAudPropertyParm',Data) -> 'enc_IndAudPropertyParm'(Data);
encode_disp('IndAudLocalControlDescriptor',Data) -> 'enc_IndAudLocalControlDescriptor'(Data);
encode_disp('IndAudStreamParms',Data) -> 'enc_IndAudStreamParms'(Data);
encode_disp('IndAudStreamDescriptor',Data) -> 'enc_IndAudStreamDescriptor'(Data);
encode_disp('IndAudMediaDescriptor',Data) -> 'enc_IndAudMediaDescriptor'(Data);
encode_disp('IndAuditParameter',Data) -> 'enc_IndAuditParameter'(Data);
encode_disp('AuditDescriptor',Data) -> 'enc_AuditDescriptor'(Data);
encode_disp('AuditReturnParameter',Data) -> 'enc_AuditReturnParameter'(Data);
encode_disp('TerminationAudit',Data) -> 'enc_TerminationAudit'(Data);
encode_disp('AuditResult',Data) -> 'enc_AuditResult'(Data);
encode_disp('AuditReply',Data) -> 'enc_AuditReply'(Data);
encode_disp('AuditRequest',Data) -> 'enc_AuditRequest'(Data);
encode_disp('SubtractRequest',Data) -> 'enc_SubtractRequest'(Data);
encode_disp('AmmsReply',Data) -> 'enc_AmmsReply'(Data);
encode_disp('AmmDescriptor',Data) -> 'enc_AmmDescriptor'(Data);
encode_disp('AmmRequest',Data) -> 'enc_AmmRequest'(Data);
encode_disp('TopologyRequest',Data) -> 'enc_TopologyRequest'(Data);
encode_disp('CommandReply',Data) -> 'enc_CommandReply'(Data);
encode_disp('Command',Data) -> 'enc_Command'(Data);
encode_disp('CommandRequest',Data) -> 'enc_CommandRequest'(Data);
encode_disp('ContextAttrAuditRequest',Data) -> 'enc_ContextAttrAuditRequest'(Data);
encode_disp('ContextRequest',Data) -> 'enc_ContextRequest'(Data);
encode_disp('ActionReply',Data) -> 'enc_ActionReply'(Data);
encode_disp('ActionRequest',Data) -> 'enc_ActionRequest'(Data);
encode_disp('ContextID',Data) -> 'enc_ContextID'(Data);
encode_disp('ErrorText',Data) -> 'enc_ErrorText'(Data);
encode_disp('ErrorCode',Data) -> 'enc_ErrorCode'(Data);
encode_disp('ErrorDescriptor',Data) -> 'enc_ErrorDescriptor'(Data);
encode_disp('TransactionAck',Data) -> 'enc_TransactionAck'(Data);
encode_disp('TransactionResponseAck',Data) -> 'enc_TransactionResponseAck'(Data);
encode_disp('TransactionReply',Data) -> 'enc_TransactionReply'(Data);
encode_disp('TransactionPending',Data) -> 'enc_TransactionPending'(Data);
encode_disp('TransactionRequest',Data) -> 'enc_TransactionRequest'(Data);
encode_disp('TransactionId',Data) -> 'enc_TransactionId'(Data);
encode_disp('Transaction',Data) -> 'enc_Transaction'(Data);
encode_disp('PathName',Data) -> 'enc_PathName'(Data);
encode_disp('IP6Address',Data) -> 'enc_IP6Address'(Data);
encode_disp('IP4Address',Data) -> 'enc_IP4Address'(Data);
encode_disp('DomainName',Data) -> 'enc_DomainName'(Data);
encode_disp('MId',Data) -> 'enc_MId'(Data);
encode_disp('Message',Data) -> 'enc_Message'(Data);
encode_disp('AuthData',Data) -> 'enc_AuthData'(Data);
encode_disp('SequenceNum',Data) -> 'enc_SequenceNum'(Data);
encode_disp('SecurityParmIndex',Data) -> 'enc_SecurityParmIndex'(Data);
encode_disp('AuthenticationHeader',Data) -> 'enc_AuthenticationHeader'(Data);
encode_disp('MegacoMessage',Data) -> 'enc_MegacoMessage'(Data);
encode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).


decode_disp('Value',Data) -> 'dec_Value'(Data);
decode_disp('TimeNotation',Data) -> 'dec_TimeNotation'(Data);
decode_disp('H221NonStandard',Data) -> 'dec_H221NonStandard'(Data);
decode_disp('NonStandardIdentifier',Data) -> 'dec_NonStandardIdentifier'(Data);
decode_disp('NonStandardData',Data) -> 'dec_NonStandardData'(Data);
decode_disp('StatisticsParameter',Data) -> 'dec_StatisticsParameter'(Data);
decode_disp('StatisticsDescriptor',Data) -> 'dec_StatisticsDescriptor'(Data);
decode_disp('PackagesItem',Data) -> 'dec_PackagesItem'(Data);
decode_disp('PackagesDescriptor',Data) -> 'dec_PackagesDescriptor'(Data);
decode_disp('ServiceChangeProfile',Data) -> 'dec_ServiceChangeProfile'(Data);
decode_disp('ServiceChangeMethod',Data) -> 'dec_ServiceChangeMethod'(Data);
decode_disp('ServiceChangeResParm',Data) -> 'dec_ServiceChangeResParm'(Data);
decode_disp('ServiceChangeAddress',Data) -> 'dec_ServiceChangeAddress'(Data);
decode_disp('ServiceChangeParm',Data) -> 'dec_ServiceChangeParm'(Data);
decode_disp('DigitMapValue',Data) -> 'dec_DigitMapValue'(Data);
decode_disp('DigitMapName',Data) -> 'dec_DigitMapName'(Data);
decode_disp('DigitMapDescriptor',Data) -> 'dec_DigitMapDescriptor'(Data);
decode_disp('ModemType',Data) -> 'dec_ModemType'(Data);
decode_disp('ModemDescriptor',Data) -> 'dec_ModemDescriptor'(Data);
decode_disp('RequestID',Data) -> 'dec_RequestID'(Data);
decode_disp('SigParameter',Data) -> 'dec_SigParameter'(Data);
decode_disp('NotifyCompletion',Data) -> 'dec_NotifyCompletion'(Data);
decode_disp('SignalName',Data) -> 'dec_SignalName'(Data);
decode_disp('SignalType',Data) -> 'dec_SignalType'(Data);
decode_disp('Signal',Data) -> 'dec_Signal'(Data);
decode_disp('SeqSigList',Data) -> 'dec_SeqSigList'(Data);
decode_disp('SignalRequest',Data) -> 'dec_SignalRequest'(Data);
decode_disp('SignalsDescriptor',Data) -> 'dec_SignalsDescriptor'(Data);
decode_disp('EventSpec',Data) -> 'dec_EventSpec'(Data);
decode_disp('EventBufferDescriptor',Data) -> 'dec_EventBufferDescriptor'(Data);
decode_disp('SecondRequestedActions',Data) -> 'dec_SecondRequestedActions'(Data);
decode_disp('SecondRequestedEvent',Data) -> 'dec_SecondRequestedEvent'(Data);
decode_disp('SecondEventsDescriptor',Data) -> 'dec_SecondEventsDescriptor'(Data);
decode_disp('EventDM',Data) -> 'dec_EventDM'(Data);
decode_disp('RequestedActions',Data) -> 'dec_RequestedActions'(Data);
decode_disp('RequestedEvent',Data) -> 'dec_RequestedEvent'(Data);
decode_disp('EventsDescriptor',Data) -> 'dec_EventsDescriptor'(Data);
decode_disp('StreamID',Data) -> 'dec_StreamID'(Data);
decode_disp('MuxType',Data) -> 'dec_MuxType'(Data);
decode_disp('MuxDescriptor',Data) -> 'dec_MuxDescriptor'(Data);
decode_disp('ServiceState',Data) -> 'dec_ServiceState'(Data);
decode_disp('EventBufferControl',Data) -> 'dec_EventBufferControl'(Data);
decode_disp('TerminationStateDescriptor',Data) -> 'dec_TerminationStateDescriptor'(Data);
decode_disp('PropertyGroup',Data) -> 'dec_PropertyGroup'(Data);
decode_disp('LocalRemoteDescriptor',Data) -> 'dec_LocalRemoteDescriptor'(Data);
decode_disp('Relation',Data) -> 'dec_Relation'(Data);
decode_disp('PkgdName',Data) -> 'dec_PkgdName'(Data);
decode_disp('Name',Data) -> 'dec_Name'(Data);
decode_disp('PropertyParm',Data) -> 'dec_PropertyParm'(Data);
decode_disp('StreamMode',Data) -> 'dec_StreamMode'(Data);
decode_disp('LocalControlDescriptor',Data) -> 'dec_LocalControlDescriptor'(Data);
decode_disp('StreamParms',Data) -> 'dec_StreamParms'(Data);
decode_disp('StreamDescriptor',Data) -> 'dec_StreamDescriptor'(Data);
decode_disp('MediaDescriptor',Data) -> 'dec_MediaDescriptor'(Data);
decode_disp('TerminationIDList',Data) -> 'dec_TerminationIDList'(Data);
decode_disp('TerminationID',Data) -> 'dec_TerminationID'(Data);
decode_disp('WildcardField',Data) -> 'dec_WildcardField'(Data);
decode_disp('ServiceChangeResult',Data) -> 'dec_ServiceChangeResult'(Data);
decode_disp('ServiceChangeReply',Data) -> 'dec_ServiceChangeReply'(Data);
decode_disp('ServiceChangeRequest',Data) -> 'dec_ServiceChangeRequest'(Data);
decode_disp('EventParameter',Data) -> 'dec_EventParameter'(Data);
decode_disp('EventName',Data) -> 'dec_EventName'(Data);
decode_disp('ObservedEvent',Data) -> 'dec_ObservedEvent'(Data);
decode_disp('ObservedEventsDescriptor',Data) -> 'dec_ObservedEventsDescriptor'(Data);
decode_disp('NotifyReply',Data) -> 'dec_NotifyReply'(Data);
decode_disp('NotifyRequest',Data) -> 'dec_NotifyRequest'(Data);
decode_disp('IndAudPackagesDescriptor',Data) -> 'dec_IndAudPackagesDescriptor'(Data);
decode_disp('IndAudStatisticsDescriptor',Data) -> 'dec_IndAudStatisticsDescriptor'(Data);
decode_disp('IndAudDigitMapDescriptor',Data) -> 'dec_IndAudDigitMapDescriptor'(Data);
decode_disp('IndAudSignal',Data) -> 'dec_IndAudSignal'(Data);
decode_disp('IndAudSeqSigList',Data) -> 'dec_IndAudSeqSigList'(Data);
decode_disp('IndAudSignalsDescriptor',Data) -> 'dec_IndAudSignalsDescriptor'(Data);
decode_disp('IndAudEventBufferDescriptor',Data) -> 'dec_IndAudEventBufferDescriptor'(Data);
decode_disp('IndAudEventsDescriptor',Data) -> 'dec_IndAudEventsDescriptor'(Data);
decode_disp('IndAudTerminationStateDescriptor',Data) -> 'dec_IndAudTerminationStateDescriptor'(Data);
decode_disp('IndAudPropertyGroup',Data) -> 'dec_IndAudPropertyGroup'(Data);
decode_disp('IndAudLocalRemoteDescriptor',Data) -> 'dec_IndAudLocalRemoteDescriptor'(Data);
decode_disp('IndAudPropertyParm',Data) -> 'dec_IndAudPropertyParm'(Data);
decode_disp('IndAudLocalControlDescriptor',Data) -> 'dec_IndAudLocalControlDescriptor'(Data);
decode_disp('IndAudStreamParms',Data) -> 'dec_IndAudStreamParms'(Data);
decode_disp('IndAudStreamDescriptor',Data) -> 'dec_IndAudStreamDescriptor'(Data);
decode_disp('IndAudMediaDescriptor',Data) -> 'dec_IndAudMediaDescriptor'(Data);
decode_disp('IndAuditParameter',Data) -> 'dec_IndAuditParameter'(Data);
decode_disp('AuditDescriptor',Data) -> 'dec_AuditDescriptor'(Data);
decode_disp('AuditReturnParameter',Data) -> 'dec_AuditReturnParameter'(Data);
decode_disp('TerminationAudit',Data) -> 'dec_TerminationAudit'(Data);
decode_disp('AuditResult',Data) -> 'dec_AuditResult'(Data);
decode_disp('AuditReply',Data) -> 'dec_AuditReply'(Data);
decode_disp('AuditRequest',Data) -> 'dec_AuditRequest'(Data);
decode_disp('SubtractRequest',Data) -> 'dec_SubtractRequest'(Data);
decode_disp('AmmsReply',Data) -> 'dec_AmmsReply'(Data);
decode_disp('AmmDescriptor',Data) -> 'dec_AmmDescriptor'(Data);
decode_disp('AmmRequest',Data) -> 'dec_AmmRequest'(Data);
decode_disp('TopologyRequest',Data) -> 'dec_TopologyRequest'(Data);
decode_disp('CommandReply',Data) -> 'dec_CommandReply'(Data);
decode_disp('Command',Data) -> 'dec_Command'(Data);
decode_disp('CommandRequest',Data) -> 'dec_CommandRequest'(Data);
decode_disp('ContextAttrAuditRequest',Data) -> 'dec_ContextAttrAuditRequest'(Data);
decode_disp('ContextRequest',Data) -> 'dec_ContextRequest'(Data);
decode_disp('ActionReply',Data) -> 'dec_ActionReply'(Data);
decode_disp('ActionRequest',Data) -> 'dec_ActionRequest'(Data);
decode_disp('ContextID',Data) -> 'dec_ContextID'(Data);
decode_disp('ErrorText',Data) -> 'dec_ErrorText'(Data);
decode_disp('ErrorCode',Data) -> 'dec_ErrorCode'(Data);
decode_disp('ErrorDescriptor',Data) -> 'dec_ErrorDescriptor'(Data);
decode_disp('TransactionAck',Data) -> 'dec_TransactionAck'(Data);
decode_disp('TransactionResponseAck',Data) -> 'dec_TransactionResponseAck'(Data);
decode_disp('TransactionReply',Data) -> 'dec_TransactionReply'(Data);
decode_disp('TransactionPending',Data) -> 'dec_TransactionPending'(Data);
decode_disp('TransactionRequest',Data) -> 'dec_TransactionRequest'(Data);
decode_disp('TransactionId',Data) -> 'dec_TransactionId'(Data);
decode_disp('Transaction',Data) -> 'dec_Transaction'(Data);
decode_disp('PathName',Data) -> 'dec_PathName'(Data);
decode_disp('IP6Address',Data) -> 'dec_IP6Address'(Data);
decode_disp('IP4Address',Data) -> 'dec_IP4Address'(Data);
decode_disp('DomainName',Data) -> 'dec_DomainName'(Data);
decode_disp('MId',Data) -> 'dec_MId'(Data);
decode_disp('Message',Data) -> 'dec_Message'(Data);
decode_disp('AuthData',Data) -> 'dec_AuthData'(Data);
decode_disp('SequenceNum',Data) -> 'dec_SequenceNum'(Data);
decode_disp('SecurityParmIndex',Data) -> 'dec_SecurityParmIndex'(Data);
decode_disp('AuthenticationHeader',Data) -> 'dec_AuthenticationHeader'(Data);
decode_disp('MegacoMessage',Data) -> 'dec_MegacoMessage'(Data);
decode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).




info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  Value
%%================================
'enc_Value'(Val) ->
    'enc_Value'(Val, [<<48>>]).

'enc_Value'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_Value_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Value_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Value_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<4>>]),
   'enc_Value_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_Value'(Tlv) ->
   'dec_Value'(Tlv, [16]).

'dec_Value'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
binary_to_list(decode_restricted_string(V1, [4]))
end
 || V1 <- Tlv1].




%%================================
%%  TimeNotation
%%================================
'enc_TimeNotation'(Val) ->
    'enc_TimeNotation'(Val, [<<48>>]).

'enc_TimeNotation'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute date(1) with type IA5String
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute time(2) with type IA5String
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<129>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_TimeNotation'(Tlv) ->
   'dec_TimeNotation'(Tlv, [16]).

'dec_TimeNotation'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute date(1) with type IA5String
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 8 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute time(2) with type IA5String
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val2 = decode_restricted_string(V2, [131073]),
C2 = byte_size(Val2),
if C2 =:= 8 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'TimeNotation', Term1, Term2}.



%%================================
%%  H221NonStandard
%%================================
'enc_H221NonStandard'(Val) ->
    'enc_H221NonStandard'(Val, [<<48>>]).

'enc_H221NonStandard'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4} = Val,

%%-------------------------------------------------
%% attribute t35CountryCode1(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute t35CountryCode2(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<129>>]),

%%-------------------------------------------------
%% attribute t35Extension(3) with type INTEGER
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_integer(Cindex3, [<<130>>]),

%%-------------------------------------------------
%% attribute manufacturerCode(4) with type INTEGER
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_integer(Cindex4, [<<131>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_H221NonStandard'(Tlv) ->
   'dec_H221NonStandard'(Tlv, [16]).

'dec_H221NonStandard'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute t35CountryCode1(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [131072]),
if 0 =< Val1, Val1 =< 255 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute t35CountryCode2(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val2 = decode_integer(V2, [131073]),
if 0 =< Val2, Val2 =< 255 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute t35Extension(3) with type INTEGER
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = begin
Val3 = decode_integer(V3, [131074]),
if 0 =< Val3, Val3 =< 255 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute manufacturerCode(4) with type INTEGER
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = begin
Val4 = decode_integer(V4, [131075]),
if 0 =< Val4, Val4 =< 65535 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv5 of [] -> true; _ -> true end, % ... extra fields skipped
   {'H221NonStandard', Term1, Term2, Term3, Term4}.



%%================================
%%  NonStandardIdentifier
%%================================
'enc_NonStandardIdentifier'(Val) ->
    'enc_NonStandardIdentifier'(Val, []).

'enc_NonStandardIdentifier'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      object ->
         encode_object_identifier(element(2,Val), [<<128>>]);
      h221NonStandard ->
         'enc_H221NonStandard'(element(2,Val), [<<161>>]);
      experimental ->
         encode_restricted_string(element(2,Val), [<<130>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_NonStandardIdentifier'(Tlv) ->
   'dec_NonStandardIdentifier'(Tlv, []).

'dec_NonStandardIdentifier'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'object'
    {131072, V1} -> 
        {object, decode_object_identifier(V1, [])};


%% 'h221NonStandard'
    {131073, V1} -> 
        {h221NonStandard, 'dec_H221NonStandard'(V1, [])};


%% 'experimental'
    {131074, V1} -> 
        {experimental, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if C1 =:= 8 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  NonStandardData
%%================================
'enc_NonStandardData'(Val) ->
    'enc_NonStandardData'(Val, [<<48>>]).

'enc_NonStandardData'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute nonStandardIdentifier(1)   External megaco_ber_media_gateway_control_v2:NonStandardIdentifier
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_NonStandardIdentifier'(Cindex1, [<<160>>]),

%%-------------------------------------------------
%% attribute data(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<129>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_NonStandardData'(Tlv) ->
   'dec_NonStandardData'(Tlv, [16]).

'dec_NonStandardData'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute nonStandardIdentifier(1)   External megaco_ber_media_gateway_control_v2:NonStandardIdentifier
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_NonStandardIdentifier'(V1, [131072]),

%%-------------------------------------------------
%% attribute data(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
binary_to_list(decode_restricted_string(V2, [131073]))
end
,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'NonStandardData', Term1, Term2}.



%%================================
%%  StatisticsParameter
%%================================
'enc_StatisticsParameter'(Val) ->
    'enc_StatisticsParameter'(Val, [<<48>>]).

'enc_StatisticsParameter'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute statName(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute statValue(2)   External megaco_ber_media_gateway_control_v2:Value OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Value'(Cindex2, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_StatisticsParameter'(Tlv) ->
   'dec_StatisticsParameter'(Tlv, [16]).

'dec_StatisticsParameter'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute statName(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute statValue(2)   External megaco_ber_media_gateway_control_v2:Value OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_Value'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'StatisticsParameter', Term1, Term2}.



%%================================
%%  StatisticsDescriptor
%%================================
'enc_StatisticsDescriptor'(Val) ->
    'enc_StatisticsDescriptor'(Val, [<<48>>]).

'enc_StatisticsDescriptor'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_StatisticsDescriptor_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_StatisticsDescriptor_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_StatisticsDescriptor_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_StatisticsParameter'(H, [<<48>>]),
   'enc_StatisticsDescriptor_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_StatisticsDescriptor'(Tlv) ->
   'dec_StatisticsDescriptor'(Tlv, [16]).

'dec_StatisticsDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_StatisticsParameter'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  PackagesItem
%%================================
'enc_PackagesItem'(Val) ->
    'enc_PackagesItem'(Val, [<<48>>]).

'enc_PackagesItem'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute packageName(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute packageVersion(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<129>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_PackagesItem'(Tlv) ->
   'dec_PackagesItem'(Tlv, [16]).

'dec_PackagesItem'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute packageName(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 2 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute packageVersion(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val2 = decode_integer(V2, [131073]),
if 0 =< Val2, Val2 =< 99 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'PackagesItem', Term1, Term2}.



%%================================
%%  PackagesDescriptor
%%================================
'enc_PackagesDescriptor'(Val) ->
    'enc_PackagesDescriptor'(Val, [<<48>>]).

'enc_PackagesDescriptor'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_PackagesDescriptor_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PackagesDescriptor_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PackagesDescriptor_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PackagesItem'(H, [<<48>>]),
   'enc_PackagesDescriptor_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_PackagesDescriptor'(Tlv) ->
   'dec_PackagesDescriptor'(Tlv, [16]).

'dec_PackagesDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PackagesItem'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  ServiceChangeProfile
%%================================
'enc_ServiceChangeProfile'(Val) ->
    'enc_ServiceChangeProfile'(Val, [<<48>>]).

'enc_ServiceChangeProfile'(Val, TagIn) ->
{_,Cindex1} = Val,

%%-------------------------------------------------
%% attribute profileName(1) with type IA5String
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

   BytesSoFar = [EncBytes1],
LenSoFar = EncLen1,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_ServiceChangeProfile'(Tlv) ->
   'dec_ServiceChangeProfile'(Tlv, [16]).

'dec_ServiceChangeProfile'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute profileName(1) with type IA5String
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 67 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv2 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv2}}}) % extra fields not allowed
end,
   {'ServiceChangeProfile', Term1}.



%%================================
%%  ServiceChangeMethod
%%================================
'enc_ServiceChangeMethod'(Val) ->
    'enc_ServiceChangeMethod'(Val, [<<10>>]).

'enc_ServiceChangeMethod'(Val, TagIn) ->
case Val of
failover -> encode_tags(TagIn, [0], 1);
forced -> encode_tags(TagIn, [1], 1);
graceful -> encode_tags(TagIn, [2], 1);
restart -> encode_tags(TagIn, [3], 1);
disconnected -> encode_tags(TagIn, [4], 1);
handOff -> encode_tags(TagIn, [5], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end.


'dec_ServiceChangeMethod'(Tlv) ->
   'dec_ServiceChangeMethod'(Tlv, [10]).

'dec_ServiceChangeMethod'(Tlv, TagIn) ->
case decode_integer(Tlv, TagIn) of
0 -> failover;
1 -> forced;
2 -> graceful;
3 -> restart;
4 -> disconnected;
5 -> handOff;
Default1 -> {asn1_enum,Default1}
end.



%%================================
%%  ServiceChangeResParm
%%================================
'enc_ServiceChangeResParm'(Val) ->
    'enc_ServiceChangeResParm'(Val, [<<48>>]).

'enc_ServiceChangeResParm'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4, Cindex5} = Val,

%%-------------------------------------------------
%% attribute serviceChangeMgcId(1)   External megaco_ber_media_gateway_control_v2:MId OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_MId'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute serviceChangeAddress(2)   External megaco_ber_media_gateway_control_v2:ServiceChangeAddress OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ServiceChangeAddress'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute serviceChangeVersion(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex3, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute serviceChangeProfile(4)   External megaco_ber_media_gateway_control_v2:ServiceChangeProfile OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ServiceChangeProfile'(Cindex4, [<<163>>])
       end,

%%-------------------------------------------------
%% attribute timestamp(5)   External megaco_ber_media_gateway_control_v2:TimeNotation OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_TimeNotation'(Cindex5, [<<164>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_ServiceChangeResParm'(Tlv) ->
   'dec_ServiceChangeResParm'(Tlv, [16]).

'dec_ServiceChangeResParm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute serviceChangeMgcId(1)   External megaco_ber_media_gateway_control_v2:MId OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_MId'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute serviceChangeAddress(2)   External megaco_ber_media_gateway_control_v2:ServiceChangeAddress OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_ServiceChangeAddress'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute serviceChangeVersion(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {begin
Val1 = decode_integer(V3, []),
if 0 =< Val1, Val1 =< 99 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute serviceChangeProfile(4)   External megaco_ber_media_gateway_control_v2:ServiceChangeProfile OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {'dec_ServiceChangeProfile'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute timestamp(5)   External megaco_ber_media_gateway_control_v2:TimeNotation OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131076,V5}|TempTlv6] ->
    {'dec_TimeNotation'(V5, []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of [] -> true; _ -> true end, % ... extra fields skipped
   {'ServiceChangeResParm', Term1, Term2, Term3, Term4, Term5}.



%%================================
%%  ServiceChangeAddress
%%================================
'enc_ServiceChangeAddress'(Val) ->
    'enc_ServiceChangeAddress'(Val, []).

'enc_ServiceChangeAddress'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      portNumber ->
         encode_integer(element(2,Val), [<<128>>]);
      ip4Address ->
         'enc_IP4Address'(element(2,Val), [<<161>>]);
      ip6Address ->
         'enc_IP6Address'(element(2,Val), [<<162>>]);
      domainName ->
         'enc_DomainName'(element(2,Val), [<<163>>]);
      deviceName ->
         encode_restricted_string(element(2,Val), [<<132>>]);
      mtpAddress ->
         encode_restricted_string(element(2,Val), [<<133>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_ServiceChangeAddress'(Tlv) ->
   'dec_ServiceChangeAddress'(Tlv, []).

'dec_ServiceChangeAddress'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'portNumber'
    {131072, V1} -> 
        {portNumber, begin
Val1 = decode_integer(V1, []),
if 0 =< Val1, Val1 =< 65535 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'ip4Address'
    {131073, V1} -> 
        {ip4Address, 'dec_IP4Address'(V1, [])};


%% 'ip6Address'
    {131074, V1} -> 
        {ip6Address, 'dec_IP6Address'(V1, [])};


%% 'domainName'
    {131075, V1} -> 
        {domainName, 'dec_DomainName'(V1, [])};


%% 'deviceName'
    {131076, V1} -> 
        {deviceName, begin
Val2 = decode_restricted_string(V1, []),
C1 = byte_size(Val2),
if 1 =< C1, C1 =< 64 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'mtpAddress'
    {131077, V1} -> 
        {mtpAddress, begin
Val3 = decode_restricted_string(V1, []),
C2 = byte_size(Val3),
if 2 =< C2, C2 =< 4 ->
binary_to_list(Val3);
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  ServiceChangeParm
%%================================
'enc_ServiceChangeParm'(Val) ->
    'enc_ServiceChangeParm'(Val, [<<48>>]).

'enc_ServiceChangeParm'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4, Cindex5, Cindex6, Cindex7, Cindex8, Cindex9, Cindex10} = Val,

%%-------------------------------------------------
%% attribute serviceChangeMethod(1) with type ENUMERATED
%%-------------------------------------------------
   {EncBytes1,EncLen1} = case Cindex1 of
failover -> encode_tags([<<128>>], [0], 1);
forced -> encode_tags([<<128>>], [1], 1);
graceful -> encode_tags([<<128>>], [2], 1);
restart -> encode_tags([<<128>>], [3], 1);
disconnected -> encode_tags([<<128>>], [4], 1);
handOff -> encode_tags([<<128>>], [5], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,

%%-------------------------------------------------
%% attribute serviceChangeAddress(2)   External megaco_ber_media_gateway_control_v2:ServiceChangeAddress OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ServiceChangeAddress'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute serviceChangeVersion(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex3, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute serviceChangeProfile(4)   External megaco_ber_media_gateway_control_v2:ServiceChangeProfile OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ServiceChangeProfile'(Cindex4, [<<163>>])
       end,

%%-------------------------------------------------
%% attribute serviceChangeReason(5)   External megaco_ber_media_gateway_control_v2:Value
%%-------------------------------------------------
   {EncBytes5,EncLen5} = 'enc_Value'(Cindex5, [<<164>>]),

%%-------------------------------------------------
%% attribute serviceChangeDelay(6) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case Cindex6 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex6, [<<133>>])
       end,

%%-------------------------------------------------
%% attribute serviceChangeMgcId(7)   External megaco_ber_media_gateway_control_v2:MId OPTIONAL
%%-------------------------------------------------
   {EncBytes7,EncLen7} =  case Cindex7 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_MId'(Cindex7, [<<166>>])
       end,

%%-------------------------------------------------
%% attribute timeStamp(8)   External megaco_ber_media_gateway_control_v2:TimeNotation OPTIONAL
%%-------------------------------------------------
   {EncBytes8,EncLen8} =  case Cindex8 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_TimeNotation'(Cindex8, [<<167>>])
       end,

%%-------------------------------------------------
%% attribute nonStandardData(9)   External megaco_ber_media_gateway_control_v2:NonStandardData OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_NonStandardData'(Cindex9, [<<168>>])
       end,

%%-------------------------------------------------
%% attribute serviceChangeInfo(10)   External megaco_ber_media_gateway_control_v2:AuditDescriptor OPTIONAL
%%-------------------------------------------------
   {EncBytes10,EncLen10} =  case Cindex10 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AuditDescriptor'(Cindex10, [<<169>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9, EncBytes10],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9 + EncLen10,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_ServiceChangeParm'(Tlv) ->
   'dec_ServiceChangeParm'(Tlv, [16]).

'dec_ServiceChangeParm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute serviceChangeMethod(1) with type ENUMERATED
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = case decode_integer(V1, [131072]) of
0 -> failover;
1 -> forced;
2 -> graceful;
3 -> restart;
4 -> disconnected;
5 -> handOff;
Default1 -> {asn1_enum,Default1}
end,

%%-------------------------------------------------
%% attribute serviceChangeAddress(2)   External megaco_ber_media_gateway_control_v2:ServiceChangeAddress OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_ServiceChangeAddress'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute serviceChangeVersion(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {begin
Val1 = decode_integer(V3, []),
if 0 =< Val1, Val1 =< 99 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute serviceChangeProfile(4)   External megaco_ber_media_gateway_control_v2:ServiceChangeProfile OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {'dec_ServiceChangeProfile'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute serviceChangeReason(5)   External megaco_ber_media_gateway_control_v2:Value
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = 'dec_Value'(V5, [131076]),

%%-------------------------------------------------
%% attribute serviceChangeDelay(6) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[{131077,V6}|TempTlv7] ->
    {begin
Val2 = decode_integer(V6, []),
if 0 =< Val2, Val2 =< 4294967295 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv7};
    _ ->
        { asn1_NOVALUE, Tlv6}
end,

%%-------------------------------------------------
%% attribute serviceChangeMgcId(7)   External megaco_ber_media_gateway_control_v2:MId OPTIONAL
%%-------------------------------------------------
{Term7,Tlv8} = case Tlv7 of
[{131078,V7}|TempTlv8] ->
    {'dec_MId'(V7, []), TempTlv8};
    _ ->
        { asn1_NOVALUE, Tlv7}
end,

%%-------------------------------------------------
%% attribute timeStamp(8)   External megaco_ber_media_gateway_control_v2:TimeNotation OPTIONAL
%%-------------------------------------------------
{Term8,Tlv9} = case Tlv8 of
[{131079,V8}|TempTlv9] ->
    {'dec_TimeNotation'(V8, []), TempTlv9};
    _ ->
        { asn1_NOVALUE, Tlv8}
end,

%%-------------------------------------------------
%% attribute nonStandardData(9)   External megaco_ber_media_gateway_control_v2:NonStandardData OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{131080,V9}|TempTlv10] ->
    {'dec_NonStandardData'(V9, []), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

%%-------------------------------------------------
%% attribute serviceChangeInfo(10)   External megaco_ber_media_gateway_control_v2:AuditDescriptor OPTIONAL
%%-------------------------------------------------
{Term10,Tlv11} = case Tlv10 of
[{131081,V10}|TempTlv11] ->
    {'dec_AuditDescriptor'(V10, []), TempTlv11};
    _ ->
        { asn1_NOVALUE, Tlv10}
end,

case Tlv11 of [] -> true; _ -> true end, % ... extra fields skipped
   {'ServiceChangeParm', Term1, Term2, Term3, Term4, Term5, Term6, Term7, Term8, Term9, Term10}.



%%================================
%%  DigitMapValue
%%================================
'enc_DigitMapValue'(Val) ->
    'enc_DigitMapValue'(Val, [<<48>>]).

'enc_DigitMapValue'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4, Cindex5} = Val,

%%-------------------------------------------------
%% attribute startTimer(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute shortTimer(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute longTimer(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex3, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute digitMapBody(4) with type IA5String
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_restricted_string(Cindex4, [<<131>>]),

%%-------------------------------------------------
%% attribute durationTimer(5) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex5, [<<132>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_DigitMapValue'(Tlv) ->
   'dec_DigitMapValue'(Tlv, [16]).

'dec_DigitMapValue'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute startTimer(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, []),
if 0 =< Val1, Val1 =< 99 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute shortTimer(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
Val2 = decode_integer(V2, []),
if 0 =< Val2, Val2 =< 99 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute longTimer(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {begin
Val3 = decode_integer(V3, []),
if 0 =< Val3, Val3 =< 99 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute digitMapBody(4) with type IA5String
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = begin
binary_to_list(decode_restricted_string(V4, [131075]))
end
,

%%-------------------------------------------------
%% attribute durationTimer(5) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131076,V5}|TempTlv6] ->
    {begin
Val4 = decode_integer(V5, []),
if 0 =< Val4, Val4 =< 99 ->
Val4;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of [] -> true; _ -> true end, % ... extra fields skipped
   {'DigitMapValue', Term1, Term2, Term3, Term4, Term5}.



%%================================
%%  DigitMapName
%%================================
'enc_DigitMapName'(Val) ->
    'enc_DigitMapName'(Val, [<<4>>]).

'enc_DigitMapName'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_DigitMapName'(Tlv) ->
   'dec_DigitMapName'(Tlv, [4]).

'dec_DigitMapName'(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if C1 =:= 2 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  DigitMapDescriptor
%%================================
'enc_DigitMapDescriptor'(Val) ->
    'enc_DigitMapDescriptor'(Val, [<<48>>]).

'enc_DigitMapDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute digitMapName(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute digitMapValue(2)   External megaco_ber_media_gateway_control_v2:DigitMapValue OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_DigitMapValue'(Cindex2, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_DigitMapDescriptor'(Tlv) ->
   'dec_DigitMapDescriptor'(Tlv, [16]).

'dec_DigitMapDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute digitMapName(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if C1 =:= 2 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute digitMapValue(2)   External megaco_ber_media_gateway_control_v2:DigitMapValue OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_DigitMapValue'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'DigitMapDescriptor', Term1, Term2}.



%%================================
%%  ModemType
%%================================
'enc_ModemType'(Val) ->
    'enc_ModemType'(Val, [<<10>>]).

'enc_ModemType'(Val, TagIn) ->
case Val of
v18 -> encode_tags(TagIn, [0], 1);
v22 -> encode_tags(TagIn, [1], 1);
v22bis -> encode_tags(TagIn, [2], 1);
v32 -> encode_tags(TagIn, [3], 1);
v32bis -> encode_tags(TagIn, [4], 1);
v34 -> encode_tags(TagIn, [5], 1);
v90 -> encode_tags(TagIn, [6], 1);
v91 -> encode_tags(TagIn, [7], 1);
synchISDN -> encode_tags(TagIn, [8], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end.


'dec_ModemType'(Tlv) ->
   'dec_ModemType'(Tlv, [10]).

'dec_ModemType'(Tlv, TagIn) ->
case decode_integer(Tlv, TagIn) of
0 -> v18;
1 -> v22;
2 -> v22bis;
3 -> v32;
4 -> v32bis;
5 -> v34;
6 -> v90;
7 -> v91;
8 -> synchISDN;
Default1 -> {asn1_enum,Default1}
end.



%%================================
%%  ModemDescriptor
%%================================
'enc_ModemDescriptor'(Val) ->
    'enc_ModemDescriptor'(Val, [<<48>>]).

'enc_ModemDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute mtl(1) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_ModemDescriptor_mtl'(Cindex1, [<<160>>]),

%%-------------------------------------------------
%% attribute mpl(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_ModemDescriptor_mpl'(Cindex2, [<<161>>]),

%%-------------------------------------------------
%% attribute nonStandardData(3)   External megaco_ber_media_gateway_control_v2:NonStandardData OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_NonStandardData'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  ModemDescriptor_mtl
%%================================
'enc_ModemDescriptor_mtl'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ModemDescriptor_mtl_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ModemDescriptor_mtl_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ModemDescriptor_mtl_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = case H of
v18 -> encode_tags([<<10>>], [0], 1);
v22 -> encode_tags([<<10>>], [1], 1);
v22bis -> encode_tags([<<10>>], [2], 1);
v32 -> encode_tags([<<10>>], [3], 1);
v32bis -> encode_tags([<<10>>], [4], 1);
v34 -> encode_tags([<<10>>], [5], 1);
v90 -> encode_tags([<<10>>], [6], 1);
v91 -> encode_tags([<<10>>], [7], 1);
synchISDN -> encode_tags([<<10>>], [8], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,
   'enc_ModemDescriptor_mtl_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  ModemDescriptor_mpl
%%================================
'enc_ModemDescriptor_mpl'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ModemDescriptor_mpl_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ModemDescriptor_mpl_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ModemDescriptor_mpl_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PropertyParm'(H, [<<48>>]),
   'enc_ModemDescriptor_mpl_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_ModemDescriptor'(Tlv) ->
   'dec_ModemDescriptor'(Tlv, [16]).

'dec_ModemDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute mtl(1) with type SEQUENCE OF
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_ModemDescriptor_mtl'(V1, [131072]),

%%-------------------------------------------------
%% attribute mpl(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_ModemDescriptor_mpl'(V2, [131073]),

%%-------------------------------------------------
%% attribute nonStandardData(3)   External megaco_ber_media_gateway_control_v2:NonStandardData OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_NonStandardData'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'ModemDescriptor', Term1, Term2, Term3}.

'dec_ModemDescriptor_mtl'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[case decode_integer(V1, [10]) of
0 -> v18;
1 -> v22;
2 -> v22bis;
3 -> v32;
4 -> v32bis;
5 -> v34;
6 -> v90;
7 -> v91;
8 -> synchISDN;
Default1 -> {asn1_enum,Default1}
end || V1 <- Tlv1].


'dec_ModemDescriptor_mpl'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PropertyParm'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  RequestID
%%================================
'enc_RequestID'(Val) ->
    'enc_RequestID'(Val, [<<2>>]).

'enc_RequestID'(Val, TagIn) ->
encode_integer(Val, TagIn).


'dec_RequestID'(Tlv) ->
   'dec_RequestID'(Tlv, [2]).

'dec_RequestID'(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  SigParameter
%%================================
'enc_SigParameter'(Val) ->
    'enc_SigParameter'(Val, [<<48>>]).

'enc_SigParameter'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute sigParameterName(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute value(2)   External megaco_ber_media_gateway_control_v2:Value
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Value'(Cindex2, [<<161>>]),

%%-------------------------------------------------
%% attribute extraInfo(3) with type CHOICE OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_SigParameter_extraInfo'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SigParameter_extraInfo
%%================================
'enc_SigParameter_extraInfo'(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      relation ->
         case element(2,Val) of
greaterThan -> encode_tags([<<128>>], [0], 1);
smallerThan -> encode_tags([<<128>>], [1], 1);
unequalTo -> encode_tags([<<128>>], [2], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end;
      range ->
         encode_boolean(element(2,Val), [<<129>>]);
      sublist ->
         encode_boolean(element(2,Val), [<<130>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_SigParameter'(Tlv) ->
   'dec_SigParameter'(Tlv, [16]).

'dec_SigParameter'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute sigParameterName(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 2 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute value(2)   External megaco_ber_media_gateway_control_v2:Value
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Value'(V2, [131073]),

%%-------------------------------------------------
%% attribute extraInfo(3) with type CHOICE OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_SigParameter_extraInfo'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'SigParameter', Term1, Term2, Term3}.

'dec_SigParameter_extraInfo'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'relation'
    {131072, V1} -> 
        {relation, case decode_integer(V1, []) of
0 -> greaterThan;
1 -> smallerThan;
2 -> unequalTo;
Default1 -> {asn1_enum,Default1}
end};


%% 'range'
    {131073, V1} -> 
        {range, decode_boolean(V1, [])};


%% 'sublist'
    {131074, V1} -> 
        {sublist, decode_boolean(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  NotifyCompletion
%%================================
'enc_NotifyCompletion'(Val) ->
    'enc_NotifyCompletion'(Val, [<<3>>]).

'enc_NotifyCompletion'(Val, TagIn) ->
encode_bit_string([], Val, [{onTimeOut,0},{onInterruptByEvent,1},{onInterruptByNewSignalDescr,2},{otherReason,3}], TagIn).


'dec_NotifyCompletion'(Tlv) ->
   'dec_NotifyCompletion'(Tlv, [3]).

'dec_NotifyCompletion'(Tlv, TagIn) ->
decode_named_bit_string(Tlv, [{onTimeOut,0},{onInterruptByEvent,1},{onInterruptByNewSignalDescr,2},{otherReason,3}], TagIn).



%%================================
%%  SignalName
%%================================
'enc_SignalName'(Val) ->
    'enc_SignalName'(Val, [<<4>>]).

'enc_SignalName'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_SignalName'(Tlv) ->
   'dec_SignalName'(Tlv, [4]).

'dec_SignalName'(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  SignalType
%%================================
'enc_SignalType'(Val) ->
    'enc_SignalType'(Val, [<<10>>]).

'enc_SignalType'(Val, TagIn) ->
case Val of
brief -> encode_tags(TagIn, [0], 1);
onOff -> encode_tags(TagIn, [1], 1);
timeOut -> encode_tags(TagIn, [2], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end.


'dec_SignalType'(Tlv) ->
   'dec_SignalType'(Tlv, [10]).

'dec_SignalType'(Tlv, TagIn) ->
case decode_integer(Tlv, TagIn) of
0 -> brief;
1 -> onOff;
2 -> timeOut;
Default1 -> {asn1_enum,Default1}
end.



%%================================
%%  Signal
%%================================
'enc_Signal'(Val) ->
    'enc_Signal'(Val, [<<48>>]).

'enc_Signal'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4, Cindex5, Cindex6, Cindex7} = Val,

%%-------------------------------------------------
%% attribute signalName(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute streamID(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute sigType(3) with type ENUMERATED OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            case Cindex3 of
brief -> encode_tags([<<130>>], [0], 1);
onOff -> encode_tags([<<130>>], [1], 1);
timeOut -> encode_tags([<<130>>], [2], 1);
Enumval3 -> exit({error,{asn1, {enumerated_not_in_range,Enumval3}}})
end
       end,

%%-------------------------------------------------
%% attribute duration(4) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex4, [<<131>>])
       end,

%%-------------------------------------------------
%% attribute notifyCompletion(5) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_bit_string([], Cindex5, [{onTimeOut,0},{onInterruptByEvent,1},{onInterruptByNewSignalDescr,2},{otherReason,3}], [<<132>>])
       end,

%%-------------------------------------------------
%% attribute keepActive(6) with type BOOLEAN OPTIONAL
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case Cindex6 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_boolean(Cindex6, [<<133>>])
       end,

%%-------------------------------------------------
%% attribute sigParList(7) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes7,EncLen7} = 'enc_Signal_sigParList'(Cindex7, [<<166>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Signal_sigParList
%%================================
'enc_Signal_sigParList'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Signal_sigParList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Signal_sigParList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Signal_sigParList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SigParameter'(H, [<<48>>]),
   'enc_Signal_sigParList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_Signal'(Tlv) ->
   'dec_Signal'(Tlv, [16]).

'dec_Signal'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute signalName(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute streamID(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
Val2 = decode_integer(V2, []),
if 0 =< Val2, Val2 =< 65535 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute sigType(3) with type ENUMERATED OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {case decode_integer(V3, []) of
0 -> brief;
1 -> onOff;
2 -> timeOut;
Default1 -> {asn1_enum,Default1}
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute duration(4) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {begin
Val3 = decode_integer(V4, []),
if 0 =< Val3, Val3 =< 65535 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute notifyCompletion(5) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131076,V5}|TempTlv6] ->
    {decode_named_bit_string(V5, [{onTimeOut,0},{onInterruptByEvent,1},{onInterruptByNewSignalDescr,2},{otherReason,3}], []), TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

%%-------------------------------------------------
%% attribute keepActive(6) with type BOOLEAN OPTIONAL
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[{131077,V6}|TempTlv7] ->
    {decode_boolean(V6, []), TempTlv7};
    _ ->
        { asn1_NOVALUE, Tlv6}
end,

%%-------------------------------------------------
%% attribute sigParList(7) with type SEQUENCE OF
%%-------------------------------------------------
[V7|Tlv8] = Tlv7, 
Term7 = 'dec_Signal_sigParList'(V7, [131078]),

case Tlv8 of [] -> true; _ -> true end, % ... extra fields skipped
   {'Signal', Term1, Term2, Term3, Term4, Term5, Term6, Term7}.

'dec_Signal_sigParList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SigParameter'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  SeqSigList
%%================================
'enc_SeqSigList'(Val) ->
    'enc_SeqSigList'(Val, [<<48>>]).

'enc_SeqSigList'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute id(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute signalList(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_SeqSigList_signalList'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SeqSigList_signalList
%%================================
'enc_SeqSigList_signalList'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_SeqSigList_signalList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SeqSigList_signalList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SeqSigList_signalList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Signal'(H, [<<48>>]),
   'enc_SeqSigList_signalList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_SeqSigList'(Tlv) ->
   'dec_SeqSigList'(Tlv, [16]).

'dec_SeqSigList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute id(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [131072]),
if 0 =< Val1, Val1 =< 65535 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute signalList(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_SeqSigList_signalList'(V2, [131073]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'SeqSigList', Term1, Term2}.

'dec_SeqSigList_signalList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Signal'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  SignalRequest
%%================================
'enc_SignalRequest'(Val) ->
    'enc_SignalRequest'(Val, []).

'enc_SignalRequest'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      signal ->
         'enc_Signal'(element(2,Val), [<<160>>]);
      seqSigList ->
         'enc_SeqSigList'(element(2,Val), [<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_SignalRequest'(Tlv) ->
   'dec_SignalRequest'(Tlv, []).

'dec_SignalRequest'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'signal'
    {131072, V1} -> 
        {signal, 'dec_Signal'(V1, [])};


%% 'seqSigList'
    {131073, V1} -> 
        {seqSigList, 'dec_SeqSigList'(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  SignalsDescriptor
%%================================
'enc_SignalsDescriptor'(Val) ->
    'enc_SignalsDescriptor'(Val, [<<48>>]).

'enc_SignalsDescriptor'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_SignalsDescriptor_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SignalsDescriptor_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SignalsDescriptor_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SignalRequest'(H, []),
   'enc_SignalsDescriptor_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_SignalsDescriptor'(Tlv) ->
   'dec_SignalsDescriptor'(Tlv, [16]).

'dec_SignalsDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SignalRequest'(V1, []) || V1 <- Tlv1].




%%================================
%%  EventSpec
%%================================
'enc_EventSpec'(Val) ->
    'enc_EventSpec'(Val, [<<48>>]).

'enc_EventSpec'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute eventName(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute streamID(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute eventParList(3) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_EventSpec_eventParList'(Cindex3, [<<162>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  EventSpec_eventParList
%%================================
'enc_EventSpec_eventParList'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_EventSpec_eventParList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_EventSpec_eventParList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_EventSpec_eventParList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_EventParameter'(H, [<<48>>]),
   'enc_EventSpec_eventParList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_EventSpec'(Tlv) ->
   'dec_EventSpec'(Tlv, [16]).

'dec_EventSpec'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute eventName(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute streamID(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
Val2 = decode_integer(V2, []),
if 0 =< Val2, Val2 =< 65535 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute eventParList(3) with type SEQUENCE OF
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_EventSpec_eventParList'(V3, [131074]),

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'EventSpec', Term1, Term2, Term3}.

'dec_EventSpec_eventParList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_EventParameter'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  EventBufferDescriptor
%%================================
'enc_EventBufferDescriptor'(Val) ->
    'enc_EventBufferDescriptor'(Val, [<<48>>]).

'enc_EventBufferDescriptor'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_EventBufferDescriptor_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_EventBufferDescriptor_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_EventBufferDescriptor_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_EventSpec'(H, [<<48>>]),
   'enc_EventBufferDescriptor_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_EventBufferDescriptor'(Tlv) ->
   'dec_EventBufferDescriptor'(Tlv, [16]).

'dec_EventBufferDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_EventSpec'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  SecondRequestedActions
%%================================
'enc_SecondRequestedActions'(Val) ->
    'enc_SecondRequestedActions'(Val, [<<48>>]).

'enc_SecondRequestedActions'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute keepActive(1) with type BOOLEAN OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_boolean(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute eventDM(2)   External megaco_ber_media_gateway_control_v2:EventDM OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_EventDM'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute signalsDescriptor(3)   External megaco_ber_media_gateway_control_v2:SignalsDescriptor OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_SignalsDescriptor'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_SecondRequestedActions'(Tlv) ->
   'dec_SecondRequestedActions'(Tlv, [16]).

'dec_SecondRequestedActions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute keepActive(1) with type BOOLEAN OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {decode_boolean(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute eventDM(2)   External megaco_ber_media_gateway_control_v2:EventDM OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_EventDM'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute signalsDescriptor(3)   External megaco_ber_media_gateway_control_v2:SignalsDescriptor OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_SignalsDescriptor'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'SecondRequestedActions', Term1, Term2, Term3}.



%%================================
%%  SecondRequestedEvent
%%================================
'enc_SecondRequestedEvent'(Val) ->
    'enc_SecondRequestedEvent'(Val, [<<48>>]).

'enc_SecondRequestedEvent'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4} = Val,

%%-------------------------------------------------
%% attribute pkgdName(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute streamID(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute eventAction(3)   External megaco_ber_media_gateway_control_v2:SecondRequestedActions OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_SecondRequestedActions'(Cindex3, [<<162>>])
       end,

%%-------------------------------------------------
%% attribute evParList(4) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_SecondRequestedEvent_evParList'(Cindex4, [<<163>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SecondRequestedEvent_evParList
%%================================
'enc_SecondRequestedEvent_evParList'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_SecondRequestedEvent_evParList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SecondRequestedEvent_evParList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SecondRequestedEvent_evParList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_EventParameter'(H, [<<48>>]),
   'enc_SecondRequestedEvent_evParList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_SecondRequestedEvent'(Tlv) ->
   'dec_SecondRequestedEvent'(Tlv, [16]).

'dec_SecondRequestedEvent'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute pkgdName(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute streamID(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
Val2 = decode_integer(V2, []),
if 0 =< Val2, Val2 =< 65535 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute eventAction(3)   External megaco_ber_media_gateway_control_v2:SecondRequestedActions OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_SecondRequestedActions'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute evParList(4) with type SEQUENCE OF
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_SecondRequestedEvent_evParList'(V4, [131075]),

case Tlv5 of [] -> true; _ -> true end, % ... extra fields skipped
   {'SecondRequestedEvent', Term1, Term2, Term3, Term4}.

'dec_SecondRequestedEvent_evParList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_EventParameter'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  SecondEventsDescriptor
%%================================
'enc_SecondEventsDescriptor'(Val) ->
    'enc_SecondEventsDescriptor'(Val, [<<48>>]).

'enc_SecondEventsDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute requestID(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute eventList(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_SecondEventsDescriptor_eventList'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SecondEventsDescriptor_eventList
%%================================
'enc_SecondEventsDescriptor_eventList'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_SecondEventsDescriptor_eventList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SecondEventsDescriptor_eventList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SecondEventsDescriptor_eventList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SecondRequestedEvent'(H, [<<48>>]),
   'enc_SecondEventsDescriptor_eventList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_SecondEventsDescriptor'(Tlv) ->
   'dec_SecondEventsDescriptor'(Tlv, [16]).

'dec_SecondEventsDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute requestID(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, []),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute eventList(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_SecondEventsDescriptor_eventList'(V2, [131073]),

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'SecondEventsDescriptor', Term1, Term2}.

'dec_SecondEventsDescriptor_eventList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SecondRequestedEvent'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  EventDM
%%================================
'enc_EventDM'(Val) ->
    'enc_EventDM'(Val, []).

'enc_EventDM'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      digitMapName ->
         encode_restricted_string(element(2,Val), [<<128>>]);
      digitMapValue ->
         'enc_DigitMapValue'(element(2,Val), [<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_EventDM'(Tlv) ->
   'dec_EventDM'(Tlv, []).

'dec_EventDM'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'digitMapName'
    {131072, V1} -> 
        {digitMapName, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if C1 =:= 2 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'digitMapValue'
    {131073, V1} -> 
        {digitMapValue, 'dec_DigitMapValue'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  RequestedActions
%%================================
'enc_RequestedActions'(Val) ->
    'enc_RequestedActions'(Val, [<<48>>]).

'enc_RequestedActions'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4} = Val,

%%-------------------------------------------------
%% attribute keepActive(1) with type BOOLEAN OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_boolean(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute eventDM(2)   External megaco_ber_media_gateway_control_v2:EventDM OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_EventDM'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute secondEvent(3)   External megaco_ber_media_gateway_control_v2:SecondEventsDescriptor OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_SecondEventsDescriptor'(Cindex3, [<<162>>])
       end,

%%-------------------------------------------------
%% attribute signalsDescriptor(4)   External megaco_ber_media_gateway_control_v2:SignalsDescriptor OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_SignalsDescriptor'(Cindex4, [<<163>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_RequestedActions'(Tlv) ->
   'dec_RequestedActions'(Tlv, [16]).

'dec_RequestedActions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute keepActive(1) with type BOOLEAN OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {decode_boolean(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute eventDM(2)   External megaco_ber_media_gateway_control_v2:EventDM OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_EventDM'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute secondEvent(3)   External megaco_ber_media_gateway_control_v2:SecondEventsDescriptor OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_SecondEventsDescriptor'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute signalsDescriptor(4)   External megaco_ber_media_gateway_control_v2:SignalsDescriptor OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {'dec_SignalsDescriptor'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of [] -> true; _ -> true end, % ... extra fields skipped
   {'RequestedActions', Term1, Term2, Term3, Term4}.



%%================================
%%  RequestedEvent
%%================================
'enc_RequestedEvent'(Val) ->
    'enc_RequestedEvent'(Val, [<<48>>]).

'enc_RequestedEvent'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4} = Val,

%%-------------------------------------------------
%% attribute pkgdName(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute streamID(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute eventAction(3)   External megaco_ber_media_gateway_control_v2:RequestedActions OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_RequestedActions'(Cindex3, [<<162>>])
       end,

%%-------------------------------------------------
%% attribute evParList(4) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_RequestedEvent_evParList'(Cindex4, [<<163>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  RequestedEvent_evParList
%%================================
'enc_RequestedEvent_evParList'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_RequestedEvent_evParList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RequestedEvent_evParList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_RequestedEvent_evParList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_EventParameter'(H, [<<48>>]),
   'enc_RequestedEvent_evParList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_RequestedEvent'(Tlv) ->
   'dec_RequestedEvent'(Tlv, [16]).

'dec_RequestedEvent'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute pkgdName(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute streamID(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
Val2 = decode_integer(V2, []),
if 0 =< Val2, Val2 =< 65535 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute eventAction(3)   External megaco_ber_media_gateway_control_v2:RequestedActions OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_RequestedActions'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute evParList(4) with type SEQUENCE OF
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_RequestedEvent_evParList'(V4, [131075]),

case Tlv5 of [] -> true; _ -> true end, % ... extra fields skipped
   {'RequestedEvent', Term1, Term2, Term3, Term4}.

'dec_RequestedEvent_evParList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_EventParameter'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  EventsDescriptor
%%================================
'enc_EventsDescriptor'(Val) ->
    'enc_EventsDescriptor'(Val, [<<48>>]).

'enc_EventsDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute requestID(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute eventList(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_EventsDescriptor_eventList'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  EventsDescriptor_eventList
%%================================
'enc_EventsDescriptor_eventList'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_EventsDescriptor_eventList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_EventsDescriptor_eventList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_EventsDescriptor_eventList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_RequestedEvent'(H, [<<48>>]),
   'enc_EventsDescriptor_eventList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_EventsDescriptor'(Tlv) ->
   'dec_EventsDescriptor'(Tlv, [16]).

'dec_EventsDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute requestID(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, []),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute eventList(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_EventsDescriptor_eventList'(V2, [131073]),

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'EventsDescriptor', Term1, Term2}.

'dec_EventsDescriptor_eventList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_RequestedEvent'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  StreamID
%%================================
'enc_StreamID'(Val) ->
    'enc_StreamID'(Val, [<<2>>]).

'enc_StreamID'(Val, TagIn) ->
encode_integer(Val, TagIn).


'dec_StreamID'(Tlv) ->
   'dec_StreamID'(Tlv, [2]).

'dec_StreamID'(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 65535 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  MuxType
%%================================
'enc_MuxType'(Val) ->
    'enc_MuxType'(Val, [<<10>>]).

'enc_MuxType'(Val, TagIn) ->
case Val of
h221 -> encode_tags(TagIn, [0], 1);
h223 -> encode_tags(TagIn, [1], 1);
h226 -> encode_tags(TagIn, [2], 1);
v76 -> encode_tags(TagIn, [3], 1);
nx64k -> encode_tags(TagIn, [4], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end.


'dec_MuxType'(Tlv) ->
   'dec_MuxType'(Tlv, [10]).

'dec_MuxType'(Tlv, TagIn) ->
case decode_integer(Tlv, TagIn) of
0 -> h221;
1 -> h223;
2 -> h226;
3 -> v76;
4 -> nx64k;
Default1 -> {asn1_enum,Default1}
end.



%%================================
%%  MuxDescriptor
%%================================
'enc_MuxDescriptor'(Val) ->
    'enc_MuxDescriptor'(Val, [<<48>>]).

'enc_MuxDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute muxType(1) with type ENUMERATED
%%-------------------------------------------------
   {EncBytes1,EncLen1} = case Cindex1 of
h221 -> encode_tags([<<128>>], [0], 1);
h223 -> encode_tags([<<128>>], [1], 1);
h226 -> encode_tags([<<128>>], [2], 1);
v76 -> encode_tags([<<128>>], [3], 1);
nx64k -> encode_tags([<<128>>], [4], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,

%%-------------------------------------------------
%% attribute termList(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_MuxDescriptor_termList'(Cindex2, [<<161>>]),

%%-------------------------------------------------
%% attribute nonStandardData(3)   External megaco_ber_media_gateway_control_v2:NonStandardData OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_NonStandardData'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  MuxDescriptor_termList
%%================================
'enc_MuxDescriptor_termList'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_MuxDescriptor_termList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_MuxDescriptor_termList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_MuxDescriptor_termList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TerminationID'(H, [<<48>>]),
   'enc_MuxDescriptor_termList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_MuxDescriptor'(Tlv) ->
   'dec_MuxDescriptor'(Tlv, [16]).

'dec_MuxDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute muxType(1) with type ENUMERATED
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = case decode_integer(V1, [131072]) of
0 -> h221;
1 -> h223;
2 -> h226;
3 -> v76;
4 -> nx64k;
Default1 -> {asn1_enum,Default1}
end,

%%-------------------------------------------------
%% attribute termList(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_MuxDescriptor_termList'(V2, [131073]),

%%-------------------------------------------------
%% attribute nonStandardData(3)   External megaco_ber_media_gateway_control_v2:NonStandardData OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_NonStandardData'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'MuxDescriptor', Term1, Term2, Term3}.

'dec_MuxDescriptor_termList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TerminationID'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  ServiceState
%%================================
'enc_ServiceState'(Val) ->
    'enc_ServiceState'(Val, [<<10>>]).

'enc_ServiceState'(Val, TagIn) ->
case Val of
test -> encode_tags(TagIn, [0], 1);
outOfSvc -> encode_tags(TagIn, [1], 1);
inSvc -> encode_tags(TagIn, [2], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end.


'dec_ServiceState'(Tlv) ->
   'dec_ServiceState'(Tlv, [10]).

'dec_ServiceState'(Tlv, TagIn) ->
case decode_integer(Tlv, TagIn) of
0 -> test;
1 -> outOfSvc;
2 -> inSvc;
Default1 -> {asn1_enum,Default1}
end.



%%================================
%%  EventBufferControl
%%================================
'enc_EventBufferControl'(Val) ->
    'enc_EventBufferControl'(Val, [<<10>>]).

'enc_EventBufferControl'(Val, TagIn) ->
case Val of
off -> encode_tags(TagIn, [0], 1);
lockStep -> encode_tags(TagIn, [1], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end.


'dec_EventBufferControl'(Tlv) ->
   'dec_EventBufferControl'(Tlv, [10]).

'dec_EventBufferControl'(Tlv, TagIn) ->
case decode_integer(Tlv, TagIn) of
0 -> off;
1 -> lockStep;
Default1 -> {asn1_enum,Default1}
end.



%%================================
%%  TerminationStateDescriptor
%%================================
'enc_TerminationStateDescriptor'(Val) ->
    'enc_TerminationStateDescriptor'(Val, [<<48>>]).

'enc_TerminationStateDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute propertyParms(1) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TerminationStateDescriptor_propertyParms'(Cindex1, [<<160>>]),

%%-------------------------------------------------
%% attribute eventBufferControl(2) with type ENUMERATED OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            case Cindex2 of
off -> encode_tags([<<129>>], [0], 1);
lockStep -> encode_tags([<<129>>], [1], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end
       end,

%%-------------------------------------------------
%% attribute serviceState(3) with type ENUMERATED OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            case Cindex3 of
test -> encode_tags([<<130>>], [0], 1);
outOfSvc -> encode_tags([<<130>>], [1], 1);
inSvc -> encode_tags([<<130>>], [2], 1);
Enumval2 -> exit({error,{asn1, {enumerated_not_in_range,Enumval2}}})
end
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  TerminationStateDescriptor_propertyParms
%%================================
'enc_TerminationStateDescriptor_propertyParms'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_TerminationStateDescriptor_propertyParms_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TerminationStateDescriptor_propertyParms_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TerminationStateDescriptor_propertyParms_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PropertyParm'(H, [<<48>>]),
   'enc_TerminationStateDescriptor_propertyParms_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_TerminationStateDescriptor'(Tlv) ->
   'dec_TerminationStateDescriptor'(Tlv, [16]).

'dec_TerminationStateDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute propertyParms(1) with type SEQUENCE OF
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TerminationStateDescriptor_propertyParms'(V1, [131072]),

%%-------------------------------------------------
%% attribute eventBufferControl(2) with type ENUMERATED OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {case decode_integer(V2, []) of
0 -> off;
1 -> lockStep;
Default1 -> {asn1_enum,Default1}
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute serviceState(3) with type ENUMERATED OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {case decode_integer(V3, []) of
0 -> test;
1 -> outOfSvc;
2 -> inSvc;
Default2 -> {asn1_enum,Default2}
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'TerminationStateDescriptor', Term1, Term2, Term3}.

'dec_TerminationStateDescriptor_propertyParms'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PropertyParm'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  PropertyGroup
%%================================
'enc_PropertyGroup'(Val) ->
    'enc_PropertyGroup'(Val, [<<48>>]).

'enc_PropertyGroup'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_PropertyGroup_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PropertyGroup_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PropertyGroup_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PropertyParm'(H, [<<48>>]),
   'enc_PropertyGroup_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_PropertyGroup'(Tlv) ->
   'dec_PropertyGroup'(Tlv, [16]).

'dec_PropertyGroup'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PropertyParm'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  LocalRemoteDescriptor
%%================================
'enc_LocalRemoteDescriptor'(Val) ->
    'enc_LocalRemoteDescriptor'(Val, [<<48>>]).

'enc_LocalRemoteDescriptor'(Val, TagIn) ->
{_,Cindex1} = Val,

%%-------------------------------------------------
%% attribute propGrps(1) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_LocalRemoteDescriptor_propGrps'(Cindex1, [<<160>>]),

   BytesSoFar = [EncBytes1],
LenSoFar = EncLen1,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  LocalRemoteDescriptor_propGrps
%%================================
'enc_LocalRemoteDescriptor_propGrps'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_LocalRemoteDescriptor_propGrps_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_LocalRemoteDescriptor_propGrps_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_LocalRemoteDescriptor_propGrps_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PropertyGroup'(H, [<<48>>]),
   'enc_LocalRemoteDescriptor_propGrps_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_LocalRemoteDescriptor'(Tlv) ->
   'dec_LocalRemoteDescriptor'(Tlv, [16]).

'dec_LocalRemoteDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute propGrps(1) with type SEQUENCE OF
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_LocalRemoteDescriptor_propGrps'(V1, [131072]),

case Tlv2 of [] -> true; _ -> true end, % ... extra fields skipped
   {'LocalRemoteDescriptor', Term1}.

'dec_LocalRemoteDescriptor_propGrps'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PropertyGroup'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  Relation
%%================================
'enc_Relation'(Val) ->
    'enc_Relation'(Val, [<<10>>]).

'enc_Relation'(Val, TagIn) ->
case Val of
greaterThan -> encode_tags(TagIn, [0], 1);
smallerThan -> encode_tags(TagIn, [1], 1);
unequalTo -> encode_tags(TagIn, [2], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end.


'dec_Relation'(Tlv) ->
   'dec_Relation'(Tlv, [10]).

'dec_Relation'(Tlv, TagIn) ->
case decode_integer(Tlv, TagIn) of
0 -> greaterThan;
1 -> smallerThan;
2 -> unequalTo;
Default1 -> {asn1_enum,Default1}
end.



%%================================
%%  PkgdName
%%================================
'enc_PkgdName'(Val) ->
    'enc_PkgdName'(Val, [<<4>>]).

'enc_PkgdName'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_PkgdName'(Tlv) ->
   'dec_PkgdName'(Tlv, [4]).

'dec_PkgdName'(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  Name
%%================================
'enc_Name'(Val) ->
    'enc_Name'(Val, [<<4>>]).

'enc_Name'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_Name'(Tlv) ->
   'dec_Name'(Tlv, [4]).

'dec_Name'(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if C1 =:= 2 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  PropertyParm
%%================================
'enc_PropertyParm'(Val) ->
    'enc_PropertyParm'(Val, [<<48>>]).

'enc_PropertyParm'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute name(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute value(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PropertyParm_value'(Cindex2, [<<161>>]),

%%-------------------------------------------------
%% attribute extraInfo(3) with type CHOICE OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_PropertyParm_extraInfo'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PropertyParm_value
%%================================
'enc_PropertyParm_value'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PropertyParm_value_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PropertyParm_value_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PropertyParm_value_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<4>>]),
   'enc_PropertyParm_value_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  PropertyParm_extraInfo
%%================================
'enc_PropertyParm_extraInfo'(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      relation ->
         case element(2,Val) of
greaterThan -> encode_tags([<<128>>], [0], 1);
smallerThan -> encode_tags([<<128>>], [1], 1);
unequalTo -> encode_tags([<<128>>], [2], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end;
      range ->
         encode_boolean(element(2,Val), [<<129>>]);
      sublist ->
         encode_boolean(element(2,Val), [<<130>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_PropertyParm'(Tlv) ->
   'dec_PropertyParm'(Tlv, [16]).

'dec_PropertyParm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute name(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute value(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PropertyParm_value'(V2, [131073]),

%%-------------------------------------------------
%% attribute extraInfo(3) with type CHOICE OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_PropertyParm_extraInfo'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'PropertyParm', Term1, Term2, Term3}.

'dec_PropertyParm_value'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
binary_to_list(decode_restricted_string(V1, [4]))
end
 || V1 <- Tlv1].


'dec_PropertyParm_extraInfo'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'relation'
    {131072, V1} -> 
        {relation, case decode_integer(V1, []) of
0 -> greaterThan;
1 -> smallerThan;
2 -> unequalTo;
Default1 -> {asn1_enum,Default1}
end};


%% 'range'
    {131073, V1} -> 
        {range, decode_boolean(V1, [])};


%% 'sublist'
    {131074, V1} -> 
        {sublist, decode_boolean(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  StreamMode
%%================================
'enc_StreamMode'(Val) ->
    'enc_StreamMode'(Val, [<<10>>]).

'enc_StreamMode'(Val, TagIn) ->
case Val of
sendOnly -> encode_tags(TagIn, [0], 1);
recvOnly -> encode_tags(TagIn, [1], 1);
sendRecv -> encode_tags(TagIn, [2], 1);
inactive -> encode_tags(TagIn, [3], 1);
loopBack -> encode_tags(TagIn, [4], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end.


'dec_StreamMode'(Tlv) ->
   'dec_StreamMode'(Tlv, [10]).

'dec_StreamMode'(Tlv, TagIn) ->
case decode_integer(Tlv, TagIn) of
0 -> sendOnly;
1 -> recvOnly;
2 -> sendRecv;
3 -> inactive;
4 -> loopBack;
Default1 -> {asn1_enum,Default1}
end.



%%================================
%%  LocalControlDescriptor
%%================================
'enc_LocalControlDescriptor'(Val) ->
    'enc_LocalControlDescriptor'(Val, [<<48>>]).

'enc_LocalControlDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4} = Val,

%%-------------------------------------------------
%% attribute streamMode(1) with type ENUMERATED OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            case Cindex1 of
sendOnly -> encode_tags([<<128>>], [0], 1);
recvOnly -> encode_tags([<<128>>], [1], 1);
sendRecv -> encode_tags([<<128>>], [2], 1);
inactive -> encode_tags([<<128>>], [3], 1);
loopBack -> encode_tags([<<128>>], [4], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end
       end,

%%-------------------------------------------------
%% attribute reserveValue(2) with type BOOLEAN OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_boolean(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute reserveGroup(3) with type BOOLEAN OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_boolean(Cindex3, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute propertyParms(4) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_LocalControlDescriptor_propertyParms'(Cindex4, [<<163>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  LocalControlDescriptor_propertyParms
%%================================
'enc_LocalControlDescriptor_propertyParms'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_LocalControlDescriptor_propertyParms_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_LocalControlDescriptor_propertyParms_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_LocalControlDescriptor_propertyParms_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PropertyParm'(H, [<<48>>]),
   'enc_LocalControlDescriptor_propertyParms_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_LocalControlDescriptor'(Tlv) ->
   'dec_LocalControlDescriptor'(Tlv, [16]).

'dec_LocalControlDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute streamMode(1) with type ENUMERATED OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {case decode_integer(V1, []) of
0 -> sendOnly;
1 -> recvOnly;
2 -> sendRecv;
3 -> inactive;
4 -> loopBack;
Default1 -> {asn1_enum,Default1}
end, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute reserveValue(2) with type BOOLEAN OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute reserveGroup(3) with type BOOLEAN OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {decode_boolean(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute propertyParms(4) with type SEQUENCE OF
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_LocalControlDescriptor_propertyParms'(V4, [131075]),

case Tlv5 of [] -> true; _ -> true end, % ... extra fields skipped
   {'LocalControlDescriptor', Term1, Term2, Term3, Term4}.

'dec_LocalControlDescriptor_propertyParms'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PropertyParm'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  StreamParms
%%================================
'enc_StreamParms'(Val) ->
    'enc_StreamParms'(Val, [<<48>>]).

'enc_StreamParms'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute localControlDescriptor(1)   External megaco_ber_media_gateway_control_v2:LocalControlDescriptor OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_LocalControlDescriptor'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute localDescriptor(2)   External megaco_ber_media_gateway_control_v2:LocalRemoteDescriptor OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_LocalRemoteDescriptor'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute remoteDescriptor(3)   External megaco_ber_media_gateway_control_v2:LocalRemoteDescriptor OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_LocalRemoteDescriptor'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_StreamParms'(Tlv) ->
   'dec_StreamParms'(Tlv, [16]).

'dec_StreamParms'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute localControlDescriptor(1)   External megaco_ber_media_gateway_control_v2:LocalControlDescriptor OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_LocalControlDescriptor'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute localDescriptor(2)   External megaco_ber_media_gateway_control_v2:LocalRemoteDescriptor OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_LocalRemoteDescriptor'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute remoteDescriptor(3)   External megaco_ber_media_gateway_control_v2:LocalRemoteDescriptor OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_LocalRemoteDescriptor'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'StreamParms', Term1, Term2, Term3}.



%%================================
%%  StreamDescriptor
%%================================
'enc_StreamDescriptor'(Val) ->
    'enc_StreamDescriptor'(Val, [<<48>>]).

'enc_StreamDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute streamID(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute streamParms(2)   External megaco_ber_media_gateway_control_v2:StreamParms
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_StreamParms'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_StreamDescriptor'(Tlv) ->
   'dec_StreamDescriptor'(Tlv, [16]).

'dec_StreamDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute streamID(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [131072]),
if 0 =< Val1, Val1 =< 65535 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute streamParms(2)   External megaco_ber_media_gateway_control_v2:StreamParms
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_StreamParms'(V2, [131073]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'StreamDescriptor', Term1, Term2}.



%%================================
%%  MediaDescriptor
%%================================
'enc_MediaDescriptor'(Val) ->
    'enc_MediaDescriptor'(Val, [<<48>>]).

'enc_MediaDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute termStateDescr(1)   External megaco_ber_media_gateway_control_v2:TerminationStateDescriptor OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_TerminationStateDescriptor'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute streams(2) with type CHOICE OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_MediaDescriptor_streams'(Cindex2, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  MediaDescriptor_streams
%%================================
'enc_MediaDescriptor_streams'(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      oneStream ->
         'enc_StreamParms'(element(2,Val), [<<160>>]);
      multiStream ->
         'enc_MediaDescriptor_streams_multiStream'(element(2,Val), [<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  MediaDescriptor_streams_multiStream
%%================================
'enc_MediaDescriptor_streams_multiStream'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_MediaDescriptor_streams_multiStream_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_MediaDescriptor_streams_multiStream_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_MediaDescriptor_streams_multiStream_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_StreamDescriptor'(H, [<<48>>]),
   'enc_MediaDescriptor_streams_multiStream_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_MediaDescriptor'(Tlv) ->
   'dec_MediaDescriptor'(Tlv, [16]).

'dec_MediaDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute termStateDescr(1)   External megaco_ber_media_gateway_control_v2:TerminationStateDescriptor OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_TerminationStateDescriptor'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute streams(2) with type CHOICE OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_MediaDescriptor_streams'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'MediaDescriptor', Term1, Term2}.

'dec_MediaDescriptor_streams'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'oneStream'
    {131072, V1} -> 
        {oneStream, 'dec_StreamParms'(V1, [])};


%% 'multiStream'
    {131073, V1} -> 
        {multiStream, 'dec_MediaDescriptor_streams_multiStream'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_MediaDescriptor_streams_multiStream'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_StreamDescriptor'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  TerminationIDList
%%================================
'enc_TerminationIDList'(Val) ->
    'enc_TerminationIDList'(Val, [<<48>>]).

'enc_TerminationIDList'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_TerminationIDList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TerminationIDList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TerminationIDList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TerminationID'(H, [<<48>>]),
   'enc_TerminationIDList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_TerminationIDList'(Tlv) ->
   'dec_TerminationIDList'(Tlv, [16]).

'dec_TerminationIDList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TerminationID'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  TerminationID
%%================================
'enc_TerminationID'(Val) ->
    'enc_TerminationID'(Val, [<<48>>]).

'enc_TerminationID'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute wildcard(1) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TerminationID_wildcard'(Cindex1, [<<160>>]),

%%-------------------------------------------------
%% attribute id(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<129>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  TerminationID_wildcard
%%================================
'enc_TerminationID_wildcard'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_TerminationID_wildcard_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TerminationID_wildcard_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TerminationID_wildcard_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<4>>]),
   'enc_TerminationID_wildcard_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_TerminationID'(Tlv) ->
   'dec_TerminationID'(Tlv, [16]).

'dec_TerminationID'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute wildcard(1) with type SEQUENCE OF
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TerminationID_wildcard'(V1, [131072]),

%%-------------------------------------------------
%% attribute id(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val1 = decode_restricted_string(V2, [131073]),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 8 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'TerminationID', Term1, Term2}.

'dec_TerminationID_wildcard'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
Val1 = decode_restricted_string(V1, [4]),
C1 = byte_size(Val1),
if C1 =:= 1 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end || V1 <- Tlv1].




%%================================
%%  WildcardField
%%================================
'enc_WildcardField'(Val) ->
    'enc_WildcardField'(Val, [<<4>>]).

'enc_WildcardField'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_WildcardField'(Tlv) ->
   'dec_WildcardField'(Tlv, [4]).

'dec_WildcardField'(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if C1 =:= 1 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  ServiceChangeResult
%%================================
'enc_ServiceChangeResult'(Val) ->
    'enc_ServiceChangeResult'(Val, []).

'enc_ServiceChangeResult'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      errorDescriptor ->
         'enc_ErrorDescriptor'(element(2,Val), [<<160>>]);
      serviceChangeResParms ->
         'enc_ServiceChangeResParm'(element(2,Val), [<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_ServiceChangeResult'(Tlv) ->
   'dec_ServiceChangeResult'(Tlv, []).

'dec_ServiceChangeResult'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'errorDescriptor'
    {131072, V1} -> 
        {errorDescriptor, 'dec_ErrorDescriptor'(V1, [])};


%% 'serviceChangeResParms'
    {131073, V1} -> 
        {serviceChangeResParms, 'dec_ServiceChangeResParm'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  ServiceChangeReply
%%================================
'enc_ServiceChangeReply'(Val) ->
    'enc_ServiceChangeReply'(Val, [<<48>>]).

'enc_ServiceChangeReply'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationIDList
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TerminationIDList'(Cindex1, [<<160>>]),

%%-------------------------------------------------
%% attribute serviceChangeResult(2)   External megaco_ber_media_gateway_control_v2:ServiceChangeResult
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_ServiceChangeResult'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_ServiceChangeReply'(Tlv) ->
   'dec_ServiceChangeReply'(Tlv, [16]).

'dec_ServiceChangeReply'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationIDList
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TerminationIDList'(V1, [131072]),

%%-------------------------------------------------
%% attribute serviceChangeResult(2)   External megaco_ber_media_gateway_control_v2:ServiceChangeResult
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_ServiceChangeResult'(V2, [131073]),

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'ServiceChangeReply', Term1, Term2}.



%%================================
%%  ServiceChangeRequest
%%================================
'enc_ServiceChangeRequest'(Val) ->
    'enc_ServiceChangeRequest'(Val, [<<48>>]).

'enc_ServiceChangeRequest'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationIDList
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TerminationIDList'(Cindex1, [<<160>>]),

%%-------------------------------------------------
%% attribute serviceChangeParms(2)   External megaco_ber_media_gateway_control_v2:ServiceChangeParm
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_ServiceChangeParm'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_ServiceChangeRequest'(Tlv) ->
   'dec_ServiceChangeRequest'(Tlv, [16]).

'dec_ServiceChangeRequest'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationIDList
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TerminationIDList'(V1, [131072]),

%%-------------------------------------------------
%% attribute serviceChangeParms(2)   External megaco_ber_media_gateway_control_v2:ServiceChangeParm
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_ServiceChangeParm'(V2, [131073]),

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'ServiceChangeRequest', Term1, Term2}.



%%================================
%%  EventParameter
%%================================
'enc_EventParameter'(Val) ->
    'enc_EventParameter'(Val, [<<48>>]).

'enc_EventParameter'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute eventParameterName(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute value(2)   External megaco_ber_media_gateway_control_v2:Value
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Value'(Cindex2, [<<161>>]),

%%-------------------------------------------------
%% attribute extraInfo(3) with type CHOICE OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_EventParameter_extraInfo'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  EventParameter_extraInfo
%%================================
'enc_EventParameter_extraInfo'(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      relation ->
         case element(2,Val) of
greaterThan -> encode_tags([<<128>>], [0], 1);
smallerThan -> encode_tags([<<128>>], [1], 1);
unequalTo -> encode_tags([<<128>>], [2], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end;
      range ->
         encode_boolean(element(2,Val), [<<129>>]);
      sublist ->
         encode_boolean(element(2,Val), [<<130>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_EventParameter'(Tlv) ->
   'dec_EventParameter'(Tlv, [16]).

'dec_EventParameter'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute eventParameterName(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 2 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute value(2)   External megaco_ber_media_gateway_control_v2:Value
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Value'(V2, [131073]),

%%-------------------------------------------------
%% attribute extraInfo(3) with type CHOICE OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_EventParameter_extraInfo'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'EventParameter', Term1, Term2, Term3}.

'dec_EventParameter_extraInfo'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'relation'
    {131072, V1} -> 
        {relation, case decode_integer(V1, []) of
0 -> greaterThan;
1 -> smallerThan;
2 -> unequalTo;
Default1 -> {asn1_enum,Default1}
end};


%% 'range'
    {131073, V1} -> 
        {range, decode_boolean(V1, [])};


%% 'sublist'
    {131074, V1} -> 
        {sublist, decode_boolean(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  EventName
%%================================
'enc_EventName'(Val) ->
    'enc_EventName'(Val, [<<4>>]).

'enc_EventName'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_EventName'(Tlv) ->
   'dec_EventName'(Tlv, [4]).

'dec_EventName'(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  ObservedEvent
%%================================
'enc_ObservedEvent'(Val) ->
    'enc_ObservedEvent'(Val, [<<48>>]).

'enc_ObservedEvent'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4} = Val,

%%-------------------------------------------------
%% attribute eventName(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute streamID(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute eventParList(3) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_ObservedEvent_eventParList'(Cindex3, [<<162>>]),

%%-------------------------------------------------
%% attribute timeNotation(4)   External megaco_ber_media_gateway_control_v2:TimeNotation OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_TimeNotation'(Cindex4, [<<163>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  ObservedEvent_eventParList
%%================================
'enc_ObservedEvent_eventParList'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ObservedEvent_eventParList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ObservedEvent_eventParList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ObservedEvent_eventParList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_EventParameter'(H, [<<48>>]),
   'enc_ObservedEvent_eventParList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_ObservedEvent'(Tlv) ->
   'dec_ObservedEvent'(Tlv, [16]).

'dec_ObservedEvent'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute eventName(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute streamID(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
Val2 = decode_integer(V2, []),
if 0 =< Val2, Val2 =< 65535 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute eventParList(3) with type SEQUENCE OF
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_ObservedEvent_eventParList'(V3, [131074]),

%%-------------------------------------------------
%% attribute timeNotation(4)   External megaco_ber_media_gateway_control_v2:TimeNotation OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {'dec_TimeNotation'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of [] -> true; _ -> true end, % ... extra fields skipped
   {'ObservedEvent', Term1, Term2, Term3, Term4}.

'dec_ObservedEvent_eventParList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_EventParameter'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  ObservedEventsDescriptor
%%================================
'enc_ObservedEventsDescriptor'(Val) ->
    'enc_ObservedEventsDescriptor'(Val, [<<48>>]).

'enc_ObservedEventsDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute requestId(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute observedEventLst(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_ObservedEventsDescriptor_observedEventLst'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  ObservedEventsDescriptor_observedEventLst
%%================================
'enc_ObservedEventsDescriptor_observedEventLst'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ObservedEventsDescriptor_observedEventLst_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ObservedEventsDescriptor_observedEventLst_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ObservedEventsDescriptor_observedEventLst_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_ObservedEvent'(H, [<<48>>]),
   'enc_ObservedEventsDescriptor_observedEventLst_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_ObservedEventsDescriptor'(Tlv) ->
   'dec_ObservedEventsDescriptor'(Tlv, [16]).

'dec_ObservedEventsDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute requestId(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [131072]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute observedEventLst(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_ObservedEventsDescriptor_observedEventLst'(V2, [131073]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'ObservedEventsDescriptor', Term1, Term2}.

'dec_ObservedEventsDescriptor_observedEventLst'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_ObservedEvent'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  NotifyReply
%%================================
'enc_NotifyReply'(Val) ->
    'enc_NotifyReply'(Val, [<<48>>]).

'enc_NotifyReply'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationIDList
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TerminationIDList'(Cindex1, [<<160>>]),

%%-------------------------------------------------
%% attribute errorDescriptor(2)   External megaco_ber_media_gateway_control_v2:ErrorDescriptor OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ErrorDescriptor'(Cindex2, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_NotifyReply'(Tlv) ->
   'dec_NotifyReply'(Tlv, [16]).

'dec_NotifyReply'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationIDList
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TerminationIDList'(V1, [131072]),

%%-------------------------------------------------
%% attribute errorDescriptor(2)   External megaco_ber_media_gateway_control_v2:ErrorDescriptor OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_ErrorDescriptor'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'NotifyReply', Term1, Term2}.



%%================================
%%  NotifyRequest
%%================================
'enc_NotifyRequest'(Val) ->
    'enc_NotifyRequest'(Val, [<<48>>]).

'enc_NotifyRequest'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationIDList
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TerminationIDList'(Cindex1, [<<160>>]),

%%-------------------------------------------------
%% attribute observedEventsDescriptor(2)   External megaco_ber_media_gateway_control_v2:ObservedEventsDescriptor
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_ObservedEventsDescriptor'(Cindex2, [<<161>>]),

%%-------------------------------------------------
%% attribute errorDescriptor(3)   External megaco_ber_media_gateway_control_v2:ErrorDescriptor OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ErrorDescriptor'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_NotifyRequest'(Tlv) ->
   'dec_NotifyRequest'(Tlv, [16]).

'dec_NotifyRequest'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationIDList
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TerminationIDList'(V1, [131072]),

%%-------------------------------------------------
%% attribute observedEventsDescriptor(2)   External megaco_ber_media_gateway_control_v2:ObservedEventsDescriptor
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_ObservedEventsDescriptor'(V2, [131073]),

%%-------------------------------------------------
%% attribute errorDescriptor(3)   External megaco_ber_media_gateway_control_v2:ErrorDescriptor OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_ErrorDescriptor'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'NotifyRequest', Term1, Term2, Term3}.



%%================================
%%  IndAudPackagesDescriptor
%%================================
'enc_IndAudPackagesDescriptor'(Val) ->
    'enc_IndAudPackagesDescriptor'(Val, [<<48>>]).

'enc_IndAudPackagesDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute packageName(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute packageVersion(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<129>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_IndAudPackagesDescriptor'(Tlv) ->
   'dec_IndAudPackagesDescriptor'(Tlv, [16]).

'dec_IndAudPackagesDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute packageName(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 2 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute packageVersion(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val2 = decode_integer(V2, [131073]),
if 0 =< Val2, Val2 =< 99 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'IndAudPackagesDescriptor', Term1, Term2}.



%%================================
%%  IndAudStatisticsDescriptor
%%================================
'enc_IndAudStatisticsDescriptor'(Val) ->
    'enc_IndAudStatisticsDescriptor'(Val, [<<48>>]).

'enc_IndAudStatisticsDescriptor'(Val, TagIn) ->
{_,Cindex1} = Val,

%%-------------------------------------------------
%% attribute statName(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

   BytesSoFar = [EncBytes1],
LenSoFar = EncLen1,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_IndAudStatisticsDescriptor'(Tlv) ->
   'dec_IndAudStatisticsDescriptor'(Tlv, [16]).

'dec_IndAudStatisticsDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute statName(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv2 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv2}}}) % extra fields not allowed
end,
   {'IndAudStatisticsDescriptor', Term1}.



%%================================
%%  IndAudDigitMapDescriptor
%%================================
'enc_IndAudDigitMapDescriptor'(Val) ->
    'enc_IndAudDigitMapDescriptor'(Val, [<<48>>]).

'enc_IndAudDigitMapDescriptor'(Val, TagIn) ->
{_,Cindex1} = Val,

%%-------------------------------------------------
%% attribute digitMapName(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex1, [<<128>>])
       end,

   BytesSoFar = [EncBytes1],
LenSoFar = EncLen1,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_IndAudDigitMapDescriptor'(Tlv) ->
   'dec_IndAudDigitMapDescriptor'(Tlv, [16]).

'dec_IndAudDigitMapDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute digitMapName(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if C1 =:= 2 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

case Tlv2 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv2}}}) % extra fields not allowed
end,
   {'IndAudDigitMapDescriptor', Term1}.



%%================================
%%  IndAudSignal
%%================================
'enc_IndAudSignal'(Val) ->
    'enc_IndAudSignal'(Val, [<<48>>]).

'enc_IndAudSignal'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute signalName(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute streamID(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_IndAudSignal'(Tlv) ->
   'dec_IndAudSignal'(Tlv, [16]).

'dec_IndAudSignal'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute signalName(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute streamID(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
Val2 = decode_integer(V2, []),
if 0 =< Val2, Val2 =< 65535 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'IndAudSignal', Term1, Term2}.



%%================================
%%  IndAudSeqSigList
%%================================
'enc_IndAudSeqSigList'(Val) ->
    'enc_IndAudSeqSigList'(Val, [<<48>>]).

'enc_IndAudSeqSigList'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute id(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute signalList(2)   External megaco_ber_media_gateway_control_v2:IndAudSignal OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_IndAudSignal'(Cindex2, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_IndAudSeqSigList'(Tlv) ->
   'dec_IndAudSeqSigList'(Tlv, [16]).

'dec_IndAudSeqSigList'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute id(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [131072]),
if 0 =< Val1, Val1 =< 65535 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute signalList(2)   External megaco_ber_media_gateway_control_v2:IndAudSignal OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_IndAudSignal'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'IndAudSeqSigList', Term1, Term2}.



%%================================
%%  IndAudSignalsDescriptor
%%================================
'enc_IndAudSignalsDescriptor'(Val) ->
    'enc_IndAudSignalsDescriptor'(Val, []).

'enc_IndAudSignalsDescriptor'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      signal ->
         'enc_IndAudSignal'(element(2,Val), [<<160>>]);
      seqSigList ->
         'enc_IndAudSeqSigList'(element(2,Val), [<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_IndAudSignalsDescriptor'(Tlv) ->
   'dec_IndAudSignalsDescriptor'(Tlv, []).

'dec_IndAudSignalsDescriptor'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'signal'
    {131072, V1} -> 
        {signal, 'dec_IndAudSignal'(V1, [])};


%% 'seqSigList'
    {131073, V1} -> 
        {seqSigList, 'dec_IndAudSeqSigList'(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  IndAudEventBufferDescriptor
%%================================
'enc_IndAudEventBufferDescriptor'(Val) ->
    'enc_IndAudEventBufferDescriptor'(Val, [<<48>>]).

'enc_IndAudEventBufferDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute eventName(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute streamID(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_IndAudEventBufferDescriptor'(Tlv) ->
   'dec_IndAudEventBufferDescriptor'(Tlv, [16]).

'dec_IndAudEventBufferDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute eventName(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute streamID(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
Val2 = decode_integer(V2, []),
if 0 =< Val2, Val2 =< 65535 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'IndAudEventBufferDescriptor', Term1, Term2}.



%%================================
%%  IndAudEventsDescriptor
%%================================
'enc_IndAudEventsDescriptor'(Val) ->
    'enc_IndAudEventsDescriptor'(Val, [<<48>>]).

'enc_IndAudEventsDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute requestID(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute pkgdName(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<129>>]),

%%-------------------------------------------------
%% attribute streamID(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex3, [<<130>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_IndAudEventsDescriptor'(Tlv) ->
   'dec_IndAudEventsDescriptor'(Tlv, [16]).

'dec_IndAudEventsDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute requestID(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, []),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute pkgdName(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val2 = decode_restricted_string(V2, [131073]),
C1 = byte_size(Val2),
if C1 =:= 4 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute streamID(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {begin
Val3 = decode_integer(V3, []),
if 0 =< Val3, Val3 =< 65535 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'IndAudEventsDescriptor', Term1, Term2, Term3}.



%%================================
%%  IndAudTerminationStateDescriptor
%%================================
'enc_IndAudTerminationStateDescriptor'(Val) ->
    'enc_IndAudTerminationStateDescriptor'(Val, [<<48>>]).

'enc_IndAudTerminationStateDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute propertyParms(1) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_IndAudTerminationStateDescriptor_propertyParms'(Cindex1, [<<160>>]),

%%-------------------------------------------------
%% attribute eventBufferControl(2) with type NULL OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_null(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute serviceState(3) with type NULL OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_null(Cindex3, [<<130>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  IndAudTerminationStateDescriptor_propertyParms
%%================================
'enc_IndAudTerminationStateDescriptor_propertyParms'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_IndAudTerminationStateDescriptor_propertyParms_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_IndAudTerminationStateDescriptor_propertyParms_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_IndAudTerminationStateDescriptor_propertyParms_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_IndAudPropertyParm'(H, [<<48>>]),
   'enc_IndAudTerminationStateDescriptor_propertyParms_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_IndAudTerminationStateDescriptor'(Tlv) ->
   'dec_IndAudTerminationStateDescriptor'(Tlv, [16]).

'dec_IndAudTerminationStateDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute propertyParms(1) with type SEQUENCE OF
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_IndAudTerminationStateDescriptor_propertyParms'(V1, [131072]),

%%-------------------------------------------------
%% attribute eventBufferControl(2) with type NULL OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_null(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute serviceState(3) with type NULL OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {decode_null(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'IndAudTerminationStateDescriptor', Term1, Term2, Term3}.

'dec_IndAudTerminationStateDescriptor_propertyParms'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_IndAudPropertyParm'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  IndAudPropertyGroup
%%================================
'enc_IndAudPropertyGroup'(Val) ->
    'enc_IndAudPropertyGroup'(Val, [<<48>>]).

'enc_IndAudPropertyGroup'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_IndAudPropertyGroup_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_IndAudPropertyGroup_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_IndAudPropertyGroup_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_IndAudPropertyParm'(H, [<<48>>]),
   'enc_IndAudPropertyGroup_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_IndAudPropertyGroup'(Tlv) ->
   'dec_IndAudPropertyGroup'(Tlv, [16]).

'dec_IndAudPropertyGroup'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_IndAudPropertyParm'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  IndAudLocalRemoteDescriptor
%%================================
'enc_IndAudLocalRemoteDescriptor'(Val) ->
    'enc_IndAudLocalRemoteDescriptor'(Val, [<<48>>]).

'enc_IndAudLocalRemoteDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute propGroupID(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute propGrps(2)   External megaco_ber_media_gateway_control_v2:IndAudPropertyGroup
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_IndAudPropertyGroup'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_IndAudLocalRemoteDescriptor'(Tlv) ->
   'dec_IndAudLocalRemoteDescriptor'(Tlv, [16]).

'dec_IndAudLocalRemoteDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute propGroupID(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, []),
if 0 =< Val1, Val1 =< 65535 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute propGrps(2)   External megaco_ber_media_gateway_control_v2:IndAudPropertyGroup
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_IndAudPropertyGroup'(V2, [131073]),

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'IndAudLocalRemoteDescriptor', Term1, Term2}.



%%================================
%%  IndAudPropertyParm
%%================================
'enc_IndAudPropertyParm'(Val) ->
    'enc_IndAudPropertyParm'(Val, [<<48>>]).

'enc_IndAudPropertyParm'(Val, TagIn) ->
{_,Cindex1} = Val,

%%-------------------------------------------------
%% attribute name(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

   BytesSoFar = [EncBytes1],
LenSoFar = EncLen1,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_IndAudPropertyParm'(Tlv) ->
   'dec_IndAudPropertyParm'(Tlv, [16]).

'dec_IndAudPropertyParm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute name(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv2 of [] -> true; _ -> true end, % ... extra fields skipped
   {'IndAudPropertyParm', Term1}.



%%================================
%%  IndAudLocalControlDescriptor
%%================================
'enc_IndAudLocalControlDescriptor'(Val) ->
    'enc_IndAudLocalControlDescriptor'(Val, [<<48>>]).

'enc_IndAudLocalControlDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4} = Val,

%%-------------------------------------------------
%% attribute streamMode(1) with type NULL OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_null(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute reserveValue(2) with type NULL OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_null(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute reserveGroup(3) with type NULL OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_null(Cindex3, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute propertyParms(4) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_IndAudLocalControlDescriptor_propertyParms'(Cindex4, [<<163>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  IndAudLocalControlDescriptor_propertyParms
%%================================
'enc_IndAudLocalControlDescriptor_propertyParms'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_IndAudLocalControlDescriptor_propertyParms_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_IndAudLocalControlDescriptor_propertyParms_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_IndAudLocalControlDescriptor_propertyParms_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_IndAudPropertyParm'(H, [<<48>>]),
   'enc_IndAudLocalControlDescriptor_propertyParms_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_IndAudLocalControlDescriptor'(Tlv) ->
   'dec_IndAudLocalControlDescriptor'(Tlv, [16]).

'dec_IndAudLocalControlDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute streamMode(1) with type NULL OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {decode_null(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute reserveValue(2) with type NULL OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_null(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute reserveGroup(3) with type NULL OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {decode_null(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute propertyParms(4) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {'dec_IndAudLocalControlDescriptor_propertyParms'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of [] -> true; _ -> true end, % ... extra fields skipped
   {'IndAudLocalControlDescriptor', Term1, Term2, Term3, Term4}.

'dec_IndAudLocalControlDescriptor_propertyParms'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_IndAudPropertyParm'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  IndAudStreamParms
%%================================
'enc_IndAudStreamParms'(Val) ->
    'enc_IndAudStreamParms'(Val, [<<48>>]).

'enc_IndAudStreamParms'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute localControlDescriptor(1)   External megaco_ber_media_gateway_control_v2:IndAudLocalControlDescriptor OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_IndAudLocalControlDescriptor'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute localDescriptor(2)   External megaco_ber_media_gateway_control_v2:IndAudLocalRemoteDescriptor OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_IndAudLocalRemoteDescriptor'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute remoteDescriptor(3)   External megaco_ber_media_gateway_control_v2:IndAudLocalRemoteDescriptor OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_IndAudLocalRemoteDescriptor'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_IndAudStreamParms'(Tlv) ->
   'dec_IndAudStreamParms'(Tlv, [16]).

'dec_IndAudStreamParms'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute localControlDescriptor(1)   External megaco_ber_media_gateway_control_v2:IndAudLocalControlDescriptor OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_IndAudLocalControlDescriptor'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute localDescriptor(2)   External megaco_ber_media_gateway_control_v2:IndAudLocalRemoteDescriptor OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_IndAudLocalRemoteDescriptor'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute remoteDescriptor(3)   External megaco_ber_media_gateway_control_v2:IndAudLocalRemoteDescriptor OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_IndAudLocalRemoteDescriptor'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'IndAudStreamParms', Term1, Term2, Term3}.



%%================================
%%  IndAudStreamDescriptor
%%================================
'enc_IndAudStreamDescriptor'(Val) ->
    'enc_IndAudStreamDescriptor'(Val, [<<48>>]).

'enc_IndAudStreamDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute streamID(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute streamParms(2)   External megaco_ber_media_gateway_control_v2:IndAudStreamParms
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_IndAudStreamParms'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_IndAudStreamDescriptor'(Tlv) ->
   'dec_IndAudStreamDescriptor'(Tlv, [16]).

'dec_IndAudStreamDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute streamID(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [131072]),
if 0 =< Val1, Val1 =< 65535 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute streamParms(2)   External megaco_ber_media_gateway_control_v2:IndAudStreamParms
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_IndAudStreamParms'(V2, [131073]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'IndAudStreamDescriptor', Term1, Term2}.



%%================================
%%  IndAudMediaDescriptor
%%================================
'enc_IndAudMediaDescriptor'(Val) ->
    'enc_IndAudMediaDescriptor'(Val, [<<48>>]).

'enc_IndAudMediaDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute termStateDescr(1)   External megaco_ber_media_gateway_control_v2:IndAudTerminationStateDescriptor OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_IndAudTerminationStateDescriptor'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute streams(2) with type CHOICE OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_IndAudMediaDescriptor_streams'(Cindex2, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  IndAudMediaDescriptor_streams
%%================================
'enc_IndAudMediaDescriptor_streams'(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      oneStream ->
         'enc_IndAudStreamParms'(element(2,Val), [<<160>>]);
      multiStream ->
         'enc_IndAudMediaDescriptor_streams_multiStream'(element(2,Val), [<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  IndAudMediaDescriptor_streams_multiStream
%%================================
'enc_IndAudMediaDescriptor_streams_multiStream'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_IndAudMediaDescriptor_streams_multiStream_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_IndAudMediaDescriptor_streams_multiStream_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_IndAudMediaDescriptor_streams_multiStream_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_IndAudStreamDescriptor'(H, [<<48>>]),
   'enc_IndAudMediaDescriptor_streams_multiStream_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_IndAudMediaDescriptor'(Tlv) ->
   'dec_IndAudMediaDescriptor'(Tlv, [16]).

'dec_IndAudMediaDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute termStateDescr(1)   External megaco_ber_media_gateway_control_v2:IndAudTerminationStateDescriptor OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_IndAudTerminationStateDescriptor'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute streams(2) with type CHOICE OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_IndAudMediaDescriptor_streams'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'IndAudMediaDescriptor', Term1, Term2}.

'dec_IndAudMediaDescriptor_streams'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'oneStream'
    {131072, V1} -> 
        {oneStream, 'dec_IndAudStreamParms'(V1, [])};


%% 'multiStream'
    {131073, V1} -> 
        {multiStream, 'dec_IndAudMediaDescriptor_streams_multiStream'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_IndAudMediaDescriptor_streams_multiStream'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_IndAudStreamDescriptor'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  IndAuditParameter
%%================================
'enc_IndAuditParameter'(Val) ->
    'enc_IndAuditParameter'(Val, []).

'enc_IndAuditParameter'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      indAudMediaDescriptor ->
         'enc_IndAudMediaDescriptor'(element(2,Val), [<<160>>]);
      indAudEventsDescriptor ->
         'enc_IndAudEventsDescriptor'(element(2,Val), [<<161>>]);
      indAudEventBufferDescriptor ->
         'enc_IndAudEventBufferDescriptor'(element(2,Val), [<<162>>]);
      indAudSignalsDescriptor ->
         'enc_IndAudSignalsDescriptor'(element(2,Val), [<<163>>]);
      indAudDigitMapDescriptor ->
         'enc_IndAudDigitMapDescriptor'(element(2,Val), [<<164>>]);
      indAudStatisticsDescriptor ->
         'enc_IndAudStatisticsDescriptor'(element(2,Val), [<<165>>]);
      indAudPackagesDescriptor ->
         'enc_IndAudPackagesDescriptor'(element(2,Val), [<<166>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_IndAuditParameter'(Tlv) ->
   'dec_IndAuditParameter'(Tlv, []).

'dec_IndAuditParameter'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'indAudMediaDescriptor'
    {131072, V1} -> 
        {indAudMediaDescriptor, 'dec_IndAudMediaDescriptor'(V1, [])};


%% 'indAudEventsDescriptor'
    {131073, V1} -> 
        {indAudEventsDescriptor, 'dec_IndAudEventsDescriptor'(V1, [])};


%% 'indAudEventBufferDescriptor'
    {131074, V1} -> 
        {indAudEventBufferDescriptor, 'dec_IndAudEventBufferDescriptor'(V1, [])};


%% 'indAudSignalsDescriptor'
    {131075, V1} -> 
        {indAudSignalsDescriptor, 'dec_IndAudSignalsDescriptor'(V1, [])};


%% 'indAudDigitMapDescriptor'
    {131076, V1} -> 
        {indAudDigitMapDescriptor, 'dec_IndAudDigitMapDescriptor'(V1, [])};


%% 'indAudStatisticsDescriptor'
    {131077, V1} -> 
        {indAudStatisticsDescriptor, 'dec_IndAudStatisticsDescriptor'(V1, [])};


%% 'indAudPackagesDescriptor'
    {131078, V1} -> 
        {indAudPackagesDescriptor, 'dec_IndAudPackagesDescriptor'(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  AuditDescriptor
%%================================
'enc_AuditDescriptor'(Val) ->
    'enc_AuditDescriptor'(Val, [<<48>>]).

'enc_AuditDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute auditToken(1) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_bit_string([], Cindex1, [{muxToken,0},{modemToken,1},{mediaToken,2},{eventsToken,3},{signalsToken,4},{digitMapToken,5},{statsToken,6},{observedEventsToken,7},{packagesToken,8},{eventBufferToken,9}], [<<128>>])
       end,

%%-------------------------------------------------
%% attribute auditPropertyToken(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AuditDescriptor_auditPropertyToken'(Cindex2, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  AuditDescriptor_auditPropertyToken
%%================================
'enc_AuditDescriptor_auditPropertyToken'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_AuditDescriptor_auditPropertyToken_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AuditDescriptor_auditPropertyToken_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AuditDescriptor_auditPropertyToken_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_IndAuditParameter'(H, []),
   'enc_AuditDescriptor_auditPropertyToken_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_AuditDescriptor'(Tlv) ->
   'dec_AuditDescriptor'(Tlv, [16]).

'dec_AuditDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute auditToken(1) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {decode_named_bit_string(V1, [{muxToken,0},{modemToken,1},{mediaToken,2},{eventsToken,3},{signalsToken,4},{digitMapToken,5},{statsToken,6},{observedEventsToken,7},{packagesToken,8},{eventBufferToken,9}], []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute auditPropertyToken(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_AuditDescriptor_auditPropertyToken'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'AuditDescriptor', Term1, Term2}.

'dec_AuditDescriptor_auditPropertyToken'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_IndAuditParameter'(V1, []) || V1 <- Tlv1].




%%================================
%%  AuditReturnParameter
%%================================
'enc_AuditReturnParameter'(Val) ->
    'enc_AuditReturnParameter'(Val, []).

'enc_AuditReturnParameter'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      errorDescriptor ->
         'enc_ErrorDescriptor'(element(2,Val), [<<160>>]);
      mediaDescriptor ->
         'enc_MediaDescriptor'(element(2,Val), [<<161>>]);
      modemDescriptor ->
         'enc_ModemDescriptor'(element(2,Val), [<<162>>]);
      muxDescriptor ->
         'enc_MuxDescriptor'(element(2,Val), [<<163>>]);
      eventsDescriptor ->
         'enc_EventsDescriptor'(element(2,Val), [<<164>>]);
      eventBufferDescriptor ->
         'enc_EventBufferDescriptor'(element(2,Val), [<<165>>]);
      signalsDescriptor ->
         'enc_SignalsDescriptor'(element(2,Val), [<<166>>]);
      digitMapDescriptor ->
         'enc_DigitMapDescriptor'(element(2,Val), [<<167>>]);
      observedEventsDescriptor ->
         'enc_ObservedEventsDescriptor'(element(2,Val), [<<168>>]);
      statisticsDescriptor ->
         'enc_StatisticsDescriptor'(element(2,Val), [<<169>>]);
      packagesDescriptor ->
         'enc_PackagesDescriptor'(element(2,Val), [<<170>>]);
      emptyDescriptors ->
         'enc_AuditDescriptor'(element(2,Val), [<<171>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_AuditReturnParameter'(Tlv) ->
   'dec_AuditReturnParameter'(Tlv, []).

'dec_AuditReturnParameter'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'errorDescriptor'
    {131072, V1} -> 
        {errorDescriptor, 'dec_ErrorDescriptor'(V1, [])};


%% 'mediaDescriptor'
    {131073, V1} -> 
        {mediaDescriptor, 'dec_MediaDescriptor'(V1, [])};


%% 'modemDescriptor'
    {131074, V1} -> 
        {modemDescriptor, 'dec_ModemDescriptor'(V1, [])};


%% 'muxDescriptor'
    {131075, V1} -> 
        {muxDescriptor, 'dec_MuxDescriptor'(V1, [])};


%% 'eventsDescriptor'
    {131076, V1} -> 
        {eventsDescriptor, 'dec_EventsDescriptor'(V1, [])};


%% 'eventBufferDescriptor'
    {131077, V1} -> 
        {eventBufferDescriptor, 'dec_EventBufferDescriptor'(V1, [])};


%% 'signalsDescriptor'
    {131078, V1} -> 
        {signalsDescriptor, 'dec_SignalsDescriptor'(V1, [])};


%% 'digitMapDescriptor'
    {131079, V1} -> 
        {digitMapDescriptor, 'dec_DigitMapDescriptor'(V1, [])};


%% 'observedEventsDescriptor'
    {131080, V1} -> 
        {observedEventsDescriptor, 'dec_ObservedEventsDescriptor'(V1, [])};


%% 'statisticsDescriptor'
    {131081, V1} -> 
        {statisticsDescriptor, 'dec_StatisticsDescriptor'(V1, [])};


%% 'packagesDescriptor'
    {131082, V1} -> 
        {packagesDescriptor, 'dec_PackagesDescriptor'(V1, [])};


%% 'emptyDescriptors'
    {131083, V1} -> 
        {emptyDescriptors, 'dec_AuditDescriptor'(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  TerminationAudit
%%================================
'enc_TerminationAudit'(Val) ->
    'enc_TerminationAudit'(Val, [<<48>>]).

'enc_TerminationAudit'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_TerminationAudit_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TerminationAudit_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TerminationAudit_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AuditReturnParameter'(H, []),
   'enc_TerminationAudit_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_TerminationAudit'(Tlv) ->
   'dec_TerminationAudit'(Tlv, [16]).

'dec_TerminationAudit'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_AuditReturnParameter'(V1, []) || V1 <- Tlv1].




%%================================
%%  AuditResult
%%================================
'enc_AuditResult'(Val) ->
    'enc_AuditResult'(Val, [<<48>>]).

'enc_AuditResult'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationID
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TerminationID'(Cindex1, [<<160>>]),

%%-------------------------------------------------
%% attribute terminationAuditResult(2)   External megaco_ber_media_gateway_control_v2:TerminationAudit
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_TerminationAudit'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_AuditResult'(Tlv) ->
   'dec_AuditResult'(Tlv, [16]).

'dec_AuditResult'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationID
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TerminationID'(V1, [131072]),

%%-------------------------------------------------
%% attribute terminationAuditResult(2)   External megaco_ber_media_gateway_control_v2:TerminationAudit
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_TerminationAudit'(V2, [131073]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'AuditResult', Term1, Term2}.



%%================================
%%  AuditReply
%%================================
'enc_AuditReply'(Val) ->
    'enc_AuditReply'(Val, []).

'enc_AuditReply'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      contextAuditResult ->
         'enc_TerminationIDList'(element(2,Val), [<<160>>]);
      error ->
         'enc_ErrorDescriptor'(element(2,Val), [<<161>>]);
      auditResult ->
         'enc_AuditResult'(element(2,Val), [<<162>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_AuditReply'(Tlv) ->
   'dec_AuditReply'(Tlv, []).

'dec_AuditReply'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'contextAuditResult'
    {131072, V1} -> 
        {contextAuditResult, 'dec_TerminationIDList'(V1, [])};


%% 'error'
    {131073, V1} -> 
        {error, 'dec_ErrorDescriptor'(V1, [])};


%% 'auditResult'
    {131074, V1} -> 
        {auditResult, 'dec_AuditResult'(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  AuditRequest
%%================================
'enc_AuditRequest'(Val) ->
    'enc_AuditRequest'(Val, [<<48>>]).

'enc_AuditRequest'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationID
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TerminationID'(Cindex1, [<<160>>]),

%%-------------------------------------------------
%% attribute auditDescriptor(2)   External megaco_ber_media_gateway_control_v2:AuditDescriptor
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AuditDescriptor'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_AuditRequest'(Tlv) ->
   'dec_AuditRequest'(Tlv, [16]).

'dec_AuditRequest'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationID
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TerminationID'(V1, [131072]),

%%-------------------------------------------------
%% attribute auditDescriptor(2)   External megaco_ber_media_gateway_control_v2:AuditDescriptor
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AuditDescriptor'(V2, [131073]),

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'AuditRequest', Term1, Term2}.



%%================================
%%  SubtractRequest
%%================================
'enc_SubtractRequest'(Val) ->
    'enc_SubtractRequest'(Val, [<<48>>]).

'enc_SubtractRequest'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationIDList
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TerminationIDList'(Cindex1, [<<160>>]),

%%-------------------------------------------------
%% attribute auditDescriptor(2)   External megaco_ber_media_gateway_control_v2:AuditDescriptor OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AuditDescriptor'(Cindex2, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_SubtractRequest'(Tlv) ->
   'dec_SubtractRequest'(Tlv, [16]).

'dec_SubtractRequest'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationIDList
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TerminationIDList'(V1, [131072]),

%%-------------------------------------------------
%% attribute auditDescriptor(2)   External megaco_ber_media_gateway_control_v2:AuditDescriptor OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_AuditDescriptor'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'SubtractRequest', Term1, Term2}.



%%================================
%%  AmmsReply
%%================================
'enc_AmmsReply'(Val) ->
    'enc_AmmsReply'(Val, [<<48>>]).

'enc_AmmsReply'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationIDList
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TerminationIDList'(Cindex1, [<<160>>]),

%%-------------------------------------------------
%% attribute terminationAudit(2)   External megaco_ber_media_gateway_control_v2:TerminationAudit OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_TerminationAudit'(Cindex2, [<<161>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_AmmsReply'(Tlv) ->
   'dec_AmmsReply'(Tlv, [16]).

'dec_AmmsReply'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationIDList
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TerminationIDList'(V1, [131072]),

%%-------------------------------------------------
%% attribute terminationAudit(2)   External megaco_ber_media_gateway_control_v2:TerminationAudit OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_TerminationAudit'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'AmmsReply', Term1, Term2}.



%%================================
%%  AmmDescriptor
%%================================
'enc_AmmDescriptor'(Val) ->
    'enc_AmmDescriptor'(Val, []).

'enc_AmmDescriptor'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      mediaDescriptor ->
         'enc_MediaDescriptor'(element(2,Val), [<<160>>]);
      modemDescriptor ->
         'enc_ModemDescriptor'(element(2,Val), [<<161>>]);
      muxDescriptor ->
         'enc_MuxDescriptor'(element(2,Val), [<<162>>]);
      eventsDescriptor ->
         'enc_EventsDescriptor'(element(2,Val), [<<163>>]);
      eventBufferDescriptor ->
         'enc_EventBufferDescriptor'(element(2,Val), [<<164>>]);
      signalsDescriptor ->
         'enc_SignalsDescriptor'(element(2,Val), [<<165>>]);
      digitMapDescriptor ->
         'enc_DigitMapDescriptor'(element(2,Val), [<<166>>]);
      auditDescriptor ->
         'enc_AuditDescriptor'(element(2,Val), [<<167>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_AmmDescriptor'(Tlv) ->
   'dec_AmmDescriptor'(Tlv, []).

'dec_AmmDescriptor'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'mediaDescriptor'
    {131072, V1} -> 
        {mediaDescriptor, 'dec_MediaDescriptor'(V1, [])};


%% 'modemDescriptor'
    {131073, V1} -> 
        {modemDescriptor, 'dec_ModemDescriptor'(V1, [])};


%% 'muxDescriptor'
    {131074, V1} -> 
        {muxDescriptor, 'dec_MuxDescriptor'(V1, [])};


%% 'eventsDescriptor'
    {131075, V1} -> 
        {eventsDescriptor, 'dec_EventsDescriptor'(V1, [])};


%% 'eventBufferDescriptor'
    {131076, V1} -> 
        {eventBufferDescriptor, 'dec_EventBufferDescriptor'(V1, [])};


%% 'signalsDescriptor'
    {131077, V1} -> 
        {signalsDescriptor, 'dec_SignalsDescriptor'(V1, [])};


%% 'digitMapDescriptor'
    {131078, V1} -> 
        {digitMapDescriptor, 'dec_DigitMapDescriptor'(V1, [])};


%% 'auditDescriptor'
    {131079, V1} -> 
        {auditDescriptor, 'dec_AuditDescriptor'(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  AmmRequest
%%================================
'enc_AmmRequest'(Val) ->
    'enc_AmmRequest'(Val, [<<48>>]).

'enc_AmmRequest'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationIDList
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TerminationIDList'(Cindex1, [<<160>>]),

%%-------------------------------------------------
%% attribute descriptors(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AmmRequest_descriptors'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  AmmRequest_descriptors
%%================================
'enc_AmmRequest_descriptors'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_AmmRequest_descriptors_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AmmRequest_descriptors_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AmmRequest_descriptors_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_AmmDescriptor'(H, []),
   'enc_AmmRequest_descriptors_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_AmmRequest'(Tlv) ->
   'dec_AmmRequest'(Tlv, [16]).

'dec_AmmRequest'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute terminationID(1)   External megaco_ber_media_gateway_control_v2:TerminationIDList
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TerminationIDList'(V1, [131072]),

%%-------------------------------------------------
%% attribute descriptors(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AmmRequest_descriptors'(V2, [131073]),

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'AmmRequest', Term1, Term2}.

'dec_AmmRequest_descriptors'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_AmmDescriptor'(V1, []) || V1 <- Tlv1].




%%================================
%%  TopologyRequest
%%================================
'enc_TopologyRequest'(Val) ->
    'enc_TopologyRequest'(Val, [<<48>>]).

'enc_TopologyRequest'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4} = Val,

%%-------------------------------------------------
%% attribute terminationFrom(1)   External megaco_ber_media_gateway_control_v2:TerminationID
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_TerminationID'(Cindex1, [<<160>>]),

%%-------------------------------------------------
%% attribute terminationTo(2)   External megaco_ber_media_gateway_control_v2:TerminationID
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_TerminationID'(Cindex2, [<<161>>]),

%%-------------------------------------------------
%% attribute topologyDirection(3) with type ENUMERATED
%%-------------------------------------------------
   {EncBytes3,EncLen3} = case Cindex3 of
bothway -> encode_tags([<<130>>], [0], 1);
isolate -> encode_tags([<<130>>], [1], 1);
oneway -> encode_tags([<<130>>], [2], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,

%%-------------------------------------------------
%% attribute streamID(4) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex4, [<<131>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_TopologyRequest'(Tlv) ->
   'dec_TopologyRequest'(Tlv, [16]).

'dec_TopologyRequest'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute terminationFrom(1)   External megaco_ber_media_gateway_control_v2:TerminationID
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_TerminationID'(V1, [131072]),

%%-------------------------------------------------
%% attribute terminationTo(2)   External megaco_ber_media_gateway_control_v2:TerminationID
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_TerminationID'(V2, [131073]),

%%-------------------------------------------------
%% attribute topologyDirection(3) with type ENUMERATED
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = case decode_integer(V3, [131074]) of
0 -> bothway;
1 -> isolate;
2 -> oneway;
Default1 -> exit({error,{asn1,{illegal_enumerated,Default1}}})
end,

%%-------------------------------------------------
%% attribute streamID(4) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {begin
Val1 = decode_integer(V4, []),
if 0 =< Val1, Val1 =< 65535 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of [] -> true; _ -> true end, % ... extra fields skipped
   {'TopologyRequest', Term1, Term2, Term3, Term4}.



%%================================
%%  CommandReply
%%================================
'enc_CommandReply'(Val) ->
    'enc_CommandReply'(Val, []).

'enc_CommandReply'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      addReply ->
         'enc_AmmsReply'(element(2,Val), [<<160>>]);
      moveReply ->
         'enc_AmmsReply'(element(2,Val), [<<161>>]);
      modReply ->
         'enc_AmmsReply'(element(2,Val), [<<162>>]);
      subtractReply ->
         'enc_AmmsReply'(element(2,Val), [<<163>>]);
      auditCapReply ->
         'enc_AuditReply'(element(2,Val), [<<164>>]);
      auditValueReply ->
         'enc_AuditReply'(element(2,Val), [<<165>>]);
      notifyReply ->
         'enc_NotifyReply'(element(2,Val), [<<166>>]);
      serviceChangeReply ->
         'enc_ServiceChangeReply'(element(2,Val), [<<167>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_CommandReply'(Tlv) ->
   'dec_CommandReply'(Tlv, []).

'dec_CommandReply'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'addReply'
    {131072, V1} -> 
        {addReply, 'dec_AmmsReply'(V1, [])};


%% 'moveReply'
    {131073, V1} -> 
        {moveReply, 'dec_AmmsReply'(V1, [])};


%% 'modReply'
    {131074, V1} -> 
        {modReply, 'dec_AmmsReply'(V1, [])};


%% 'subtractReply'
    {131075, V1} -> 
        {subtractReply, 'dec_AmmsReply'(V1, [])};


%% 'auditCapReply'
    {131076, V1} -> 
        {auditCapReply, 'dec_AuditReply'(V1, [])};


%% 'auditValueReply'
    {131077, V1} -> 
        {auditValueReply, 'dec_AuditReply'(V1, [])};


%% 'notifyReply'
    {131078, V1} -> 
        {notifyReply, 'dec_NotifyReply'(V1, [])};


%% 'serviceChangeReply'
    {131079, V1} -> 
        {serviceChangeReply, 'dec_ServiceChangeReply'(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  Command
%%================================
'enc_Command'(Val) ->
    'enc_Command'(Val, []).

'enc_Command'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      addReq ->
         'enc_AmmRequest'(element(2,Val), [<<160>>]);
      moveReq ->
         'enc_AmmRequest'(element(2,Val), [<<161>>]);
      modReq ->
         'enc_AmmRequest'(element(2,Val), [<<162>>]);
      subtractReq ->
         'enc_SubtractRequest'(element(2,Val), [<<163>>]);
      auditCapRequest ->
         'enc_AuditRequest'(element(2,Val), [<<164>>]);
      auditValueRequest ->
         'enc_AuditRequest'(element(2,Val), [<<165>>]);
      notifyReq ->
         'enc_NotifyRequest'(element(2,Val), [<<166>>]);
      serviceChangeReq ->
         'enc_ServiceChangeRequest'(element(2,Val), [<<167>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_Command'(Tlv) ->
   'dec_Command'(Tlv, []).

'dec_Command'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'addReq'
    {131072, V1} -> 
        {addReq, 'dec_AmmRequest'(V1, [])};


%% 'moveReq'
    {131073, V1} -> 
        {moveReq, 'dec_AmmRequest'(V1, [])};


%% 'modReq'
    {131074, V1} -> 
        {modReq, 'dec_AmmRequest'(V1, [])};


%% 'subtractReq'
    {131075, V1} -> 
        {subtractReq, 'dec_SubtractRequest'(V1, [])};


%% 'auditCapRequest'
    {131076, V1} -> 
        {auditCapRequest, 'dec_AuditRequest'(V1, [])};


%% 'auditValueRequest'
    {131077, V1} -> 
        {auditValueRequest, 'dec_AuditRequest'(V1, [])};


%% 'notifyReq'
    {131078, V1} -> 
        {notifyReq, 'dec_NotifyRequest'(V1, [])};


%% 'serviceChangeReq'
    {131079, V1} -> 
        {serviceChangeReq, 'dec_ServiceChangeRequest'(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  CommandRequest
%%================================
'enc_CommandRequest'(Val) ->
    'enc_CommandRequest'(Val, [<<48>>]).

'enc_CommandRequest'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute command(1)   External megaco_ber_media_gateway_control_v2:Command
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_Command'(Cindex1, [<<160>>]),

%%-------------------------------------------------
%% attribute optional(2) with type NULL OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_null(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute wildcardReturn(3) with type NULL OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_null(Cindex3, [<<130>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_CommandRequest'(Tlv) ->
   'dec_CommandRequest'(Tlv, [16]).

'dec_CommandRequest'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute command(1)   External megaco_ber_media_gateway_control_v2:Command
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_Command'(V1, [131072]),

%%-------------------------------------------------
%% attribute optional(2) with type NULL OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_null(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute wildcardReturn(3) with type NULL OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {decode_null(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'CommandRequest', Term1, Term2, Term3}.



%%================================
%%  ContextAttrAuditRequest
%%================================
'enc_ContextAttrAuditRequest'(Val) ->
    'enc_ContextAttrAuditRequest'(Val, [<<48>>]).

'enc_ContextAttrAuditRequest'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute topology(1) with type NULL OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_null(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute emergency(2) with type NULL OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_null(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute priority(3) with type NULL OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_null(Cindex3, [<<130>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_ContextAttrAuditRequest'(Tlv) ->
   'dec_ContextAttrAuditRequest'(Tlv, [16]).

'dec_ContextAttrAuditRequest'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute topology(1) with type NULL OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {decode_null(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute emergency(2) with type NULL OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_null(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute priority(3) with type NULL OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {decode_null(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'ContextAttrAuditRequest', Term1, Term2, Term3}.



%%================================
%%  ContextRequest
%%================================
'enc_ContextRequest'(Val) ->
    'enc_ContextRequest'(Val, [<<48>>]).

'enc_ContextRequest'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute priority(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute emergency(2) with type BOOLEAN OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_boolean(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute topologyReq(3) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ContextRequest_topologyReq'(Cindex3, [<<162>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  ContextRequest_topologyReq
%%================================
'enc_ContextRequest_topologyReq'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ContextRequest_topologyReq_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ContextRequest_topologyReq_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ContextRequest_topologyReq_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TopologyRequest'(H, [<<48>>]),
   'enc_ContextRequest_topologyReq_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_ContextRequest'(Tlv) ->
   'dec_ContextRequest'(Tlv, [16]).

'dec_ContextRequest'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute priority(1) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, []),
if 0 =< Val1, Val1 =< 15 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute emergency(2) with type BOOLEAN OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute topologyReq(3) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_ContextRequest_topologyReq'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'ContextRequest', Term1, Term2, Term3}.

'dec_ContextRequest_topologyReq'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TopologyRequest'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  ActionReply
%%================================
'enc_ActionReply'(Val) ->
    'enc_ActionReply'(Val, [<<48>>]).

'enc_ActionReply'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4} = Val,

%%-------------------------------------------------
%% attribute contextId(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute errorDescriptor(2)   External megaco_ber_media_gateway_control_v2:ErrorDescriptor OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ErrorDescriptor'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute contextReply(3)   External megaco_ber_media_gateway_control_v2:ContextRequest OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ContextRequest'(Cindex3, [<<162>>])
       end,

%%-------------------------------------------------
%% attribute commandReply(4) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_ActionReply_commandReply'(Cindex4, [<<163>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  ActionReply_commandReply
%%================================
'enc_ActionReply_commandReply'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ActionReply_commandReply_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ActionReply_commandReply_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ActionReply_commandReply_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_CommandReply'(H, []),
   'enc_ActionReply_commandReply_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_ActionReply'(Tlv) ->
   'dec_ActionReply'(Tlv, [16]).

'dec_ActionReply'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute contextId(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [131072]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute errorDescriptor(2)   External megaco_ber_media_gateway_control_v2:ErrorDescriptor OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_ErrorDescriptor'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute contextReply(3)   External megaco_ber_media_gateway_control_v2:ContextRequest OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_ContextRequest'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute commandReply(4) with type SEQUENCE OF
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_ActionReply_commandReply'(V4, [131075]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
   {'ActionReply', Term1, Term2, Term3, Term4}.

'dec_ActionReply_commandReply'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_CommandReply'(V1, []) || V1 <- Tlv1].




%%================================
%%  ActionRequest
%%================================
'enc_ActionRequest'(Val) ->
    'enc_ActionRequest'(Val, [<<48>>]).

'enc_ActionRequest'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4} = Val,

%%-------------------------------------------------
%% attribute contextId(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute contextRequest(2)   External megaco_ber_media_gateway_control_v2:ContextRequest OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ContextRequest'(Cindex2, [<<161>>])
       end,

%%-------------------------------------------------
%% attribute contextAttrAuditReq(3)   External megaco_ber_media_gateway_control_v2:ContextAttrAuditRequest OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_ContextAttrAuditRequest'(Cindex3, [<<162>>])
       end,

%%-------------------------------------------------
%% attribute commandRequests(4) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_ActionRequest_commandRequests'(Cindex4, [<<163>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  ActionRequest_commandRequests
%%================================
'enc_ActionRequest_commandRequests'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ActionRequest_commandRequests_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ActionRequest_commandRequests_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ActionRequest_commandRequests_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_CommandRequest'(H, [<<48>>]),
   'enc_ActionRequest_commandRequests_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_ActionRequest'(Tlv) ->
   'dec_ActionRequest'(Tlv, [16]).

'dec_ActionRequest'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute contextId(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [131072]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute contextRequest(2)   External megaco_ber_media_gateway_control_v2:ContextRequest OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {'dec_ContextRequest'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute contextAttrAuditReq(3)   External megaco_ber_media_gateway_control_v2:ContextAttrAuditRequest OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {'dec_ContextAttrAuditRequest'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute commandRequests(4) with type SEQUENCE OF
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_ActionRequest_commandRequests'(V4, [131075]),

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
   {'ActionRequest', Term1, Term2, Term3, Term4}.

'dec_ActionRequest_commandRequests'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_CommandRequest'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  ContextID
%%================================
'enc_ContextID'(Val) ->
    'enc_ContextID'(Val, [<<2>>]).

'enc_ContextID'(Val, TagIn) ->
encode_integer(Val, TagIn).


'dec_ContextID'(Tlv) ->
   'dec_ContextID'(Tlv, [2]).

'dec_ContextID'(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  ErrorText
%%================================
'enc_ErrorText'(Val) ->
    'enc_ErrorText'(Val, [<<22>>]).

'enc_ErrorText'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_ErrorText'(Tlv) ->
   'dec_ErrorText'(Tlv, [22]).

'dec_ErrorText'(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  ErrorCode
%%================================
'enc_ErrorCode'(Val) ->
    'enc_ErrorCode'(Val, [<<2>>]).

'enc_ErrorCode'(Val, TagIn) ->
encode_integer(Val, TagIn).


'dec_ErrorCode'(Tlv) ->
   'dec_ErrorCode'(Tlv, [2]).

'dec_ErrorCode'(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 65535 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  ErrorDescriptor
%%================================
'enc_ErrorDescriptor'(Val) ->
    'enc_ErrorDescriptor'(Val, [<<48>>]).

'enc_ErrorDescriptor'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute errorCode(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute errorText(2) with type IA5String OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_ErrorDescriptor'(Tlv) ->
   'dec_ErrorDescriptor'(Tlv, [16]).

'dec_ErrorDescriptor'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute errorCode(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [131072]),
if 0 =< Val1, Val1 =< 65535 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute errorText(2) with type IA5String OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
binary_to_list(decode_restricted_string(V2, []))
end
, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'ErrorDescriptor', Term1, Term2}.



%%================================
%%  TransactionAck
%%================================
'enc_TransactionAck'(Val) ->
    'enc_TransactionAck'(Val, [<<48>>]).

'enc_TransactionAck'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute firstAck(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute lastAck(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_TransactionAck'(Tlv) ->
   'dec_TransactionAck'(Tlv, [16]).

'dec_TransactionAck'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute firstAck(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [131072]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute lastAck(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
Val2 = decode_integer(V2, []),
if 0 =< Val2, Val2 =< 4294967295 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'TransactionAck', Term1, Term2}.



%%================================
%%  TransactionResponseAck
%%================================
'enc_TransactionResponseAck'(Val) ->
    'enc_TransactionResponseAck'(Val, [<<48>>]).

'enc_TransactionResponseAck'(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_TransactionResponseAck_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TransactionResponseAck_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TransactionResponseAck_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_TransactionAck'(H, [<<48>>]),
   'enc_TransactionResponseAck_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_TransactionResponseAck'(Tlv) ->
   'dec_TransactionResponseAck'(Tlv, [16]).

'dec_TransactionResponseAck'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_TransactionAck'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  TransactionReply
%%================================
'enc_TransactionReply'(Val) ->
    'enc_TransactionReply'(Val, [<<48>>]).

'enc_TransactionReply'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute transactionId(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute immAckRequired(2) with type NULL OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_null(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute transactionResult(3) with type CHOICE
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_TransactionReply_transactionResult'(Cindex3, [<<162>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  TransactionReply_transactionResult
%%================================
'enc_TransactionReply_transactionResult'(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      transactionError ->
         'enc_ErrorDescriptor'(element(2,Val), [<<160>>]);
      actionReplies ->
         'enc_TransactionReply_transactionResult_actionReplies'(element(2,Val), [<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  TransactionReply_transactionResult_actionReplies
%%================================
'enc_TransactionReply_transactionResult_actionReplies'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_TransactionReply_transactionResult_actionReplies_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TransactionReply_transactionResult_actionReplies_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TransactionReply_transactionResult_actionReplies_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_ActionReply'(H, [<<48>>]),
   'enc_TransactionReply_transactionResult_actionReplies_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_TransactionReply'(Tlv) ->
   'dec_TransactionReply'(Tlv, [16]).

'dec_TransactionReply'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute transactionId(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [131072]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute immAckRequired(2) with type NULL OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {decode_null(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute transactionResult(3) with type CHOICE
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_TransactionReply_transactionResult'(V3, [131074]),

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'TransactionReply', Term1, Term2, Term3}.

'dec_TransactionReply_transactionResult'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'transactionError'
    {131072, V1} -> 
        {transactionError, 'dec_ErrorDescriptor'(V1, [])};


%% 'actionReplies'
    {131073, V1} -> 
        {actionReplies, 'dec_TransactionReply_transactionResult_actionReplies'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_TransactionReply_transactionResult_actionReplies'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_ActionReply'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  TransactionPending
%%================================
'enc_TransactionPending'(Val) ->
    'enc_TransactionPending'(Val, [<<48>>]).

'enc_TransactionPending'(Val, TagIn) ->
{_,Cindex1} = Val,

%%-------------------------------------------------
%% attribute transactionId(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

   BytesSoFar = [EncBytes1],
LenSoFar = EncLen1,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_TransactionPending'(Tlv) ->
   'dec_TransactionPending'(Tlv, [16]).

'dec_TransactionPending'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute transactionId(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [131072]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv2 of [] -> true; _ -> true end, % ... extra fields skipped
   {'TransactionPending', Term1}.



%%================================
%%  TransactionRequest
%%================================
'enc_TransactionRequest'(Val) ->
    'enc_TransactionRequest'(Val, [<<48>>]).

'enc_TransactionRequest'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute transactionId(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute actions(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_TransactionRequest_actions'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  TransactionRequest_actions
%%================================
'enc_TransactionRequest_actions'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_TransactionRequest_actions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_TransactionRequest_actions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_TransactionRequest_actions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_ActionRequest'(H, [<<48>>]),
   'enc_TransactionRequest_actions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_TransactionRequest'(Tlv) ->
   'dec_TransactionRequest'(Tlv, [16]).

'dec_TransactionRequest'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute transactionId(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [131072]),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute actions(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_TransactionRequest_actions'(V2, [131073]),

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
   {'TransactionRequest', Term1, Term2}.

'dec_TransactionRequest_actions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_ActionRequest'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  TransactionId
%%================================
'enc_TransactionId'(Val) ->
    'enc_TransactionId'(Val, [<<2>>]).

'enc_TransactionId'(Val, TagIn) ->
encode_integer(Val, TagIn).


'dec_TransactionId'(Tlv) ->
   'dec_TransactionId'(Tlv, [2]).

'dec_TransactionId'(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 4294967295 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  Transaction
%%================================
'enc_Transaction'(Val) ->
    'enc_Transaction'(Val, []).

'enc_Transaction'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      transactionRequest ->
         'enc_TransactionRequest'(element(2,Val), [<<160>>]);
      transactionPending ->
         'enc_TransactionPending'(element(2,Val), [<<161>>]);
      transactionReply ->
         'enc_TransactionReply'(element(2,Val), [<<162>>]);
      transactionResponseAck ->
         'enc_TransactionResponseAck'(element(2,Val), [<<163>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_Transaction'(Tlv) ->
   'dec_Transaction'(Tlv, []).

'dec_Transaction'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'transactionRequest'
    {131072, V1} -> 
        {transactionRequest, 'dec_TransactionRequest'(V1, [])};


%% 'transactionPending'
    {131073, V1} -> 
        {transactionPending, 'dec_TransactionPending'(V1, [])};


%% 'transactionReply'
    {131074, V1} -> 
        {transactionReply, 'dec_TransactionReply'(V1, [])};


%% 'transactionResponseAck'
    {131075, V1} -> 
        {transactionResponseAck, 'dec_TransactionResponseAck'(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  PathName
%%================================
'enc_PathName'(Val) ->
    'enc_PathName'(Val, [<<22>>]).

'enc_PathName'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_PathName'(Tlv) ->
   'dec_PathName'(Tlv, [22]).

'dec_PathName'(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 64 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  IP6Address
%%================================
'enc_IP6Address'(Val) ->
    'enc_IP6Address'(Val, [<<48>>]).

'enc_IP6Address'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute address(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute portNumber(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_IP6Address'(Tlv) ->
   'dec_IP6Address'(Tlv, [16]).

'dec_IP6Address'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute address(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 16 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute portNumber(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
Val2 = decode_integer(V2, []),
if 0 =< Val2, Val2 =< 65535 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'IP6Address', Term1, Term2}.



%%================================
%%  IP4Address
%%================================
'enc_IP4Address'(Val) ->
    'enc_IP4Address'(Val, [<<48>>]).

'enc_IP4Address'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute address(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute portNumber(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_IP4Address'(Tlv) ->
   'dec_IP4Address'(Tlv, [16]).

'dec_IP4Address'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute address(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute portNumber(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
Val2 = decode_integer(V2, []),
if 0 =< Val2, Val2 =< 65535 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'IP4Address', Term1, Term2}.



%%================================
%%  DomainName
%%================================
'enc_DomainName'(Val) ->
    'enc_DomainName'(Val, [<<48>>]).

'enc_DomainName'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute name(1) with type IA5String
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute portNumber(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_DomainName'(Tlv) ->
   'dec_DomainName'(Tlv, [16]).

'dec_DomainName'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute name(1) with type IA5String
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [131072]))
end
,

%%-------------------------------------------------
%% attribute portNumber(2) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
Val1 = decode_integer(V2, []),
if 0 =< Val1, Val1 =< 65535 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'DomainName', Term1, Term2}.



%%================================
%%  MId
%%================================
'enc_MId'(Val) ->
    'enc_MId'(Val, []).

'enc_MId'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      ip4Address ->
         'enc_IP4Address'(element(2,Val), [<<160>>]);
      ip6Address ->
         'enc_IP6Address'(element(2,Val), [<<161>>]);
      domainName ->
         'enc_DomainName'(element(2,Val), [<<162>>]);
      deviceName ->
         encode_restricted_string(element(2,Val), [<<131>>]);
      mtpAddress ->
         encode_restricted_string(element(2,Val), [<<132>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_MId'(Tlv) ->
   'dec_MId'(Tlv, []).

'dec_MId'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'ip4Address'
    {131072, V1} -> 
        {ip4Address, 'dec_IP4Address'(V1, [])};


%% 'ip6Address'
    {131073, V1} -> 
        {ip6Address, 'dec_IP6Address'(V1, [])};


%% 'domainName'
    {131074, V1} -> 
        {domainName, 'dec_DomainName'(V1, [])};


%% 'deviceName'
    {131075, V1} -> 
        {deviceName, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 64 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'mtpAddress'
    {131076, V1} -> 
        {mtpAddress, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 2 =< C2, C2 =< 4 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  Message
%%================================
'enc_Message'(Val) ->
    'enc_Message'(Val, [<<48>>]).

'enc_Message'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute mId(2)   External megaco_ber_media_gateway_control_v2:MId
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_MId'(Cindex2, [<<161>>]),

%%-------------------------------------------------
%% attribute messageBody(3) with type CHOICE
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_Message_messageBody'(Cindex3, [<<162>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  Message_messageBody
%%================================
'enc_Message_messageBody'(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      messageError ->
         'enc_ErrorDescriptor'(element(2,Val), [<<160>>]);
      transactions ->
         'enc_Message_messageBody_transactions'(element(2,Val), [<<161>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  Message_messageBody_transactions
%%================================
'enc_Message_messageBody_transactions'(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Message_messageBody_transactions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Message_messageBody_transactions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Message_messageBody_transactions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Transaction'(H, []),
   'enc_Message_messageBody_transactions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



'dec_Message'(Tlv) ->
   'dec_Message'(Tlv, [16]).

'dec_Message'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [131072]),
if 0 =< Val1, Val1 =< 99 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute mId(2)   External megaco_ber_media_gateway_control_v2:MId
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_MId'(V2, [131073]),

%%-------------------------------------------------
%% attribute messageBody(3) with type CHOICE
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_Message_messageBody'(V3, [131074]),

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
   {'Message', Term1, Term2, Term3}.

'dec_Message_messageBody'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'messageError'
    {131072, V1} -> 
        {messageError, 'dec_ErrorDescriptor'(V1, [])};


%% 'transactions'
    {131073, V1} -> 
        {transactions, 'dec_Message_messageBody_transactions'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'dec_Message_messageBody_transactions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Transaction'(V1, []) || V1 <- Tlv1].




%%================================
%%  AuthData
%%================================
'enc_AuthData'(Val) ->
    'enc_AuthData'(Val, [<<4>>]).

'enc_AuthData'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_AuthData'(Tlv) ->
   'dec_AuthData'(Tlv, [4]).

'dec_AuthData'(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if 12 =< C1, C1 =< 32 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  SequenceNum
%%================================
'enc_SequenceNum'(Val) ->
    'enc_SequenceNum'(Val, [<<4>>]).

'enc_SequenceNum'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_SequenceNum'(Tlv) ->
   'dec_SequenceNum'(Tlv, [4]).

'dec_SequenceNum'(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  SecurityParmIndex
%%================================
'enc_SecurityParmIndex'(Val) ->
    'enc_SecurityParmIndex'(Val, [<<4>>]).

'enc_SecurityParmIndex'(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


'dec_SecurityParmIndex'(Tlv) ->
   'dec_SecurityParmIndex'(Tlv, [4]).

'dec_SecurityParmIndex'(Tlv, TagIn) ->
begin
Val1 = decode_restricted_string(Tlv, TagIn),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  AuthenticationHeader
%%================================
'enc_AuthenticationHeader'(Val) ->
    'enc_AuthenticationHeader'(Val, [<<48>>]).

'enc_AuthenticationHeader'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3} = Val,

%%-------------------------------------------------
%% attribute secParmIndex(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute seqNum(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<129>>]),

%%-------------------------------------------------
%% attribute ad(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<130>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_AuthenticationHeader'(Tlv) ->
   'dec_AuthenticationHeader'(Tlv, [16]).

'dec_AuthenticationHeader'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute secParmIndex(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_restricted_string(V1, [131072]),
C1 = byte_size(Val1),
if C1 =:= 4 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute seqNum(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val2 = decode_restricted_string(V2, [131073]),
C2 = byte_size(Val2),
if C2 =:= 4 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute ad(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = begin
Val3 = decode_restricted_string(V3, [131074]),
C3 = byte_size(Val3),
if 12 =< C3, C3 =< 32 ->
binary_to_list(Val3);
true ->
exit({error,{asn1,bad_range}})
end
end,

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
   {'AuthenticationHeader', Term1, Term2, Term3}.



%%================================
%%  MegacoMessage
%%================================
'enc_MegacoMessage'(Val) ->
    'enc_MegacoMessage'(Val, [<<48>>]).

'enc_MegacoMessage'(Val, TagIn) ->
{_,Cindex1, Cindex2} = Val,

%%-------------------------------------------------
%% attribute authHeader(1)   External megaco_ber_media_gateway_control_v2:AuthenticationHeader OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_AuthenticationHeader'(Cindex1, [<<160>>])
       end,

%%-------------------------------------------------
%% attribute mess(2)   External megaco_ber_media_gateway_control_v2:Message
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_Message'(Cindex2, [<<161>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_MegacoMessage'(Tlv) ->
   'dec_MegacoMessage'(Tlv, [16]).

'dec_MegacoMessage'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute authHeader(1)   External megaco_ber_media_gateway_control_v2:AuthenticationHeader OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {'dec_AuthenticationHeader'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute mess(2)   External megaco_ber_media_gateway_control_v2:Message
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_Message'(V2, [131073]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
   {'MegacoMessage', Term1, Term2}.


%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    encode_bit_string(element(1, Arg), element(2, Arg), element(3, Arg), element(4, Arg)),
    ok.

ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_,L}|Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L)|Acc]);
collect_parts([{3,<<Unused,Bits/binary>>}|Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T,V}|Rest], Acc) ->
    collect_parts(Rest, [V|Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3,<<Unused,Bits/binary>>}|Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits|Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc|lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H|Al]).

decode_bitstring2(1,
                  Unused,
                  <<B7:1,B6:1,B5:1,B4:1,B3:1,B2:1,B1:1,B0:1,_/binary>>) ->
    lists:sublist([B7,B6,B5,B4,B3,B2,B1,B0], 8 - Unused);
decode_bitstring2(Len,
                  Unused,
                  <<B7:1,
                    B6:1,
                    B5:1,
                    B4:1,
                    B3:1,
                    B2:1,
                    B1:1,
                    B0:1,
                    Buffer/binary>>) ->
    [B7,B6,B5,B4,B3,B2,B1,B0|decode_bitstring2(Len - 1, Unused, Buffer)].

decode_bitstring_NNL(BitList, NamedNumberList) ->
    decode_bitstring_NNL(BitList, NamedNumberList, 0, []).

decode_bitstring_NNL([], _, _No, Result) ->
    lists:reverse(Result);
decode_bitstring_NNL([B|BitList],
                     [{Name,No}|NamedNumberList],
                     No,
                     Result) ->
    if
        B =:= 0 ->
            decode_bitstring_NNL(BitList,
                                 NamedNumberList,
                                 No + 1,
                                 Result);
        true ->
            decode_bitstring_NNL(BitList,
                                 NamedNumberList,
                                 No + 1,
                                 [Name|Result])
    end;
decode_bitstring_NNL([1|BitList], NamedNumberList, No, Result) ->
    decode_bitstring_NNL(BitList,
                         NamedNumberList,
                         No + 1,
                         [{bit,No}|Result]);
decode_bitstring_NNL([0|BitList], NamedNumberList, No, Result) ->
    decode_bitstring_NNL(BitList, NamedNumberList, No + 1, Result).

decode_boolean(Tlv, TagIn) ->
    Val = match_tags(Tlv, TagIn),
    case Val of
        <<0:8>> ->
            false;
        <<_:8>> ->
            true;
        _ ->
            exit({error,{asn1,{decode_boolean,Val}}})
    end.

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_named_bit_string(Buffer, NamedNumberList, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            [];
        <<Unused,Bits/binary>> ->
            BitString = decode_bitstring2(byte_size(Bits), Unused, Bits),
            decode_bitstring_NNL(BitString, NamedNumberList)
    end.

decode_null(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    case Val of
        <<>> ->
            'NULL';
        _ ->
            exit({error,{asn1,{decode_null,Val}}})
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal|ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1,Val2} =
        if
            AddedObjVal < 40 ->
                {0,AddedObjVal};
            AddedObjVal < 80 ->
                {1,AddedObjVal - 40};
            true ->
                {2,AddedObjVal - 80}
        end,
    list_to_tuple([Val1,Val2|ObjVals]).

decode_restricted_string(Tlv, TagsIn) ->
    match_and_collect(Tlv, TagsIn).

e_object_identifier({'OBJECT IDENTIFIER',V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1,E2|Tail]) ->
    Head = 40 * E1 + E2,
    {H,Lh} = mk_object_val(Head),
    {R,Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H|R],Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B,L} = mk_object_val(H),
    {B,Len + L}.

encode_bin_bit_string(C, {Unused,BinBits}, _NamedBitList, TagIn) ->
    case C of
        [] ->
            remove_unused_then_dotag(TagIn, Unused, BinBits);
        {_Min,Max} ->
            BBLen = byte_size(BinBits) * 8 - Unused,
            if
                BBLen > Max ->
                    exit({error,
                          {asn1,
                           {bitstring_length,
                            {{was,BBLen},{maximum,Max}}}}});
                true ->
                    remove_unused_then_dotag(TagIn, Unused, BinBits)
            end;
        Size ->
            case byte_size(BinBits) * 8 - Unused of
                BBSize when BBSize =< Size ->
                    remove_unused_then_dotag(TagIn, Unused, BinBits);
                BBSize ->
                    exit({error,
                          {asn1,
                           {bitstring_length,
                            {{was,BBSize},{should_be,Size}}}}})
            end
    end.

encode_bit_string(C, Bits, NamedBitList, TagIn) when is_bitstring(Bits) ->
    PadLen = (8 - bit_size(Bits) band 7) band 7,
    Compact = {PadLen,<<Bits/bitstring,0:PadLen>>},
    encode_bin_bit_string(C, Compact, NamedBitList, TagIn);
encode_bit_string(C, Bin = {Unused,BinBits}, NamedBitList, TagIn)
    when is_integer(Unused), is_binary(BinBits) ->
    encode_bin_bit_string(C, Bin, NamedBitList, TagIn);
encode_bit_string(C, [FirstVal|RestVal], NamedBitList, TagIn)
    when is_atom(FirstVal) ->
    encode_bit_string_named(C, [FirstVal|RestVal], NamedBitList, TagIn);
encode_bit_string(C, [{bit,X}|RestVal], NamedBitList, TagIn) ->
    encode_bit_string_named(C, [{bit,X}|RestVal], NamedBitList, TagIn);
encode_bit_string(C, [FirstVal|RestVal], NamedBitList, TagIn)
    when is_integer(FirstVal) ->
    encode_bit_string_bits(C, [FirstVal|RestVal], NamedBitList, TagIn);
encode_bit_string(_C, 0, _NamedBitList, TagIn) ->
    encode_tags(TagIn, <<0>>, 1);
encode_bit_string(_C, [], _NamedBitList, TagIn) ->
    encode_tags(TagIn, <<0>>, 1);
encode_bit_string(C, IntegerVal, NamedBitList, TagIn)
    when is_integer(IntegerVal) ->
    BitListVal = int_to_bitlist(IntegerVal),
    encode_bit_string_bits(C, BitListVal, NamedBitList, TagIn).

encode_bit_string_bits(C, BitListVal, _NamedBitList, TagIn)
    when is_list(BitListVal) ->
    case C of
        [] ->
            {Len,Unused,OctetList} = encode_bitstring(BitListVal),
            encode_tags(TagIn, [Unused|OctetList], Len + 1);
        Constr = {Min,_Max} when is_integer(Min) ->
            encode_constr_bit_str_bits(Constr, BitListVal, TagIn);
        {Constr = {_,_},[]} ->
            encode_constr_bit_str_bits(Constr, BitListVal, TagIn);
        Constr = {{_,_},{_,_}} ->
            encode_constr_bit_str_bits(Constr, BitListVal, TagIn);
        Size when is_integer(Size) ->
            case length(BitListVal) of
                BitSize when BitSize == Size ->
                    {Len,Unused,OctetList} =
                        encode_bitstring(BitListVal),
                    encode_tags(TagIn, [Unused|OctetList], Len + 1);
                BitSize when BitSize < Size ->
                    PaddedList =
                        pad_bit_list(Size - BitSize, BitListVal),
                    {Len,Unused,OctetList} =
                        encode_bitstring(PaddedList),
                    encode_tags(TagIn, [Unused|OctetList], Len + 1);
                BitSize ->
                    exit({error,
                          {asn1,
                           {bitstring_length,
                            {{was,BitSize},{should_be,Size}}}}})
            end
    end.

encode_bit_string_named(C, [FirstVal|RestVal], NamedBitList, TagIn) ->
    ToSetPos = get_all_bitposes([FirstVal|RestVal], NamedBitList, []),
    Size =
        case C of
            [] ->
                lists:max(ToSetPos) + 1;
            {_Min,Max} ->
                Max;
            TSize ->
                TSize
        end,
    BitList = make_and_set_list(Size, ToSetPos, 0),
    {Len,Unused,OctetList} = encode_bitstring(BitList),
    encode_tags(TagIn, [Unused|OctetList], Len + 1).

encode_bitstring([B8,B7,B6,B5,B4,B3,B2,B1|Rest]) ->
    Val =
        B8 bsl 7 bor (B7 bsl 6) bor (B6 bsl 5) bor (B5 bsl 4)
        bor
        (B4 bsl 3)
        bor
        (B3 bsl 2)
        bor
        (B2 bsl 1)
        bor
        B1,
    encode_bitstring(Rest, [Val], 1);
encode_bitstring(Val) ->
    {Unused,Octet} = unused_bitlist(Val, 7, 0),
    {1,Unused,[Octet]}.

encode_bitstring([B8,B7,B6,B5,B4,B3,B2,B1|Rest], Ack, Len) ->
    Val =
        B8 bsl 7 bor (B7 bsl 6) bor (B6 bsl 5) bor (B5 bsl 4)
        bor
        (B4 bsl 3)
        bor
        (B3 bsl 2)
        bor
        (B2 bsl 1)
        bor
        B1,
    encode_bitstring(Rest, [Ack,Val], Len + 1);
encode_bitstring([], Ack, Len) ->
    {Len,0,Ack};
encode_bitstring(Rest, Ack, Len) ->
    {Unused,Val} = unused_bitlist(Rest, 7, 0),
    {Len + 1,Unused,[Ack,Val]}.

encode_boolean(true, TagIn) ->
    encode_tags(TagIn, [255], 1);
encode_boolean(false, TagIn) ->
    encode_tags(TagIn, [0], 1);
encode_boolean(X, _) ->
    exit({error,{asn1,{encode_boolean,X}}}).

encode_constr_bit_str_bits({{_Min1,Max1},{Min2,Max2}},
                           BitListVal,
                           TagIn) ->
    BitLen = length(BitListVal),
    case BitLen of
        Len when Len > Max2 ->
            exit({error,
                  {asn1,
                   {bitstring_length,{{was,BitLen},{maximum,Max2}}}}});
        Len when Len > Max1, Len < Min2 ->
            exit({error,
                  {asn1,
                   {bitstring_length,
                    {{was,BitLen},{not_allowed_interval,Max1,Min2}}}}});
        _ ->
            {Len,Unused,OctetList} = encode_bitstring(BitListVal),
            encode_tags(TagIn, [Unused,OctetList], Len + 1)
    end;
encode_constr_bit_str_bits({Min,Max}, BitListVal, TagIn) ->
    BitLen = length(BitListVal),
    if
        BitLen > Max ->
            exit({error,
                  {asn1,{bitstring_length,{{was,BitLen},{maximum,Max}}}}});
        BitLen < Min ->
            exit({error,
                  {asn1,{bitstring_length,{{was,BitLen},{minimum,Max}}}}});
        true ->
            {Len,Unused,OctetList} = encode_bitstring(BitListVal),
            encode_tags(TagIn, [Unused,OctetList], Len + 1)
    end.

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes,length(Bytes)}.

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error,{asn1,{encode_integer,Val}}}).

encode_integer_neg(- 1, [B1|_T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255|Acc]).

encode_integer_pos(0, [B|_Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255|Acc]).

encode_length(L) when L =< 127 ->
    {[L],1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len|Oct],Len + 1};
        true ->
            exit({error,{asn1,too_long_length_oct,Len}})
    end.

encode_null(_Val, TagIn) ->
    encode_tags(TagIn, [], 0).

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar,LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag|Trest], BytesSoFar, LenSoFar) ->
    {Bytes2,L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag,Bytes2|BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar,LenSoFar}.

get_all_bitposes([{bit,ValPos}|Rest], NamedBitList, Ack) ->
    get_all_bitposes(Rest, NamedBitList, [ValPos|Ack]);
get_all_bitposes([Val|Rest], NamedBitList, Ack) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedBitList) of
        {_ValName,ValPos} ->
            get_all_bitposes(Rest, NamedBitList, [ValPos|Ack]);
        _ ->
            exit({error,{asn1,{bitstring_namedbit,Val}}})
    end;
get_all_bitposes([], _NamedBitList, Ack) ->
    lists:sort(Ack).

int_to_bitlist(0) ->
    [];
int_to_bitlist(Int) when is_integer(Int), Int >= 0 ->
    [Int band 1|int_to_bitlist(Int bsr 1)].

make_and_set_list(0, [], _) ->
    [];
make_and_set_list(0, _, _) ->
    exit({error,{asn1,bitstring_sizeconstraint}});
make_and_set_list(Len, [XPos|SetPos], XPos) ->
    [1|make_and_set_list(Len - 1, SetPos, XPos + 1)];
make_and_set_list(Len, [Pos|SetPos], XPos) ->
    [0|make_and_set_list(Len - 1, [Pos|SetPos], XPos + 1)];
make_and_set_list(Len, [], XPos) ->
    [0|make_and_set_list(Len - 1, [], XPos + 1)].

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_|_] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T,V}, [T]) ->
    V;
match_tags({T,V}, [T|Tt]) ->
    match_tags(V, Tt);
match_tags([{T,V}], [T|Tt]) ->
    match_tags(V, Tt);
match_tags([{T,_V}|_] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag,_V} = Tlv, [T|_Tt]) ->
    exit({error,{asn1,{wrong_tag,{{expected,T},{got,Tag,Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255|Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_object_val(0, Ack, Len) ->
    {Ack,Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128|Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val],1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).

pad_bit_list(Size, BitListVal) ->
    Tail = lists:duplicate(Size, 0),
    lists:append(BitListVal, Tail).

remove_unused_then_dotag(TagIn, Unused, BinBits) ->
    case Unused of
        0 when byte_size(BinBits) =:= 0 ->
            encode_tags(TagIn, <<0>>, 1);
        0 ->
            Bin = <<Unused,BinBits/binary>>,
            encode_tags(TagIn, Bin, byte_size(Bin));
        Num ->
            N = byte_size(BinBits) - 1,
            <<BBits:N/binary,LastByte>> = BinBits,
            encode_tags(TagIn,
                        [Unused,
                         binary_to_list(BBits)
                         ++
                         [LastByte bsr Num bsl Num]],
                        1 + byte_size(BinBits))
    end.

unused_bitlist([], Trail, Ack) ->
    {Trail + 1,Ack};
unused_bitlist([Bit|Rest], Trail, Ack) ->
    unused_bitlist(Rest, Trail - 1, Bit bsl Trail bor Ack).
