/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Decompiler;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.TokenStream;

public class Parser {
    static final int CLEAR_TI_MASK = 65535;
    static final int TI_AFTER_EOL = 65536;
    static final int TI_CHECK_LABEL = 131072;
    CompilerEnvirons compilerEnv;
    private ErrorReporter errorReporter;
    private String sourceURI;
    boolean calledByCompileFunction;
    private TokenStream ts;
    private int currentFlaggedToken;
    private int syntaxErrorCount;
    private IRFactory nf;
    private int nestingOfFunction;
    private Decompiler decompiler;
    private String encodedSource;
    ScriptOrFnNode currentScriptOrFn;
    Node.Scope currentScope;
    private int nestingOfWith;
    private Map<String, Node> labelSet;
    private ObjArray loopSet;
    private ObjArray loopAndSwitchSet;
    private int endFlags;

    public int getCurrentLineNumber() {
        return this.ts.getLineno();
    }

    public Parser(CompilerEnvirons compilerEnvirons, ErrorReporter errorReporter) {
        this.compilerEnv = compilerEnvirons;
        this.errorReporter = errorReporter;
    }

    protected Decompiler createDecompiler(CompilerEnvirons compilerEnvirons) {
        return new Decompiler();
    }

    void addStrictWarning(String string, String string2) {
        if (this.compilerEnv.isStrictMode()) {
            this.addWarning(string, string2);
        }
    }

    void addWarning(String string, String string2) {
        String string3 = ScriptRuntime.getMessage1(string, string2);
        if (this.compilerEnv.reportWarningAsError()) {
            ++this.syntaxErrorCount;
            this.errorReporter.error(string3, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
        } else {
            this.errorReporter.warning(string3, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
        }
    }

    void addError(String string) {
        ++this.syntaxErrorCount;
        String string2 = ScriptRuntime.getMessage0(string);
        this.errorReporter.error(string2, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
    }

    void addError(String string, String string2) {
        ++this.syntaxErrorCount;
        String string3 = ScriptRuntime.getMessage1(string, string2);
        this.errorReporter.error(string3, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
    }

    RuntimeException reportError(String string) {
        this.addError(string);
        throw new ParserException();
    }

    private int peekToken() throws IOException {
        int n = this.currentFlaggedToken;
        if (n == 0) {
            n = this.ts.getToken();
            if (n == 1) {
                while ((n = this.ts.getToken()) == 1) {
                }
                n |= 0x10000;
            }
            this.currentFlaggedToken = n;
        }
        return n & 0xFFFF;
    }

    private int peekFlaggedToken() throws IOException {
        this.peekToken();
        return this.currentFlaggedToken;
    }

    private void consumeToken() {
        this.currentFlaggedToken = 0;
    }

    private int nextToken() throws IOException {
        int n = this.peekToken();
        this.consumeToken();
        return n;
    }

    private int nextFlaggedToken() throws IOException {
        this.peekToken();
        int n = this.currentFlaggedToken;
        this.consumeToken();
        return n;
    }

    private boolean matchToken(int n) throws IOException {
        int n2 = this.peekToken();
        if (n2 != n) {
            return false;
        }
        this.consumeToken();
        return true;
    }

    private int peekTokenOrEOL() throws IOException {
        int n = this.peekToken();
        if ((this.currentFlaggedToken & 0x10000) != 0) {
            n = 1;
        }
        return n;
    }

    private void setCheckForLabel() {
        if ((this.currentFlaggedToken & 0xFFFF) != 39) {
            throw Kit.codeBug();
        }
        this.currentFlaggedToken |= 0x20000;
    }

    private void mustMatchToken(int n, String string) throws IOException, ParserException {
        if (!this.matchToken(n)) {
            this.reportError(string);
        }
    }

    private void mustHaveXML() {
        if (!this.compilerEnv.isXmlAvailable()) {
            this.reportError("msg.XML.not.available");
        }
    }

    public String getEncodedSource() {
        return this.encodedSource;
    }

    public boolean eof() {
        return this.ts.eof();
    }

    boolean insideFunction() {
        return this.nestingOfFunction != 0;
    }

    void pushScope(Node node) {
        Node.Scope scope = (Node.Scope)node;
        if (scope.getParentScope() != null) {
            throw Kit.codeBug();
        }
        scope.setParent(this.currentScope);
        this.currentScope = scope;
    }

    void popScope() {
        this.currentScope = this.currentScope.getParentScope();
    }

    private Node enterLoop(Node node, boolean bl) {
        Node node2 = this.nf.createLoopNode(node, this.ts.getLineno());
        if (this.loopSet == null) {
            this.loopSet = new ObjArray();
            if (this.loopAndSwitchSet == null) {
                this.loopAndSwitchSet = new ObjArray();
            }
        }
        this.loopSet.push(node2);
        this.loopAndSwitchSet.push(node2);
        if (bl) {
            this.pushScope(node2);
        }
        return node2;
    }

    private void exitLoop(boolean bl) {
        this.loopSet.pop();
        this.loopAndSwitchSet.pop();
        if (bl) {
            this.popScope();
        }
    }

    private Node enterSwitch(Node node, int n) {
        Node node2 = this.nf.createSwitch(node, n);
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ObjArray();
        }
        this.loopAndSwitchSet.push(node2);
        return node2;
    }

    private void exitSwitch() {
        this.loopAndSwitchSet.pop();
    }

    public ScriptOrFnNode parse(String string, String string2, int n) {
        this.sourceURI = string2;
        this.ts = new TokenStream(this, null, string, n);
        try {
            return this.parse();
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    public ScriptOrFnNode parse(Reader reader, String string, int n) throws IOException {
        this.sourceURI = string;
        this.ts = new TokenStream(this, reader, null, n);
        return this.parse();
    }

    private ScriptOrFnNode parse() throws IOException {
        int n;
        this.decompiler = this.createDecompiler(this.compilerEnv);
        this.nf = new IRFactory(this);
        this.currentScriptOrFn = this.nf.createScript();
        this.currentScope = this.currentScriptOrFn;
        int n2 = this.decompiler.getCurrentOffset();
        this.encodedSource = null;
        this.decompiler.addToken(135);
        this.currentFlaggedToken = 0;
        this.syntaxErrorCount = 0;
        int n3 = this.ts.getLineno();
        Node node = this.nf.createLeaf(128);
        try {
            while ((n = this.peekToken()) > 0) {
                Node node2;
                block8: {
                    if (n == 108) {
                        this.consumeToken();
                        try {
                            node2 = this.function(this.calledByCompileFunction ? 2 : 1);
                            break block8;
                        }
                        catch (ParserException parserException) {
                            break;
                        }
                    }
                    node2 = this.statement();
                }
                this.nf.addChildToBack(node, node2);
            }
        }
        catch (StackOverflowError stackOverflowError) {
            String string = ScriptRuntime.getMessage0("msg.too.deep.parser.recursion");
            throw Context.reportRuntimeError(string, this.sourceURI, this.ts.getLineno(), null, 0);
        }
        if (this.syntaxErrorCount != 0) {
            String string = String.valueOf(this.syntaxErrorCount);
            string = ScriptRuntime.getMessage1("msg.got.syntax.errors", string);
            throw this.errorReporter.runtimeError(string, this.sourceURI, n3, null, 0);
        }
        this.currentScriptOrFn.setSourceName(this.sourceURI);
        this.currentScriptOrFn.setBaseLineno(n3);
        this.currentScriptOrFn.setEndLineno(this.ts.getLineno());
        n = this.decompiler.getCurrentOffset();
        this.currentScriptOrFn.setEncodedSourceBounds(n2, n);
        this.nf.initScript(this.currentScriptOrFn, node);
        if (this.compilerEnv.isGeneratingSource()) {
            this.encodedSource = this.decompiler.getEncodedSource();
        }
        this.decompiler = null;
        return this.currentScriptOrFn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node parseFunctionBody() throws IOException {
        Node node;
        block10: {
            ++this.nestingOfFunction;
            node = this.nf.createBlock(this.ts.getLineno());
            try {
                while (true) {
                    Node node2;
                    int n = this.peekToken();
                    switch (n) {
                        case -1: 
                        case 0: 
                        case 85: {
                            break block10;
                        }
                        case 108: {
                            this.consumeToken();
                            node2 = this.function(1);
                            break;
                        }
                        default: {
                            node2 = this.statement();
                        }
                    }
                    this.nf.addChildToBack(node, node2);
                }
            }
            catch (ParserException parserException) {
            }
            finally {
                --this.nestingOfFunction;
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node function(int n) throws IOException, ParserException {
        int n2;
        Node node;
        String string;
        int n3 = n;
        int n4 = this.ts.getLineno();
        int n5 = this.decompiler.markFunctionStart(n);
        Node node2 = null;
        if (this.matchToken(39)) {
            string = this.ts.getString();
            this.decompiler.addName(string);
            if (!this.matchToken(86)) {
                if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                    Node node3 = this.nf.createName(string);
                    string = "";
                    node2 = this.memberExprTail(false, node3);
                }
                this.mustMatchToken(86, "msg.no.paren.parms");
            }
        } else if (this.matchToken(86)) {
            string = "";
        } else {
            string = "";
            if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                node2 = this.memberExpr(false);
            }
            this.mustMatchToken(86, "msg.no.paren.parms");
        }
        if (node2 != null) {
            n3 = 2;
        }
        if (n3 != 2 && string.length() > 0) {
            this.defineSymbol(108, false, string);
        }
        boolean bl = this.insideFunction();
        FunctionNode functionNode = this.nf.createFunction(string);
        if (bl || this.nestingOfWith > 0) {
            functionNode.itsIgnoreDynamicScope = true;
        }
        int n6 = this.currentScriptOrFn.addFunction(functionNode);
        ScriptOrFnNode scriptOrFnNode = this.currentScriptOrFn;
        this.currentScriptOrFn = functionNode;
        Node.Scope scope = this.currentScope;
        this.currentScope = functionNode;
        int n7 = this.nestingOfWith;
        this.nestingOfWith = 0;
        Map<String, Node> map = this.labelSet;
        this.labelSet = null;
        ObjArray objArray = this.loopSet;
        this.loopSet = null;
        ObjArray objArray2 = this.loopAndSwitchSet;
        this.loopAndSwitchSet = null;
        int n8 = this.endFlags;
        this.endFlags = 0;
        Node node4 = null;
        try {
            this.decompiler.addToken(86);
            if (!this.matchToken(87)) {
                boolean bl2 = true;
                do {
                    String string2;
                    if (!bl2) {
                        this.decompiler.addToken(88);
                    }
                    bl2 = false;
                    int n9 = this.peekToken();
                    if (n9 == 82 || n9 == 84) {
                        if (node4 == null) {
                            node4 = new Node(88);
                        }
                        string2 = this.currentScriptOrFn.getNextTempName();
                        this.defineSymbol(86, false, string2);
                        node4.addChildToBack(this.nf.createDestructuringAssignment(121, this.primaryExpr(), this.nf.createName(string2)));
                        continue;
                    }
                    this.mustMatchToken(39, "msg.no.parm");
                    string2 = this.ts.getString();
                    this.defineSymbol(86, false, string2);
                    this.decompiler.addName(string2);
                } while (this.matchToken(88));
                this.mustMatchToken(87, "msg.no.paren.after.parms");
            }
            this.decompiler.addToken(87);
            this.mustMatchToken(84, "msg.no.brace.body");
            this.decompiler.addEOL(84);
            node = this.parseFunctionBody();
            if (node4 != null) {
                node.addChildToFront(new Node(132, node4, this.ts.getLineno()));
            }
            this.mustMatchToken(85, "msg.no.brace.after.body");
            if (this.compilerEnv.isStrictMode() && !node.hasConsistentReturnUsage()) {
                String string3 = string.length() > 0 ? "msg.no.return.value" : "msg.anon.no.return.value";
                this.addStrictWarning(string3, string);
            }
            if (n3 == 2 && string.length() > 0 && this.currentScope.getSymbol(string) == null) {
                this.defineSymbol(108, false, string);
            }
            this.decompiler.addToken(85);
            n2 = this.decompiler.markFunctionEnd(n5);
            if (n != 2) {
                this.decompiler.addToken(1);
            }
        }
        finally {
            this.endFlags = n8;
            this.loopAndSwitchSet = objArray2;
            this.loopSet = objArray;
            this.labelSet = map;
            this.nestingOfWith = n7;
            this.currentScriptOrFn = scriptOrFnNode;
            this.currentScope = scope;
        }
        functionNode.setEncodedSourceBounds(n5, n2);
        functionNode.setSourceName(this.sourceURI);
        functionNode.setBaseLineno(n4);
        functionNode.setEndLineno(this.ts.getLineno());
        Node node5 = this.nf.initFunction(functionNode, n6, node, n3);
        if (node2 != null) {
            node5 = this.nf.createAssignment(89, node2, node5);
            if (n != 2) {
                node5 = this.nf.createExprStatementNoReturn(node5, n4);
            }
        }
        return node5;
    }

    private Node statements(Node node) throws IOException {
        int n;
        Node node2;
        Node node3 = node2 = node != null ? node : this.nf.createBlock(this.ts.getLineno());
        while ((n = this.peekToken()) > 0 && n != 85) {
            this.nf.addChildToBack(node2, this.statement());
        }
        return node2;
    }

    private Node condition() throws IOException, ParserException {
        this.mustMatchToken(86, "msg.no.paren.cond");
        this.decompiler.addToken(86);
        Node node = this.expr(false);
        this.mustMatchToken(87, "msg.no.paren.after.cond");
        this.decompiler.addToken(87);
        if (node.getProp(19) == null && (node.getType() == 8 || node.getType() == 35 || node.getType() == 37)) {
            this.addStrictWarning("msg.equal.as.assign", "");
        }
        return node;
    }

    private Node matchJumpLabelName() throws IOException, ParserException {
        Node node = null;
        int n = this.peekTokenOrEOL();
        if (n == 39) {
            this.consumeToken();
            String string = this.ts.getString();
            this.decompiler.addName(string);
            if (this.labelSet != null) {
                node = this.labelSet.get(string);
            }
            if (node == null) {
                this.reportError("msg.undef.label");
            }
        }
        return node;
    }

    private Node statement() throws IOException {
        try {
            Node node = this.statementHelper(null);
            if (node != null) {
                if (this.compilerEnv.isStrictMode() && !node.hasSideEffects()) {
                    this.addStrictWarning("msg.no.side.effects", "");
                }
                return node;
            }
        }
        catch (ParserException parserException) {
            // empty catch block
        }
        int n = this.ts.getLineno();
        block5: while (true) {
            int n2 = this.peekTokenOrEOL();
            this.consumeToken();
            switch (n2) {
                case -1: 
                case 0: 
                case 1: 
                case 81: {
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        return this.nf.createExprStatement(this.nf.createName("error"), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node statementHelper(Node node) throws IOException, ParserException {
        int n;
        Node node2 = null;
        int n2 = this.peekToken();
        switch (n2) {
            case 111: {
                this.consumeToken();
                this.decompiler.addToken(111);
                int n3 = this.ts.getLineno();
                Node node3 = this.condition();
                this.decompiler.addEOL(84);
                Node node4 = this.statement();
                Node node5 = null;
                if (this.matchToken(112)) {
                    this.decompiler.addToken(85);
                    this.decompiler.addToken(112);
                    this.decompiler.addEOL(84);
                    node5 = this.statement();
                }
                this.decompiler.addEOL(85);
                node2 = this.nf.createIf(node3, node4, node5, n3);
                return node2;
            }
            case 113: {
                this.consumeToken();
                this.decompiler.addToken(113);
                int n4 = this.ts.getLineno();
                this.mustMatchToken(86, "msg.no.paren.switch");
                this.decompiler.addToken(86);
                node2 = this.enterSwitch(this.expr(false), n4);
                try {
                    this.mustMatchToken(87, "msg.no.paren.after.switch");
                    this.decompiler.addToken(87);
                    this.mustMatchToken(84, "msg.no.brace.switch");
                    this.decompiler.addEOL(84);
                    boolean bl = false;
                    block51: while (true) {
                        Node node6;
                        n2 = this.nextToken();
                        switch (n2) {
                            case 85: {
                                break block51;
                            }
                            case 114: {
                                this.decompiler.addToken(114);
                                node6 = this.expr(false);
                                this.mustMatchToken(102, "msg.no.colon.case");
                                this.decompiler.addEOL(102);
                                break;
                            }
                            case 115: {
                                if (bl) {
                                    this.reportError("msg.double.switch.default");
                                }
                                this.decompiler.addToken(115);
                                bl = true;
                                node6 = null;
                                this.mustMatchToken(102, "msg.no.colon.case");
                                this.decompiler.addEOL(102);
                                break;
                            }
                            default: {
                                this.reportError("msg.bad.switch");
                                break block51;
                            }
                        }
                        Node node7 = this.nf.createLeaf(128);
                        while ((n2 = this.peekToken()) != 85 && n2 != 114 && n2 != 115 && n2 != 0) {
                            this.nf.addChildToBack(node7, this.statement());
                        }
                        this.nf.addSwitchCase(node2, node6, node7);
                    }
                    this.decompiler.addEOL(85);
                    this.nf.closeSwitch(node2);
                }
                finally {
                    this.exitSwitch();
                }
                return node2;
            }
            case 116: {
                this.consumeToken();
                this.decompiler.addToken(116);
                Node node8 = this.enterLoop(node, true);
                try {
                    Node node9 = this.condition();
                    this.decompiler.addEOL(84);
                    Node node10 = this.statement();
                    this.decompiler.addEOL(85);
                    node2 = this.nf.createWhile(node8, node9, node10);
                }
                finally {
                    this.exitLoop(true);
                }
                return node2;
            }
            case 117: {
                this.consumeToken();
                this.decompiler.addToken(117);
                this.decompiler.addEOL(84);
                Node node11 = this.enterLoop(node, true);
                try {
                    Node node12 = this.statement();
                    this.decompiler.addToken(85);
                    this.mustMatchToken(116, "msg.no.while.do");
                    this.decompiler.addToken(116);
                    Node node13 = this.condition();
                    node2 = this.nf.createDoWhile(node11, node12, node13);
                }
                finally {
                    this.exitLoop(true);
                }
                this.matchToken(81);
                this.decompiler.addEOL(81);
                return node2;
            }
            case 118: {
                this.consumeToken();
                boolean bl = false;
                this.decompiler.addToken(118);
                Node node14 = this.enterLoop(node, true);
                try {
                    Node node15;
                    Node node16;
                    Node node17 = null;
                    int n5 = -1;
                    if (this.matchToken(39)) {
                        this.decompiler.addName(this.ts.getString());
                        if (this.ts.getString().equals("each")) {
                            bl = true;
                        } else {
                            this.reportError("msg.no.paren.for");
                        }
                    }
                    this.mustMatchToken(86, "msg.no.paren.for");
                    this.decompiler.addToken(86);
                    n2 = this.peekToken();
                    if (n2 == 81) {
                        node16 = this.nf.createLeaf(127);
                    } else if (n2 == 121 || n2 == 152) {
                        this.consumeToken();
                        this.decompiler.addToken(n2);
                        node16 = this.variables(true, n2);
                        n5 = n2;
                    } else {
                        node16 = this.expr(true);
                    }
                    if (this.matchToken(52)) {
                        this.decompiler.addToken(52);
                        node15 = this.expr(false);
                    } else {
                        this.mustMatchToken(81, "msg.no.semi.for");
                        this.decompiler.addToken(81);
                        node15 = this.peekToken() == 81 ? this.nf.createLeaf(127) : this.expr(false);
                        this.mustMatchToken(81, "msg.no.semi.for.cond");
                        this.decompiler.addToken(81);
                        node17 = this.peekToken() == 87 ? this.nf.createLeaf(127) : this.expr(false);
                    }
                    this.mustMatchToken(87, "msg.no.paren.for.ctrl");
                    this.decompiler.addToken(87);
                    this.decompiler.addEOL(84);
                    Node node18 = this.statement();
                    this.decompiler.addEOL(85);
                    node2 = node17 == null ? this.nf.createForIn(n5, node14, node16, node15, node18, bl) : this.nf.createFor(node14, node16, node15, node17, node18);
                }
                finally {
                    this.exitLoop(true);
                }
                return node2;
            }
            case 80: {
                this.consumeToken();
                int n6 = this.ts.getLineno();
                Node node19 = null;
                Node node20 = null;
                this.decompiler.addToken(80);
                if (this.peekToken() != 84) {
                    this.reportError("msg.no.brace.try");
                }
                this.decompiler.addEOL(84);
                Node node21 = this.statement();
                this.decompiler.addEOL(85);
                node19 = this.nf.createLeaf(128);
                boolean bl = false;
                int n7 = this.peekToken();
                if (n7 == 123) {
                    while (this.matchToken(123)) {
                        if (bl) {
                            this.reportError("msg.catch.unreachable");
                        }
                        this.decompiler.addToken(123);
                        this.mustMatchToken(86, "msg.no.paren.catch");
                        this.decompiler.addToken(86);
                        this.mustMatchToken(39, "msg.bad.catchcond");
                        String string = this.ts.getString();
                        this.decompiler.addName(string);
                        Node node22 = null;
                        if (this.matchToken(111)) {
                            this.decompiler.addToken(111);
                            node22 = this.expr(false);
                        } else {
                            bl = true;
                        }
                        this.mustMatchToken(87, "msg.bad.catchcond");
                        this.decompiler.addToken(87);
                        this.mustMatchToken(84, "msg.no.brace.catchblock");
                        this.decompiler.addEOL(84);
                        this.nf.addChildToBack(node19, this.nf.createCatch(string, node22, this.statements(null), this.ts.getLineno()));
                        this.mustMatchToken(85, "msg.no.brace.after.body");
                        this.decompiler.addEOL(85);
                    }
                } else if (n7 != 124) {
                    this.mustMatchToken(124, "msg.try.no.catchfinally");
                }
                if (this.matchToken(124)) {
                    this.decompiler.addToken(124);
                    this.decompiler.addEOL(84);
                    node20 = this.statement();
                    this.decompiler.addEOL(85);
                }
                node2 = this.nf.createTryCatchFinally(node21, node19, node20, n6);
                return node2;
            }
            case 50: {
                this.consumeToken();
                if (this.peekTokenOrEOL() == 1) {
                    this.reportError("msg.bad.throw.eol");
                }
                n = this.ts.getLineno();
                this.decompiler.addToken(50);
                node2 = this.nf.createThrow(this.expr(false), n);
                break;
            }
            case 119: {
                this.consumeToken();
                n = this.ts.getLineno();
                this.decompiler.addToken(119);
                Node node23 = this.matchJumpLabelName();
                if (node23 == null) {
                    if (this.loopAndSwitchSet == null || this.loopAndSwitchSet.size() == 0) {
                        this.reportError("msg.bad.break");
                        return null;
                    }
                    node23 = (Node)this.loopAndSwitchSet.peek();
                }
                node2 = this.nf.createBreak(node23, n);
                break;
            }
            case 120: {
                Node node24;
                this.consumeToken();
                n = this.ts.getLineno();
                this.decompiler.addToken(120);
                Node node25 = this.matchJumpLabelName();
                if (node25 == null) {
                    if (this.loopSet == null || this.loopSet.size() == 0) {
                        this.reportError("msg.continue.outside");
                        return null;
                    }
                    node24 = (Node)this.loopSet.peek();
                } else {
                    node24 = this.nf.getLabelLoop(node25);
                    if (node24 == null) {
                        this.reportError("msg.continue.nonloop");
                        return null;
                    }
                }
                node2 = this.nf.createContinue(node24, n);
                break;
            }
            case 122: {
                Node node26;
                this.consumeToken();
                this.decompiler.addToken(122);
                int n8 = this.ts.getLineno();
                this.mustMatchToken(86, "msg.no.paren.with");
                this.decompiler.addToken(86);
                Node node27 = this.expr(false);
                this.mustMatchToken(87, "msg.no.paren.after.with");
                this.decompiler.addToken(87);
                this.decompiler.addEOL(84);
                ++this.nestingOfWith;
                try {
                    node26 = this.statement();
                }
                finally {
                    --this.nestingOfWith;
                }
                this.decompiler.addEOL(85);
                node2 = this.nf.createWith(node27, node26, n8);
                return node2;
            }
            case 121: 
            case 153: {
                this.consumeToken();
                this.decompiler.addToken(n2);
                node2 = this.variables(false, n2);
                break;
            }
            case 152: {
                this.consumeToken();
                this.decompiler.addToken(152);
                if (this.peekToken() == 86) {
                    return this.let(true);
                }
                node2 = this.variables(false, n2);
                if (this.peekToken() == 81) break;
                return node2;
            }
            case 4: 
            case 72: {
                node2 = this.returnOrYield(n2, false);
                break;
            }
            case 159: {
                this.consumeToken();
                this.decompiler.addToken(159);
                node2 = this.nf.createDebugger(this.ts.getLineno());
                break;
            }
            case 84: {
                this.consumeToken();
                if (node != null) {
                    this.decompiler.addToken(84);
                }
                Node node28 = this.nf.createScopeNode(128, this.ts.getLineno());
                this.pushScope(node28);
                try {
                    this.statements(node28);
                    this.mustMatchToken(85, "msg.no.brace.block");
                    if (node != null) {
                        this.decompiler.addEOL(85);
                    }
                    Node node29 = node28;
                    return node29;
                }
                finally {
                    this.popScope();
                }
            }
            case -1: 
            case 81: {
                this.consumeToken();
                node2 = this.nf.createLeaf(127);
                return node2;
            }
            case 108: {
                this.consumeToken();
                node2 = this.function(3);
                return node2;
            }
            case 115: {
                this.consumeToken();
                this.mustHaveXML();
                this.decompiler.addToken(115);
                int n9 = this.ts.getLineno();
                if (!this.matchToken(39) || !this.ts.getString().equals("xml")) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addName(" xml");
                if (!this.matchToken(39) || !this.ts.getString().equals("namespace")) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addName(" namespace");
                if (!this.matchToken(89)) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addToken(89);
                Node node30 = this.expr(false);
                node2 = this.nf.createDefaultNamespace(node30, n9);
                break;
            }
            case 39: {
                boolean bl;
                int n10 = this.ts.getLineno();
                String string = this.ts.getString();
                this.setCheckForLabel();
                node2 = this.expr(false);
                if (node2.getType() != 129) {
                    node2 = this.nf.createExprStatement(node2, n10);
                    break;
                }
                if (this.peekToken() != 102) {
                    Kit.codeBug();
                }
                this.consumeToken();
                this.decompiler.addName(string);
                this.decompiler.addEOL(102);
                if (this.labelSet == null) {
                    this.labelSet = new HashMap<String, Node>();
                } else if (this.labelSet.containsKey(string)) {
                    this.reportError("msg.dup.label");
                }
                if (node == null) {
                    bl = true;
                    node = node2;
                } else {
                    bl = false;
                }
                this.labelSet.put(string, node);
                try {
                    node2 = this.statementHelper(node);
                }
                finally {
                    this.labelSet.remove(string);
                }
                if (bl) {
                    node2 = this.nf.createLabeledStatement(node, node2);
                }
                return node2;
            }
            default: {
                int n11 = this.ts.getLineno();
                node2 = this.expr(false);
                node2 = this.nf.createExprStatement(node2, n11);
                break;
            }
        }
        n = this.peekFlaggedToken();
        switch (n & 0xFFFF) {
            case 81: {
                this.consumeToken();
                break;
            }
            case -1: 
            case 0: 
            case 85: {
                break;
            }
            default: {
                if ((n & 0x10000) != 0) break;
                this.reportError("msg.no.semi.stmt");
            }
        }
        this.decompiler.addEOL(81);
        return node2;
    }

    private static final boolean nowAllSet(int n, int n2, int n3) {
        return (n & n3) != n3 && (n2 & n3) == n3;
    }

    private Node returnOrYield(int n, boolean bl) throws IOException, ParserException {
        Node node;
        Node node2;
        if (!this.insideFunction()) {
            this.reportError(n == 4 ? "msg.bad.return" : "msg.bad.yield");
        }
        this.consumeToken();
        this.decompiler.addToken(n);
        int n2 = this.ts.getLineno();
        switch (this.peekTokenOrEOL()) {
            case -1: 
            case 0: 
            case 1: 
            case 72: 
            case 81: 
            case 83: 
            case 85: 
            case 87: {
                node2 = null;
                break;
            }
            default: {
                node2 = this.expr(false);
            }
        }
        int n3 = this.endFlags;
        if (n == 4) {
            this.endFlags = node2 == null ? (this.endFlags |= 2) : (this.endFlags |= 4);
            node = this.nf.createReturn(node2, n2);
            if (Parser.nowAllSet(n3, this.endFlags, 6)) {
                this.addStrictWarning("msg.return.inconsistent", "");
            }
        } else {
            this.endFlags |= 8;
            node = this.nf.createYield(node2, n2);
            if (!bl) {
                node = new Node(132, node, n2);
            }
        }
        if (Parser.nowAllSet(n3, this.endFlags, 12)) {
            String string = ((FunctionNode)this.currentScriptOrFn).getFunctionName();
            if (string.length() == 0) {
                this.addError("msg.anon.generator.returns", "");
            } else {
                this.addError("msg.generator.returns", string);
            }
        }
        return node;
    }

    private Node variables(boolean bl, int n) throws IOException, ParserException {
        Node node = this.nf.createVariables(n, this.ts.getLineno());
        boolean bl2 = true;
        do {
            Node node2 = null;
            String string = null;
            int n2 = this.peekToken();
            if (n2 == 82 || n2 == 84) {
                node2 = this.primaryExpr();
            } else {
                this.mustMatchToken(39, "msg.bad.var");
                string = this.ts.getString();
                if (!bl2) {
                    this.decompiler.addToken(88);
                }
                bl2 = false;
                this.decompiler.addName(string);
                this.defineSymbol(n, bl, string);
            }
            Node node3 = null;
            if (this.matchToken(89)) {
                this.decompiler.addToken(89);
                node3 = this.assignExpr(bl);
            }
            if (node2 != null) {
                if (node3 == null) {
                    if (!bl) {
                        this.reportError("msg.destruct.assign.no.init");
                    }
                    this.nf.addChildToBack(node, node2);
                    continue;
                }
                this.nf.addChildToBack(node, this.nf.createDestructuringAssignment(n, node2, node3));
                continue;
            }
            Node node4 = this.nf.createName(string);
            if (node3 != null) {
                this.nf.addChildToBack(node4, node3);
            }
            this.nf.addChildToBack(node, node4);
        } while (this.matchToken(88));
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node let(boolean bl) throws IOException, ParserException {
        this.mustMatchToken(86, "msg.no.paren.after.let");
        this.decompiler.addToken(86);
        Node node = this.nf.createScopeNode(152, this.ts.getLineno());
        this.pushScope(node);
        try {
            Node node2 = this.variables(false, 152);
            this.nf.addChildToBack(node, node2);
            this.mustMatchToken(87, "msg.no.paren.let");
            this.decompiler.addToken(87);
            if (bl && this.peekToken() == 84) {
                this.consumeToken();
                this.decompiler.addEOL(84);
                this.nf.addChildToBack(node, this.statements(null));
                this.mustMatchToken(85, "msg.no.curly.let");
                this.decompiler.addToken(85);
            } else {
                node.setType(157);
                this.nf.addChildToBack(node, this.expr(false));
                if (bl) {
                    node = this.nf.createExprStatement(node, this.ts.getLineno());
                }
            }
        }
        finally {
            this.popScope();
        }
        return node;
    }

    void defineSymbol(int n, boolean bl, String string) {
        Node.Scope scope = this.currentScope.getDefiningScope(string);
        Node.Symbol symbol = scope != null ? scope.getSymbol(string) : null;
        boolean bl2 = false;
        if (symbol != null && (symbol.declType == 153 || n == 153)) {
            bl2 = true;
        } else {
            switch (n) {
                case 152: {
                    if (symbol != null && scope == this.currentScope) {
                        bl2 = symbol.declType == 152;
                    }
                    int n2 = this.currentScope.getType();
                    if (!(bl || n2 != 131 && n2 != 111)) {
                        this.addError("msg.let.decl.not.in.block");
                    }
                    this.currentScope.putSymbol(string, new Node.Symbol(n, string));
                    break;
                }
                case 108: 
                case 121: 
                case 153: {
                    if (symbol != null) {
                        if (symbol.declType == 121) {
                            this.addStrictWarning("msg.var.redecl", string);
                            break;
                        }
                        if (symbol.declType != 86) break;
                        this.addStrictWarning("msg.var.hides.arg", string);
                        break;
                    }
                    this.currentScriptOrFn.putSymbol(string, new Node.Symbol(n, string));
                    break;
                }
                case 86: {
                    if (symbol != null) {
                        this.addWarning("msg.dup.parms", string);
                    }
                    this.currentScriptOrFn.putSymbol(string, new Node.Symbol(n, string));
                    break;
                }
                default: {
                    throw Kit.codeBug();
                }
            }
        }
        if (bl2) {
            this.addError(symbol.declType == 153 ? "msg.const.redecl" : (symbol.declType == 152 ? "msg.let.redecl" : (symbol.declType == 121 ? "msg.var.redecl" : (symbol.declType == 108 ? "msg.fn.redecl" : "msg.parm.redecl"))), string);
        }
    }

    private Node expr(boolean bl) throws IOException, ParserException {
        Node node = this.assignExpr(bl);
        while (this.matchToken(88)) {
            this.decompiler.addToken(88);
            if (this.compilerEnv.isStrictMode() && !node.hasSideEffects()) {
                this.addStrictWarning("msg.no.side.effects", "");
            }
            if (this.peekToken() == 72) {
                this.reportError("msg.yield.parenthesized");
            }
            node = this.nf.createBinary(88, node, this.assignExpr(bl));
        }
        return node;
    }

    private Node assignExpr(boolean bl) throws IOException, ParserException {
        int n = this.peekToken();
        if (n == 72) {
            this.consumeToken();
            return this.returnOrYield(n, true);
        }
        Node node = this.condExpr(bl);
        n = this.peekToken();
        if (89 <= n && n <= 100) {
            this.consumeToken();
            this.decompiler.addToken(n);
            node = this.nf.createAssignment(n, node, this.assignExpr(bl));
        }
        return node;
    }

    private Node condExpr(boolean bl) throws IOException, ParserException {
        Node node = this.orExpr(bl);
        if (this.matchToken(101)) {
            this.decompiler.addToken(101);
            Node node2 = this.assignExpr(false);
            this.mustMatchToken(102, "msg.no.colon.cond");
            this.decompiler.addToken(102);
            Node node3 = this.assignExpr(bl);
            return this.nf.createCondExpr(node, node2, node3);
        }
        return node;
    }

    private Node orExpr(boolean bl) throws IOException, ParserException {
        Node node = this.andExpr(bl);
        if (this.matchToken(103)) {
            this.decompiler.addToken(103);
            node = this.nf.createBinary(103, node, this.orExpr(bl));
        }
        return node;
    }

    private Node andExpr(boolean bl) throws IOException, ParserException {
        Node node = this.bitOrExpr(bl);
        if (this.matchToken(104)) {
            this.decompiler.addToken(104);
            node = this.nf.createBinary(104, node, this.andExpr(bl));
        }
        return node;
    }

    private Node bitOrExpr(boolean bl) throws IOException, ParserException {
        Node node = this.bitXorExpr(bl);
        while (this.matchToken(9)) {
            this.decompiler.addToken(9);
            node = this.nf.createBinary(9, node, this.bitXorExpr(bl));
        }
        return node;
    }

    private Node bitXorExpr(boolean bl) throws IOException, ParserException {
        Node node = this.bitAndExpr(bl);
        while (this.matchToken(10)) {
            this.decompiler.addToken(10);
            node = this.nf.createBinary(10, node, this.bitAndExpr(bl));
        }
        return node;
    }

    private Node bitAndExpr(boolean bl) throws IOException, ParserException {
        Node node = this.eqExpr(bl);
        while (this.matchToken(11)) {
            this.decompiler.addToken(11);
            node = this.nf.createBinary(11, node, this.eqExpr(bl));
        }
        return node;
    }

    private Node eqExpr(boolean bl) throws IOException, ParserException {
        Node node = this.relExpr(bl);
        block9: while (true) {
            int n = this.peekToken();
            switch (n) {
                case 12: 
                case 13: 
                case 46: 
                case 47: {
                    this.consumeToken();
                    int n2 = n;
                    int n3 = n;
                    if (this.compilerEnv.getLanguageVersion() == 120) {
                        switch (n) {
                            case 12: {
                                n3 = 46;
                                break;
                            }
                            case 13: {
                                n3 = 47;
                                break;
                            }
                            case 46: {
                                n2 = 12;
                                break;
                            }
                            case 47: {
                                n2 = 13;
                            }
                        }
                    }
                    this.decompiler.addToken(n2);
                    node = this.nf.createBinary(n3, node, this.relExpr(bl));
                    continue block9;
                }
            }
            break;
        }
        return node;
    }

    private Node relExpr(boolean bl) throws IOException, ParserException {
        Node node = this.shiftExpr();
        block4: while (true) {
            int n = this.peekToken();
            switch (n) {
                case 52: {
                    if (bl) break block4;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 53: {
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    node = this.nf.createBinary(n, node, this.shiftExpr());
                    continue block4;
                }
            }
            break;
        }
        return node;
    }

    private Node shiftExpr() throws IOException, ParserException {
        Node node = this.addExpr();
        block3: while (true) {
            int n = this.peekToken();
            switch (n) {
                case 18: 
                case 19: 
                case 20: {
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    node = this.nf.createBinary(n, node, this.addExpr());
                    continue block3;
                }
            }
            break;
        }
        return node;
    }

    private Node addExpr() throws IOException, ParserException {
        int n;
        Node node = this.mulExpr();
        while ((n = this.peekToken()) == 21 || n == 22) {
            this.consumeToken();
            this.decompiler.addToken(n);
            node = this.nf.createBinary(n, node, this.mulExpr());
        }
        return node;
    }

    private Node mulExpr() throws IOException, ParserException {
        Node node = this.unaryExpr();
        block3: while (true) {
            int n = this.peekToken();
            switch (n) {
                case 23: 
                case 24: 
                case 25: {
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    node = this.nf.createBinary(n, node, this.unaryExpr());
                    continue block3;
                }
            }
            break;
        }
        return node;
    }

    private Node unaryExpr() throws IOException, ParserException {
        int n = this.peekToken();
        switch (n) {
            case 26: 
            case 27: 
            case 32: 
            case 125: {
                this.consumeToken();
                this.decompiler.addToken(n);
                return this.nf.createUnary(n, this.unaryExpr());
            }
            case 21: {
                this.consumeToken();
                this.decompiler.addToken(28);
                return this.nf.createUnary(28, this.unaryExpr());
            }
            case 22: {
                this.consumeToken();
                this.decompiler.addToken(29);
                return this.nf.createUnary(29, this.unaryExpr());
            }
            case 105: 
            case 106: {
                this.consumeToken();
                this.decompiler.addToken(n);
                return this.nf.createIncDec(n, false, this.memberExpr(true));
            }
            case 31: {
                this.consumeToken();
                this.decompiler.addToken(31);
                return this.nf.createUnary(31, this.unaryExpr());
            }
            case -1: {
                this.consumeToken();
                break;
            }
            case 14: {
                if (this.compilerEnv.isXmlAvailable()) {
                    this.consumeToken();
                    Node node = this.xmlInitializer();
                    return this.memberExprTail(true, node);
                }
            }
            default: {
                Node node = this.memberExpr(true);
                n = this.peekTokenOrEOL();
                if (n == 105 || n == 106) {
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    return this.nf.createIncDec(n, true, node);
                }
                return node;
            }
        }
        return this.nf.createName("error");
    }

    private Node xmlInitializer() throws IOException {
        int n = this.ts.getFirstXMLToken();
        if (n != 144 && n != 147) {
            this.reportError("msg.syntax");
            return null;
        }
        Node node = this.nf.createLeaf(30);
        String string = this.ts.getString();
        boolean bl = string.trim().startsWith("<>");
        Node node2 = this.nf.createName(bl ? "XMLList" : "XML");
        this.nf.addChildToBack(node, node2);
        node2 = null;
        while (true) {
            switch (n) {
                case 144: {
                    string = this.ts.getString();
                    this.decompiler.addName(string);
                    this.mustMatchToken(84, "msg.syntax");
                    this.decompiler.addToken(84);
                    Node node3 = this.peekToken() == 85 ? this.nf.createString("") : this.expr(false);
                    this.mustMatchToken(85, "msg.syntax");
                    this.decompiler.addToken(85);
                    node2 = node2 == null ? this.nf.createString(string) : this.nf.createBinary(21, node2, this.nf.createString(string));
                    if (this.ts.isXMLAttribute()) {
                        node3 = this.nf.createUnary(74, node3);
                        Node node4 = this.nf.createBinary(21, this.nf.createString("\""), node3);
                        node3 = this.nf.createBinary(21, node4, this.nf.createString("\""));
                    } else {
                        node3 = this.nf.createUnary(75, node3);
                    }
                    node2 = this.nf.createBinary(21, node2, node3);
                    break;
                }
                case 147: {
                    string = this.ts.getString();
                    this.decompiler.addName(string);
                    node2 = node2 == null ? this.nf.createString(string) : this.nf.createBinary(21, node2, this.nf.createString(string));
                    this.nf.addChildToBack(node, node2);
                    return node;
                }
                default: {
                    this.reportError("msg.syntax");
                    return null;
                }
            }
            n = this.ts.getNextXMLToken();
        }
    }

    private void argumentList(Node node) throws IOException, ParserException {
        boolean bl = this.matchToken(87);
        if (!bl) {
            boolean bl2 = true;
            do {
                if (!bl2) {
                    this.decompiler.addToken(88);
                }
                bl2 = false;
                if (this.peekToken() == 72) {
                    this.reportError("msg.yield.parenthesized");
                }
                this.nf.addChildToBack(node, this.assignExpr(false));
            } while (this.matchToken(88));
            this.mustMatchToken(87, "msg.no.paren.arg");
        }
        this.decompiler.addToken(87);
    }

    private Node memberExpr(boolean bl) throws IOException, ParserException {
        Node node;
        int n = this.peekToken();
        if (n == 30) {
            this.consumeToken();
            this.decompiler.addToken(30);
            node = this.nf.createCallOrNew(30, this.memberExpr(false));
            if (this.matchToken(86)) {
                this.decompiler.addToken(86);
                this.argumentList(node);
            }
            if ((n = this.peekToken()) == 84) {
                this.nf.addChildToBack(node, this.primaryExpr());
            }
        } else {
            node = this.primaryExpr();
        }
        return this.memberExprTail(bl, node);
    }

    private Node memberExprTail(boolean bl, Node node) throws IOException, ParserException {
        block12: while (true) {
            int n = this.peekToken();
            block0 : switch (n) {
                case 107: 
                case 142: {
                    String string;
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    int n2 = 0;
                    if (n == 142) {
                        this.mustHaveXML();
                        n2 = 4;
                    }
                    if (!this.compilerEnv.isXmlAvailable()) {
                        this.mustMatchToken(39, "msg.no.name.after.dot");
                        string = this.ts.getString();
                        this.decompiler.addName(string);
                        node = this.nf.createPropertyGet(node, null, string, n2);
                        break;
                    }
                    n = this.nextToken();
                    switch (n) {
                        case 50: {
                            this.decompiler.addName("throw");
                            node = this.propertyName(node, "throw", n2);
                            break block0;
                        }
                        case 39: {
                            string = this.ts.getString();
                            this.decompiler.addName(string);
                            node = this.propertyName(node, string, n2);
                            break block0;
                        }
                        case 23: {
                            this.decompiler.addName("*");
                            node = this.propertyName(node, "*", n2);
                            break block0;
                        }
                        case 146: {
                            this.decompiler.addToken(146);
                            node = this.attributeAccess(node, n2);
                            break block0;
                        }
                    }
                    this.reportError("msg.no.name.after.dot");
                    break;
                }
                case 145: {
                    this.consumeToken();
                    this.mustHaveXML();
                    this.decompiler.addToken(145);
                    node = this.nf.createDotQuery(node, this.expr(false), this.ts.getLineno());
                    this.mustMatchToken(87, "msg.no.paren");
                    this.decompiler.addToken(87);
                    break;
                }
                case 82: {
                    this.consumeToken();
                    this.decompiler.addToken(82);
                    node = this.nf.createElementGet(node, null, this.expr(false), 0);
                    this.mustMatchToken(83, "msg.no.bracket.index");
                    this.decompiler.addToken(83);
                    break;
                }
                case 86: {
                    if (!bl) break block12;
                    this.consumeToken();
                    this.decompiler.addToken(86);
                    node = this.nf.createCallOrNew(38, node);
                    this.argumentList(node);
                    break;
                }
                default: {
                    break block12;
                }
            }
        }
        return node;
    }

    private Node attributeAccess(Node node, int n) throws IOException {
        n |= 2;
        int n2 = this.nextToken();
        switch (n2) {
            case 39: {
                String string = this.ts.getString();
                this.decompiler.addName(string);
                node = this.propertyName(node, string, n);
                break;
            }
            case 23: {
                this.decompiler.addName("*");
                node = this.propertyName(node, "*", n);
                break;
            }
            case 82: {
                this.decompiler.addToken(82);
                node = this.nf.createElementGet(node, null, this.expr(false), n);
                this.mustMatchToken(83, "msg.no.bracket.index");
                this.decompiler.addToken(83);
                break;
            }
            default: {
                this.reportError("msg.no.name.after.xmlAttr");
                node = this.nf.createPropertyGet(node, null, "?", n);
            }
        }
        return node;
    }

    private Node propertyName(Node node, String string, int n) throws IOException, ParserException {
        String string2 = null;
        if (this.matchToken(143)) {
            this.decompiler.addToken(143);
            string2 = string;
            int n2 = this.nextToken();
            switch (n2) {
                case 39: {
                    string = this.ts.getString();
                    this.decompiler.addName(string);
                    break;
                }
                case 23: {
                    this.decompiler.addName("*");
                    string = "*";
                    break;
                }
                case 82: {
                    this.decompiler.addToken(82);
                    node = this.nf.createElementGet(node, string2, this.expr(false), n);
                    this.mustMatchToken(83, "msg.no.bracket.index");
                    this.decompiler.addToken(83);
                    return node;
                }
                default: {
                    this.reportError("msg.no.name.after.coloncolon");
                    string = "?";
                }
            }
        }
        node = this.nf.createPropertyGet(node, string2, string, n);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node arrayComprehension(String string, Node node) throws IOException, ParserException {
        Node node2;
        Node node3;
        String string2;
        if (this.nextToken() != 118) {
            throw Kit.codeBug();
        }
        this.decompiler.addName(" ");
        this.decompiler.addToken(118);
        boolean bl = false;
        if (this.matchToken(39)) {
            this.decompiler.addName(this.ts.getString());
            if (this.ts.getString().equals("each")) {
                bl = true;
            } else {
                this.reportError("msg.no.paren.for");
            }
        }
        this.mustMatchToken(86, "msg.no.paren.for");
        this.decompiler.addToken(86);
        int n = this.peekToken();
        if (n == 82 || n == 84) {
            string2 = this.currentScriptOrFn.getNextTempName();
            this.defineSymbol(86, false, string2);
            node = this.nf.createBinary(88, this.nf.createAssignment(89, this.primaryExpr(), this.nf.createName(string2)), node);
        } else if (n == 39) {
            this.consumeToken();
            string2 = this.ts.getString();
            this.decompiler.addName(string2);
        } else {
            this.reportError("msg.bad.var");
            return this.nf.createNumber(0.0);
        }
        Node node4 = this.nf.createName(string2);
        this.defineSymbol(152, false, string2);
        this.mustMatchToken(52, "msg.in.after.for.name");
        this.decompiler.addToken(52);
        Node node5 = this.expr(false);
        this.mustMatchToken(87, "msg.no.paren.for.ctrl");
        this.decompiler.addToken(87);
        n = this.peekToken();
        if (n == 118) {
            node3 = this.arrayComprehension(string, node);
        } else {
            node2 = this.nf.createCallOrNew(38, this.nf.createPropertyGet(this.nf.createName(string), null, "push", 0));
            node2.addChildToBack(node);
            node3 = new Node(132, node2, this.ts.getLineno());
            if (n == 111) {
                this.consumeToken();
                this.decompiler.addToken(111);
                int n2 = this.ts.getLineno();
                Node node6 = this.condition();
                node3 = this.nf.createIf(node6, node3, null, n2);
            }
            this.mustMatchToken(83, "msg.no.bracket.arg");
            this.decompiler.addToken(83);
        }
        node2 = this.enterLoop(null, true);
        try {
            Node node7 = this.nf.createForIn(152, node2, node4, node5, node3, bl);
            return node7;
        }
        finally {
            this.exitLoop(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node primaryExpr() throws IOException, ParserException {
        int n = this.nextFlaggedToken();
        int n2 = n & 0xFFFF;
        switch (n2) {
            case 108: {
                return this.function(2);
            }
            case 82: {
                ObjArray objArray = new ObjArray();
                int n3 = 0;
                int n4 = 0;
                this.decompiler.addToken(82);
                boolean bl = true;
                while (true) {
                    if ((n2 = this.peekToken()) == 88) {
                        this.consumeToken();
                        this.decompiler.addToken(88);
                        if (!bl) {
                            bl = true;
                            continue;
                        }
                        objArray.add(null);
                        ++n3;
                        continue;
                    }
                    if (n2 == 83) break;
                    if (n3 == 0 && objArray.size() == 1 && n2 == 118) {
                        Node node = this.nf.createScopeNode(156, this.ts.getLineno());
                        String string = this.currentScriptOrFn.getNextTempName();
                        this.pushScope(node);
                        try {
                            this.defineSymbol(152, false, string);
                            Node node2 = (Node)objArray.get(0);
                            Node node3 = this.nf.createBlock(this.ts.getLineno());
                            Node node4 = new Node(132, this.nf.createAssignment(89, this.nf.createName(string), this.nf.createCallOrNew(30, this.nf.createName("Array"))), this.ts.getLineno());
                            node3.addChildToBack(node4);
                            node3.addChildToBack(this.arrayComprehension(string, node2));
                            node.addChildToBack(node3);
                            node.addChildToBack(this.nf.createName(string));
                            Node node5 = node;
                            return node5;
                        }
                        finally {
                            this.popScope();
                        }
                    }
                    if (!bl) {
                        this.reportError("msg.no.bracket.arg");
                    }
                    objArray.add(this.assignExpr(false));
                    bl = false;
                }
                this.consumeToken();
                this.decompiler.addToken(83);
                n4 = objArray.size() + (bl ? 1 : 0);
                return this.nf.createArrayLiteral(objArray, n3, n4);
            }
            case 84: {
                ObjArray objArray = new ObjArray();
                this.decompiler.addToken(84);
                if (!this.matchToken(85)) {
                    boolean bl = true;
                    block25: do {
                        if (!bl) {
                            this.decompiler.addToken(88);
                        } else {
                            bl = false;
                        }
                        n2 = this.peekToken();
                        switch (n2) {
                            case 39: 
                            case 41: {
                                Object object;
                                this.consumeToken();
                                String string = this.ts.getString();
                                if (n2 == 39) {
                                    if (string.equals("get") && this.peekToken() == 39) {
                                        this.decompiler.addToken(150);
                                        this.consumeToken();
                                        string = this.ts.getString();
                                        this.decompiler.addName(string);
                                        object = ScriptRuntime.getIndexObject(string);
                                        if (this.getterSetterProperty(objArray, object, true)) continue block25;
                                        break block25;
                                    }
                                    if (string.equals("set") && this.peekToken() == 39) {
                                        this.decompiler.addToken(151);
                                        this.consumeToken();
                                        string = this.ts.getString();
                                        this.decompiler.addName(string);
                                        object = ScriptRuntime.getIndexObject(string);
                                        if (this.getterSetterProperty(objArray, object, false)) continue block25;
                                        break block25;
                                    }
                                    this.decompiler.addName(string);
                                } else {
                                    this.decompiler.addString(string);
                                }
                                object = ScriptRuntime.getIndexObject(string);
                                this.plainProperty(objArray, object);
                                break;
                            }
                            case 40: {
                                this.consumeToken();
                                double d = this.ts.getNumber();
                                this.decompiler.addNumber(d);
                                Object object = ScriptRuntime.getIndexObject(d);
                                this.plainProperty(objArray, object);
                                break;
                            }
                            case 85: {
                                break block25;
                            }
                            default: {
                                this.reportError("msg.bad.prop");
                                break block25;
                            }
                        }
                    } while (this.matchToken(88));
                    this.mustMatchToken(85, "msg.no.brace.prop");
                }
                this.decompiler.addToken(85);
                return this.nf.createObjectLiteral(objArray);
            }
            case 152: {
                this.decompiler.addToken(152);
                return this.let(false);
            }
            case 86: {
                this.decompiler.addToken(86);
                Node node = this.expr(false);
                node.putProp(19, Boolean.TRUE);
                this.decompiler.addToken(87);
                this.mustMatchToken(87, "msg.no.paren");
                return node;
            }
            case 146: {
                this.mustHaveXML();
                this.decompiler.addToken(146);
                Node node = this.attributeAccess(null, 0);
                return node;
            }
            case 39: {
                String string = this.ts.getString();
                if ((n & 0x20000) != 0 && this.peekToken() == 102) {
                    return this.nf.createLabel(this.ts.getLineno());
                }
                this.decompiler.addName(string);
                Node node = this.compilerEnv.isXmlAvailable() ? this.propertyName(null, string, 0) : this.nf.createName(string);
                return node;
            }
            case 40: {
                double d = this.ts.getNumber();
                this.decompiler.addNumber(d);
                return this.nf.createNumber(d);
            }
            case 41: {
                String string = this.ts.getString();
                this.decompiler.addString(string);
                return this.nf.createString(string);
            }
            case 24: 
            case 99: {
                this.ts.readRegExp(n2);
                String string = this.ts.regExpFlags;
                this.ts.regExpFlags = null;
                String string2 = this.ts.getString();
                this.decompiler.addRegexp(string2, string);
                int n5 = this.currentScriptOrFn.addRegexp(string2, string);
                return this.nf.createRegExp(n5);
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.decompiler.addToken(n2);
                return this.nf.createLeaf(n2);
            }
            case 126: {
                this.reportError("msg.reserved.id");
                break;
            }
            case -1: {
                break;
            }
            case 0: {
                this.reportError("msg.unexpected.eof");
                break;
            }
            default: {
                this.reportError("msg.syntax");
            }
        }
        return null;
    }

    private void plainProperty(ObjArray objArray, Object object) throws IOException {
        this.mustMatchToken(102, "msg.no.colon.prop");
        this.decompiler.addToken(66);
        objArray.add(object);
        objArray.add(this.assignExpr(false));
    }

    private boolean getterSetterProperty(ObjArray objArray, Object object, boolean bl) throws IOException {
        Node node = this.function(2);
        if (node.getType() != 108) {
            this.reportError("msg.bad.prop");
            return false;
        }
        int n = node.getExistingIntProp(1);
        FunctionNode functionNode = this.currentScriptOrFn.getFunctionNode(n);
        if (functionNode.getFunctionName().length() != 0) {
            this.reportError("msg.bad.prop");
            return false;
        }
        objArray.add(object);
        if (bl) {
            objArray.add(this.nf.createUnary(150, node));
        } else {
            objArray.add(this.nf.createUnary(151, node));
        }
        return true;
    }

    private static class ParserException
    extends RuntimeException {
        static final long serialVersionUID = 5882582646773765630L;

        private ParserException() {
        }
    }
}

