/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.gradle.api.specs.Spec;
import org.gradle.internal.BiAction;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.Model;
import org.gradle.model.internal.core.DirectNodeInputUsingModelAction;
import org.gradle.model.internal.core.ExtractedModelCreator;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.InputUsingModelAction;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelTypeInitializationException;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.AbstractModelCreationRuleExtractor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.RuleMethodBackedMutationAction;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.ModelValueSchema;
import org.gradle.model.internal.manage.schema.extract.InvalidManagedModelElementTypeException;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class ManagedModelCreationRuleExtractor
extends AbstractModelCreationRuleExtractor<Model> {
    private final ModelSchemaStore schemaStore;

    public ManagedModelCreationRuleExtractor(ModelSchemaStore schemaStore) {
        this.schemaStore = schemaStore;
    }

    @Override
    public String getDescription() {
        return String.format("@%s and taking a managed model element", super.getDescription());
    }

    @Override
    public Spec<MethodRuleDefinition<?, ?>> getSpec() {
        final Spec<MethodRuleDefinition<?, ?>> superSpec = super.getSpec();
        return new Spec<MethodRuleDefinition<?, ?>>(){

            public boolean isSatisfiedBy(MethodRuleDefinition<?, ?> element) {
                return superSpec.isSatisfiedBy(element) && element.getReturnType().equals(ModelType.of(Void.TYPE));
            }
        };
    }

    @Override
    public <R, S> ExtractedModelRule registration(MethodRuleDefinition<R, S> ruleDefinition) {
        String modelName = this.determineModelName(ruleDefinition);
        List<ModelReference<?>> references = ruleDefinition.getReferences();
        if (references.isEmpty()) {
            throw new InvalidModelRuleDeclarationException(ruleDefinition.getDescriptor(), "a void returning model element creation rule has to take a managed model element instance as the first argument");
        }
        ModelType<?> managedType = references.get(0).getType();
        return new ExtractedModelCreator(this.buildModelCreatorForManagedType(managedType, ruleDefinition, ModelPath.path(modelName)));
    }

    @Override
    protected String getNameFromAnnotation(MethodRuleDefinition<?, ?> ruleDefinition) {
        return ruleDefinition.getAnnotation(Model.class).value();
    }

    private <T> ModelCreator buildModelCreatorForManagedType(ModelType<T> managedType, MethodRuleDefinition<?, ?> ruleDefinition, final ModelPath modelPath) {
        final ModelSchema<T> modelSchema = this.getModelSchema(managedType, ruleDefinition);
        if (modelSchema instanceof ModelValueSchema) {
            throw new InvalidModelRuleDeclarationException(ruleDefinition.getDescriptor(), "a void returning model element creation rule cannot take a value type as the first parameter, which is the element being created. Return the value from the method.");
        }
        List<ModelReference<?>> bindings = ruleDefinition.getReferences();
        List<ModelReference<?>> inputs = bindings.subList(1, bindings.size());
        final ModelRuleDescriptor descriptor = ruleDefinition.getDescriptor();
        ModelReference<T> reference = ModelReference.of(modelPath, managedType);
        return ModelCreators.of(modelPath).descriptor(descriptor).action(ModelActionRole.DefineProjections, ModelReference.of(NodeInitializerRegistry.class), new BiAction<MutableModelNode, List<ModelView<?>>>(){

            public void execute(MutableModelNode node, List<ModelView<?>> modelViews) {
                NodeInitializerRegistry nodeInitializerRegistry = (NodeInitializerRegistry)modelViews.get(0).getInstance();
                NodeInitializer initializer = ManagedModelCreationRuleExtractor.getNodeInitializer(descriptor, modelSchema, nodeInitializerRegistry);
                for (ModelProjection modelProjection : initializer.getProjections()) {
                    node.addProjection(modelProjection);
                }
                ModelAction projector = initializer.getProjector(modelPath, descriptor);
                if (projector != null) {
                    node.applyToSelf(ModelActionRole.DefineProjections, projector);
                }
            }
        }).action(ModelActionRole.Create, ModelReference.of(NodeInitializerRegistry.class), new BiAction<MutableModelNode, List<ModelView<?>>>(){

            public void execute(MutableModelNode node, List<ModelView<?>> modelViews) {
                NodeInitializerRegistry nodeInitializerRegistry = (NodeInitializerRegistry)modelViews.get(0).getInstance();
                NodeInitializer initializer = ManagedModelCreationRuleExtractor.getNodeInitializer(descriptor, modelSchema, nodeInitializerRegistry);
                node.applyToSelf(ModelActionRole.Create, DirectNodeInputUsingModelAction.of(ModelReference.of(modelPath), descriptor, initializer.getInputs(), initializer));
            }
        }).action(ModelActionRole.Initialize, InputUsingModelAction.of(reference, descriptor, inputs, new RuleMethodBackedMutationAction(ruleDefinition.getRuleInvoker()))).build();
    }

    private static NodeInitializer getNodeInitializer(ModelRuleDescriptor descriptor, ModelSchema<?> modelSchema, NodeInitializerRegistry nodeInitializerRegistry) {
        try {
            return nodeInitializerRegistry.getNodeInitializer(NodeInitializerContext.forType(modelSchema.getType()));
        }
        catch (ModelTypeInitializationException e) {
            throw new InvalidModelRuleDeclarationException(descriptor, (Throwable)((Object)e));
        }
    }

    private <T> ModelSchema<T> getModelSchema(ModelType<T> managedType, MethodRuleDefinition<?, ?> ruleDefinition) {
        try {
            return this.schemaStore.getSchema(managedType);
        }
        catch (InvalidManagedModelElementTypeException e) {
            throw new InvalidModelRuleDeclarationException(ruleDefinition.getDescriptor(), (Throwable)e);
        }
    }
}

