/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import groovy.lang.Closure;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ExcludeRuleContainer;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.internal.artifacts.DefaultExcludeRuleContainer;
import org.gradle.api.internal.artifacts.dependencies.AbstractDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModuleDependency
extends AbstractDependency
implements ModuleDependency {
    private ExcludeRuleContainer excludeRuleContainer = new DefaultExcludeRuleContainer();
    private Set<DependencyArtifact> artifacts = new HashSet<DependencyArtifact>();
    private String configuration;
    private boolean transitive = true;

    protected AbstractModuleDependency(String configuration) {
        this.configuration = GUtil.elvis(configuration, "default");
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public ModuleDependency setTransitive(boolean transitive) {
        this.transitive = transitive;
        return this;
    }

    @Override
    public String getConfiguration() {
        return this.configuration;
    }

    @Override
    public ModuleDependency exclude(Map<String, String> excludeProperties) {
        this.excludeRuleContainer.add(excludeProperties);
        return this;
    }

    @Override
    public Set<ExcludeRule> getExcludeRules() {
        return this.excludeRuleContainer.getRules();
    }

    private void setExcludeRuleContainer(ExcludeRuleContainer excludeRuleContainer) {
        this.excludeRuleContainer = excludeRuleContainer;
    }

    @Override
    public Set<DependencyArtifact> getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(Set<DependencyArtifact> artifacts) {
        this.artifacts = artifacts;
    }

    @Override
    public AbstractModuleDependency addArtifact(DependencyArtifact artifact) {
        this.artifacts.add(artifact);
        return this;
    }

    @Override
    public DependencyArtifact artifact(Closure configureClosure) {
        DependencyArtifact artifact = ConfigureUtil.configure(configureClosure, new DefaultDependencyArtifact());
        this.artifacts.add(artifact);
        return artifact;
    }

    protected void copyTo(AbstractModuleDependency target) {
        super.copyTo(target);
        target.setArtifacts(new HashSet<DependencyArtifact>(this.getArtifacts()));
        target.setExcludeRuleContainer(new DefaultExcludeRuleContainer(this.getExcludeRules()));
        target.setTransitive(this.isTransitive());
    }

    protected boolean isKeyEquals(ModuleDependency dependencyRhs) {
        if (this.getGroup() != null ? !this.getGroup().equals(dependencyRhs.getGroup()) : dependencyRhs.getGroup() != null) {
            return false;
        }
        if (!this.getName().equals(dependencyRhs.getName())) {
            return false;
        }
        if (!this.getConfiguration().equals(dependencyRhs.getConfiguration())) {
            return false;
        }
        return !(this.getVersion() != null ? !this.getVersion().equals(dependencyRhs.getVersion()) : dependencyRhs.getVersion() != null);
    }

    protected boolean isCommonContentEquals(ModuleDependency dependencyRhs) {
        if (!this.isKeyEquals(dependencyRhs)) {
            return false;
        }
        if (this.isTransitive() != dependencyRhs.isTransitive()) {
            return false;
        }
        if (this.getArtifacts() != null ? !this.getArtifacts().equals(dependencyRhs.getArtifacts()) : dependencyRhs.getArtifacts() != null) {
            return false;
        }
        return !(this.getExcludeRules() != null ? !this.getExcludeRules().equals(dependencyRhs.getExcludeRules()) : dependencyRhs.getExcludeRules() != null);
    }
}

