/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.coffeescript.compile.internal.rhino;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.WorkResult;
import org.gradle.plugins.javascript.coffeescript.CoffeeScriptCompileSpec;
import org.gradle.plugins.javascript.coffeescript.CoffeeScriptCompiler;
import org.gradle.plugins.javascript.coffeescript.compile.internal.SerializableCoffeeScriptCompileSpec;
import org.gradle.plugins.javascript.coffeescript.compile.internal.rhino.CoffeeScriptCompilerWorker;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorkerHandle;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorkerHandleFactory;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorkerSpec;
import org.gradle.process.JavaExecSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhinoCoffeeScriptCompiler
implements CoffeeScriptCompiler {
    private final RhinoWorkerHandleFactory rhinoWorkerHandleFactory;
    private final Iterable<File> rhinoClasspath;
    private final LogLevel logLevel;
    private final File workingDir;

    public RhinoCoffeeScriptCompiler(RhinoWorkerHandleFactory rhinoWorkerHandleFactory, Iterable<File> rhinoClasspath, LogLevel logLevel, File workingDir) {
        this.rhinoWorkerHandleFactory = rhinoWorkerHandleFactory;
        this.rhinoClasspath = rhinoClasspath;
        this.logLevel = logLevel;
        this.workingDir = workingDir;
    }

    @Override
    public WorkResult compile(CoffeeScriptCompileSpec spec) {
        RhinoWorkerHandle<Boolean, SerializableCoffeeScriptCompileSpec> handle = this.rhinoWorkerHandleFactory.create(this.rhinoClasspath, this.createWorkerSpec(), this.logLevel, new Action<JavaExecSpec>(){

            public void execute(JavaExecSpec javaExecSpec) {
                javaExecSpec.setWorkingDir((Object)RhinoCoffeeScriptCompiler.this.workingDir);
            }
        });
        final Boolean result = handle.process(new SerializableCoffeeScriptCompileSpec(spec));
        return new WorkResult(){

            public boolean getDidWork() {
                return result;
            }
        };
    }

    private RhinoWorkerSpec<Boolean, SerializableCoffeeScriptCompileSpec> createWorkerSpec() {
        return new RhinoWorkerSpec<Boolean, SerializableCoffeeScriptCompileSpec>(Boolean.class, SerializableCoffeeScriptCompileSpec.class, CoffeeScriptCompilerWorker.class);
    }
}

