/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal;

import java.io.File;
import java.util.Iterator;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.internal.NoFactoryRegisteredForTypeException;
import org.gradle.api.internal.rules.AddOnlyRuleAwarePolymorphicDomainObjectContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.registry.LanguageRegistration;
import org.gradle.language.base.internal.registry.LanguageRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFunctionalSourceSet
extends AddOnlyRuleAwarePolymorphicDomainObjectContainer<LanguageSourceSet>
implements FunctionalSourceSet {
    private final String name;
    private final LanguageRegistry languageRegistry;
    private final File baseDir;

    public DefaultFunctionalSourceSet(String name, Instantiator instantiator, LanguageRegistry languageRegistry, File baseDir) {
        super(LanguageSourceSet.class, instantiator);
        this.name = name;
        this.languageRegistry = languageRegistry;
        this.baseDir = baseDir;
    }

    protected <U extends LanguageSourceSet> U doCreate(String name, Class<U> type) {
        U languageSourceSet = this.createLanguageSourceSet(name, type);
        return languageSourceSet;
    }

    @Override
    public File getBaseDir() {
        return this.baseDir;
    }

    private <U extends LanguageSourceSet> U createLanguageSourceSet(String name, Class<U> type) {
        NamedDomainObjectFactory<LanguageSourceSet> sourceSetFactory = this.findSourceSetFactory(type);
        if (sourceSetFactory == null) {
            throw new InvalidUserDataException(String.format("Cannot create a %s because this type is not known to %s. Known types are: %s", type.getSimpleName(), this.getDisplayName(), this.languageRegistry.getSupportedTypeNames()), (Throwable)new NoFactoryRegisteredForTypeException());
        }
        return (U)((LanguageSourceSet)type.cast(sourceSetFactory.create(name)));
    }

    private <U extends LanguageSourceSet> NamedDomainObjectFactory<? extends LanguageSourceSet> findSourceSetFactory(Class<U> type) {
        Iterator i$ = this.languageRegistry.iterator();
        while (i$.hasNext()) {
            LanguageRegistration languageRegistration = (LanguageRegistration)i$.next();
            Class sourceSetType = languageRegistration.getSourceSetType();
            if (!type.equals(sourceSetType)) continue;
            return languageRegistration.getSourceSetFactory(this.getName());
        }
        return null;
    }

    public String getDisplayName() {
        return FunctionalSourceSet.class.getSimpleName();
    }

    public String toString() {
        return String.format("source set '%s'", this.name);
    }

    public String getName() {
        return this.name;
    }
}

