/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import java.lang.annotation.Annotation;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.List;
import org.gradle.model.ModelMap;
import org.gradle.model.collection.CollectionBuilder;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.inspect.AbstractAnnotationDrivenModelRuleExtractor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.InvalidModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationDrivenComponentModelRuleExtractor<T extends Annotation>
extends AbstractAnnotationDrivenModelRuleExtractor<T> {
    protected void assertIsVoidMethod(MethodRuleDefinition<?, ?> ruleDefinition) {
        if (!ModelType.of(Void.TYPE).equals((Object)ruleDefinition.getReturnType())) {
            throw new InvalidModelException(String.format("Method %s must not have a return value.", this.getDescription()));
        }
    }

    protected <V> void visitSubject(RuleMethodDataCollector dataCollector, MethodRuleDefinition<?, ?> ruleDefinition, Class<V> typeParameter) {
        if (ruleDefinition.getReferences().size() == 0) {
            throw new InvalidModelException(String.format("Method %s must have a parameter of type '%s'.", this.getDescription(), ModelMap.class.getName()));
        }
        ModelType builder = ruleDefinition.getSubjectReference().getType();
        Class<CollectionBuilder> containerClass = CollectionBuilder.class;
        if (!ModelType.of(containerClass).isAssignableFrom(builder)) {
            throw new InvalidModelException(String.format("Method %s first parameter must be of type '%s'.", this.getDescription(), ModelMap.class.getName()));
        }
        if (builder.getTypeVariables().size() != 1) {
            throw new InvalidModelException(String.format("Parameter of type '%s' must declare a type parameter extending '%s'.", ModelMap.class.getSimpleName(), typeParameter.getSimpleName()));
        }
        ModelType subType = (ModelType)builder.getTypeVariables().get(0);
        if (subType.isWildcard()) {
            throw new InvalidModelException(String.format("%s type '%s' cannot be a wildcard type (i.e. cannot use ? super, ? extends etc.).", typeParameter.getName(), subType.toString()));
        }
        dataCollector.parameterTypes.put(typeParameter, subType.getConcreteClass());
    }

    protected <S> void visitDependency(RuleMethodDataCollector dataCollector, MethodRuleDefinition<?, ?> ruleDefinition, ModelType<S> expectedDependency) {
        List references = ruleDefinition.getReferences();
        ModelType dependency = null;
        for (ModelReference reference : references) {
            if (!expectedDependency.isAssignableFrom(reference.getType())) continue;
            if (dependency != null) {
                throw new InvalidModelException(String.format("Method %s must have one parameter extending %s. Found multiple parameter extending %s.", this.getDescription(), expectedDependency.getConcreteClass().getSimpleName(), expectedDependency.getConcreteClass().getSimpleName()));
            }
            dependency = reference.getType().asSubtype(expectedDependency);
        }
        if (dependency == null) {
            throw new InvalidModelException(String.format("Method %s must have one parameter extending %s. Found no parameter extending %s.", this.getDescription(), expectedDependency.getConcreteClass().getSimpleName(), expectedDependency.getConcreteClass().getSimpleName()));
        }
        dataCollector.put(expectedDependency.getConcreteClass(), dependency.getConcreteClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RuleMethodDataCollector {
        private HashMap<Class<?>, Class<?>> parameterTypes = new HashMap();

        protected RuleMethodDataCollector() {
        }

        public <S, R extends S> Class<R> getParameterType(Class<S> baseClass) {
            return this.parameterTypes.get(baseClass);
        }

        public <S> void put(Class<S> baseClass, Class<? extends S> concreteClass) {
            if (!baseClass.isAssignableFrom(concreteClass)) {
                throw new InvalidParameterException(String.format("Class %s must be assignable from Class %s", baseClass.getName(), concreteClass.getName()));
            }
            this.parameterTypes.put(baseClass, concreteClass);
        }
    }
}

