/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.messaging.dispatch.AsyncDispatch;
import org.gradle.messaging.dispatch.AsyncReceive;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.DispatchFailureHandler;
import org.gradle.messaging.dispatch.FailureHandlingDispatch;
import org.gradle.messaging.dispatch.Receive;
import org.gradle.messaging.remote.internal.AsyncConnection;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.Protocol;
import org.gradle.messaging.remote.internal.ProtocolStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncConnectionAdapter<T>
implements AsyncConnection<T>,
Stoppable {
    private final Connection<T> connection;
    private final AsyncReceive<T> incoming;
    private final ProtocolStack<T> stack;
    private final AsyncDispatch<T> outgoing;
    private final Set<Stoppable> executors = new HashSet<Stoppable>();

    public AsyncConnectionAdapter(Connection<T> connection, DispatchFailureHandler<? super T> dispatchFailureHandler, ExecutorFactory executor, Protocol<T> ... protocols) {
        this.connection = connection;
        StoppableExecutor outgoingExecutor = executor.create(String.format("%s send", connection));
        this.executors.add((Stoppable)outgoingExecutor);
        this.outgoing = new AsyncDispatch((Executor)outgoingExecutor);
        this.outgoing.dispatchTo(new FailureHandlingDispatch<T>(connection, dispatchFailureHandler));
        StoppableExecutor dispatchExecutor = executor.create(String.format("%s dispatch", connection));
        this.executors.add((Stoppable)dispatchExecutor);
        this.stack = new ProtocolStack<T>((Executor)dispatchExecutor, dispatchFailureHandler, dispatchFailureHandler, protocols);
        this.stack.getBottom().dispatchTo(this.outgoing);
        StoppableExecutor incomingExecutor = executor.create(String.format("%s receive", connection));
        this.executors.add((Stoppable)incomingExecutor);
        this.incoming = new AsyncReceive((Executor)incomingExecutor);
        this.incoming.dispatchTo(this.stack.getBottom());
        this.incoming.receiveFrom(new ConnectionReceive<T>(connection));
    }

    @Override
    public void dispatch(T message) {
        this.stack.getTop().dispatch(message);
    }

    @Override
    public void dispatchTo(Dispatch<? super T> handler) {
        this.stack.getTop().dispatchTo(handler);
    }

    public void stop() {
        CompositeStoppable.stoppable((Object[])new Object[]{this.stack, this.outgoing, this.connection, this.incoming}).add(this.executors).stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectionReceive<T>
    implements Receive<T> {
        private final Connection<T> connection;

        public ConnectionReceive(Connection<T> connection) {
            this.connection = connection;
        }

        @Override
        public T receive() {
            Object result = this.connection.receive();
            if (result == null) {
                AsyncConnectionAdapter.this.stack.requestStop();
            }
            return result;
        }
    }
}

