/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.internal.serialize.ObjectReader;
import org.gradle.internal.serialize.ObjectWriter;
import org.gradle.internal.serialize.StatefulSerializer;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.internal.MessageSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KryoBackedMessageSerializer<T>
implements MessageSerializer<T> {
    private final StatefulSerializer<T> payloadSerializer;

    public KryoBackedMessageSerializer(StatefulSerializer<T> payloadSerializer) {
        this.payloadSerializer = payloadSerializer;
    }

    @Override
    public ObjectReader<T> newReader(InputStream inputStream, Address localAddress, Address remoteAddress) {
        KryoBackedDecoder decoder = new KryoBackedDecoder(inputStream);
        return this.payloadSerializer.newReader(decoder);
    }

    @Override
    public ObjectWriter<T> newWriter(OutputStream outputStream) {
        final KryoBackedEncoder encoder = new KryoBackedEncoder(outputStream);
        final ObjectWriter<T> writer = this.payloadSerializer.newWriter(encoder);
        return new ObjectWriter<T>(){

            @Override
            public void write(T value) throws Exception {
                writer.write(value);
                encoder.flush();
            }
        };
    }
}

