/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javajs.util.Lst;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import org.jmol.util.Logger;
import org.openscience.jmol.app.webexport.WebPanel;

class ArrayListTransferHandler
extends TransferHandler {
    DataFlavor localArrayListFlavor;
    DataFlavor serialArrayListFlavor;
    String localArrayListType = "application/x-java-jvm-local-objectref;class=java.util.ArrayList";
    JList<?> source = null;
    int[] sourceIndices = null;
    int addIndex = -1;
    int addCount = 0;
    WebPanel webPanel;

    ArrayListTransferHandler(WebPanel webPanel) {
        this.webPanel = webPanel;
        try {
            this.localArrayListFlavor = new DataFlavor(this.localArrayListType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ArrayListTransferHandler: unable to create data flavor");
        }
        this.serialArrayListFlavor = new DataFlavor(ArrayList.class, "ArrayList");
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        Lst lst;
        JList jList;
        block12: {
            if (this.sourceIndices == null || !this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                return false;
            }
            jList = null;
            lst = null;
            try {
                jList = (JList)jComponent;
                if (this.hasLocalArrayListFlavor(transferable.getTransferDataFlavors())) {
                    lst = (Lst)transferable.getTransferData(this.localArrayListFlavor);
                    break block12;
                }
                if (this.hasSerialArrayListFlavor(transferable.getTransferDataFlavors())) {
                    lst = (Lst)transferable.getTransferData(this.serialArrayListFlavor);
                    break block12;
                }
                return false;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Logger.error("importData: unsupported data flavor");
                return false;
            }
            catch (IOException iOException) {
                Logger.error("importData: I/O exception");
                return false;
            }
        }
        int n = jList.getSelectedIndex();
        if (this.source.equals(jList) && n >= this.sourceIndices[0] && n <= this.sourceIndices[this.sourceIndices.length - 1]) {
            this.sourceIndices = null;
            return true;
        }
        DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
        int n2 = defaultListModel.getSize();
        if (n < 0) {
            n = n2;
        } else {
            if (this.sourceIndices[0] < n) {
                ++n;
            }
            if (n > n2) {
                n = n2;
            }
        }
        this.addIndex = n;
        this.addCount = lst.size();
        for (int i = 0; i < lst.size(); ++i) {
            defaultListModel.add(n++, ArrayListTransferHandler.objectOf(defaultListModel, lst.get(i)));
        }
        return true;
    }

    private static Object objectOf(DefaultListModel<?> defaultListModel, Object object) {
        if (object instanceof String) {
            String string = (String)object;
            int n = defaultListModel.size();
            while (--n >= 0) {
                Object obj = defaultListModel.get(n);
                if (obj instanceof String || !obj.toString().equals(string)) continue;
                return defaultListModel.get(n);
            }
        }
        return object;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (n == 2 && this.sourceIndices != null) {
            int n2;
            DefaultListModel defaultListModel = (DefaultListModel)this.source.getModel();
            if (this.addCount > 0) {
                for (n2 = 0; n2 < this.sourceIndices.length; ++n2) {
                    if (this.sourceIndices[n2] <= this.addIndex) continue;
                    int n3 = n2;
                    this.sourceIndices[n3] = this.sourceIndices[n3] + this.addCount;
                }
            }
            for (n2 = this.sourceIndices.length - 1; n2 >= 0; --n2) {
                defaultListModel.remove(this.sourceIndices[n2]);
            }
            ((JList)jComponent).setSelectedIndices(new int[0]);
            if (this.webPanel != null) {
                this.webPanel.syncLists();
            }
        }
        this.sourceIndices = null;
        this.addIndex = -1;
        this.addCount = 0;
    }

    private boolean hasLocalArrayListFlavor(DataFlavor[] dataFlavorArray) {
        if (this.localArrayListFlavor == null) {
            return false;
        }
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(this.localArrayListFlavor)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSerialArrayListFlavor(DataFlavor[] dataFlavorArray) {
        if (this.serialArrayListFlavor == null) {
            return false;
        }
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!dataFlavorArray[i].equals(this.serialArrayListFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (this.hasLocalArrayListFlavor(dataFlavorArray)) {
            return true;
        }
        return this.hasSerialArrayListFlavor(dataFlavorArray);
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        if (jComponent instanceof JList) {
            this.source = (JList)jComponent;
            this.sourceIndices = this.source.getSelectedIndices();
            List<?> list = this.source.getSelectedValuesList();
            if (list == null || list.size() == 0) {
                return null;
            }
            Lst<String> lst = new Lst<String>();
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                String string = obj.toString();
                if (string == null) {
                    string = "";
                }
                lst.addLast(string);
            }
            return new ArrayListTransferable(lst);
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    class ArrayListTransferable
    implements Transferable {
        Lst<String> data;

        ArrayListTransferable(Lst<String> lst) {
            this.data = lst;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{ArrayListTransferHandler.this.localArrayListFlavor, ArrayListTransferHandler.this.serialArrayListFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (ArrayListTransferHandler.this.localArrayListFlavor.equals(dataFlavor)) {
                return true;
            }
            return ArrayListTransferHandler.this.serialArrayListFlavor.equals(dataFlavor);
        }
    }
}

