/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import org.jmol.script.ContextToken;
import org.jmol.script.SV;
import org.jmol.script.ScriptCompiler;
import org.jmol.script.ScriptFunction;

class ScriptFlowContext {
    private ScriptCompiler compiler;
    ContextToken token;
    int pt0;
    int ptDefault;
    ScriptFunction function;
    SV var;
    ScriptFlowContext parent;
    int lineStart;
    int commandStart;
    int ptLine;
    int ptCommand;
    boolean forceEndIf = true;
    String ident;
    int addLine;

    ScriptFlowContext(ScriptCompiler scriptCompiler, ContextToken contextToken, int n, ScriptFlowContext scriptFlowContext) {
        this.compiler = scriptCompiler;
        this.token = contextToken;
        this.ident = (String)contextToken.value;
        this.pt0 = n;
        this.parent = scriptFlowContext;
        short s = this.compiler.lineCurrent;
        this.ptLine = s;
        this.lineStart = s;
        this.commandStart = this.ptCommand = this.compiler.iCommand;
    }

    ScriptFlowContext getBreakableContext(int n) {
        ScriptFlowContext scriptFlowContext = this;
        while (!(scriptFlowContext == null || ScriptCompiler.isBreakableContext(scriptFlowContext.token.tok) && n-- <= 0)) {
            scriptFlowContext = scriptFlowContext.parent;
        }
        return scriptFlowContext;
    }

    boolean checkForceEndIf(int n) {
        boolean bl;
        if (this.ptCommand == this.compiler.iCommand && this.addLine > 0) {
            ++this.addLine;
        }
        boolean bl2 = this.forceEndIf && this.ptCommand < this.compiler.iCommand && this.ptLine + (this.addLine == 0 ? 0 : this.addLine + n) == this.compiler.lineCurrent ? true : (bl = false);
        if (bl) {
            this.forceEndIf = false;
        }
        return bl;
    }

    int setPt0(int n, boolean bl) {
        this.pt0 = n;
        if (bl) {
            this.ptDefault = n;
        }
        this.setLine();
        return n;
    }

    void setLine() {
        this.ptLine = this.compiler.lineCurrent;
        this.ptCommand = this.compiler.iCommand + 1;
    }

    public String toString() {
        return "ident " + this.ident + " line " + this.lineStart + " command " + this.commandStart;
    }

    String path() {
        String string = "";
        ScriptFlowContext scriptFlowContext = this;
        while (scriptFlowContext != null) {
            string = scriptFlowContext.ident + "-" + string;
            scriptFlowContext = scriptFlowContext.parent;
        }
        return "[" + string + "]";
    }

    void setFunction(ScriptFunction scriptFunction) {
        this.function = scriptFunction;
    }
}

