/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

public class CsfReader
extends MopacSlaterReader {
    private int nAtoms = 0;
    private String strAtomicNumbers = "";
    private int fieldCount;
    private int nVibrations = 0;
    private int nGaussians = 0;
    private int nSlaters = 0;
    private Map<String, Bond> htBonds;
    private Map<String, Integer> propertyItemCounts = new Hashtable<String, Integer>();
    private final int[] fieldTypes = new int[100];
    private static final byte objCls1 = 1;
    private static final byte objID1 = 2;
    private static final byte objCls2 = 3;
    private static final byte objID2 = 4;
    private static final String[] connectorFields = new String[]{"objCls1", "objID1", "objCls2", "objID2"};
    private static final byte[] connectorFieldMap = new byte[]{1, 2, 3, 4};
    private Map<String, String[]> connectors;
    private static final byte ID = -1;
    private static final byte SYM = 1;
    private static final byte ANUM = 2;
    private static final byte CHRG = 3;
    private static final byte XYZ = 4;
    private static final byte PCHRG = 5;
    private static final String[] atomFields = new String[]{"ID", "sym", "anum", "chrg", "xyz_coordinates", "pchrg"};
    private static final byte[] atomFieldMap = new byte[]{-1, 1, 2, 3, 4, 5};
    private static final byte BTYPE = 1;
    private static final String[] bondFields = new String[]{"ID", "type"};
    private static final byte[] bondFieldMap = new byte[]{-1, 1};
    private static final byte NORMAL_MODE = 1;
    private static final byte VIB_ENERGY = 2;
    private static final byte DIPOLE = 3;
    private static final String[] vibFields = new String[]{"ID", "normalMode", "Energy", "transitionDipole"};
    private static final byte[] vibFieldMap = new byte[]{-1, 1, 2, 3};
    private static final byte EIG_VAL = 1;
    private static final byte MO_OCC = 2;
    private static final byte EIG_VEC = 3;
    private static final byte EIG_VEC_COMPRESSED = 4;
    private static final byte COEF_INDICES = 5;
    private static final byte BFXN_ANGL = 6;
    private static final byte STO_EXP = 7;
    private static final byte CONTRACTIONS = 8;
    private static final byte GTO_EXP = 9;
    private static final byte SHELL = 10;
    private static final String[] moFields = new String[]{"ID", "eig_val", "mo_occ", "eig_vec", "eig_vec_compressed", "coef_indices", "bfxn_ang", "sto_exp", "contractions", "gto_exp", "shell"};
    private static final byte[] moFieldMap = new byte[]{-1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.equals("local_transform")) {
            this.processLocalTransform();
            return true;
        }
        if (this.line.startsWith("object_class")) {
            if (this.line.equals("object_class connector")) {
                this.processConnectorObject();
                return false;
            }
            if (this.line.equals("object_class atom")) {
                this.processAtomObject();
                return false;
            }
            if (this.line.equals("object_class bond")) {
                this.processBondObject();
                return false;
            }
            if (this.line.equals("object_class vibrational_level")) {
                this.processVibrationObject();
                return false;
            }
            if (this.line.equals("object_class mol_orbital")) {
                this.processMolecularOrbitalObject();
                return false;
            }
            if (this.line.equals("object_class sto_basis_fxn")) {
                this.processBasisObject("sto");
                return false;
            }
            if (this.line.equals("object_class gto_basis_fxn")) {
                this.processBasisObject("gto");
                return false;
            }
        }
        return true;
    }

    private void processLocalTransform() throws Exception {
        String[] stringArray = PT.getTokens(this.rd() + " " + this.rd() + " " + this.rd() + " " + this.rd());
        this.setTransform(this.parseFloatStr(stringArray[0]), this.parseFloatStr(stringArray[1]), this.parseFloatStr(stringArray[2]), this.parseFloatStr(stringArray[4]), this.parseFloatStr(stringArray[5]), this.parseFloatStr(stringArray[6]), this.parseFloatStr(stringArray[8]), this.parseFloatStr(stringArray[9]), this.parseFloatStr(stringArray[10]));
    }

    private int getPropertyCount(String string) {
        Integer n = this.propertyItemCounts.get(string);
        return string.equals("ID") ? 1 : (n == null ? 0 : n);
    }

    private int parseLineParameters(String[] stringArray, byte[] byArray) throws Exception {
        for (int i = 0; i < this.fieldCount; ++i) {
            this.fieldTypes[i] = 0;
        }
        this.fieldCount = -1;
        if (this.line == null || this.line.startsWith("property_flags:")) {
            this.rd();
        }
        if (this.line == null || this.line.startsWith("object_class")) {
            return this.fieldCount;
        }
        String[] stringArray2 = new String[]{};
        while (this.line != null) {
            stringArray2 = this.getTokens();
            if (this.line.indexOf("property ") == 0) {
                this.propertyItemCounts.put(stringArray2[1], stringArray2[6].equals("STRING") ? 1 : this.parseIntStr(stringArray2[5]));
            } else if (this.line.indexOf("ID") == 0) break;
            this.rd();
        }
        int n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            int n2 = stringArray.length;
            while (--n2 >= 0) {
                if (!string.equals(stringArray[n2])) continue;
                this.fieldTypes[n] = byArray[n2];
                this.fieldCount = n + 1;
                break;
            }
            n += this.getPropertyCount(string);
        }
        return this.fieldCount;
    }

    private void fillCsfArray(String string, String[] stringArray, int n, Object object, boolean bl) throws Exception {
        int n2 = this.getPropertyCount(string);
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4 = n3 + i;
            if (n4 == stringArray.length) {
                stringArray = PT.getTokens(this.rd());
                n3 -= n4 - n;
                n4 = n;
            }
            if (bl) {
                ((int[])object)[i] = this.parseIntStr(stringArray[n4]);
                continue;
            }
            ((float[])object)[i] = this.parseFloatStr(stringArray[n4]);
        }
    }

    private void processConnectorObject() throws Exception {
        this.connectors = new Hashtable<String, String[]>();
        this.rd();
        this.parseLineParameters(connectorFields, connectorFieldMap);
        block6: while (this.rd() != null && !this.line.startsWith("property_flags:")) {
            String string = null;
            String string2 = null;
            String[] stringArray = this.getTokens();
            String string3 = "";
            boolean bl = false;
            block7: for (int i = 0; i < this.fieldCount; ++i) {
                String string4 = stringArray[i];
                switch (this.fieldTypes[i]) {
                    case 1: {
                        if (string4.equals("atom")) continue block7;
                        continue block6;
                    }
                    case 3: {
                        string3 = string4;
                        if (string4.equals("sto_basis_fxn")) {
                            ++this.nSlaters;
                            continue block7;
                        }
                        if (string4.equals("gto_basis_fxn")) {
                            ++this.nGaussians;
                            continue block7;
                        }
                        if (string4.equals("vibrational_level")) {
                            bl = true;
                            continue block7;
                        }
                        if (string4.equals("bond")) continue block7;
                        continue block6;
                    }
                    case 2: {
                        string = string4;
                        continue block7;
                    }
                    case 4: {
                        string2 = string3 + string4;
                        if (!bl) continue block7;
                        this.nVibrations = Math.max(this.nVibrations, this.parseIntStr(string4));
                        continue block7;
                    }
                }
            }
            if (string == null || string2 == null) continue;
            if (this.connectors.containsKey(string2)) {
                String[] stringArray2 = this.connectors.get(string2);
                stringArray2[1] = string;
                if (this.htBonds == null) continue;
                this.setBond(this.htBonds.get(string2), stringArray2);
                continue;
            }
            String[] stringArray3 = new String[2];
            stringArray3[0] = string;
            this.connectors.put(string2, stringArray3);
        }
    }

    private void setBond(Bond bond, String[] stringArray) {
        bond.atomIndex1 = this.asc.getAtomIndex(stringArray[0]);
        bond.atomIndex2 = this.asc.getAtomIndex(stringArray[1]);
        this.asc.addBond(bond);
    }

    private void processAtomObject() throws Exception {
        this.rd();
        this.parseLineParameters(atomFields, atomFieldMap);
        this.nAtoms = 0;
        while (this.rd() != null && !this.line.startsWith("property_flags:")) {
            String[] stringArray = this.getTokens();
            Atom atom = new Atom();
            block9: for (int i = 0; i < this.fieldCount; ++i) {
                int n = this.fieldTypes[i];
                if (n == 0) continue;
                String string = stringArray[i];
                if (string == null) {
                    Logger.warn("field == null in " + this.line);
                }
                switch (n) {
                    case -1: {
                        atom.atomSerial = PT.parseInt(string);
                        continue block9;
                    }
                    case 1: {
                        atom.elementSymbol = string;
                        atom.atomName = string + atom.atomSerial;
                        continue block9;
                    }
                    case 2: {
                        this.strAtomicNumbers = this.strAtomicNumbers + string + " ";
                        continue block9;
                    }
                    case 3: {
                        atom.formalCharge = this.parseIntStr(string);
                        continue block9;
                    }
                    case 5: {
                        atom.partialCharge = this.parseFloatStr(string);
                        continue block9;
                    }
                    case 4: {
                        this.setAtomCoordTokens(atom, stringArray, i);
                        i += 2;
                    }
                }
            }
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("atom " + atom.atomName + " has invalid/unknown coordinates");
                continue;
            }
            ++this.nAtoms;
            this.asc.addAtomWithMappedSerialNumber(atom);
        }
    }

    private void processBondObject() throws Exception {
        this.rd();
        this.parseLineParameters(bondFields, bondFieldMap);
        while (this.rd() != null && !this.line.startsWith("property_flags:")) {
            String string = null;
            String[] stringArray = this.getTokens();
            block5: for (int i = 0; i < this.fieldCount; ++i) {
                String string2 = stringArray[i];
                switch (this.fieldTypes[i]) {
                    case -1: {
                        string = "bond" + string2;
                        continue block5;
                    }
                    case 1: {
                        int n = 1;
                        if (string2.equals("single")) {
                            n = 1;
                        } else if (string2.equals("double")) {
                            n = 2;
                        } else if (string2.equals("triple")) {
                            n = 3;
                        } else {
                            Logger.warn("unknown CSF bond order: " + string2);
                        }
                        Bond bond = new Bond(-1, -1, 1);
                        bond.order = n;
                        if (this.connectors == null) {
                            if (this.htBonds == null) {
                                this.htBonds = new Hashtable<String, Bond>();
                            }
                            this.htBonds.put(string, bond);
                            continue block5;
                        }
                        this.setBond(bond, this.connectors.get(string));
                    }
                }
            }
        }
    }

    private void processVibrationObject() throws Exception {
        int n;
        int n2;
        float[][] fArray = new float[this.nVibrations][this.nAtoms * 3];
        String[] stringArray = new String[this.nVibrations];
        this.rd();
        while (this.line != null && this.parseLineParameters(vibFields, vibFieldMap) > 0) {
            while (this.rd() != null && !this.line.startsWith("property_flags:")) {
                String[] stringArray2 = this.getTokens();
                n2 = -1;
                block7: for (n = 0; n < this.fieldCount; ++n) {
                    String string = stringArray2[n];
                    switch (this.fieldTypes[n]) {
                        case -1: {
                            n2 = this.parseIntStr(string) - 1;
                            continue block7;
                        }
                        case 1: {
                            this.fillCsfArray("normalMode", stringArray2, n, fArray[n2], false);
                            continue block7;
                        }
                        case 2: {
                            stringArray[n2] = string;
                        }
                    }
                }
            }
        }
        for (int i = 0; i < this.nVibrations; ++i) {
            if (!this.doGetVibration(i + 1)) continue;
            this.asc.cloneAtomSetWithBonds(false);
            this.asc.setAtomSetFrequency(null, null, stringArray[i], null);
            n2 = 0;
            n = this.nAtoms * (i + 1);
            for (int j = 0; j < this.nAtoms; ++j) {
                this.asc.addVibrationVector(n + j, fArray[i][n2++], fArray[i][n2++], fArray[i][n2++]);
            }
        }
    }

    private void processMolecularOrbitalObject() throws Exception {
        if (this.nSlaters == 0 && this.nGaussians == 0 || !this.doReadMolecularOrbitals) {
            this.rd();
            return;
        }
        this.nOrbitals = this.nSlaters + this.nGaussians;
        Logger.info("Reading CSF data for " + this.nOrbitals + " molecular orbitals");
        float[] fArray = new float[this.nOrbitals];
        float[] fArray2 = new float[this.nOrbitals];
        float[][] fArray3 = new float[this.nOrbitals][this.nOrbitals];
        float[][] fArray4 = null;
        int[][] nArray = null;
        int n = 0;
        boolean bl = false;
        this.rd();
        while (this.line != null && this.parseLineParameters(moFields, moFieldMap) > 0) {
            while (this.rd() != null && !this.line.startsWith("property_flags:")) {
                String[] stringArray = this.getTokens();
                block10: for (int i = 0; i < this.fieldCount; ++i) {
                    switch (this.fieldTypes[i]) {
                        case -1: {
                            n = this.parseIntStr(stringArray[i]) - 1;
                            continue block10;
                        }
                        case 1: {
                            fArray[n] = this.parseFloatStr(stringArray[i]);
                            continue block10;
                        }
                        case 2: {
                            fArray2[n] = this.parseFloatStr(stringArray[i]);
                            continue block10;
                        }
                        case 3: {
                            this.fillCsfArray("eig_vec", stringArray, i, fArray3[n], false);
                            continue block10;
                        }
                        case 4: {
                            bl = true;
                            if (fArray4 == null) {
                                fArray4 = new float[this.nOrbitals][this.nOrbitals];
                            }
                            this.fillCsfArray("eig_vec_compressed", stringArray, i, fArray4[n], false);
                            continue block10;
                        }
                        case 5: {
                            if (nArray == null) {
                                nArray = new int[this.nOrbitals][this.nOrbitals];
                            }
                            this.fillCsfArray("coef_indices", stringArray, i, nArray[n], true);
                        }
                    }
                }
            }
        }
        for (int i = 0; i < this.nOrbitals; ++i) {
            if (bl) {
                int n2;
                for (int j = 0; j < nArray[i].length && (n2 = nArray[i][j] - 1) >= 0; ++j) {
                    fArray3[i][n2] = fArray4[i][j];
                }
            }
            for (int j = 0; j < this.nOrbitals; ++j) {
                if (!(Math.abs(fArray3[i][j]) < 1.0E-4f)) continue;
                fArray3[i][j] = 0.0f;
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("energy", Float.valueOf(fArray[i]));
            hashtable.put("occupancy", Float.valueOf(fArray2[i]));
            hashtable.put("coefficients", fArray3[i]);
            this.setMO(hashtable);
        }
        this.setMOs("eV");
    }

    private void processBasisObject(String string) throws Exception {
        int n;
        String[] stringArray;
        int n2;
        int n3;
        String[] stringArray2 = PT.getTokens(this.strAtomicNumbers);
        this.atomicNumbers = new int[stringArray2.length];
        for (n3 = 0; n3 < this.atomicNumbers.length; ++n3) {
            this.atomicNumbers[n3] = this.parseIntStr(stringArray2[n3]);
        }
        this.nOrbitals = this.nSlaters + this.nGaussians;
        n3 = string.equals("gto") ? 1 : 0;
        float[][] fArray = AU.newFloat2(this.nOrbitals);
        float[][] fArray2 = null;
        String[] stringArray3 = new String[this.nOrbitals];
        int[] nArray = new int[this.nOrbitals];
        int n4 = 0;
        this.rd();
        while (this.line != null && this.parseLineParameters(moFields, moFieldMap) > 0) {
            if (n4 == 0) {
                n4 = this.getPropertyCount(string + "_exp");
            }
            n2 = 0;
            while (this.rd() != null && !this.line.startsWith("property_flags:")) {
                stringArray = this.getTokens();
                block10: for (n = 0; n < this.fieldCount; ++n) {
                    String string2 = stringArray[n];
                    switch (this.fieldTypes[n]) {
                        case -1: {
                            n2 = this.parseIntStr(string2) - 1;
                            continue block10;
                        }
                        case 6: {
                            stringArray3[n2] = string2;
                            continue block10;
                        }
                        case 7: 
                        case 9: {
                            fArray[n2] = new float[n4];
                            this.fillCsfArray(string + "_exp", stringArray, n, fArray[n2], false);
                            continue block10;
                        }
                        case 10: {
                            nArray[n2] = this.parseIntStr(string2);
                            continue block10;
                        }
                        case 8: {
                            if (fArray2 == null) {
                                fArray2 = new float[this.nOrbitals][n4];
                            }
                            this.fillCsfArray("contractions", stringArray, n, fArray2[n2], false);
                        }
                    }
                }
            }
        }
        if (n3 != 0) {
            Lst<int[]> lst = new Lst<int[]>();
            stringArray = new Lst();
            n = 0;
            int n5 = 0;
            for (int i = 0; i < this.nGaussians; ++i) {
                int n6;
                if (nArray[i] == n) continue;
                n = nArray[i];
                int[] nArray2 = new int[4];
                nArray2[0] = n6 = this.asc.getAtomIndex(this.connectors.get(string + "_basis_fxn" + (i + 1))[0]);
                nArray2[1] = BasisFunctionReader.getQuantumShellTagID(stringArray3[i].substring(0, 1));
                int n7 = 0;
                while (++n7 < n4 && fArray[i][n7] != 0.0f) {
                }
                nArray2[2] = n5;
                nArray2[3] = n7;
                lst.addLast(nArray2);
                n5 += n7;
                for (int j = 0; j < n7; ++j) {
                    stringArray.addLast(new float[]{fArray[i][j], fArray2[i][j]});
                }
            }
            float[][] fArray3 = AU.newFloat2(n5);
            for (int i = 0; i < n5; ++i) {
                fArray3[i] = (float[])stringArray.get(i);
            }
            this.moData.put("shells", lst);
            this.moData.put("gaussians", fArray3);
        } else {
            for (n2 = 0; n2 < this.nSlaters; ++n2) {
                int n8 = this.asc.getAtomIndex(this.connectors.get(string + "_basis_fxn" + (n2 + 1))[0]);
                for (n = 0; n < n4 && fArray[n2][n] != 0.0f; ++n) {
                    this.createSphericalSlaterByType(n8, this.atomicNumbers[n8], stringArray3[n2], fArray[n2][n] * (float)(n == 0 ? 1 : -1), fArray2 == null ? 1.0f : fArray2[n2][n]);
                }
            }
            this.setSlaters(true, false);
        }
    }
}

