/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

public class SelectCommand
extends Command {
    private final Collection<OsmPrimitive> newSelection;
    private Collection<OsmPrimitive> oldSelection;

    public SelectCommand(Collection<OsmPrimitive> collection) {
        this.newSelection = collection;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
    }

    @Override
    public void undoCommand() {
        Main.map.mapView.getEditLayer().data.setSelected(this.oldSelection);
    }

    @Override
    public boolean executeCommand() {
        this.oldSelection = Main.map.mapView.getEditLayer().data.getSelected();
        Main.map.mapView.getEditLayer().data.setSelected(this.newSelection);
        return true;
    }

    @Override
    public String getDescriptionText() {
        int n = this.newSelection != null ? this.newSelection.size() : 0;
        return I18n.trn("Selected {0} object", "Selected {0} objects", n, n);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.newSelection == null ? 0 : this.newSelection.hashCode());
        n = 31 * n + (this.oldSelection == null ? 0 : this.oldSelection.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SelectCommand selectCommand = (SelectCommand)object;
        if (this.newSelection == null ? selectCommand.newSelection != null : !this.newSelection.equals(selectCommand.newSelection)) {
            return false;
        }
        return !(this.oldSelection == null ? selectCommand.oldSelection != null : !this.oldSelection.equals(selectCommand.oldSelection));
    }
}

