/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;

public class SimplePrimitiveId
implements PrimitiveId,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long id;
    private final OsmPrimitiveType type;
    public static final Pattern ID_PATTERN = Pattern.compile("(n|node|w|way|r|rel|relation)[ /]?(\\d+)");
    public static final Pattern MULTIPLE_IDS_PATTERN = Pattern.compile(ID_PATTERN.pattern() + "(-(\\d+))?");

    public SimplePrimitiveId(long l, OsmPrimitiveType osmPrimitiveType) {
        this.id = l;
        this.type = osmPrimitiveType;
    }

    @Override
    public OsmPrimitiveType getType() {
        return this.type;
    }

    @Override
    public long getUniqueId() {
        return this.id;
    }

    @Override
    public boolean isNew() {
        return this.id <= 0L;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.id ^ this.id >>> 32);
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SimplePrimitiveId simplePrimitiveId = (SimplePrimitiveId)object;
        if (this.id != simplePrimitiveId.id) {
            return false;
        }
        return !(this.type == null ? simplePrimitiveId.type != null : !this.type.equals((Object)simplePrimitiveId.type));
    }

    public String toString() {
        return (Object)((Object)this.type) + " " + this.id;
    }

    public static SimplePrimitiveId fromString(String string) {
        Matcher matcher = ID_PATTERN.matcher(string);
        if (matcher.matches()) {
            return new SimplePrimitiveId(Long.parseLong(matcher.group(matcher.groupCount())), SimplePrimitiveId.getOsmPrimitiveType(string.charAt(0)));
        }
        throw new IllegalArgumentException("The string " + string + " does not match the pattern " + ID_PATTERN);
    }

    public static List<SimplePrimitiveId> multipleFromString(String string) {
        Matcher matcher = MULTIPLE_IDS_PATTERN.matcher(string);
        if (matcher.matches()) {
            return SimplePrimitiveId.extractIdsInto(matcher, new ArrayList<SimplePrimitiveId>());
        }
        throw new IllegalArgumentException("The string " + string + " does not match the pattern " + MULTIPLE_IDS_PATTERN);
    }

    public static List<SimplePrimitiveId> fuzzyParse(String string) {
        ArrayList<SimplePrimitiveId> arrayList = new ArrayList<SimplePrimitiveId>();
        Matcher matcher = MULTIPLE_IDS_PATTERN.matcher(string);
        while (matcher.find()) {
            SimplePrimitiveId.extractIdsInto(matcher, arrayList);
        }
        return arrayList;
    }

    private static List<SimplePrimitiveId> extractIdsInto(MatchResult matchResult, List<SimplePrimitiveId> list) {
        OsmPrimitiveType osmPrimitiveType = SimplePrimitiveId.getOsmPrimitiveType(matchResult.group(1).charAt(0));
        String string = matchResult.group(2);
        String string2 = matchResult.group(4);
        if (string2 != null) {
            long l = string2.length() < string.length() ? Long.parseLong(string.substring(0, string.length() - string2.length()) + string2) : Long.parseLong(string2);
            for (long i = Long.parseLong(string); i <= l; ++i) {
                list.add(new SimplePrimitiveId(i, osmPrimitiveType));
            }
        } else {
            list.add(new SimplePrimitiveId(Long.parseLong(string), osmPrimitiveType));
        }
        return list;
    }

    private static OsmPrimitiveType getOsmPrimitiveType(char c) {
        return c == 'n' ? OsmPrimitiveType.NODE : (c == 'w' ? OsmPrimitiveType.WAY : OsmPrimitiveType.RELATION);
    }
}

