/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.io.IOException;
import org.w3c.dom.Element;
import writer2latex.api.Config;
import writer2latex.api.ConverterFactory;
import writer2latex.base.ConverterBase;
import writer2latex.latex.BibConverter;
import writer2latex.latex.BlockConverter;
import writer2latex.latex.CaptionConverter;
import writer2latex.latex.CharStyleConverter;
import writer2latex.latex.ColorConverter;
import writer2latex.latex.DrawConverter;
import writer2latex.latex.FieldConverter;
import writer2latex.latex.HeadingConverter;
import writer2latex.latex.IndexConverter;
import writer2latex.latex.InlineConverter;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocument;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.ListStyleConverter;
import writer2latex.latex.MathConverter;
import writer2latex.latex.NoteConverter;
import writer2latex.latex.PageStyleConverter;
import writer2latex.latex.ParConverter;
import writer2latex.latex.SectionConverter;
import writer2latex.latex.TableConverter;
import writer2latex.latex.i18n.ClassicI18n;
import writer2latex.latex.i18n.I18n;
import writer2latex.latex.i18n.XeTeXI18n;
import writer2latex.latex.util.Context;
import writer2latex.latex.util.Info;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;
import writer2latex.util.ExportNameCollection;
import writer2latex.util.Misc;

public final class ConverterPalette
extends ConverterBase {
    private LaTeXConfig config = new LaTeXConfig();
    private LaTeXDocument texDoc;
    private Context mainContext;
    private CSVList globalOptions;
    private I18n i18n;
    private ColorConverter colorCv;
    private CharStyleConverter charSc;
    private ListStyleConverter listSc;
    private PageStyleConverter pageSc;
    private BlockConverter blockCv;
    private ParConverter parCv;
    private HeadingConverter headingCv;
    private IndexConverter indexCv;
    private BibConverter bibCv;
    private SectionConverter sectionCv;
    private TableConverter tableCv;
    private NoteConverter noteCv;
    private CaptionConverter captionCv;
    private InlineConverter inlineCv;
    private FieldConverter fieldCv;
    private DrawConverter drawCv;
    private MathConverter mathCv;
    private Info info;

    @Override
    public Config getConfig() {
        return this.config;
    }

    public String getOutFileName() {
        return this.sTargetFileName;
    }

    public Context getMainContext() {
        return this.mainContext;
    }

    public void addGlobalOption(String sOption) {
        this.globalOptions.addValue(sOption);
    }

    public I18n getI18n() {
        return this.i18n;
    }

    public ColorConverter getColorCv() {
        return this.colorCv;
    }

    public CharStyleConverter getCharSc() {
        return this.charSc;
    }

    public ListStyleConverter getListSc() {
        return this.listSc;
    }

    public PageStyleConverter getPageSc() {
        return this.pageSc;
    }

    public BlockConverter getBlockCv() {
        return this.blockCv;
    }

    public ParConverter getParCv() {
        return this.parCv;
    }

    public HeadingConverter getHeadingCv() {
        return this.headingCv;
    }

    public IndexConverter getIndexCv() {
        return this.indexCv;
    }

    public BibConverter getBibCv() {
        return this.bibCv;
    }

    public SectionConverter getSectionCv() {
        return this.sectionCv;
    }

    public TableConverter getTableCv() {
        return this.tableCv;
    }

    public NoteConverter getNoteCv() {
        return this.noteCv;
    }

    public CaptionConverter getCaptionCv() {
        return this.captionCv;
    }

    public InlineConverter getInlineCv() {
        return this.inlineCv;
    }

    public FieldConverter getFieldCv() {
        return this.fieldCv;
    }

    public DrawConverter getDrawCv() {
        return this.drawCv;
    }

    public MathConverter getMathCv() {
        return this.mathCv;
    }

    public Info getInfo() {
        return this.info;
    }

    @Override
    public void convertInner() throws IOException {
        StyleWithProperties dpStyle;
        this.sTargetFileName = Misc.trimDocumentName(this.sTargetFileName, ".tex");
        String sSafeTargetFileName = new ExportNameCollection(true).getExportName(this.sTargetFileName);
        this.imageConverter.setBaseFileName(sSafeTargetFileName + "-img");
        if (this.config.saveImagesInSubdir()) {
            this.imageConverter.setUseSubdir(sSafeTargetFileName + "-img");
        }
        if (this.config.getBackend() == 2 || this.config.getBackend() == 4) {
            this.imageConverter.setDefaultFormat("image/png");
            this.imageConverter.setDefaultVectorFormat("application/pdf");
            this.imageConverter.addAcceptedFormat("image/jpeg");
        } else if (this.config.getBackend() == 1) {
            this.imageConverter.setDefaultFormat("image/x-eps");
        }
        if (this.config.getTableSequenceName().length() > 0) {
            this.ofr.addTableSequenceName(this.config.getTableSequenceName());
        }
        if (this.config.getFigureSequenceName().length() > 0) {
            this.ofr.addFigureSequenceName(this.config.getFigureSequenceName());
        }
        this.i18n = this.config.getBackend() != 4 ? new ClassicI18n(this.ofr, this.config, this) : new XeTeXI18n(this.ofr, this.config, this);
        this.colorCv = new ColorConverter(this.ofr, this.config, this);
        this.charSc = new CharStyleConverter(this.ofr, this.config, this);
        this.listSc = new ListStyleConverter(this.ofr, this.config, this);
        this.pageSc = new PageStyleConverter(this.ofr, this.config, this);
        this.blockCv = new BlockConverter(this.ofr, this.config, this);
        this.parCv = new ParConverter(this.ofr, this.config, this);
        this.headingCv = new HeadingConverter(this.ofr, this.config, this);
        this.indexCv = new IndexConverter(this.ofr, this.config, this);
        this.bibCv = new BibConverter(this.ofr, this.config, this);
        this.sectionCv = new SectionConverter(this.ofr, this.config, this);
        this.tableCv = new TableConverter(this.ofr, this.config, this);
        this.noteCv = new NoteConverter(this.ofr, this.config, this);
        this.captionCv = new CaptionConverter(this.ofr, this.config, this);
        this.inlineCv = new InlineConverter(this.ofr, this.config, this);
        this.fieldCv = new FieldConverter(this.ofr, this.config, this);
        this.drawCv = new DrawConverter(this.ofr, this.config, this);
        this.mathCv = new MathConverter(this.ofr, this.config, this);
        this.info = new Info(this.ofr, this.config, this);
        this.texDoc = new LaTeXDocument(this.sTargetFileName, this.config.getWrapLinesAfter(), true);
        if (this.config.getBackend() != 4) {
            this.texDoc.setEncoding(ClassicI18n.writeJavaEncoding(this.config.getInputencoding()));
        } else {
            this.texDoc.setEncoding("UTF-8");
        }
        this.converterResult.addDocument(this.texDoc);
        this.globalOptions = new CSVList(',');
        this.mainContext = new Context();
        this.mainContext.resetFormattingFromStyle(this.ofr.getDefaultParStyle());
        this.mainContext.setInMulticols(this.pageSc.isTwocolumn());
        LaTeXDocumentPortion packages = new LaTeXDocumentPortion(false);
        LaTeXDocumentPortion declarations = new LaTeXDocumentPortion(false);
        LaTeXDocumentPortion body = new LaTeXDocumentPortion(true);
        Element content = this.ofr.getContent();
        this.blockCv.traverseBlockText(content, body, this.mainContext);
        this.noteCv.insertEndnotes(body);
        this.i18n.appendDeclarations(packages, declarations);
        this.colorCv.appendDeclarations(packages, declarations);
        this.noteCv.appendDeclarations(packages, declarations);
        this.charSc.appendDeclarations(packages, declarations);
        this.headingCv.appendDeclarations(packages, declarations);
        this.parCv.appendDeclarations(packages, declarations);
        this.listSc.appendDeclarations(packages, declarations);
        this.pageSc.appendDeclarations(packages, declarations);
        this.blockCv.appendDeclarations(packages, declarations);
        this.indexCv.appendDeclarations(packages, declarations);
        this.bibCv.appendDeclarations(packages, declarations);
        this.sectionCv.appendDeclarations(packages, declarations);
        this.tableCv.appendDeclarations(packages, declarations);
        this.captionCv.appendDeclarations(packages, declarations);
        this.inlineCv.appendDeclarations(packages, declarations);
        this.fieldCv.appendDeclarations(packages, declarations);
        this.drawCv.appendDeclarations(packages, declarations);
        this.mathCv.appendDeclarations(packages, declarations);
        String sCustomPreamble = this.config.getCustomPreamble();
        if (sCustomPreamble.length() > 0) {
            declarations.append(sCustomPreamble).nl();
        }
        this.createMeta("title", this.metaData.getTitle(), declarations);
        if (this.config.metadata()) {
            this.createMeta("author", this.metaData.getCreator(), declarations);
            String sDate = this.metaData.getDate();
            if (sDate != null) {
                this.createMeta("date", Misc.dateOnly(sDate), declarations);
            }
        }
        if (this.config.formatting() >= 3 && (dpStyle = this.ofr.getDefaultParStyle()) != null) {
            String s = dpStyle.getProperty("fo:font-size");
            if ("10pt".equals(s)) {
                this.globalOptions.addValue("10pt");
            }
            if ("11pt".equals(s)) {
                this.globalOptions.addValue("11pt");
            }
            if ("12pt".equals(s)) {
                this.globalOptions.addValue("12pt");
            }
        }
        if (this.config.getGlobalOptions().length() > 0) {
            this.globalOptions.addValue(this.config.getGlobalOptions());
        }
        LaTeXDocumentPortion result = this.texDoc.getContents();
        if (!this.config.noPreamble()) {
            result.append("% This file was converted to LaTeX by Writer2LaTeX ver. " + ConverterFactory.getVersion()).nl().append("% see http://writer2latex.sourceforge.net for more info").nl();
            result.append("\\documentclass");
            if (!this.globalOptions.isEmpty()) {
                result.append("[").append(this.globalOptions.toString()).append("]");
            }
            result.append("{").append(this.config.getDocumentclass()).append("}").nl();
            result.append(packages).append(declarations).append("\\begin{document}").nl();
        }
        result.append(body);
        if (!this.config.noPreamble()) {
            result.append("\\end{document}").nl();
        } else {
            result.append("\\endinput").nl();
        }
        if (this.bibCv.getBibTeXDocument() != null) {
            this.converterResult.addDocument(this.bibCv.getBibTeXDocument());
        }
    }

    private void createMeta(String sName, String sValue, LaTeXDocumentPortion ldp) {
        if (sValue == null) {
            return;
        }
        ldp.append("\\" + sName + "{" + this.i18n.convert(sValue, false, this.mainContext.getLang()) + "}").nl();
    }
}

