/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.business.loaders;

import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.business.IdManager;
import org.pdfsam.guiclient.business.thumbnails.ThumbnailCreatorsRegisty;
import org.pdfsam.guiclient.business.thumbnails.creators.ThumbnailsCreator;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooser;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooserType;
import org.pdfsam.guiclient.commons.panels.JVisualPdfPageSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.DocumentPage;
import org.pdfsam.guiclient.exceptions.ThumbnailCreationException;
import org.pdfsam.guiclient.utils.DialogUtility;
import org.pdfsam.i18n.GettextResource;

public class PdfThumbnailsLoader {
    private static final Logger log = Logger.getLogger(PdfThumbnailsLoader.class.getPackage().getName());
    private JVisualPdfPageSelectionPanel panel;
    private ThumbnailsCreator creator;
    private long id = 0L;

    public PdfThumbnailsLoader(JVisualPdfPageSelectionPanel panel) {
        this.panel = panel;
    }

    public void showFileChooserAndAddFile() throws ThumbnailCreationException {
        JFileChooser fileChooser = SharedJFileChooser.getInstance(SharedJFileChooserType.PDF_FILE, 0);
        if (fileChooser.showOpenDialog(this.panel) == 0 && this.canLoad()) {
            this.addFile(fileChooser.getSelectedFile());
        }
    }

    public boolean canLoad() {
        boolean retVal = true;
        if (this.panel.getThumbnailList().getModel().getSize() >= 1) {
            if (0 == DialogUtility.askForEmptySelectionPanel(this.panel)) {
                this.panel.resetPanel();
            } else {
                retVal = false;
            }
        }
        return retVal;
    }

    public synchronized void addFile(File file, String password, List<DocumentPage> template) throws ThumbnailCreationException {
        this.creator = ThumbnailCreatorsRegisty.getCreator(Configuration.getInstance().getThumbnailsCreatorIdentifier());
        if (this.creator != null) {
            log.debug(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Generating thumbnails using the following library:") + " " + this.creator.getCreatorName());
            this.generateNewId();
            this.creator.initThumbnailsPanel(file, password, this.panel, this.id, template);
        } else {
            log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to initialize the thumbnails creation library."));
        }
    }

    public void addFile(File file, String password) throws ThumbnailCreationException {
        this.addFile(file, password, null);
    }

    public void addFile(File file) throws ThumbnailCreationException {
        this.addFile(file, null);
    }

    public void addFile(File file, boolean checkIfAlreadyAdded) throws ThumbnailCreationException {
        if (!checkIfAlreadyAdded || checkIfAlreadyAdded && this.canLoad()) {
            this.addFile(file);
        }
    }

    public synchronized void cleanCreator() {
        if (this.creator != null) {
            this.creator.clean(this.id);
        }
    }

    private void generateNewId() {
        this.id = IdManager.getInstance().getNewId();
    }

    public long getId() {
        return this.id;
    }
}

