/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.dto;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.Rotation;
import org.pdfsam.guiclient.utils.ConversionUtility;
import org.pdfsam.guiclient.utils.ImageUtility;
import org.pdfsam.guiclient.utils.paper.PaperFormatUtility;

public class VisualPageListItem
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7598120284619680606L;
    private transient BufferedImage thumbnail = ImageUtility.getHourglassImage();
    private int pageNumber;
    private boolean deleted = false;
    private String parentFileCanonicalPath = "";
    private String documentPassword = "";
    private Rotation rotation = Rotation.DEGREES_0;
    private Rotation originalRotation = Rotation.DEGREES_0;
    private String paperFormat = "";

    public VisualPageListItem() {
    }

    public VisualPageListItem(int pageNumber) {
        this(ImageUtility.getHourglassImage(), pageNumber);
    }

    public VisualPageListItem(int pageNumber, String parentFileCanonicalPath) {
        this(ImageUtility.getHourglassImage(), pageNumber, false, parentFileCanonicalPath, null);
    }

    public VisualPageListItem(int pageNumber, String parentFileCanonicalPath, String documentPassword) {
        this(ImageUtility.getHourglassImage(), pageNumber, false, parentFileCanonicalPath, documentPassword);
    }

    public VisualPageListItem(BufferedImage thumbnail, int pageNumber) {
        this(thumbnail, pageNumber, false);
    }

    public VisualPageListItem(BufferedImage thumbnail, int pageNumber, boolean deleted) {
        this(thumbnail, pageNumber, deleted, "", null);
    }

    public VisualPageListItem(BufferedImage thumbnail, int pageNumber, boolean deleted, String parentFileCanonicalPath, String documentPassword) {
        this(thumbnail, pageNumber, deleted, parentFileCanonicalPath, documentPassword, Rotation.DEGREES_0);
    }

    public VisualPageListItem(BufferedImage thumbnail, int pageNumber, boolean deleted, String parentFileCanonicalPath, String documentPassword, Rotation rotation) {
        this.thumbnail = thumbnail;
        this.pageNumber = pageNumber;
        this.deleted = deleted;
        this.parentFileCanonicalPath = parentFileCanonicalPath;
        this.documentPassword = documentPassword;
        this.rotation = rotation;
    }

    public BufferedImage getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(BufferedImage thumbnail) {
        this.thumbnail = thumbnail;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getParentFileCanonicalPath() {
        return this.parentFileCanonicalPath;
    }

    public void setParentFileCanonicalPath(String parentFileCanonicalPath) {
        this.parentFileCanonicalPath = parentFileCanonicalPath;
    }

    public String getDocumentPassword() {
        return this.documentPassword;
    }

    public void setDocumentPassword(String documentPassword) {
        this.documentPassword = documentPassword;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    public void rotateClockwise() {
        this.rotation = this.rotation.rotateClockwise();
        this.thumbnail = ImageUtility.rotateImage(this.thumbnail, 90);
    }

    public void rotateAnticlockwise() {
        this.rotation = this.rotation.rotateAnticlockwise();
        this.thumbnail = ImageUtility.rotateImage(this.thumbnail, 270);
    }

    public boolean isRotated() {
        return this.getCompleteRotation() != Rotation.DEGREES_0.getDegrees();
    }

    public boolean isFullyRotated() {
        return this.getCompleteRotation() == Rotation.DEGREES_180.getDegrees();
    }

    public void setPaperFormat(double width, double height, int resolution) {
        double width2 = Math.round(ConversionUtility.toCentimeters(width / (double)resolution) * 10.0);
        double height2 = Math.round(ConversionUtility.toCentimeters(height / (double)resolution) * 10.0);
        this.paperFormat = PaperFormatUtility.getFormat(width2, height2);
    }

    public void setPaperFormat(double width, double height) {
        this.setPaperFormat(width, height, Configuration.getInstance().getScreenResolution());
    }

    public Object clone() {
        VisualPageListItem retVal = new VisualPageListItem(this.thumbnail, this.pageNumber, this.deleted, this.parentFileCanonicalPath, this.documentPassword, this.rotation);
        retVal.setPaperFormat(this.paperFormat);
        retVal.setOriginalRotation(this.originalRotation);
        return retVal;
    }

    public String getPaperFormat() {
        return this.paperFormat;
    }

    public void setPaperFormat(String paperFormat) {
        this.paperFormat = paperFormat;
    }

    public Rotation getOriginalRotation() {
        return this.originalRotation;
    }

    public void setOriginalRotation(Rotation originalRotation) {
        this.originalRotation = originalRotation;
    }

    public int getCompleteRotation() {
        int retVal = this.rotation.getDegrees();
        if (this.originalRotation != null) {
            retVal += this.originalRotation.getDegrees();
        }
        return retVal %= 360;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(ImageUtility.toByteArray(this.thumbnail));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.thumbnail = ImageUtility.fromByteArray((byte[])in.readObject());
    }
}

