/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.dom.ElementConfigurationException;
import de.intarsys.tools.dom.ElementTools;
import de.intarsys.tools.monitor.Counter;
import de.intarsys.tools.monitor.CounterMonitorTrace;
import de.intarsys.tools.monitor.Monitor;
import de.intarsys.tools.monitor.MonitorTrace;
import org.w3c.dom.Element;

public class CounterMonitor
extends Monitor {
    private String counterName;
    private Counter counter;

    public CounterMonitor() {
    }

    public CounterMonitor(String string) {
        super(string);
    }

    public CounterMonitor(String string, Counter counter) {
        super(string);
        this.counter = counter;
    }

    @Override
    public void configure(Element element) throws ElementConfigurationException {
        super.configure(element);
        this.counterName = ElementTools.getPathString(element, "countername", null);
        if (this.counterName == null) {
            throw new ElementConfigurationException("<countername> may not be null");
        }
        this.counter = Counter.get(this.counterName);
    }

    @Override
    protected CounterMonitorTrace createMonitorTrace() {
        return new CounterMonitorTrace(this);
    }

    @Override
    protected void doCalculation(MonitorTrace monitorTrace) {
        if (monitorTrace.getStart() < this.statistic.min) {
            this.statistic.min = monitorTrace.getStart();
        }
        if (monitorTrace.getStop() < this.statistic.min) {
            this.statistic.min = monitorTrace.getStop();
        }
        if (monitorTrace.getStart() > this.statistic.max) {
            this.statistic.max = monitorTrace.getStart();
        }
        if (monitorTrace.getStop() > this.statistic.max) {
            this.statistic.max = monitorTrace.getStop();
        }
        this.statistic.total = this.last - this.first;
        this.statistic.avg = (this.statistic.avg * this.statistic.count + monitorTrace.getStop()) / (this.statistic.count + 1L);
        ++this.statistic.count;
    }

    public Counter getCounter() {
        return this.counter;
    }
}

