/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.graphics.SoftMask;
import org.icepdf.core.util.Library;

public class ExtGState
extends Dictionary {
    private static final Logger logger = Logger.getLogger(ExtGState.class.toString());

    public ExtGState(Library library, Hashtable graphicsState) {
        super(library, graphicsState);
    }

    Number getLineWidth() {
        return this.getNumber("LW");
    }

    Number getLineCapStyle() {
        return this.getNumber("LC");
    }

    Number getLineJoinStyle() {
        return this.getNumber("LJ");
    }

    Number getMiterLimit() {
        return this.getNumber("ML");
    }

    Vector getLineDashPattern() {
        Vector<Object> dashPattern = null;
        Number dashPhase = new Float(0.0f);
        float[] dashArray = null;
        if (this.entries.containsKey("D")) {
            try {
                Vector dashData = (Vector)this.entries.get("D");
                dashPhase = (Number)dashData.elementAt(1);
                Vector dashVector = (Vector)dashData.elementAt(0);
                if (dashVector.size() > 0) {
                    int sz = dashVector.size();
                    dashArray = new float[sz];
                    for (int i = 0; i < sz; ++i) {
                        dashArray[i] = ((Number)dashVector.get(i)).floatValue();
                    }
                } else {
                    dashPhase = new Float(0.0f);
                    dashArray = null;
                }
                dashPattern = new Vector<Object>(2);
                dashPattern.add(dashArray);
                dashPattern.add(dashPhase);
            }
            catch (ClassCastException e) {
                logger.log(Level.FINE, "Dash pattern syntax error: ", e);
            }
        }
        return dashPattern;
    }

    Number getStrokingAlphConstant() {
        return this.getNumber("CA");
    }

    Number getNonStrokingAlphConstant() {
        return this.getNumber("ca");
    }

    Boolean getOverprint() {
        Object o = this.getObject("OP");
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return null;
    }

    Boolean getOverprintFill() {
        Object o = this.getObject("op");
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return null;
    }

    Number getOverprintMode() {
        return this.getNumber("OPM");
    }

    public SoftMask getSMask() {
        Object tmp = this.library.getObject(this.entries, "SMask");
        if (tmp != null && tmp instanceof Hashtable) {
            SoftMask softMask = new SoftMask(this.library, (Hashtable)tmp);
            return softMask;
        }
        return null;
    }
}

