/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.dto.commands;

import java.io.File;
import org.pdfsam.console.business.dto.PageRotation;
import org.pdfsam.console.business.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;

public class ConcatParsedCommand
extends AbstractParsedCommand {
    private static final long serialVersionUID = 2204294454175542123L;
    public static final String F_ARG = "f";
    public static final String COPYFIELDS_ARG = "copyfields";
    public static final String L_ARG = "l";
    public static final String U_ARG = "u";
    public static final String O_ARG = "o";
    public static final String R_ARG = "r";
    public static final String D_ARG = "d";
    private File outputFile;
    private File inputCvsOrXmlFile;
    private File inputDirectory;
    private PdfFile[] inputFileList;
    private String[] pageSelections;
    private PageRotation[] rotations = null;
    private boolean copyFields = false;

    public ConcatParsedCommand() {
    }

    public ConcatParsedCommand(File outputFile, File inputCvsOrXmlFile, PdfFile[] inputFileList, String[] pageSelections, boolean copyFields, PageRotation[] rotations, File inputDirectory) {
        this.outputFile = outputFile;
        this.inputCvsOrXmlFile = inputCvsOrXmlFile;
        this.inputFileList = inputFileList;
        this.pageSelections = pageSelections;
        this.copyFields = copyFields;
        this.rotations = rotations;
        this.inputDirectory = inputDirectory;
    }

    public ConcatParsedCommand(File outputFile, File inputCvsOrXmlFile, PdfFile[] inputFileList, String[] pageSelections, boolean copyFields, PageRotation[] rotations, File inputDirectory, boolean overwrite, boolean compress, char outputPdfVersion) {
        super(overwrite, compress, outputPdfVersion);
        this.outputFile = outputFile;
        this.inputCvsOrXmlFile = inputCvsOrXmlFile;
        this.inputFileList = inputFileList;
        this.pageSelections = pageSelections;
        this.copyFields = copyFields;
        this.rotations = rotations;
        this.inputDirectory = inputDirectory;
    }

    public ConcatParsedCommand(File outputFile, File inputCvsOrXmlFile, PdfFile[] inputFileList, String pageSelection, boolean copyFields, PageRotation[] rotations, File inputDirectory, boolean overwrite, boolean compress, File logFile, char outputPdfVersion) {
        super(overwrite, compress, logFile, outputPdfVersion);
        this.outputFile = outputFile;
        this.inputCvsOrXmlFile = inputCvsOrXmlFile;
        this.inputFileList = inputFileList;
        this.copyFields = copyFields;
        this.rotations = rotations;
        this.inputDirectory = inputDirectory;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public File getInputCvsOrXmlFile() {
        return this.inputCvsOrXmlFile;
    }

    public void setInputCvsOrXmlFile(File inputCvsOrXmlFile) {
        this.inputCvsOrXmlFile = inputCvsOrXmlFile;
    }

    public PdfFile[] getInputFileList() {
        return this.inputFileList;
    }

    public void setInputFileList(PdfFile[] inputFileList) {
        this.inputFileList = inputFileList;
    }

    public String[] getPageSelections() {
        return this.pageSelections;
    }

    public void setPageSelections(String[] pageSelections) {
        this.pageSelections = pageSelections;
    }

    public boolean isCopyFields() {
        return this.copyFields;
    }

    public void setCopyFields(boolean copyFields) {
        this.copyFields = copyFields;
    }

    public PageRotation[] getRotations() {
        return this.rotations;
    }

    public void setRotations(PageRotation[] rotations) {
        this.rotations = rotations;
    }

    public File getInputDirectory() {
        return this.inputDirectory;
    }

    public void setInputDirectory(File inputDirectory) {
        this.inputDirectory = inputDirectory;
    }

    public final String getCommand() {
        return "concat";
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer();
        retVal.append(super.toString());
        retVal.append(this.outputFile == null ? "" : "[outputFile=" + this.outputFile.getAbsolutePath() + "]");
        retVal.append(this.inputDirectory == null ? "" : "[inputDirectory=" + this.inputDirectory.getAbsolutePath() + "]");
        if (this.inputFileList != null) {
            for (int i = 0; i < this.inputFileList.length; ++i) {
                retVal.append(this.inputFileList[i] == null ? "" : "[inputFileList[" + i + "]=" + this.inputFileList[i].getFile().getAbsolutePath() + "]");
            }
        }
        if (this.rotations != null) {
            retVal.append("[rotations.length=" + this.rotations.length + "]");
        }
        retVal.append(this.inputCvsOrXmlFile == null ? "" : "[inputCvsOrXmlFile=" + this.inputCvsOrXmlFile.getAbsolutePath() + "]");
        if (this.pageSelections != null) {
            retVal.append("[pageSelections=" + this.pageSelections + "]");
        }
        retVal.append("[copyFields=" + this.copyFields + "]");
        retVal.append("[command=" + this.getCommand() + "]");
        return retVal.toString();
    }
}

