/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.utils;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.pdfsam.console.business.dto.PdfFile;

public final class PdfUtility {
    private PdfUtility() {
    }

    public static int getMaxBookmarksDepth(InputStream bookmarks) throws Exception {
        int retVal = 0;
        if (bookmarks != null) {
            SAXReader reader = new SAXReader();
            Document document = reader.read(bookmarks);
            StringBuffer buffer = new StringBuffer("/Bookmark/Title[@Action=\"GoTo\"]");
            List nodes = document.selectNodes(buffer.toString());
            while (nodes != null && nodes.size() > 0) {
                ++retVal;
                buffer.append("/Title[@Action=\"GoTo\"]");
                nodes = document.selectNodes(buffer.toString());
            }
        }
        return retVal;
    }

    public static PdfReader readerFor(PdfFile file) throws IOException, NoSuchFieldException, IllegalAccessException {
        PdfReader reader = new PdfReader(new RandomAccessFileOrArray(file.getFile().getAbsolutePath()), file.getPasswordBytes());
        PdfUtility.unethical(reader);
        return reader;
    }

    public static PdfReader fullReaderFor(PdfFile file) throws IOException, NoSuchFieldException, IllegalAccessException {
        PdfReader reader = new PdfReader((InputStream)new FileInputStream(file.getFile()), file.getPasswordBytes());
        PdfUtility.unethical(reader);
        return reader;
    }

    private static void unethical(PdfReader reader) throws NoSuchFieldException, IllegalAccessException {
        if (!reader.isOpenedWithFullPermissions()) {
            Field field = reader.getClass().getDeclaredField("encrypted");
            field.setAccessible(true);
            field.setBoolean(reader, false);
        }
    }
}

