/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.pdf.pd.PDCSLab;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtCSCIEBased;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;

public class AwtCSLab
extends AwtCSCIEBased {
    public AwtCSLab(PDColorSpace pDColorSpace) {
        super(pDColorSpace);
    }

    @Override
    protected ColorSpace createColorSpace() {
        return new LabColorSpace();
    }

    @Override
    public ColorModel getColorModel(PDImage pDImage) {
        return new ComponentColorModel(this.getColorSpace(), false, false, 1, 0);
    }

    @Override
    public int getNumComponents() {
        return 3;
    }

    protected PDCSLab myPDColorSpace() {
        return (PDCSLab)this.getPDColorSpace();
    }

    class LabColorSpace
    extends ColorSpace {
        LabColorSpace() {
            super(13, 3);
        }

        @Override
        public float[] fromCIEXYZ(float[] fArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] fromRGB(float[] fArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] toCIEXYZ(float[] fArray) {
            float[] fArray2 = AwtCSLab.this.myPDColorSpace().getWhitePoint();
            float f = (fArray[0] + 16.0f) / 116.0f + fArray[1] / 500.0f;
            float f2 = (fArray[0] + 16.0f) / 116.0f;
            float f3 = (fArray[0] + 16.0f) / 116.0f - fArray[2] / 200.0f;
            float f4 = fArray2[0] * (f >= 0.20689656f ? (float)Math.pow(f, 3.0) : 0.12841855f * (f - 0.13793103f));
            float f5 = fArray2[1] * (f2 >= 0.20689656f ? (float)Math.pow(f2, 3.0) : 0.12841855f * (f2 - 0.13793103f));
            float f6 = fArray2[2] * (f3 >= 0.20689656f ? (float)Math.pow(f3, 3.0) : 0.12841855f * (f3 - 0.13793103f));
            return new float[]{Math.max(Math.min(f4, 1.0f), 0.0f), Math.max(Math.min(f5, 1.0f), 0.0f), Math.max(Math.min(f6, 1.0f), 0.0f)};
        }

        @Override
        public float[] toRGB(float[] fArray) {
            return ColorSpace.getInstance(1001).toRGB(this.toCIEXYZ(fArray));
        }
    }
}

