/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.plugin.split.GUI;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pdfsam.guiclient.business.listeners.EnterDoClickListener;
import org.pdfsam.guiclient.commons.business.listeners.CompressCheckBoxItemListener;
import org.pdfsam.guiclient.commons.components.CommonComponentsFactory;
import org.pdfsam.guiclient.commons.components.JPdfVersionCombo;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooser;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooserType;
import org.pdfsam.guiclient.commons.panels.JPdfSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.guiclient.dto.StringItem;
import org.pdfsam.guiclient.exceptions.LoadJobException;
import org.pdfsam.guiclient.exceptions.SaveJobException;
import org.pdfsam.guiclient.gui.components.JHelpLabel;
import org.pdfsam.guiclient.plugins.interfaces.AbstractPlugablePanel;
import org.pdfsam.i18n.GettextResource;
import org.pdfsam.plugin.split.components.JBLevelCombo;
import org.pdfsam.plugin.split.components.JSplitRadioButton;
import org.pdfsam.plugin.split.components.JSplitRadioButtonModel;
import org.pdfsam.plugin.split.components.JSplitSizeCombo;
import org.pdfsam.plugin.split.listeners.RadioListener;
import org.pdfsam.plugin.split.listeners.RunButtonActionListener;

public class SplitMainGUI
extends AbstractPlugablePanel {
    private static final long serialVersionUID = -5907189950338614835L;
    private static final Logger log = Logger.getLogger((String)SplitMainGUI.class.getPackage().getName());
    private JTextField outPrefixText = CommonComponentsFactory.getInstance().createTextField(3);
    private SpringLayout outputPanelLayout;
    private SpringLayout destinationPanelLayout;
    private JTextField destinationFolderText = CommonComponentsFactory.getInstance().createTextField(1);
    private JTextField thisPageTextField = CommonComponentsFactory.getInstance().createTextField(0);
    private JTextField nPagesTextField = CommonComponentsFactory.getInstance().createTextField(0);
    private JHelpLabel checksHelpLabel;
    private SpringLayout optionsPaneLayout;
    private JHelpLabel prefixHelpLabel;
    private JHelpLabel destinationHelpLabel;
    private SpringLayout splitSpringLayout;
    private String splitType = "";
    private JPdfVersionCombo versionCombo = new JPdfVersionCombo(true);
    private Configuration config;
    private JPdfSelectionPanel selectionPanel = new JPdfSelectionPanel(1, 6, false, false);
    private JSplitSizeCombo splitSizeCombo = new JSplitSizeCombo();
    private JBLevelCombo bLevelCombo = new JBLevelCombo(this.selectionPanel);
    private final JButton browseDestButton = CommonComponentsFactory.getInstance().createButton(2);
    private final JButton runButton = CommonComponentsFactory.getInstance().createButton(1);
    private final EnterDoClickListener browsedEnterkeyListener = new EnterDoClickListener(this.browseDestButton);
    private final EnterDoClickListener runEnterkeyListener = new EnterDoClickListener(this.runButton);
    private final JSplitRadioButton burstRadio = new JSplitRadioButton("BURST");
    private final JSplitRadioButton everyNRadio = new JSplitRadioButton("NSPLIT");
    private final JSplitRadioButton evenRadio = new JSplitRadioButton("EVEN");
    private final JSplitRadioButton oddRadio = new JSplitRadioButton("ODD");
    private final JSplitRadioButton thisPageRadio = new JSplitRadioButton("SPLIT");
    private final JSplitRadioButton sizeRadio = new JSplitRadioButton("SIZE");
    private final JSplitRadioButton bookmarksLevel = new JSplitRadioButton("BLEVEL");
    private RadioListener radioListener;
    private final JRadioButton sameAsSourceRadio = new JRadioButton();
    private final JRadioButton chooseAFolderRadio = new JRadioButton();
    private ButtonGroup splitOptionsRadioGroup;
    private final JCheckBox overwriteCheckbox = CommonComponentsFactory.getInstance().createCheckBox(1);
    private final JCheckBox outputCompressedCheck = CommonComponentsFactory.getInstance().createCheckBox(2);
    private final SplitFocusPolicy splitFocusPolicy = new SplitFocusPolicy();
    private final JPanel splitOptionsPanel = new JPanel();
    private final JPanel destinationPanel = new JPanel();
    private final JPanel outputOptionsPanel = new JPanel();
    private final JPanel splitTypesPanel = new JPanel();
    private final JLabel outPrefixLabel = new JLabel();
    private final JLabel outputVersionLabel = CommonComponentsFactory.getInstance().createLabel(1);
    private final String PLUGIN_AUTHOR = "Andrea Vacondio";
    private final String PLUGIN_VERSION = "0.5.7";

    public SplitMainGUI() {
        this.initialize();
    }

    private void initialize() {
        this.config = Configuration.getInstance();
        this.setPanelIcon("/images/split.png");
        this.setPreferredSize(new Dimension(500, 570));
        this.splitSpringLayout = new SpringLayout();
        this.setLayout(this.splitSpringLayout);
        this.add((Component)this.selectionPanel);
        this.optionsPaneLayout = new SpringLayout();
        this.splitOptionsPanel.setLayout(this.optionsPaneLayout);
        this.splitOptionsPanel.setBorder(BorderFactory.createTitledBorder(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split options")));
        this.add(this.splitOptionsPanel);
        GridLayout splitOptionsLayout = new GridLayout(0, 3, 5, 5);
        this.splitTypesPanel.setLayout(splitOptionsLayout);
        this.burstRadio.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Burst (split into single pages)"));
        this.everyNRadio.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split every \"n\" pages"));
        this.evenRadio.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split even pages"));
        this.oddRadio.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split odd pages"));
        this.nPagesTextField.setEnabled(false);
        this.thisPageRadio.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split after these pages"));
        this.sizeRadio.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split at this size"));
        this.bookmarksLevel.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split by bookmarks level"));
        this.thisPageTextField.setEnabled(false);
        this.splitSizeCombo.setEnabled(false);
        this.bLevelCombo.setEnabled(false);
        this.splitTypesPanel.add(this.burstRadio);
        this.splitTypesPanel.add(this.thisPageRadio);
        this.splitTypesPanel.add(this.thisPageTextField);
        this.splitTypesPanel.add(this.evenRadio);
        this.splitTypesPanel.add(this.everyNRadio);
        this.splitTypesPanel.add(this.nPagesTextField);
        this.splitTypesPanel.add(this.oddRadio);
        this.splitTypesPanel.add(this.sizeRadio);
        this.splitTypesPanel.add(this.splitSizeCombo);
        this.splitTypesPanel.add(new JLabel());
        this.splitTypesPanel.add(this.bookmarksLevel);
        this.splitTypesPanel.add(this.bLevelCombo);
        this.splitOptionsPanel.add(this.splitTypesPanel);
        String helpText = "<html><body><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split options") + "</b><ul>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Burst") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Explode the pdf document into single pages") + ".</li>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split every \"n\" pages") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split the document every \"n\" pages") + ".</li>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split even pages") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split the document every even page") + ".</li>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split odd pages") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split the document every odd page") + ".</li>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split after these pages") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split the document after page numbers (num1-num2-num3..)") + ".</li>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split at this size") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split the document in files of the given size (roughly)") + ".</li>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split by bookmarks level") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split the document at pages referred by bookmarks of the given level") + ".</li>" + "</ul></body></html>";
        this.checksHelpLabel = new JHelpLabel(helpText, true);
        this.splitOptionsPanel.add((Component)this.checksHelpLabel);
        this.radioListener = new RadioListener(this, this.nPagesTextField, this.thisPageTextField, this.splitSizeCombo, this.bLevelCombo);
        this.burstRadio.setActionCommand("disableAll");
        this.burstRadio.addActionListener(this.radioListener);
        this.everyNRadio.setActionCommand("enableFirst");
        this.everyNRadio.addActionListener(this.radioListener);
        this.evenRadio.setActionCommand("disableAll");
        this.evenRadio.addActionListener(this.radioListener);
        this.oddRadio.setActionCommand("disableAll");
        this.oddRadio.addActionListener(this.radioListener);
        this.thisPageRadio.setActionCommand("enableSecond");
        this.thisPageRadio.addActionListener(this.radioListener);
        this.sizeRadio.setActionCommand("enableThird");
        this.sizeRadio.addActionListener(this.radioListener);
        this.bookmarksLevel.setActionCommand("enableFourth");
        this.bookmarksLevel.addActionListener(this.radioListener);
        this.destinationPanelLayout = new SpringLayout();
        this.destinationPanel.setLayout(this.destinationPanelLayout);
        this.destinationPanel.setBorder(BorderFactory.createTitledBorder(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Destination folder")));
        this.add(this.destinationPanel);
        this.sameAsSourceRadio.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Same as source"));
        this.destinationPanel.add(this.sameAsSourceRadio);
        this.chooseAFolderRadio.setSelected(true);
        this.chooseAFolderRadio.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Choose a folder"));
        this.destinationPanel.add(this.chooseAFolderRadio);
        this.splitOptionsRadioGroup = new ButtonGroup();
        this.splitOptionsRadioGroup.add(this.burstRadio);
        this.splitOptionsRadioGroup.add(this.everyNRadio);
        this.splitOptionsRadioGroup.add(this.evenRadio);
        this.splitOptionsRadioGroup.add(this.oddRadio);
        this.splitOptionsRadioGroup.add(this.thisPageRadio);
        this.splitOptionsRadioGroup.add(this.sizeRadio);
        this.splitOptionsRadioGroup.add(this.bookmarksLevel);
        ButtonGroup outputRadioGroup = new ButtonGroup();
        outputRadioGroup.add(this.sameAsSourceRadio);
        outputRadioGroup.add(this.chooseAFolderRadio);
        this.destinationPanel.add(this.destinationFolderText);
        this.destinationPanel.add(this.overwriteCheckbox);
        this.destinationPanel.add(this.outputCompressedCheck);
        this.outputCompressedCheck.addItemListener((ItemListener)new CompressCheckBoxItemListener(this.versionCombo));
        this.outputCompressedCheck.setSelected(true);
        this.destinationPanel.add((Component)this.versionCombo);
        this.destinationPanel.add(this.outputVersionLabel);
        this.browseDestButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File chosenFile;
                JFileChooser fileChooser = SharedJFileChooser.getInstance((SharedJFileChooserType)SharedJFileChooserType.NO_FILTER, (int)1, (String)SplitMainGUI.this.destinationFolderText.getText());
                if (fileChooser.showOpenDialog(SplitMainGUI.this.browseDestButton.getParent()) == 0 && (chosenFile = fileChooser.getSelectedFile()) != null) {
                    SplitMainGUI.this.destinationFolderText.setText(chosenFile.getAbsolutePath());
                }
            }
        });
        this.destinationPanel.add(this.browseDestButton);
        String helpTextDest = "<html><body><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Destination output directory") + "</b>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Use the same output folder as the input file or choose a folder.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"To choose a folder browse or enter the full path to the destination output directory.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Check the box if you want to overwrite the output files if they already exist.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Check the box if you want compressed output files.") + " " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"PDF version 1.5 or above.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Set the pdf version of the ouput document.") + "</p>" + "</body></html>";
        this.destinationHelpLabel = new JHelpLabel(helpTextDest, true);
        this.destinationPanel.add((Component)this.destinationHelpLabel);
        this.outputOptionsPanel.setBorder(BorderFactory.createTitledBorder(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Output options")));
        this.outputPanelLayout = new SpringLayout();
        this.outputOptionsPanel.setLayout(this.outputPanelLayout);
        this.add(this.outputOptionsPanel);
        this.outPrefixLabel.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Output file names prefix:"));
        this.outputOptionsPanel.add(this.outPrefixLabel);
        this.outPrefixText.setPreferredSize(new Dimension(180, 20));
        this.outputOptionsPanel.add(this.outPrefixText);
        String helpTextPrefix = "<html><body><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Output files prefix") + "</b>" + "<p> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"If it contains \"[CURRENTPAGE]\", \"[TIMESTAMP]\", \"[FILENUMBER]\" or \"[BOOKMARK_NAME]\" it performs variable substitution.") + "</p>" + "<p> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Ex. prefix_[BASENAME]_[CURRENTPAGE] generates prefix_FileName_005.pdf.") + "</p>" + "<br><p> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"If it doesn't contain \"[CURRENTPAGE]\", \"[TIMESTAMP]\" or \"[FILENUMBER]\" it generates oldstyle output file names.") + "</p>" + "<br><p> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Available variables") + ": [CURRENTPAGE], [TIMESTAMP], [BASENAME], [FILENUMBER], [BOOKMARK_NAME].</p>" + "</body></html>";
        this.prefixHelpLabel = new JHelpLabel(helpTextPrefix, true);
        this.outputOptionsPanel.add((Component)this.prefixHelpLabel);
        this.runButton.addActionListener((ActionListener)((Object)new RunButtonActionListener(this)));
        this.runButton.setToolTipText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split selected file"));
        this.runButton.setMargin(new Insets(5, 5, 5, 5));
        this.runButton.setSize(new Dimension(88, 25));
        this.add(this.runButton);
        this.sameAsSourceRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SplitMainGUI.this.destinationFolderText.setEnabled(false);
                SplitMainGUI.this.browseDestButton.setEnabled(false);
            }
        });
        this.chooseAFolderRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SplitMainGUI.this.destinationFolderText.setEnabled(true);
                SplitMainGUI.this.browseDestButton.setEnabled(true);
            }
        });
        this.browseDestButton.addKeyListener((KeyListener)this.browsedEnterkeyListener);
        this.runButton.addKeyListener((KeyListener)this.runEnterkeyListener);
        this.outPrefixText.addKeyListener((KeyListener)this.runEnterkeyListener);
        this.setLayout();
    }

    public String getPluginAuthor() {
        return "Andrea Vacondio";
    }

    public String getPluginName() {
        return GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split");
    }

    public String getVersion() {
        return "0.5.7";
    }

    public Node getJobNode(Node arg0, boolean savePasswords) throws SaveJobException {
        try {
            if (arg0 != null) {
                Element fileSource = ((Element)arg0).addElement("source");
                PdfSelectionTableItem[] items = this.selectionPanel.getTableRows();
                if (items != null && items.length > 0) {
                    fileSource.addAttribute("value", items[0].getInputFile().getAbsolutePath());
                    if (savePasswords) {
                        fileSource.addAttribute("password", items[0].getPassword());
                    }
                }
                Element splitOption = ((Element)arg0).addElement("split_option");
                if (this.splitOptionsRadioGroup.getSelection() != null) {
                    splitOption.addAttribute("value", ((JSplitRadioButtonModel)this.splitOptionsRadioGroup.getSelection()).getSplitCommand());
                }
                Element splitNpages = ((Element)arg0).addElement("npages");
                splitNpages.addAttribute("value", this.nPagesTextField.getText());
                Element splitThispage = ((Element)arg0).addElement("thispage");
                splitThispage.addAttribute("value", this.thisPageTextField.getText());
                Element splitSize = ((Element)arg0).addElement("splitsize");
                splitSize.addAttribute("value", this.splitSizeCombo.getSelectedItem().toString());
                Element bookLevel = ((Element)arg0).addElement("bookmarkslevel");
                if (this.bLevelCombo.getSelectedItem() != null) {
                    bookLevel.addAttribute("value", this.bLevelCombo.getSelectedItem().toString());
                }
                Element fileDestination = ((Element)arg0).addElement("destination");
                fileDestination.addAttribute("value", this.destinationFolderText.getText());
                Element filePrefix = ((Element)arg0).addElement("prefix");
                filePrefix.addAttribute("value", this.outPrefixText.getText());
                Element file_overwrite = ((Element)arg0).addElement("overwrite");
                file_overwrite.addAttribute("value", this.overwriteCheckbox.isSelected() ? TRUE : FALSE);
                Element fileCompress = ((Element)arg0).addElement("compressed");
                fileCompress.addAttribute("value", this.outputCompressedCheck.isSelected() ? TRUE : FALSE);
                Element pdfVersion = ((Element)arg0).addElement("pdfversion");
                pdfVersion.addAttribute("value", ((StringItem)this.versionCombo.getSelectedItem()).getId());
            }
            return arg0;
        }
        catch (Exception ex) {
            throw new SaveJobException((Throwable)ex);
        }
    }

    public void loadJobNode(Node arg0) throws LoadJobException {
        try {
            Node pdfVersion;
            Node filePrefix;
            Node fileCompressed;
            Node fileDestination;
            Node bookLevel;
            Node splitSize;
            Node splitThispage;
            Node splitNpages;
            Node splitOption;
            Node fileSource = arg0.selectSingleNode("source/@value");
            if (fileSource != null && fileSource.getText().length() > 0) {
                Node filePwd = arg0.selectSingleNode("source/@password");
                String password = null;
                if (filePwd != null && filePwd.getText().length() > 0) {
                    password = filePwd.getText();
                }
                this.selectionPanel.getLoader().addFile(new File(fileSource.getText()), password);
            }
            if ((splitOption = arg0.selectSingleNode("split_option/@value")) != null) {
                if (splitOption.getText().equals(this.burstRadio.getSplitCommand())) {
                    this.burstRadio.doClick();
                } else if (splitOption.getText().equals(this.everyNRadio.getSplitCommand())) {
                    this.everyNRadio.doClick();
                } else if (splitOption.getText().equals(this.evenRadio.getSplitCommand())) {
                    this.evenRadio.doClick();
                } else if (splitOption.getText().equals(this.oddRadio.getSplitCommand())) {
                    this.oddRadio.doClick();
                } else if (splitOption.getText().equals(this.thisPageRadio.getSplitCommand())) {
                    this.thisPageRadio.doClick();
                } else if (splitOption.getText().equals(this.sizeRadio.getSplitCommand())) {
                    this.sizeRadio.doClick();
                } else if (splitOption.getText().equals(this.bookmarksLevel.getSplitCommand())) {
                    this.bookmarksLevel.doClick();
                }
            }
            if ((splitNpages = arg0.selectSingleNode("npages/@value")) != null) {
                this.nPagesTextField.setText(splitNpages.getText());
            }
            if ((splitThispage = arg0.selectSingleNode("thispage/@value")) != null) {
                this.thisPageTextField.setText(splitThispage.getText());
            }
            if ((splitSize = arg0.selectSingleNode("splitsize/@value")) != null) {
                this.splitSizeCombo.setSelectedItem(splitSize.getText());
            }
            if ((bookLevel = arg0.selectSingleNode("bookmarkslevel/@value")) != null) {
                this.bLevelCombo.setSelectedItem(bookLevel.getText());
            }
            if ((fileDestination = arg0.selectSingleNode("destination/@value")) != null && fileDestination.getText().length() > 0) {
                this.destinationFolderText.setText(fileDestination.getText());
                this.chooseAFolderRadio.doClick();
            } else {
                this.sameAsSourceRadio.doClick();
            }
            Node fileOverwrite = arg0.selectSingleNode("overwrite/@value");
            if (fileOverwrite != null) {
                this.overwriteCheckbox.setSelected(TRUE.equals(fileOverwrite.getText()));
            }
            if ((fileCompressed = arg0.selectSingleNode("compressed/@value")) != null && TRUE.equals(fileCompressed.getText())) {
                this.outputCompressedCheck.doClick();
            }
            if ((filePrefix = arg0.selectSingleNode("prefix/@value")) != null) {
                this.outPrefixText.setText(filePrefix.getText());
            }
            if ((pdfVersion = arg0.selectSingleNode("pdfversion/@value")) != null) {
                for (int i = 0; i < this.versionCombo.getItemCount(); ++i) {
                    if (!((StringItem)this.versionCombo.getItemAt(i)).getId().equals(pdfVersion.getText())) continue;
                    this.versionCombo.setSelectedIndex(i);
                    break;
                }
            }
            log.info((Object)GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Split section loaded."));
        }
        catch (Exception ex) {
            log.error((Object)GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Error: "), (Throwable)ex);
        }
    }

    private void setLayout() {
        this.splitSpringLayout.putConstraint("South", (Component)this.selectionPanel, 115, "North", (Component)((Object)this));
        this.splitSpringLayout.putConstraint("East", (Component)this.selectionPanel, 0, "East", (Component)((Object)this));
        this.splitSpringLayout.putConstraint("North", (Component)this.selectionPanel, 0, "North", (Component)((Object)this));
        this.splitSpringLayout.putConstraint("West", (Component)this.selectionPanel, 0, "West", (Component)((Object)this));
        this.splitSpringLayout.putConstraint("South", (Component)this.splitOptionsPanel, 145, "North", (Component)this.splitOptionsPanel);
        this.splitSpringLayout.putConstraint("East", (Component)this.splitOptionsPanel, 0, "East", (Component)((Object)this));
        this.splitSpringLayout.putConstraint("North", (Component)this.splitOptionsPanel, 20, "South", (Component)this.selectionPanel);
        this.splitSpringLayout.putConstraint("West", (Component)this.splitOptionsPanel, 0, "West", (Component)this.selectionPanel);
        this.splitSpringLayout.putConstraint("South", (Component)this.destinationPanel, 160, "North", (Component)this.destinationPanel);
        this.splitSpringLayout.putConstraint("East", (Component)this.destinationPanel, 0, "East", (Component)this.splitOptionsPanel);
        this.splitSpringLayout.putConstraint("North", (Component)this.destinationPanel, 10, "South", (Component)this.splitOptionsPanel);
        this.splitSpringLayout.putConstraint("West", (Component)this.destinationPanel, 0, "West", (Component)this.splitOptionsPanel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.sameAsSourceRadio, 25, "North", (Component)this.sameAsSourceRadio);
        this.destinationPanelLayout.putConstraint("North", (Component)this.sameAsSourceRadio, 0, "North", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("West", (Component)this.sameAsSourceRadio, 10, "West", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.chooseAFolderRadio, 0, "South", (Component)this.sameAsSourceRadio);
        this.destinationPanelLayout.putConstraint("North", (Component)this.chooseAFolderRadio, 0, "North", (Component)this.sameAsSourceRadio);
        this.destinationPanelLayout.putConstraint("West", (Component)this.chooseAFolderRadio, 20, "East", (Component)this.sameAsSourceRadio);
        this.destinationPanelLayout.putConstraint("South", (Component)this.destinationFolderText, 50, "North", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("North", (Component)this.destinationFolderText, 30, "North", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("East", (Component)this.destinationFolderText, -105, "East", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("West", (Component)this.destinationFolderText, 5, "West", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.overwriteCheckbox, 17, "North", (Component)this.overwriteCheckbox);
        this.destinationPanelLayout.putConstraint("North", (Component)this.overwriteCheckbox, 5, "South", (Component)this.destinationFolderText);
        this.destinationPanelLayout.putConstraint("West", (Component)this.overwriteCheckbox, 0, "West", (Component)this.destinationFolderText);
        this.destinationPanelLayout.putConstraint("South", (Component)this.outputCompressedCheck, 17, "North", (Component)this.outputCompressedCheck);
        this.destinationPanelLayout.putConstraint("North", (Component)this.outputCompressedCheck, 5, "South", (Component)this.overwriteCheckbox);
        this.destinationPanelLayout.putConstraint("West", (Component)this.outputCompressedCheck, 0, "West", (Component)this.destinationFolderText);
        this.destinationPanelLayout.putConstraint("South", (Component)this.outputVersionLabel, 17, "North", (Component)this.outputVersionLabel);
        this.destinationPanelLayout.putConstraint("North", (Component)this.outputVersionLabel, 8, "South", (Component)this.outputCompressedCheck);
        this.destinationPanelLayout.putConstraint("West", (Component)this.outputVersionLabel, 0, "West", (Component)this.destinationFolderText);
        this.destinationPanelLayout.putConstraint("South", (Component)this.versionCombo, 0, "South", (Component)this.outputVersionLabel);
        this.destinationPanelLayout.putConstraint("West", (Component)this.versionCombo, 2, "East", (Component)this.outputVersionLabel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.browseDestButton, 0, "South", (Component)this.destinationFolderText);
        this.destinationPanelLayout.putConstraint("East", (Component)this.browseDestButton, -10, "East", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("North", (Component)this.browseDestButton, -25, "South", (Component)this.destinationFolderText);
        this.destinationPanelLayout.putConstraint("West", (Component)this.browseDestButton, -98, "East", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.destinationHelpLabel, -1, "South", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("East", (Component)this.destinationHelpLabel, -1, "East", (Component)this.destinationPanel);
        this.splitSpringLayout.putConstraint("South", (Component)this.outputOptionsPanel, 55, "North", (Component)this.outputOptionsPanel);
        this.splitSpringLayout.putConstraint("East", (Component)this.outputOptionsPanel, 0, "East", (Component)this.destinationPanel);
        this.splitSpringLayout.putConstraint("North", (Component)this.outputOptionsPanel, 10, "South", (Component)this.destinationPanel);
        this.splitSpringLayout.putConstraint("West", (Component)this.outputOptionsPanel, 0, "West", (Component)this.destinationPanel);
        this.outputPanelLayout.putConstraint("South", (Component)this.outPrefixLabel, 20, "North", (Component)this.outputOptionsPanel);
        this.outputPanelLayout.putConstraint("North", (Component)this.outPrefixLabel, 0, "North", (Component)this.outputOptionsPanel);
        this.outputPanelLayout.putConstraint("West", (Component)this.outPrefixLabel, 5, "West", (Component)this.outputOptionsPanel);
        this.outputPanelLayout.putConstraint("South", (Component)this.outPrefixText, 0, "South", (Component)this.outPrefixLabel);
        this.outputPanelLayout.putConstraint("West", (Component)this.outPrefixText, 10, "East", (Component)this.outPrefixLabel);
        this.outputPanelLayout.putConstraint("East", (Component)this.outPrefixText, -30, "East", (Component)this.outputOptionsPanel);
        this.outputPanelLayout.putConstraint("South", (Component)this.prefixHelpLabel, -1, "South", (Component)this.outputOptionsPanel);
        this.outputPanelLayout.putConstraint("East", (Component)this.prefixHelpLabel, -1, "East", (Component)this.outputOptionsPanel);
        this.splitSpringLayout.putConstraint("East", (Component)this.runButton, -11, "East", (Component)((Object)this));
        this.splitSpringLayout.putConstraint("North", (Component)this.runButton, 10, "South", (Component)this.outputOptionsPanel);
        this.optionsPaneLayout.putConstraint("North", (Component)this.splitTypesPanel, 0, "North", (Component)this.splitOptionsPanel);
        this.optionsPaneLayout.putConstraint("West", (Component)this.splitTypesPanel, 10, "West", (Component)this.splitOptionsPanel);
        this.optionsPaneLayout.putConstraint("South", (Component)this.checksHelpLabel, -1, "South", (Component)this.splitOptionsPanel);
        this.optionsPaneLayout.putConstraint("East", (Component)this.checksHelpLabel, -1, "East", (Component)this.splitOptionsPanel);
    }

    public void setSplitType(String splitType) {
        this.splitType = splitType;
    }

    public FocusTraversalPolicy getFocusPolicy() {
        return this.splitFocusPolicy;
    }

    public void resetPanel() {
        this.selectionPanel.clearSelectionTable();
        this.destinationFolderText.setText("");
        this.versionCombo.resetComponent();
        this.outputCompressedCheck.setSelected(false);
        this.overwriteCheckbox.setSelected(false);
        this.thisPageTextField.setText("");
        this.nPagesTextField.setText("");
        this.outPrefixText.setText("pdfsam_");
        this.bLevelCombo.resetComponent();
        ButtonModel bmodel = this.splitOptionsRadioGroup.getSelection();
        if (bmodel != null) {
            bmodel.setSelected(false);
        }
        this.chooseAFolderRadio.setSelected(true);
    }

    public JTextField getOutPrefixText() {
        return this.outPrefixText;
    }

    public JTextField getDestinationFolderText() {
        return this.destinationFolderText;
    }

    public JTextField getThisPageTextField() {
        return this.thisPageTextField;
    }

    public JPdfVersionCombo getVersionCombo() {
        return this.versionCombo;
    }

    public JPdfSelectionPanel getSelectionPanel() {
        return this.selectionPanel;
    }

    public JSplitSizeCombo getSplitSizeCombo() {
        return this.splitSizeCombo;
    }

    public JBLevelCombo getbLevelCombo() {
        return this.bLevelCombo;
    }

    public JSplitRadioButton getBookmarksLevel() {
        return this.bookmarksLevel;
    }

    public JCheckBox getOverwriteCheckbox() {
        return this.overwriteCheckbox;
    }

    public String getSplitType() {
        return this.splitType;
    }

    public JRadioButton getSameAsSourceRadio() {
        return this.sameAsSourceRadio;
    }

    public JCheckBox getOutputCompressedCheck() {
        return this.outputCompressedCheck;
    }

    public JTextField getnPagesTextField() {
        return this.nPagesTextField;
    }

    public class SplitFocusPolicy
    extends FocusTraversalPolicy {
        public Component getComponentAfter(Container CycleRootComp, Component aComponent) {
            if (aComponent.equals(SplitMainGUI.this.selectionPanel.getAddFileButton())) {
                return SplitMainGUI.this.selectionPanel.getClearButton();
            }
            if (aComponent.equals(SplitMainGUI.this.selectionPanel.getClearButton())) {
                return SplitMainGUI.this.burstRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.burstRadio)) {
                return SplitMainGUI.this.evenRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.evenRadio)) {
                return SplitMainGUI.this.oddRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.oddRadio)) {
                return SplitMainGUI.this.thisPageRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.thisPageRadio)) {
                if (SplitMainGUI.this.thisPageTextField.isEnabled()) {
                    return SplitMainGUI.this.thisPageTextField;
                }
                return SplitMainGUI.this.everyNRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.thisPageTextField)) {
                return SplitMainGUI.this.everyNRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.everyNRadio)) {
                if (SplitMainGUI.this.nPagesTextField.isEnabled()) {
                    return SplitMainGUI.this.nPagesTextField;
                }
                return SplitMainGUI.this.sizeRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.nPagesTextField)) {
                return SplitMainGUI.this.sizeRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.sizeRadio)) {
                if (SplitMainGUI.this.splitSizeCombo.isEnabled()) {
                    return SplitMainGUI.this.splitSizeCombo;
                }
                return SplitMainGUI.this.bookmarksLevel;
            }
            if (aComponent.equals(SplitMainGUI.this.splitSizeCombo) || aComponent.getParent().equals(SplitMainGUI.this.splitSizeCombo)) {
                return SplitMainGUI.this.bookmarksLevel;
            }
            if (aComponent.equals(SplitMainGUI.this.bookmarksLevel)) {
                if (SplitMainGUI.this.bLevelCombo.isEnabled()) {
                    return SplitMainGUI.this.bLevelCombo.getLevelCombo();
                }
                return SplitMainGUI.this.sameAsSourceRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.bLevelCombo.getLevelCombo()) || aComponent.getParent().equals(SplitMainGUI.this.bLevelCombo.getLevelCombo())) {
                if (SplitMainGUI.this.bLevelCombo.getFillCombo().isEnabled()) {
                    return SplitMainGUI.this.bLevelCombo.getFillCombo();
                }
                return SplitMainGUI.this.sameAsSourceRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.bLevelCombo.getFillCombo())) {
                return SplitMainGUI.this.sameAsSourceRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.sameAsSourceRadio)) {
                return SplitMainGUI.this.chooseAFolderRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.chooseAFolderRadio)) {
                if (SplitMainGUI.this.destinationFolderText.isEnabled()) {
                    return SplitMainGUI.this.destinationFolderText;
                }
                return SplitMainGUI.this.overwriteCheckbox;
            }
            if (aComponent.equals(SplitMainGUI.this.destinationFolderText)) {
                return SplitMainGUI.this.browseDestButton;
            }
            if (aComponent.equals(SplitMainGUI.this.browseDestButton)) {
                return SplitMainGUI.this.overwriteCheckbox;
            }
            if (aComponent.equals(SplitMainGUI.this.overwriteCheckbox)) {
                return SplitMainGUI.this.outputCompressedCheck;
            }
            if (aComponent.equals(SplitMainGUI.this.outputCompressedCheck)) {
                return SplitMainGUI.this.versionCombo;
            }
            if (aComponent.equals(SplitMainGUI.this.versionCombo)) {
                return SplitMainGUI.this.outPrefixText;
            }
            if (aComponent.equals(SplitMainGUI.this.outPrefixText)) {
                return SplitMainGUI.this.runButton;
            }
            if (aComponent.equals(SplitMainGUI.this.runButton)) {
                return SplitMainGUI.this.selectionPanel.getAddFileButton();
            }
            return SplitMainGUI.this.selectionPanel.getAddFileButton();
        }

        public Component getComponentBefore(Container CycleRootComp, Component aComponent) {
            if (aComponent.equals(SplitMainGUI.this.selectionPanel.getAddFileButton())) {
                return SplitMainGUI.this.runButton;
            }
            if (aComponent.equals(SplitMainGUI.this.runButton)) {
                return SplitMainGUI.this.outPrefixText;
            }
            if (aComponent.equals(SplitMainGUI.this.outPrefixText)) {
                return SplitMainGUI.this.versionCombo;
            }
            if (aComponent.equals(SplitMainGUI.this.versionCombo)) {
                return SplitMainGUI.this.outputCompressedCheck;
            }
            if (aComponent.equals(SplitMainGUI.this.outputCompressedCheck)) {
                return SplitMainGUI.this.overwriteCheckbox;
            }
            if (aComponent.equals(SplitMainGUI.this.overwriteCheckbox)) {
                if (SplitMainGUI.this.browseDestButton.isEnabled()) {
                    return SplitMainGUI.this.browseDestButton;
                }
                return SplitMainGUI.this.chooseAFolderRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.browseDestButton)) {
                return SplitMainGUI.this.destinationFolderText;
            }
            if (aComponent.equals(SplitMainGUI.this.destinationFolderText)) {
                return SplitMainGUI.this.chooseAFolderRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.chooseAFolderRadio)) {
                return SplitMainGUI.this.sameAsSourceRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.sameAsSourceRadio)) {
                if (SplitMainGUI.this.bLevelCombo.isEnabled()) {
                    if (SplitMainGUI.this.bLevelCombo.getFillCombo().isEnabled()) {
                        return SplitMainGUI.this.bLevelCombo.getFillCombo();
                    }
                    return SplitMainGUI.this.bLevelCombo.getLevelCombo();
                }
                return SplitMainGUI.this.bookmarksLevel;
            }
            if (aComponent.equals(SplitMainGUI.this.bLevelCombo.getLevelCombo()) || aComponent.getParent().equals(SplitMainGUI.this.bLevelCombo.getLevelCombo())) {
                return SplitMainGUI.this.bookmarksLevel;
            }
            if (aComponent.equals(SplitMainGUI.this.bLevelCombo.getFillCombo())) {
                return SplitMainGUI.this.bLevelCombo.getLevelCombo();
            }
            if (aComponent.equals(SplitMainGUI.this.bookmarksLevel)) {
                if (SplitMainGUI.this.splitSizeCombo.isEnabled()) {
                    return SplitMainGUI.this.splitSizeCombo;
                }
                return SplitMainGUI.this.sizeRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.splitSizeCombo) || aComponent.getParent().equals(SplitMainGUI.this.splitSizeCombo)) {
                return SplitMainGUI.this.sizeRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.sizeRadio)) {
                if (SplitMainGUI.this.nPagesTextField.isEnabled()) {
                    return SplitMainGUI.this.nPagesTextField;
                }
                return SplitMainGUI.this.everyNRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.nPagesTextField)) {
                return SplitMainGUI.this.everyNRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.everyNRadio)) {
                if (SplitMainGUI.this.thisPageTextField.isEnabled()) {
                    return SplitMainGUI.this.thisPageTextField;
                }
                return SplitMainGUI.this.thisPageRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.thisPageTextField)) {
                return SplitMainGUI.this.thisPageRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.thisPageRadio)) {
                return SplitMainGUI.this.oddRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.oddRadio)) {
                return SplitMainGUI.this.evenRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.evenRadio)) {
                return SplitMainGUI.this.burstRadio;
            }
            if (aComponent.equals(SplitMainGUI.this.burstRadio)) {
                return SplitMainGUI.this.selectionPanel.getClearButton();
            }
            if (aComponent.equals(SplitMainGUI.this.selectionPanel.getClearButton())) {
                return SplitMainGUI.this.selectionPanel.getAddFileButton();
            }
            return SplitMainGUI.this.selectionPanel.getAddFileButton();
        }

        public Component getDefaultComponent(Container CycleRootComp) {
            return SplitMainGUI.this.selectionPanel.getAddFileButton();
        }

        public Component getLastComponent(Container CycleRootComp) {
            return SplitMainGUI.this.runButton;
        }

        public Component getFirstComponent(Container CycleRootComp) {
            return SplitMainGUI.this.selectionPanel.getAddFileButton();
        }
    }
}

