/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProviderBase;
import org.fife.ui.autocomplete.Util;

public abstract class AbstractCompletionProvider
extends CompletionProviderBase {
    protected List completions;
    protected Comparator comparator = new CaseInsensitiveComparator();

    public AbstractCompletionProvider() {
        this.clearParameterizedCompletionParams();
    }

    public void addCompletion(Completion completion) {
        this.checkProviderAndAdd(completion);
        Collections.sort(this.completions);
    }

    public void addCompletions(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Completion completion = (Completion)list.get(i);
            this.checkProviderAndAdd(completion);
        }
        Collections.sort(this.completions);
    }

    protected void addWordCompletions(String[] stringArray) {
        int n = stringArray == null ? 0 : stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.completions.add(new BasicCompletion(this, stringArray[i]));
        }
        Collections.sort(this.completions);
    }

    protected void checkProviderAndAdd(Completion completion) {
        if (completion.getProvider() != this) {
            throw new IllegalArgumentException("Invalid CompletionProvider");
        }
        this.completions.add(completion);
    }

    public void clear() {
        this.completions.clear();
    }

    public List getCompletionByInputText(String string) {
        int n;
        int n2 = Collections.binarySearch(this.completions, string, this.comparator);
        if (n2 < 0) {
            return null;
        }
        for (n = n2; n > 0 && this.comparator.compare(this.completions.get(n - 1), string) == 0; --n) {
        }
        int n3 = this.completions.size();
        while (++n2 < n3 && this.comparator.compare(this.completions.get(n2), string) == 0) {
        }
        return this.completions.subList(n, n2);
    }

    protected List getCompletionsImpl(JTextComponent jTextComponent) {
        ArrayList arrayList = new ArrayList();
        String string = this.getAlreadyEnteredText(jTextComponent);
        if (string != null) {
            Completion completion;
            int n = Collections.binarySearch(this.completions, string, this.comparator);
            if (n < 0) {
                n = -n - 1;
            } else {
                for (int i = n - 1; i > 0 && this.comparator.compare(this.completions.get(i), string) == 0; --i) {
                    arrayList.add(this.completions.get(i));
                }
            }
            while (n < this.completions.size() && Util.startsWithIgnoreCase((completion = (Completion)this.completions.get(n)).getInputText(), string)) {
                arrayList.add(completion);
                ++n;
            }
        }
        return arrayList;
    }

    public boolean removeCompletion(Completion completion) {
        int n = Collections.binarySearch(this.completions, completion);
        if (n < 0) {
            return false;
        }
        this.completions.remove(n);
        return true;
    }

    private static class CaseInsensitiveComparator
    implements Comparator,
    Serializable {
        private CaseInsensitiveComparator() {
        }

        public int compare(Object object, Object object2) {
            Completion completion = (Completion)object;
            return String.CASE_INSENSITIVE_ORDER.compare(completion.getInputText(), object2.toString());
        }
    }
}

