/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.text.View;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.FunctionCompletion;
import org.fife.ui.autocomplete.MarkupTagCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.VariableCompletion;

public class CompletionCellRenderer
extends DefaultListCellRenderer {
    private static Color altBG;
    private Font font;
    private boolean showTypes;
    private boolean selected;
    private Color realBG;
    private Rectangle paintTextR;
    private static final String PREFIX = "<html><nobr>";

    public CompletionCellRenderer() {
        this.setShowTypes(true);
        this.paintTextR = new Rectangle();
    }

    public static Color getAlternateBackground() {
        return altBG;
    }

    public Font getDisplayFont() {
        return this.font;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (this.font != null) {
            this.setFont(this.font);
        }
        this.selected = bl;
        Color color = this.realBG = altBG != null && (n & 1) == 0 ? altBG : jList.getBackground();
        if (object instanceof FunctionCompletion) {
            FunctionCompletion functionCompletion = (FunctionCompletion)object;
            this.prepareForFunctionCompletion(jList, functionCompletion, n, bl, bl2);
        } else if (object instanceof VariableCompletion) {
            VariableCompletion variableCompletion = (VariableCompletion)object;
            this.prepareForVariableCompletion(jList, variableCompletion, n, bl, bl2);
        } else if (object instanceof MarkupTagCompletion) {
            MarkupTagCompletion markupTagCompletion = (MarkupTagCompletion)object;
            this.prepareForMarkupTagCompletion(jList, markupTagCompletion, n, bl, bl2);
        } else {
            Completion completion = (Completion)object;
            this.prepareForOtherCompletion(jList, completion, n, bl, bl2);
        }
        if (!bl && (n & 1) == 0 && altBG != null) {
            this.setBackground(altBG);
        }
        return this;
    }

    public boolean getShowTypes() {
        return this.showTypes;
    }

    protected void paintComponent(Graphics graphics) {
        String string;
        graphics.setColor(this.realBG);
        int n = 0;
        if (this.getIcon() != null) {
            n = this.getIcon().getIconWidth();
        }
        if (this.selected && n > 0) {
            graphics.fillRect(0, 0, n, this.getHeight());
            graphics.setColor(this.getBackground());
            graphics.fillRect(n, 0, this.getWidth() - n, this.getHeight());
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.getIcon() != null) {
            this.getIcon().paintIcon(this, graphics, 0, 0);
        }
        if ((string = this.getText()) != null) {
            this.paintTextR.setBounds(n, 0, this.getWidth() - n, this.getHeight());
            this.paintTextR.x += 3;
            int n2 = this.paintTextR.height - graphics.getFontMetrics().getHeight();
            View view = (View)this.getClientProperty("html");
            if (view != null) {
                this.paintTextR.y += n2 / 2;
                this.paintTextR.height -= n2;
                view.paint(graphics, this.paintTextR);
            } else {
                int n3 = this.paintTextR.x;
                int n4 = this.paintTextR.y;
                System.out.println(graphics.getFontMetrics().getAscent());
                graphics.drawString(string, n3, n4);
            }
        }
    }

    protected void prepareForFunctionCompletion(JList jList, FunctionCompletion functionCompletion, int n, boolean bl, boolean bl2) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(PREFIX);
        stringBuffer.append(functionCompletion.getName());
        char c = functionCompletion.getProvider().getParameterListStart();
        if (c != '\u0000') {
            stringBuffer.append(c);
        }
        int n3 = functionCompletion.getParamCount();
        for (n2 = 0; n2 < n3; ++n2) {
            ParameterizedCompletion.Parameter parameter = functionCompletion.getParam(n2);
            String string = parameter.getType();
            String string2 = parameter.getName();
            if (string != null) {
                if (!bl) {
                    stringBuffer.append("<font color='#aa0077'>");
                }
                stringBuffer.append(string);
                if (!bl) {
                    stringBuffer.append("</font>");
                }
                if (string2 != null) {
                    stringBuffer.append(' ');
                }
            }
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            if (n2 >= n3 - '\u0001') continue;
            stringBuffer.append(functionCompletion.getProvider().getParameterListSeparator());
        }
        n2 = functionCompletion.getProvider().getParameterListEnd();
        if (n2 != 0) {
            stringBuffer.append((char)n2);
        }
        if (this.getShowTypes() && functionCompletion.getType() != null) {
            stringBuffer.append(" : ");
            if (!bl) {
                stringBuffer.append("<font color='#808080'>");
            }
            stringBuffer.append(functionCompletion.getType());
            if (!bl) {
                stringBuffer.append("</font>");
            }
        }
        this.setText(stringBuffer.toString());
    }

    protected void prepareForMarkupTagCompletion(JList jList, MarkupTagCompletion markupTagCompletion, int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(PREFIX);
        stringBuffer.append(markupTagCompletion.getName());
        this.setText(stringBuffer.toString());
    }

    protected void prepareForOtherCompletion(JList jList, Completion completion, int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(PREFIX);
        stringBuffer.append(completion.getInputText());
        this.setText(stringBuffer.toString());
    }

    protected void prepareForVariableCompletion(JList jList, VariableCompletion variableCompletion, int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(PREFIX);
        stringBuffer.append(variableCompletion.getName());
        if (this.getShowTypes() && variableCompletion.getType() != null) {
            stringBuffer.append(" : ");
            if (!bl) {
                stringBuffer.append("<font color='#808080'>");
            }
            stringBuffer.append(variableCompletion.getType());
            if (!bl) {
                stringBuffer.append("</font>");
            }
        }
        this.setText(stringBuffer.toString());
    }

    public static void setAlternateBackground(Color color) {
        altBG = color;
    }

    public void setDisplayFont(Font font) {
        this.font = font;
    }

    public void setShowTypes(boolean bl) {
        this.showTypes = bl;
    }
}

