/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control;

import com.baselet.control.CanCloseProgram;
import com.baselet.control.config.Config;
import com.baselet.control.config.handler.ConfigHandler;
import com.baselet.control.constants.Constants;
import com.baselet.control.enums.Program;
import com.baselet.control.enums.RuntimeType;
import com.baselet.control.util.CanOpenDiagram;
import com.baselet.control.util.Path;
import com.baselet.control.util.RecentlyUsedFilesList;
import com.baselet.control.util.RunningFileChecker;
import com.baselet.control.util.Utils;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.DrawPanel;
import com.baselet.diagram.Notifier;
import com.baselet.diagram.PaletteHandler;
import com.baselet.diagram.UpdateCheckTimerTask;
import com.baselet.diagram.io.OpenFileChooser;
import com.baselet.element.interfaces.GridElement;
import com.baselet.gui.BaseGUI;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.pane.OwnSyntaxPane;
import com.baselet.gui.standalone.StandaloneGUI;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.jar.Attributes;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Main
implements CanCloseProgram,
CanOpenDiagram {
    private static final Logger log = Logger.getLogger(Main.class);
    private static Main main = new Main();
    private static String tmp_file;
    private static String tmp_read_file;
    private static boolean file_created;
    private GridElement editedGridElement;
    private TreeMap<String, PaletteHandler> palettes;
    private final ArrayList<DiagramHandler> diagrams = new ArrayList();
    private static HashMap<GridElement, DiagramHandler> gridElementToHandlerMapping;

    static {
        file_created = false;
        gridElementToHandlerMapping = new HashMap();
    }

    public static Main getInstance() {
        return main;
    }

    public static void main(String[] args) {
        Main.initHomeProgramPath();
        main.initLogger();
        main.readManifestInfo();
        ConfigHandler.loadConfig();
        tmp_file = String.valueOf(Program.getInstance().getProgramName().toLowerCase()) + ".tmp";
        tmp_read_file = String.valueOf(Program.getInstance().getProgramName().toLowerCase()) + "_1.tmp";
        if (args.length != 0) {
            String action = null;
            String format = null;
            String filename = null;
            String output = null;
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (arg.startsWith("-action=")) {
                    action = arg.substring(8);
                } else if (arg.startsWith("-format=")) {
                    format = arg.substring(8);
                } else if (arg.startsWith("-filename=")) {
                    filename = arg.substring(10);
                } else if (arg.startsWith("-output=")) {
                    output = arg.substring(8);
                }
                ++n2;
            }
            if (action == null && format == null && (filename != null || args.length == 1)) {
                if (filename == null) {
                    filename = args[0];
                }
                if (!Main.alreadyRunningChecker(false) || !Main.sendFileNameToRunningApplication(filename)) {
                    main.init(new StandaloneGUI(main));
                    main.doOpen(filename);
                }
            } else if (action != null && format != null && filename != null) {
                if (action.equals("convert")) {
                    WildcardFileFilter fileFilter;
                    File[] files;
                    Program.getInstance().setRuntimeType(RuntimeType.BATCH);
                    String[] splitFilename = filename.split("(/|\\\\)");
                    String localName = splitFilename[splitFilename.length - 1];
                    String dir = filename.substring(0, filename.length() - localName.length());
                    if (dir.isEmpty()) {
                        dir = ".";
                    }
                    if ((files = new File(dir).listFiles((FileFilter)(fileFilter = new WildcardFileFilter(localName)))) != null) {
                        File[] fileArray = files;
                        int n3 = files.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File file = fileArray[n4];
                            Main.doConvert(file, format, output);
                            ++n4;
                        }
                    }
                } else {
                    Main.printUsage();
                }
            } else {
                Main.printUsage();
            }
        } else {
            Main.alreadyRunningChecker(true);
            if (Config.getInstance().isCheckForUpdates()) {
                new Timer("Update Checker", true).schedule((TimerTask)UpdateCheckTimerTask.getInstance(), 0L);
            }
            main.init(new StandaloneGUI(main));
            main.doNew();
        }
    }

    private static void initHomeProgramPath() {
        String tempPath = Path.executable();
        tempPath = tempPath.substring(0, tempPath.length() - 1);
        tempPath = tempPath.substring(0, tempPath.lastIndexOf(47) + 1);
        String realPath = String.valueOf(new File(tempPath).getAbsolutePath()) + "/";
        Path.setHomeProgram(realPath);
    }

    public void init(BaseGUI gui) {
        CurrentGui.getInstance().setGui(gui);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        gui.initGUI();
    }

    public void initLogger() {
        String log4jFilePath = String.valueOf(Path.homeProgram()) + "log4j.properties";
        try {
            if (!new File(log4jFilePath).exists()) {
                File tempLog4jFile = File.createTempFile("log4j.properties", null);
                tempLog4jFile.deleteOnExit();
                log4jFilePath = tempLog4jFile.getAbsolutePath();
                BufferedWriter writer = new BufferedWriter(new FileWriter(tempLog4jFile));
                writer.write("log4j.rootLogger=ERROR, SYSTEM_OUT\nlog4j.appender.SYSTEM_OUT=org.apache.log4j.ConsoleAppender\nlog4j.appender.SYSTEM_OUT.layout=org.apache.log4j.PatternLayout\nlog4j.appender.SYSTEM_OUT.layout.ConversionPattern=%6r | %-5p | %-30c - \"%m\"%n\n");
                ((Writer)writer).close();
            }
            Properties props = new Properties();
            props.put("PROJECT_PATH", Path.homeProgram());
            FileInputStream inStream = new FileInputStream(log4jFilePath);
            props.load(inStream);
            inStream.close();
            PropertyConfigurator.configure((Properties)props);
            log.info((Object)"Logger configuration initialized");
        }
        catch (Exception e) {
            System.err.println("Initialization of log4j.properties failed:");
            e.printStackTrace();
        }
    }

    private void readManifestInfo() {
        try {
            Attributes attributes = Path.manifest().getMainAttributes();
            Program.getInstance().init(attributes.getValue("Bundle-Version"));
        }
        catch (Exception e) {
            log.error((Object)"Cannot read manifest", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void displayError(String error) {
        JOptionPane.showMessageDialog(CurrentGui.getInstance().getGui().getMainFrame(), error, "ERROR", 0);
    }

    private static void printToConsole(String text) {
        System.out.println(text);
    }

    private static void printUsage() {
        StringBuilder formatBuilder = new StringBuilder("pdf|svg|eps");
        String[] stringArray = ImageIO.getWriterFileSuffixes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String format = stringArray[n2];
            formatBuilder.append("|").append(format);
            ++n2;
        }
        Main.printToConsole("USAGE: -action=convert -format=(" + formatBuilder.toString() + ") -filename=inputfile." + Program.getInstance().getExtension() + " [-output=outputfile[.extension]]");
    }

    public static void doConvert(File inputFile, String outputFormat, String outputParam) {
        if (!inputFile.exists()) {
            Main.printToConsole("File '" + inputFile.getAbsolutePath() + "' not found.");
            return;
        }
        DiagramHandler handler = new DiagramHandler(inputFile);
        String outputFileName = Main.determineOutputName(inputFile, outputFormat, outputParam);
        try {
            handler.getFileHandler().doExportAs(outputFormat, new File(outputFileName));
            Main.printToConsole("Conversion finished: \"" + inputFile.getAbsolutePath() + "\" to \"" + outputParam + "\"");
        }
        catch (Exception e) {
            Main.printToConsole(e.getMessage());
        }
    }

    private static String determineOutputName(File inputFile, String outputFormat, String outputParam) {
        String outputFileName = outputParam == null ? inputFile.getAbsolutePath() : (new File(outputParam).isDirectory() ? String.valueOf(outputParam) + File.separator + inputFile.getName() : outputParam);
        return Main.createBatchOutputName(outputFormat, outputFileName);
    }

    private static String createBatchOutputName(String extension, String fileName) {
        if (fileName.endsWith(extension)) {
            return fileName;
        }
        return String.valueOf(fileName) + "." + extension;
    }

    private static boolean alreadyRunningChecker(boolean force) {
        File f;
        block3: {
            try {
                f = new File(String.valueOf(Path.temp()) + tmp_file);
                if (!f.exists() || force) break block3;
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return true;
            }
        }
        Utils.safeCreateFile(f, false);
        file_created = true;
        new Timer("alreadyRunningChecker", true).schedule((TimerTask)new RunningFileChecker(String.valueOf(Path.temp()) + tmp_file, String.valueOf(Path.temp()) + tmp_read_file, main), 0L, 1000L);
        return false;
    }

    private static boolean sendFileNameToRunningApplication(String filename) {
        File f1 = new File(String.valueOf(Path.temp()) + tmp_file);
        boolean write_successful = true;
        try {
            PrintWriter writer = new PrintWriter(f1);
            writer.println(filename);
            writer.close();
        }
        catch (Exception ex) {
            write_successful = false;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        File f2 = new File(String.valueOf(Path.temp()) + tmp_read_file);
        if (!f2.exists() || !write_successful) {
            Main.alreadyRunningChecker(true);
            return false;
        }
        Utils.safeDeleteFile(f2, false);
        return true;
    }

    public void setPropertyPanelToCustomElement(GridElement e) {
        this.editedGridElement = e;
    }

    public void setPropertyPanelToGridElement(final GridElement e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.this.setPropertyPanelToGridElementHelper(e);
            }
        });
    }

    private void setPropertyPanelToGridElementHelper(GridElement e) {
        this.editedGridElement = e;
        OwnSyntaxPane propertyPane = CurrentGui.getInstance().getGui().getPropertyPane();
        if (e != null) {
            propertyPane.switchToElement(e);
        } else {
            DiagramHandler handler = CurrentDiagram.getInstance().getDiagramHandler();
            if (handler == null) {
                propertyPane.switchToNonElement("");
            } else {
                propertyPane.switchToNonElement(handler.getHelpText());
            }
        }
    }

    public void doNew() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.this.doNewHelper();
            }
        });
    }

    private void doNewHelper() {
        if (this.lastTabIsEmpty()) {
            return;
        }
        DiagramHandler diagram = new DiagramHandler(null);
        this.diagrams.add(diagram);
        CurrentGui.getInstance().getGui().open(diagram);
        if (this.diagrams.size() == 1) {
            this.setPropertyPanelToGridElement(null);
        }
    }

    public void doOpenFromFileChooser() {
        List<String> files = new OpenFileChooser().getFilesToOpen(CurrentGui.getInstance().getGui().getMainFrame());
        for (String file : files) {
            this.doOpen(file);
        }
    }

    @Override
    public void doOpen(final String filename) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.this.doOpenHelper(filename);
            }
        });
    }

    private void doOpenHelper(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            Notifier.getInstance().showNotification(String.valueOf(filename) + " does not exist");
            return;
        }
        Config.getInstance().setOpenFileHome(file.getParent());
        DiagramHandler handler = this.getDiagramHandlerForFile(filename);
        if (handler != null) {
            CurrentGui.getInstance().getGui().jumpTo(handler);
            Notifier.getInstance().showNotification("switched to " + filename);
        } else {
            if (this.lastTabIsEmpty()) {
                this.diagrams.get(this.diagrams.size() - 1).doClose();
            }
            this.editedGridElement = null;
            DiagramHandler diagram = new DiagramHandler(file);
            this.diagrams.add(diagram);
            CurrentGui.getInstance().getGui().open(diagram);
            if (this.diagrams.size() == 1) {
                this.setPropertyPanelToGridElement(null);
            }
            RecentlyUsedFilesList.getInstance().add(filename);
            Notifier.getInstance().showNotification(String.valueOf(filename) + " opened");
        }
    }

    private DiagramHandler getDiagramHandlerForFile(String file) {
        for (DiagramHandler d : this.diagrams) {
            if (!d.getFullPathName().equalsIgnoreCase(file)) continue;
            return d;
        }
        return null;
    }

    private boolean lastTabIsEmpty() {
        DiagramHandler lastDiagram;
        return !this.diagrams.isEmpty() && (lastDiagram = this.diagrams.get(this.diagrams.size() - 1)).getController().isEmpty() && lastDiagram.getDrawPanel().getGridElements().isEmpty();
    }

    @Override
    public void closeProgram() {
        ConfigHandler.saveConfig(CurrentGui.getInstance().getGui());
        if (file_created) {
            Utils.safeDeleteFile(new File(String.valueOf(Path.temp()) + tmp_file), true);
        }
    }

    public TreeMap<String, PaletteHandler> getPalettes() {
        if (this.palettes == null) {
            this.palettes = new TreeMap(Constants.DEFAULT_FIRST_COMPARATOR);
            List<File> palettes = this.scanForPalettes();
            for (File palette : palettes) {
                this.palettes.put(this.getFilenameWithoutExtension(palette), new PaletteHandler(palette));
            }
        }
        return this.palettes;
    }

    private String getFilenameWithoutExtension(File file) {
        return file.getName().substring(0, file.getName().indexOf("."));
    }

    private List<File> scanForPalettes() {
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        File[] paletteFiles = fileSystemView.getFiles(new File(String.valueOf(Path.homeProgram()) + "palettes/"), false);
        ArrayList<File> palettes = new ArrayList<File>();
        File[] fileArray = paletteFiles;
        int n = paletteFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File palette = fileArray[n2];
            if (palette.getName().endsWith("." + Program.getInstance().getExtension())) {
                palettes.add(palette);
            }
            ++n2;
        }
        return palettes;
    }

    public List<String> getTemplateNames() {
        File[] templateFiles;
        ArrayList<String> templates = new ArrayList<String>();
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        File[] fileArray = templateFiles = fileSystemView.getFiles(new File(Path.customElements()), false);
        int n = templateFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File template = fileArray[n2];
            if (template.getName().endsWith(".java")) {
                templates.add(template.getName().substring(0, template.getName().length() - 5));
            }
            ++n2;
        }
        Collections.sort(templates, Constants.DEFAULT_FIRST_COMPARATOR);
        return templates;
    }

    public List<DiagramHandler> getDiagrams() {
        return this.diagrams;
    }

    public Collection<DiagramHandler> getDiagramsAndPalettes() {
        ArrayList<DiagramHandler> returnList = new ArrayList<DiagramHandler>(this.getDiagrams());
        returnList.addAll(this.getPalettes().values());
        return returnList;
    }

    public GridElement getEditedGridElement() {
        return this.editedGridElement;
    }

    public PaletteHandler getPalette() {
        String name = CurrentGui.getInstance().getGui().getSelectedPalette();
        if (name != null) {
            return this.getPalettes().get(name);
        }
        return null;
    }

    public DrawPanel getPalettePanel() {
        return this.getPalette().getDrawPanel();
    }

    public static DiagramHandler getHandlerForElement(GridElement element) {
        return gridElementToHandlerMapping.get(element);
    }

    public static DiagramHandler setHandlerForElement(GridElement element, DiagramHandler handler) {
        return gridElementToHandlerMapping.put(element, handler);
    }
}

