/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.basics.geom;

import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GeometricFunctions {
    public static double distanceBetweenTwoPoints(PointDouble pointDouble, PointDouble pointDouble2) {
        return GeometricFunctions.distanceBetweenTwoPoints(pointDouble.x, pointDouble.y, pointDouble2.x, pointDouble2.y);
    }

    public static double getDistanceBetweenLineAndPoint(PointDouble pointDouble, PointDouble pointDouble2, PointDouble pointDouble3) {
        return GeometricFunctions.getDistanceBetweenLineAndPoint(pointDouble.x, pointDouble.y, pointDouble2.x, pointDouble2.y, pointDouble3.x, pointDouble3.y);
    }

    private static double distanceBetweenTwoPoints(double d, double d2, double d3, double d4) {
        double d5 = d - d3;
        double d6 = d2 - d4;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    private static double getDistanceBetweenLineAndPoint(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d3 - d;
        double d8 = d4 - d2;
        double d9 = d7 * d7 + d8 * d8;
        double d10 = ((d5 - d) * d7 + (d6 - d2) * d8) / d9;
        if (d10 > 1.0) {
            d10 = 1.0;
        } else if (d10 < 0.0) {
            d10 = 0.0;
        }
        double d11 = d + d10 * d7;
        double d12 = d2 + d10 * d8;
        return GeometricFunctions.distanceBetweenTwoPoints(d11, d12, d5, d6);
    }

    public static PointDouble getPointOnLineWithDistanceFromStart(PointDouble pointDouble, PointDouble pointDouble2, double d) {
        double d2 = pointDouble2.getX() - pointDouble.getX();
        double d3 = pointDouble2.getY() - pointDouble.getY();
        double d4 = GeometricFunctions.distanceBetweenTwoPoints(pointDouble, pointDouble2);
        double d5 = d / d4;
        return new PointDouble(pointDouble.getX() + d2 * d5, pointDouble.getY() + d3 * d5);
    }

    public static PointDouble getIntersectionPoint(Line line, Line line2) {
        double d;
        double d2;
        double d3 = line.getStart().getX();
        double d4 = line.getStart().getY();
        double d5 = line.getEnd().getX();
        double d6 = line.getEnd().getY();
        double d7 = line2.getStart().getX();
        double d8 = line2.getStart().getY();
        double d9 = line2.getEnd().getX();
        double d10 = line2.getEnd().getY();
        PointDouble pointDouble = null;
        double d11 = (d3 - d5) * (d8 - d10) - (d4 - d6) * (d7 - d9);
        if (d11 != 0.0 && (line.getDistanceToPoint(pointDouble = new PointDouble(d2 = ((d7 - d9) * (d3 * d6 - d4 * d5) - (d3 - d5) * (d7 * d10 - d8 * d9)) / d11, d = ((d8 - d10) * (d3 * d6 - d4 * d5) - (d4 - d6) * (d7 * d10 - d8 * d9)) / d11)) > 1.0 || line2.getDistanceToPoint(pointDouble) > 1.0)) {
            pointDouble = null;
        }
        return pointDouble;
    }

    public static List<PointDouble> getIntersectionPoints(Line line, Rectangle rectangle) {
        List<PointDouble> list = Arrays.asList(GeometricFunctions.getIntersectionPoint(line, new Line(new PointDouble(rectangle.getX(), rectangle.getY()), new PointDouble(rectangle.getX() + rectangle.getWidth(), rectangle.getY()))), GeometricFunctions.getIntersectionPoint(line, new Line(new PointDouble(rectangle.getX(), rectangle.getY() + rectangle.getHeight()), new PointDouble(rectangle.getX() + rectangle.getWidth(), rectangle.getY() + rectangle.getHeight()))), GeometricFunctions.getIntersectionPoint(line, new Line(new PointDouble(rectangle.getX(), rectangle.getY()), new PointDouble(rectangle.getX(), rectangle.getY() + rectangle.getHeight()))), GeometricFunctions.getIntersectionPoint(line, new Line(new PointDouble(rectangle.getX() + rectangle.getWidth(), rectangle.getY()), new PointDouble(rectangle.getX() + rectangle.getWidth(), rectangle.getY() + rectangle.getHeight()))));
        ArrayList<PointDouble> arrayList = new ArrayList<PointDouble>();
        for (PointDouble pointDouble : list) {
            if (pointDouble == null) continue;
            arrayList.add(pointDouble);
        }
        return arrayList;
    }
}

