/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet;

import com.baselet.control.basics.XValues;
import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.enums.ElementStyle;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.facet.Alignment;
import com.baselet.element.facet.Buffer;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.Settings;
import com.baselet.element.sticking.polygon.SimpleStickingPolygonGenerator;
import com.baselet.element.sticking.polygon.StickingPolygonGenerator;
import java.util.HashMap;
import java.util.Map;

public class PropertiesParserState {
    private final Settings settings;
    private final DrawHandler drawer;
    private Alignment alignment;
    private double textPrintPosition;
    private double minimumWidth;
    private Buffer buffer;
    private Dimension gridElementSize;
    private ElementStyle elementStyle;
    private StickingPolygonGenerator stickingPolygonGenerator = SimpleStickingPolygonGenerator.INSTANCE;
    private double totalTextBlockHeight;
    private final Map<Class<? extends Facet>, Object> facetResponse = new HashMap<Class<? extends Facet>, Object>();

    public PropertiesParserState(Settings settings, DrawHandler drawHandler) {
        this.settings = settings;
        this.drawer = drawHandler;
    }

    public void resetValues(Dimension dimension, double d, boolean bl) {
        this.alignment = new Alignment(this.settings);
        this.textPrintPosition = 0.0;
        this.minimumWidth = 0.0;
        this.buffer = new Buffer();
        this.gridElementSize = dimension;
        this.elementStyle = this.settings.getElementStyle();
        this.stickingPolygonGenerator = SimpleStickingPolygonGenerator.INSTANCE;
        this.totalTextBlockHeight = d;
        this.facetResponse.clear();
        this.drawer.setEnableDrawing(bl);
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public double getTextPrintPosition() {
        return this.textPrintPosition + this.buffer.getTop();
    }

    public void increaseTextPrintPosition(double d) {
        this.textPrintPosition += d;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public Dimension getGridElementSize() {
        return this.gridElementSize;
    }

    public XValues getXLimits(double d) {
        XValues xValues = this.settings.getXValues(d, this.getGridElementSize().height, this.getGridElementSize().width);
        xValues.addLeft(this.buffer.getLeft());
        xValues.subRight(this.buffer.getRight());
        return xValues;
    }

    public XValues getXLimitsForArea(double d, double d2, boolean bl) {
        XValues xValues = this.getXLimits(d - d2);
        XValues xValues2 = this.getXLimits(d);
        XValues xValues3 = xValues.intersect(xValues2, bl);
        return xValues3;
    }

    public void updateMinimumWidth(double d) {
        this.minimumWidth = Math.max(this.minimumWidth, d);
    }

    public void updateMinimumSize(double d, double d2) {
        this.updateMinimumWidth(d);
        this.getBuffer().setTopMin(d2);
    }

    public double getCalculatedElementWidth() {
        return this.minimumWidth;
    }

    public ElementStyle getElementStyle() {
        return this.elementStyle;
    }

    public void setElementStyle(ElementStyle elementStyle) {
        this.elementStyle = elementStyle;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public DrawHandler getDrawer() {
        return this.drawer;
    }

    public <T> T getFacetResponse(Class<? extends Facet> clazz, T t) {
        Object object = this.facetResponse.get(clazz);
        if (object == null) {
            return t;
        }
        return (T)object;
    }

    public <T> T getOrInitFacetResponse(Class<? extends Facet> clazz, T t) {
        T t2 = this.getFacetResponse(clazz, t);
        this.setFacetResponse(clazz, t2);
        return t2;
    }

    public void setFacetResponse(Class<? extends Facet> clazz, Object object) {
        this.facetResponse.put(clazz, object);
    }

    public StickingPolygonGenerator getStickingPolygonGenerator() {
        return this.stickingPolygonGenerator;
    }

    public void setStickingPolygonGenerator(StickingPolygonGenerator stickingPolygonGenerator) {
        this.stickingPolygonGenerator = stickingPolygonGenerator;
    }

    public double getTotalTextBlockHeight() {
        return this.totalTextBlockHeight;
    }
}

