/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XCharStruct
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 12;
    }

    @Override
    public int getDataSize() {
        return XCharStruct.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XCharStruct(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XCharStruct() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XCharStruct.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public short get_lbearing() {
        log.finest("");
        return Native.getShort(this.pData + 0L);
    }

    public void set_lbearing(short v) {
        log.finest("");
        Native.putShort(this.pData + 0L, v);
    }

    public short get_rbearing() {
        log.finest("");
        return Native.getShort(this.pData + 2L);
    }

    public void set_rbearing(short v) {
        log.finest("");
        Native.putShort(this.pData + 2L, v);
    }

    public short get_width() {
        log.finest("");
        return Native.getShort(this.pData + 4L);
    }

    public void set_width(short v) {
        log.finest("");
        Native.putShort(this.pData + 4L, v);
    }

    public short get_ascent() {
        log.finest("");
        return Native.getShort(this.pData + 6L);
    }

    public void set_ascent(short v) {
        log.finest("");
        Native.putShort(this.pData + 6L, v);
    }

    public short get_descent() {
        log.finest("");
        return Native.getShort(this.pData + 8L);
    }

    public void set_descent(short v) {
        log.finest("");
        Native.putShort(this.pData + 8L, v);
    }

    public short get_attributes() {
        log.finest("");
        return Native.getShort(this.pData + 10L);
    }

    public void set_attributes(short v) {
        log.finest("");
        Native.putShort(this.pData + 10L, v);
    }

    @Override
    String getName() {
        return "XCharStruct";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(240);
        ret.append("lbearing = ").append(this.get_lbearing()).append(", ");
        ret.append("rbearing = ").append(this.get_rbearing()).append(", ");
        ret.append("width = ").append(this.get_width()).append(", ");
        ret.append("ascent = ").append(this.get_ascent()).append(", ");
        ret.append("descent = ").append(this.get_descent()).append(", ");
        ret.append("attributes = ").append(this.get_attributes()).append(", ");
        return ret.toString();
    }
}

