/**
Copyright (c) 2012, Brice Videau <brice.videau@imag.fr>
Copyright (c) 2012, Vincent Danjean <Vincent.Danjean@ens-lyon.org>
All rights reserved.
      
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    
1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.
        
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Do not edit this file. It is automatically generated.

*/
#include "ocl_icd.h"
struct _cl_icd_dispatch master_dispatch = {
  clGetPlatformIDs,
  clGetPlatformInfo,
  clGetDeviceIDs,
  clGetDeviceInfo,
  clCreateContext,
  clCreateContextFromType,
  clRetainContext,
  clReleaseContext,
  clGetContextInfo,
  clCreateCommandQueue,
  clRetainCommandQueue,
  clReleaseCommandQueue,
  clGetCommandQueueInfo,
  clSetCommandQueueProperty,
  clCreateBuffer,
  clCreateImage2D,
  clCreateImage3D,
  clRetainMemObject,
  clReleaseMemObject,
  clGetSupportedImageFormats,
  clGetMemObjectInfo,
  clGetImageInfo,
  clCreateSampler,
  clRetainSampler,
  clReleaseSampler,
  clGetSamplerInfo,
  clCreateProgramWithSource,
  clCreateProgramWithBinary,
  clRetainProgram,
  clReleaseProgram,
  clBuildProgram,
  clUnloadCompiler,
  clGetProgramInfo,
  clGetProgramBuildInfo,
  clCreateKernel,
  clCreateKernelsInProgram,
  clRetainKernel,
  clReleaseKernel,
  clSetKernelArg,
  clGetKernelInfo,
  clGetKernelWorkGroupInfo,
  clWaitForEvents,
  clGetEventInfo,
  clRetainEvent,
  clReleaseEvent,
  clGetEventProfilingInfo,
  clFlush,
  clFinish,
  clEnqueueReadBuffer,
  clEnqueueWriteBuffer,
  clEnqueueCopyBuffer,
  clEnqueueReadImage,
  clEnqueueWriteImage,
  clEnqueueCopyImage,
  clEnqueueCopyImageToBuffer,
  clEnqueueCopyBufferToImage,
  clEnqueueMapBuffer,
  clEnqueueMapImage,
  clEnqueueUnmapMemObject,
  clEnqueueNDRangeKernel,
  clEnqueueTask,
  clEnqueueNativeKernel,
  clEnqueueMarker,
  clEnqueueWaitForEvents,
  clEnqueueBarrier,
  clGetExtensionFunctionAddress,
  clCreateFromGLBuffer,
  clCreateFromGLTexture2D,
  clCreateFromGLTexture3D,
  clCreateFromGLRenderbuffer,
  clGetGLObjectInfo,
  clGetGLTextureInfo,
  clEnqueueAcquireGLObjects,
  clEnqueueReleaseGLObjects,
  clGetGLContextInfoKHR,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  clSetEventCallback,
  clCreateSubBuffer,
  clSetMemObjectDestructorCallback,
  clCreateUserEvent,
  clSetUserEventStatus,
  clEnqueueReadBufferRect,
  clEnqueueWriteBufferRect,
  clEnqueueCopyBufferRect,
  clCreateSubDevicesEXT,
  clRetainDeviceEXT,
  clReleaseDeviceEXT,
  clCreateEventFromGLsyncKHR,
  clCreateSubDevices,
  clRetainDevice,
  clReleaseDevice,
  clCreateImage,
  clCreateProgramWithBuiltInKernels,
  clCompileProgram,
  clLinkProgram,
  clUnloadPlatformCompiler,
  clGetKernelArgInfo,
  clEnqueueFillBuffer,
  clEnqueueFillImage,
  clEnqueueMigrateMemObjects,
  clEnqueueMarkerWithWaitList,
  clEnqueueBarrierWithWaitList,
  clGetExtensionFunctionAddressForPlatform,
  clCreateFromGLTexture,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  clCreateCommandQueueWithProperties,
  clCreatePipe,
  clGetPipeInfo,
  clSVMAlloc,
  clSVMFree,
  clEnqueueSVMFree,
  clEnqueueSVMMemcpy,
  clEnqueueSVMMemFill,
  clEnqueueSVMMap,
  clEnqueueSVMUnmap,
  clCreateSamplerWithProperties,
  clSetKernelArgSVMPointer,
  clSetKernelExecInfo,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL,
  (void *) NULL
};

CL_API_ENTRY cl_int CL_API_CALL clIcdGetPlatformIDsKHR(  
             cl_uint num_entries, 
             cl_platform_id *platforms,
             cl_uint *num_platforms) {
  if( platforms == NULL && num_platforms == NULL )
    return CL_INVALID_VALUE;
  if( num_entries == 0 && platforms != NULL )
    return CL_INVALID_VALUE;
#error You have to fill the commented lines with corresponding variables from your library
//  if( your_number_of_platforms == 0)
//    return CL_PLATFORM_NOT_FOUND_KHR;
//  if( num_platforms != NULL )
//    *num_platforms = your_number_of_platforms;
  if( platforms != NULL ) {
    cl_uint i;
//    for( i=0; i<(your_number_of_platforms<num_entries?your_number_of_platforms:num_entries); i++)
//      platforms[i] = &your_platforms[i];
  }
  return CL_SUCCESS;
}

CL_API_ENTRY void * CL_API_CALL clGetExtensionFunctionAddress(
             const char *   func_name) CL_API_SUFFIX__VERSION_1_0 {
#error You have to fill this function with your extensions of incorporate these lines in your version
  if( func_name != NULL &&  strcmp("clIcdGetPlatformIDsKHR", func_name) == 0 )
    return (void *)clIcdGetPlatformIDsKHR;
  return NULL;
}
CL_API_ENTRY cl_int CL_API_CALL clGetPlatformInfo(
             cl_platform_id   platform, 
             cl_platform_info param_name,
             size_t           param_value_size, 
             void *           param_value,
             size_t *         param_value_size_ret) CL_API_SUFFIX__VERSION_1_0 {
#error You ahve to fill this function with your information or assert that your version responds to CL_PLATFORM_ICD_SUFFIX_KHR
//  char cl_platform_profile[] = "FULL_PROFILE";
//  char cl_platform_version[] = "OpenCL 1.1";
//  char cl_platform_name[] = "DummyCL";
//  char cl_platform_vendor[] = "LIG";
//  char cl_platform_extensions[] = "cl_khr_icd";
//  char cl_platform_icd_suffix_khr[] = "DUMMY";
  size_t size_string;
  char * string_p;
  if( platform != NULL ) {
    int found = 0;
    int i;
    for(i=0; i<num_master_platforms; i++) {
      if( platform == &master_platforms[i] )
        found = 1;
    }
    if(!found)
      return CL_INVALID_PLATFORM;
  }
  switch ( param_name ) {
    case CL_PLATFORM_PROFILE:
      string_p = cl_platform_profile;
      size_string = sizeof(cl_platform_profile);
      break;
    case CL_PLATFORM_VERSION:
      string_p = cl_platform_version;
      size_string = sizeof(cl_platform_version);
      break;
    case CL_PLATFORM_NAME:
      string_p = cl_platform_name;
      size_string = sizeof(cl_platform_name);
      break;
    case CL_PLATFORM_VENDOR:
      string_p = cl_platform_vendor;
      size_string = sizeof(cl_platform_vendor);
      break;
    case CL_PLATFORM_EXTENSIONS:
      string_p = cl_platform_extensions;
      size_string = sizeof(cl_platform_extensions);
      break;
    case CL_PLATFORM_ICD_SUFFIX_KHR:
      string_p = cl_platform_icd_suffix_khr;
      size_string = sizeof(cl_platform_icd_suffix_khr);
      break;
    default:
      return CL_INVALID_VALUE;
      break;
  }
  if( param_value != NULL ) {
    if( size_string > param_value_size )
      return CL_INVALID_VALUE;
    memcpy(param_value, string_p, size_string);
  }
  if( param_value_size_ret != NULL )
    *param_value_size_ret = size_string;
  return CL_SUCCESS;
}
