/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl;

import org.apache.subversion.javahl.types.RuntimeVersion;
import org.apache.subversion.javahl.types.Version;

public class NativeResources {
    private static Version version;
    private static RuntimeVersion runtimeVersion;

    public static Version getVersion() {
        return version;
    }

    public static RuntimeVersion getRuntimeVersion() {
        return runtimeVersion;
    }

    public static synchronized void loadNativeLibrary() {
        String[] stringArray;
        UnsatisfiedLinkError unsatisfiedLinkError = null;
        try {
            stringArray = System.getProperty("subversion.native.library");
            if (stringArray != null) {
                System.load((String)stringArray);
                NativeResources.init();
                return;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
            unsatisfiedLinkError = unsatisfiedLinkError2;
        }
        for (String string : stringArray = new String[]{"svnjavahl-1", "libsvnjavahl-1", "svnjavahl"}) {
            try {
                System.loadLibrary(string);
                NativeResources.init();
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError3) {
                if (unsatisfiedLinkError != null) continue;
                unsatisfiedLinkError = unsatisfiedLinkError3;
            }
        }
        if (unsatisfiedLinkError == null) {
            unsatisfiedLinkError = new UnsatisfiedLinkError("Unable to load JavaHL native library");
        }
        throw unsatisfiedLinkError;
    }

    private static final void init() {
        version = new Version();
        if (!version.isAtLeast(1, 9, 0)) {
            throw new LinkageError("Native library version must be at least 1.9.0, but is only " + version);
        }
        runtimeVersion = new RuntimeVersion();
        if (runtimeVersion.getMajor() < version.getMajor() || runtimeVersion.getMajor() == version.getMajor() && runtimeVersion.getMinor() < version.getMinor()) {
            throw new LinkageError("Compile-time Native library version is " + version + " but the run-time version is " + runtimeVersion);
        }
    }
}

