// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var C, OPS_Parser, OnePassSignature, Packet, asymmetric, hash, iced, uint_to_buffer, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  Packet = require('./base').Packet;

  C = require('../../const').openpgp;

  asymmetric = require('../../asymmetric');

  hash = require('../../hash');

  uint_to_buffer = require('../../util').uint_to_buffer;

  OnePassSignature = (function(_super) {
    __extends(OnePassSignature, _super);

    function OnePassSignature(_arg) {
      this.sig_type = _arg.sig_type, this.hasher = _arg.hasher, this.sig_klass = _arg.sig_klass, this.key_id = _arg.key_id, this.is_final = _arg.is_final;
    }

    OnePassSignature.parse = function(slice) {
      return (new OPS_Parser(slice)).parse();
    };

    OnePassSignature.prototype.write_unframed = function(cb) {
      var bufs, unframed, vals, x;
      vals = [C.versions.one_pass_sig, this.sig_type, this.hasher.type, this.sig_klass.type];
      bufs = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = vals.length; _i < _len; _i++) {
          x = vals[_i];
          _results.push(uint_to_buffer(8, x));
        }
        return _results;
      })();
      bufs.push(this.key_id);
      bufs.push(uint_to_buffer(8, this.is_final));
      unframed = Buffer.concat(bufs);
      return cb(null, unframed);
    };

    OnePassSignature.prototype.write = function(cb) {
      var err, framed, unframed, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/home/max/src/keybase/kbpgp/src/openpgp/packet/one_pass_sig.iced",
            funcname: "OnePassSignature.write"
          });
          _this.write_unframed(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return unframed = arguments[1];
              };
            })(),
            lineno: 38
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          framed = _this.frame_packet(C.packet_tags.one_pass_sig, unframed);
          return cb(err, framed);
        };
      })(this));
    };

    return OnePassSignature;

  })(Packet);

  OPS_Parser = (function() {
    function OPS_Parser(slice) {
      this.slice = slice;
    }

    OPS_Parser.prototype.parse = function() {
      var hasher, is_final, key_id, sig_klass, sig_type, v;
      if ((v = this.slice.read_uint8()) !== C.versions.one_pass_sig) {
        throw new Error("Unknown OnePassSignature version " + v);
      }
      sig_type = this.slice.read_uint8();
      hasher = hash.alloc_or_throw(this.slice.read_uint8());
      sig_klass = asymmetric.get_class(this.slice.read_uint8());
      key_id = this.slice.read_buffer(8);
      is_final = this.slice.read_uint8();
      return new OnePassSignature({
        sig_type: sig_type,
        hasher: hasher,
        sig_klass: sig_klass,
        key_id: key_id,
        is_final: is_final
      });
    };

    return OPS_Parser;

  })();

  exports.OnePassSignature = OnePassSignature;

}).call(this);
