#ifndef _LWQQ_CONFIG_H__
#define _LWQQ_CONFIG_H__

#define WITH_LIBEV
/* #undef WITH_LIBUV */
#define WITH_SQLITE
/* #undef WITHOUT_ASYNC */
#define WITH_MOZJS
/* #undef MOZJS_185 */
#define MOZJS_17

#define HAVE_STRTOK_R
// using open_memstream in http.c
// direct write response to mem file
/* #undef HAVE_OPEN_MEMSTREAM */

#define LWQQ_VERSION "0.6.1"
#define RES_DIR "/usr/share/lwqq"

// use a single thread to poll message
// default: disabled
// note default value is good enough, it run poll in libev, asynced, 
/* #undef USE_MSG_THREAD */

//detach thread without join it
#define DETACH_THREAD False

//write discu into database
#define DISCU_READ_DB 1

// when continuly poll_msg_lost happend {?} times, send relink
// default : 5
#define RETRY_BEFORE_RELINK 4

// set poll_msg timeout {?} seconds
// default : 90
#define POLL_MSG_TIMEOUT 75

#define OFFPIC_USE_WQQ

#define LWQQ_MAGIC 0x4153

#define LWQQ_DEFAULT_CATE "My Friends"
#define LWQQ_PASSERBY_CATE "Passerby"
#define LWQQ_RETRY_VALUE 3
#define LWQQ_CACHE_DIR "/tmp/lwqq"

typedef enum {
   LWQQ_WITH_LIBEV     = 1 << 0,
   LWQQ_WITH_LIBUV     = 1 << 1,
   LWQQ_WITH_SQLITE    = 1 << 2,
   LWQQ_WITH_MOZJS     = 1 << 3,
   LWQQ_WITH_SSL       = 1 << 4,
   LWQQ_WITH_ASYNCHDNS = 1 << 5
} LwqqFeatures;

#endif /* __CONFIG_H__ */

