# expand-range [![NPM version](https://badge.fury.io/js/expand-range.svg)](http://badge.fury.io/js/expand-range)

> Fast, bash-like range expansion. Expand a range of numbers or letters, uppercase or lowercase. See the benchmarks. Used by micromatch.

## Install with [npm](npmjs.org)

```bash
npm i expand-range --save
```

Wraps [fill-range] to do range expansion using `..` separated strings. See [fill-range] for the full list of options and features.


## Example usage

```js
var expand = require('expand-range');
```

**Params**

```js
expand(start, stop, increment);
```

 - `start`: the number or letter to start with
 - `end`: the number or letter to end with
 - `increment`: optionally pass the increment to use. works for letters or numbers

**Examples**

```js
expand('a..e')
//=> ['a', 'b', 'c', 'd', 'e']

expand('a..e..2')
//=> ['a', 'c', 'e']

expand('A..E..2')
//=> ['A', 'C', 'E']

expand('1..3')
//=> ['1', '2', '3']

expand('0..-5')
//=> [ '0', '-1', '-2', '-3', '-4', '-5' ]

expand('-9..9..3')
//=> [ '-9', '-6', '-3', '0', '3', '6', '9' ])

expand('-1..-10..-2')
//=> [ '-1', '-3', '-5', '-7', '-9' ]

expand('1..10..2')
//=> [ '1', '3', '5', '7', '9' ]
```


### Custom function

Optionally pass a custom function as the second argument:

```js
expand('a..e', function (val, isNumber, pad, i) {
  if (!isNumber) {
    return String.fromCharCode(val) + i;
  }
  return val;
});
//=> ['a0', 'b1', 'c2', 'd3', 'e4']
```

## Related

- [micromatch]: wildcard/glob matcher for javascript. a faster alternative to minimatch.
- [fill-range]: the library this depends on for core functionality
- [braces]: this library is used in braces, a fast Brash-like brace expansion lib.

## Run tests

Install dev dependencies

```bash
npm i -d && npm test
```

## Contributing
Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/expand-range/issues).

## Author

**Jon Schlinkert**
 
+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert) 

## License
Copyright (c) 2015 Jon Schlinkert  
Released under the MIT license

***

_This file was generated by [verb](https://github.com/assemble/verb) on January 30, 2015._

[fill-range]: https://github.com/jonschlinkert/fill-range
[micromatch]: https://github.com/jonschlinkert/micromatch
[braces]: https://github.com/jonschlinkert/braces