/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.resources.ResourceManager;

public final class AboutPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(AboutPanel.class.getName());
    public static final String SITE_URL = "http://www.freecol.org";
    public static final String PROJECT_URL = "http://sourceforge.net/projects/freecol/";
    private static final String MANUAL_URL = "http://www.freecol.org/documentation/freecol-user-manual.html";

    public AboutPanel(FreeColClient freeColClient) {
        super(freeColClient, new MigLayout("wrap"));
        BufferedImage tempImage = ResourceManager.getImage("image.flavor.Title");
        JLabel apLogoLabel = new JLabel(new ImageIcon(tempImage));
        apLogoLabel.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), new BevelBorder(1)));
        this.add((Component)apLogoLabel, "center");
        Font fontBold = FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.TINY, 1, this.getImageLibrary().getScaleFactor());
        Font fontNormal = FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.TINY, this.getImageLibrary().getScaleFactor());
        JLabel apVersion = Utility.localizedLabel("aboutPanel.version");
        apVersion.setFont(fontBold);
        JLabel apRevision = new JLabel(FreeCol.getRevision());
        apRevision.setFont(fontNormal);
        this.add((Component)apVersion, "newline 20");
        this.add((Component)apRevision, "newline");
        JLabel apOfficialSite = new JLabel();
        apOfficialSite = Utility.localizedLabel("aboutPanel.officialSite");
        apOfficialSite.setFont(fontBold);
        this.add((Component)apOfficialSite, "newline 10");
        JButton apSiteURL = Utility.getLinkButton(SITE_URL, null, SITE_URL);
        apSiteURL.addActionListener(this);
        apSiteURL.setFont(fontNormal);
        this.add((Component)apSiteURL, "newline");
        JLabel apSFProject = new JLabel();
        apSFProject = Utility.localizedLabel("aboutPanel.sfProject");
        apSFProject.setFont(fontBold);
        this.add((Component)apSFProject, "newline 10");
        JButton apProjectURL = Utility.getLinkButton(PROJECT_URL, null, PROJECT_URL);
        apProjectURL.addActionListener(this);
        apProjectURL.setFont(fontNormal);
        this.add((Component)apProjectURL, "newline");
        JLabel apManual = Utility.localizedLabel("aboutPanel.manual");
        apManual.setFont(fontBold);
        this.add((Component)apManual, "newline 10");
        JButton apManualURL = Utility.getLinkButton(MANUAL_URL, null, MANUAL_URL);
        apManualURL.addActionListener(this);
        this.add((Component)apManualURL, "newline");
        JTextArea apLegal = Utility.localizedTextArea("aboutPanel.legalDisclaimer");
        apLegal.setFont(fontNormal);
        this.add((Component)apLegal, "newline 20, width 300px");
        JLabel apCopyright = Utility.localizedLabel("aboutPanel.copyright");
        apCopyright.setFont(fontNormal);
        this.add((Component)apCopyright, "newline 10");
        this.add((Component)this.okButton, "newline 20, tag ok");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String url = ae.getActionCommand();
        if (SITE_URL.equals(url) || PROJECT_URL.equals(url) || MANUAL_URL.equals(url)) {
            String os = System.getProperty("os.name");
            String[] cmd = null;
            if (os == null) {
                return;
            }
            cmd = os.toLowerCase().contains("mac") ? new String[]{"open", "-a", "Safari", url} : (os.toLowerCase().contains("windows") ? new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", url} : (os.toLowerCase().contains("linux") ? new String[]{"xdg-open", url} : new String[]{"firefox", url}));
            try {
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException iOException) {}
        } else {
            super.actionPerformed(ae);
        }
    }
}

