/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.dynamic;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.EmptyAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.dynamic.ExternalConverter;
import org.scilab.forge.jlatexmath.dynamic.ExternalConverterFactory;

public class DynamicAtom
extends Atom {
    private static ExternalConverterFactory ecFactory;
    private ExternalConverter converter;
    private TeXFormula formula = new TeXFormula();
    private String externalCode;
    private boolean insert;
    private boolean refreshed;

    public DynamicAtom(String string, String string2) {
        this.externalCode = string;
        if (ecFactory != null) {
            this.converter = ecFactory.getExternalConverter();
        }
        if (string2 != null && string2.equals("i")) {
            this.insert = true;
        }
    }

    public static boolean hasAnExternalConverterFactory() {
        return ecFactory != null;
    }

    public static void setExternalConverterFactory(ExternalConverterFactory externalConverterFactory) {
        ecFactory = externalConverterFactory;
    }

    public boolean getInsertMode() {
        return this.insert;
    }

    public Atom getAtom() {
        if (!this.refreshed) {
            this.formula.setLaTeX(this.converter.getLaTeXString(this.externalCode));
            this.refreshed = true;
        }
        if (this.formula.root == null) {
            return new EmptyAtom();
        }
        return this.formula.root;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        if (this.converter != null) {
            if (this.refreshed) {
                this.refreshed = false;
            } else {
                this.formula.setLaTeX(this.converter.getLaTeXString(this.externalCode));
            }
            if (this.formula.root != null) {
                return this.formula.root.createBox(teXEnvironment);
            }
        }
        return new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
    }
}

