/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.protocol;

import java.util.List;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.progress.OperationIdentifier;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializer;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.launcher.daemon.protocol.BuildEvent;
import org.gradle.launcher.daemon.protocol.CloseInput;
import org.gradle.launcher.daemon.protocol.Failure;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.protocol.OutputMessage;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.internal.LogEvent;
import org.gradle.logging.internal.LogLevelChangeEvent;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.ProgressCompleteEvent;
import org.gradle.logging.internal.ProgressEvent;
import org.gradle.logging.internal.ProgressStartEvent;
import org.gradle.logging.internal.StyledTextOutputEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonMessageSerializer {
    public static Serializer<Message> create() {
        BaseSerializerFactory factory = new BaseSerializerFactory();
        Serializer logLevelSerializer = factory.getSerializerFor(LogLevel.class);
        Serializer throwableSerializer = factory.getSerializerFor(Throwable.class);
        DefaultSerializerRegistry registry = new DefaultSerializerRegistry();
        registry.register(BuildEvent.class, (Serializer)new BuildEventSerializer());
        registry.register(Failure.class, (Serializer)new FailureSerializer((Serializer<Throwable>)throwableSerializer));
        registry.register(ForwardInput.class, (Serializer)new ForwardInputSerializer());
        registry.register(CloseInput.class, (Serializer)new CloseInputSerializer());
        DefaultSerializerRegistry outputEventRegistry = new DefaultSerializerRegistry();
        outputEventRegistry.register(LogEvent.class, (Serializer)new LogEventSerializer((Serializer<LogLevel>)logLevelSerializer, (Serializer<Throwable>)throwableSerializer));
        outputEventRegistry.register(StyledTextOutputEvent.class, (Serializer)new StyledTextOutputEventSerializer((Serializer<LogLevel>)logLevelSerializer, (Serializer<List<StyledTextOutputEvent.Span>>)new ListSerializer((Serializer)new SpanSerializer((Serializer<StyledTextOutput.Style>)factory.getSerializerFor(StyledTextOutput.Style.class)))));
        outputEventRegistry.register(ProgressStartEvent.class, (Serializer)new ProgressStartEventSerializer());
        outputEventRegistry.register(ProgressCompleteEvent.class, (Serializer)new ProgressCompleteEventSerializer());
        outputEventRegistry.register(ProgressEvent.class, (Serializer)new ProgressEventSerializer());
        outputEventRegistry.register(LogLevelChangeEvent.class, (Serializer)new LogLevelChangeEventSerializer((Serializer<LogLevel>)logLevelSerializer));
        registry.register(OutputMessage.class, (Serializer)new OutputMessageSerializer((Serializer<OutputEvent>)outputEventRegistry.build()));
        registry.useJavaSerialization(Message.class);
        return registry.build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutputMessageSerializer
    implements Serializer<OutputMessage> {
        private final Serializer<OutputEvent> eventSerializer;

        public OutputMessageSerializer(Serializer<OutputEvent> eventSerializer) {
            this.eventSerializer = eventSerializer;
        }

        public void write(Encoder encoder, OutputMessage message) throws Exception {
            this.eventSerializer.write(encoder, (Object)message.getEvent());
        }

        public OutputMessage read(Decoder decoder) throws Exception {
            return new OutputMessage((OutputEvent)this.eventSerializer.read(decoder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CloseInputSerializer
    implements Serializer<CloseInput> {
        private CloseInputSerializer() {
        }

        public void write(Encoder encoder, CloseInput value) {
        }

        public CloseInput read(Decoder decoder) {
            return new CloseInput();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForwardInputSerializer
    implements Serializer<ForwardInput> {
        private ForwardInputSerializer() {
        }

        public void write(Encoder encoder, ForwardInput message) throws Exception {
            encoder.writeBinary(message.getBytes());
        }

        public ForwardInput read(Decoder decoder) throws Exception {
            return new ForwardInput(decoder.readBinary());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StyledTextOutputEventSerializer
    implements Serializer<StyledTextOutputEvent> {
        private final Serializer<LogLevel> logLevelSerializer;
        private final Serializer<List<StyledTextOutputEvent.Span>> spanSerializer;

        public StyledTextOutputEventSerializer(Serializer<LogLevel> logLevelSerializer, Serializer<List<StyledTextOutputEvent.Span>> spanSerializer) {
            this.logLevelSerializer = logLevelSerializer;
            this.spanSerializer = spanSerializer;
        }

        public void write(Encoder encoder, StyledTextOutputEvent event) throws Exception {
            encoder.writeLong(event.getTimestamp());
            encoder.writeString((CharSequence)event.getCategory());
            this.logLevelSerializer.write(encoder, (Object)event.getLogLevel());
            this.spanSerializer.write(encoder, event.getSpans());
        }

        public StyledTextOutputEvent read(Decoder decoder) throws Exception {
            long timestamp = decoder.readLong();
            String category = decoder.readString();
            LogLevel logLevel = (LogLevel)((Object)this.logLevelSerializer.read(decoder));
            List spans = (List)this.spanSerializer.read(decoder);
            return new StyledTextOutputEvent(timestamp, category, logLevel, spans);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpanSerializer
    implements Serializer<StyledTextOutputEvent.Span> {
        private final Serializer<StyledTextOutput.Style> styleSerializer;

        public SpanSerializer(Serializer<StyledTextOutput.Style> styleSerializer) {
            this.styleSerializer = styleSerializer;
        }

        public void write(Encoder encoder, StyledTextOutputEvent.Span value) throws Exception {
            this.styleSerializer.write(encoder, (Object)value.getStyle());
            encoder.writeString((CharSequence)value.getText());
        }

        public StyledTextOutputEvent.Span read(Decoder decoder) throws Exception {
            return new StyledTextOutputEvent.Span((StyledTextOutput.Style)((Object)this.styleSerializer.read(decoder)), decoder.readString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LogEventSerializer
    implements Serializer<LogEvent> {
        private final Serializer<Throwable> throwableSerializer;
        private final Serializer<LogLevel> logLevelSerializer;

        public LogEventSerializer(Serializer<LogLevel> logLevelSerializer, Serializer<Throwable> throwableSerializer) {
            this.logLevelSerializer = logLevelSerializer;
            this.throwableSerializer = throwableSerializer;
        }

        public void write(Encoder encoder, LogEvent event) throws Exception {
            encoder.writeLong(event.getTimestamp());
            encoder.writeString((CharSequence)event.getCategory());
            this.logLevelSerializer.write(encoder, (Object)event.getLogLevel());
            encoder.writeString((CharSequence)event.getMessage());
            this.throwableSerializer.write(encoder, (Object)event.getThrowable());
        }

        public LogEvent read(Decoder decoder) throws Exception {
            long timestamp = decoder.readLong();
            String category = decoder.readString();
            LogLevel logLevel = (LogLevel)((Object)this.logLevelSerializer.read(decoder));
            String message = decoder.readString();
            Throwable throwable = (Throwable)this.throwableSerializer.read(decoder);
            return new LogEvent(timestamp, category, logLevel, message, throwable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LogLevelChangeEventSerializer
    implements Serializer<LogLevelChangeEvent> {
        private final Serializer<LogLevel> logLevelSerializer;

        public LogLevelChangeEventSerializer(Serializer<LogLevel> logLevelSerializer) {
            this.logLevelSerializer = logLevelSerializer;
        }

        public void write(Encoder encoder, LogLevelChangeEvent value) throws Exception {
            this.logLevelSerializer.write(encoder, (Object)value.getNewLogLevel());
        }

        public LogLevelChangeEvent read(Decoder decoder) throws Exception {
            LogLevel logLevel = (LogLevel)((Object)this.logLevelSerializer.read(decoder));
            return new LogLevelChangeEvent(logLevel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProgressCompleteEventSerializer
    implements Serializer<ProgressCompleteEvent> {
        private ProgressCompleteEventSerializer() {
        }

        public void write(Encoder encoder, ProgressCompleteEvent event) throws Exception {
            encoder.writeSmallLong(event.getOperationId().getId());
            encoder.writeLong(event.getTimestamp());
            encoder.writeString((CharSequence)event.getCategory());
            encoder.writeString((CharSequence)event.getDescription());
            encoder.writeString((CharSequence)event.getStatus());
        }

        public ProgressCompleteEvent read(Decoder decoder) throws Exception {
            OperationIdentifier id = new OperationIdentifier(decoder.readSmallLong());
            long timestamp = decoder.readLong();
            String category = decoder.readString();
            String description = decoder.readString();
            String status = decoder.readString();
            return new ProgressCompleteEvent(id, timestamp, category, description, status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProgressEventSerializer
    implements Serializer<ProgressEvent> {
        private ProgressEventSerializer() {
        }

        public void write(Encoder encoder, ProgressEvent event) throws Exception {
            encoder.writeSmallLong(event.getOperationId().getId());
            encoder.writeLong(event.getTimestamp());
            encoder.writeString((CharSequence)event.getCategory());
            encoder.writeString((CharSequence)event.getStatus());
        }

        public ProgressEvent read(Decoder decoder) throws Exception {
            OperationIdentifier id = new OperationIdentifier(decoder.readSmallLong());
            long timestamp = decoder.readLong();
            String category = decoder.readString();
            String status = decoder.readString();
            return new ProgressEvent(id, timestamp, category, status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProgressStartEventSerializer
    implements Serializer<ProgressStartEvent> {
        private ProgressStartEventSerializer() {
        }

        public void write(Encoder encoder, ProgressStartEvent event) throws Exception {
            encoder.writeSmallLong(event.getOperationId().getId());
            if (event.getParentId() == null) {
                encoder.writeBoolean(false);
            } else {
                encoder.writeBoolean(true);
                encoder.writeSmallLong(event.getParentId().getId());
            }
            encoder.writeLong(event.getTimestamp());
            encoder.writeString((CharSequence)event.getCategory());
            encoder.writeString((CharSequence)event.getDescription());
            encoder.writeNullableString((CharSequence)event.getShortDescription());
            encoder.writeNullableString((CharSequence)event.getLoggingHeader());
            encoder.writeString((CharSequence)event.getStatus());
        }

        public ProgressStartEvent read(Decoder decoder) throws Exception {
            OperationIdentifier id = new OperationIdentifier(decoder.readSmallLong());
            OperationIdentifier parentId = decoder.readBoolean() ? new OperationIdentifier(decoder.readSmallLong()) : null;
            long timestamp = decoder.readLong();
            String category = decoder.readString();
            String description = decoder.readString();
            String shortDescription = decoder.readNullableString();
            String loggingHeader = decoder.readNullableString();
            String status = decoder.readString();
            return new ProgressStartEvent(id, parentId, timestamp, category, description, shortDescription, loggingHeader, status);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuildEventSerializer
    implements Serializer<BuildEvent> {
        private final Serializer<Object> payloadSerializer = new DefaultSerializer();

        private BuildEventSerializer() {
        }

        public void write(Encoder encoder, BuildEvent buildEvent) throws Exception {
            this.payloadSerializer.write(encoder, buildEvent.getPayload());
        }

        public BuildEvent read(Decoder decoder) throws Exception {
            return new BuildEvent(this.payloadSerializer.read(decoder));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FailureSerializer
    implements Serializer<Failure> {
        private final Serializer<Throwable> throwableSerializer;

        public FailureSerializer(Serializer<Throwable> throwableSerializer) {
            this.throwableSerializer = throwableSerializer;
        }

        public void write(Encoder encoder, Failure failure) throws Exception {
            this.throwableSerializer.write(encoder, failure.getValue());
        }

        public Failure read(Decoder decoder) throws Exception {
            return new Failure((Throwable)this.throwableSerializer.read(decoder));
        }
    }
}

